/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.common.framework.receipt.util;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.annotation.Autowired;
import kd.ebg.egf.common.annotation.Component;
import kd.ebg.egf.common.constant.ConfigInputType;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.framework.conf.IParameter;
import kd.ebg.egf.common.framework.conf.ParameterImpl;
import kd.ebg.egf.common.utils.AESUtil;
import kd.ebg.receipt.common.core.utils.EBGStringUtils;
import kd.ebg.receipt.common.framework.context.RequestContextUtils;
import kd.ebg.receipt.common.framework.receipt.constant.ConfigDataType;
import kd.ebg.receipt.common.framework.receipt.exception.ConfigUnhandleException;
import kd.ebg.receipt.common.framework.receipt.mark.EBConfigMark;
import kd.ebg.receipt.common.framework.receipt.mark.EBConfigMarkType;
import kd.ebg.receipt.common.framework.receipt.reflect.FieldOperateFactory;
import kd.ebg.receipt.common.model.receipt.EBConfig;
import kd.ebg.receipt.common.model.receipt.GlobalObjectParamConfig;
import kd.ebg.receipt.common.model.repository.receipt.EBConfigRepository;
import kd.ebg.receipt.common.model.repository.receipt.GlobalConfigRepository;
import kd.ebg.receipt.common.utils.SpringContextUtil;
import kd.sdk.annotation.SdkDeprecated;

@Component
public class EBConfigBuilder {
    @Autowired
    private EBConfigRepository ebConfigRepository;
    @Autowired
    private GlobalConfigRepository globalConfigRepository;

    @SdkDeprecated
    public static EBConfigBuilder getInstance() {
        return SpringContextUtil.getBean(EBConfigBuilder.class);
    }

    @SdkDeprecated
    public <T> T buildConfig(Class<T> cls, String loginId) {
        EBContext context = EBContext.getContext();
        T t = null;
        try {
            EBConfigMarkType type = cls.getAnnotation(EBConfigMarkType.class);
            if (null == type) {
                throw new ConfigUnhandleException(ResManager.loadKDString((String)"\u914d\u7f6e\u7c7b\u5fc5\u987b\u6709@EBConfigMarkType\u6ce8\u89e3\u3002", (String)"EBConfigBuilder_0", (String)"ebg-receipt-common", (Object[])new Object[0]));
            }
            String bankVersionID = type.bankVersionID();
            if (type.configType().isBasedOnContext()) {
                bankVersionID = context.getBankVersionID();
            }
            if (EBGStringUtils.isEmpty(loginId)) {
                loginId = bankVersionID + "-1";
            }
            t = cls.newInstance();
            ArrayList<EBConfig> configs = new ArrayList(1);
            String cacheName = String.format("%s_config", loginId);
            IParameter parameter = EBContext.getContext().getParameter();
            if (parameter == null) {
                parameter = new ParameterImpl();
                EBContext.getContext().setParameter(parameter);
            }
            if (EBGStringUtils.isEmpty(RequestContextUtils.getRunningParam(cacheName))) {
                configs = this.getConfigFromDB(bankVersionID, loginId, context.getCustomID());
                context.setBankLoginID(loginId);
                try {
                    EBContext.initParameter();
                }
                catch (Throwable e) {
                    parameter = new ParameterImpl();
                    EBContext.getContext().setParameter(parameter);
                }
            }
            ParameterImpl iParameter = (ParameterImpl)RequestContextUtils.getParameter();
            for (EBConfig config : configs) {
                if (!EBGStringUtils.isEmpty(iParameter.getBankParameter(config.getFieldName())) || !EBGStringUtils.isNotEmpty(config.getFieldValue())) continue;
                String configValue = config.getFieldValue();
                if (EBGStringUtils.isEmpty(config.getConfigType())) {
                    configValue = AESUtil.unencryptedDesEncrypt((String)configValue, (String)(config.getId() + ""));
                } else if (ConfigInputType.PASSWORD.getInputType().equalsIgnoreCase(config.getConfigType())) {
                    configValue = AESUtil.unencryptedDesEncrypt((String)configValue, (String)(config.getId() + ""));
                }
                iParameter.setBankParameter(config.getFieldName(), configValue);
            }
            RequestContextUtils.setRunningParam(cacheName, "true");
            this.setFieldValue(t, cls, configs, true);
        }
        catch (Exception e) {
            throw new ConfigUnhandleException(e);
        }
        return t;
    }

    @SdkDeprecated
    public <T> T buildConfig(Class<T> cls) {
        String customID = RequestContext.get().getTenantId();
        T t = null;
        try {
            EBConfigMarkType type = cls.getAnnotation(EBConfigMarkType.class);
            if (null == type) {
                throw new ConfigUnhandleException(ResManager.loadKDString((String)"\u914d\u7f6e\u7c7b\u5fc5\u987b\u6709@EBConfigMarkType\u6ce8\u89e3\u3002", (String)"EBConfigBuilder_0", (String)"ebg-receipt-common", (Object[])new Object[0]));
            }
            List<EBConfig> configs = this.getGlobalConfigFromDB(customID);
            t = cls.newInstance();
            this.setFieldValue(t, cls, configs, false);
        }
        catch (Exception e) {
            throw new ConfigUnhandleException(e);
        }
        return t;
    }

    public <T> T buildBusinessConfig(Class<T> cls, String bankVersionid) {
        EBContext context = EBContext.getContext();
        T t = null;
        try {
            EBConfigMarkType type = cls.getAnnotation(EBConfigMarkType.class);
            if (null == type) {
                throw new ConfigUnhandleException(ResManager.loadKDString((String)"\u914d\u7f6e\u7c7b\u5fc5\u987b\u6709@EBConfigMarkType\u6ce8\u89e3\u3002", (String)"EBConfigBuilder_0", (String)"ebg-receipt-common", (Object[])new Object[0]));
            }
            List<EBConfig> configs = this.getBusinessConfigFromDB(context.getCustomID(), bankVersionid);
            t = cls.newInstance();
            this.setFieldValue(t, cls, configs, false);
        }
        catch (Exception e) {
            throw new ConfigUnhandleException(e);
        }
        return t;
    }

    private <T> void setFieldValue(T obj, Class<T> tClass, List<EBConfig> ebConfigs, boolean isBankLogin) {
        Field[] fields;
        for (Field field : fields = tClass.getDeclaredFields()) {
            String name;
            String value;
            EBConfigMark config = field.getAnnotation(EBConfigMark.class);
            if (null == config) continue;
            String fileName = field.getName();
            if (EBGStringUtils.isNotEmpty(config.name())) {
                fileName = config.name();
            }
            if (EBGStringUtils.isEmpty(value = isBankLogin ? RequestContextUtils.getBankParameterValue(fileName) : this.getFieldValue(config.dataType(), fileName, ebConfigs))) {
                value = config.defaultValue();
            }
            if ("java.lang.Integer".equalsIgnoreCase(name = field.getType().getName()) || "int".equalsIgnoreCase(name)) {
                boolean isIntValue = true;
                try {
                    Integer.parseInt(value);
                    isIntValue = true;
                }
                catch (Throwable e) {
                    isIntValue = false;
                }
                if (!isIntValue) {
                    value = "";
                }
            }
            FieldOperateFactory.setFieldValue(field, obj, value);
        }
    }

    private String getFieldValue(ConfigDataType type, String fieldName, List<EBConfig> ebConfigs) {
        String value = "";
        for (EBConfig config : ebConfigs) {
            if (!fieldName.equals(config.getFieldName())) continue;
            value = config.getFieldValue();
            if (!Objects.equals(type.getName(), ConfigDataType.PASSWORD.getName())) break;
            value = AESUtil.unencryptedDesEncrypt((String)value, (String)String.valueOf(config.getId()));
            break;
        }
        return value;
    }

    private List<EBConfig> getGlobalConfigFromDB(String customNo) {
        List<GlobalObjectParamConfig> receiptGlobalObjectParamConfig = this.globalConfigRepository.findGlobalReceiptConfigByCustomID(customNo);
        ArrayList<EBConfig> globalReceiptConfigs = new ArrayList<EBConfig>(4);
        receiptGlobalObjectParamConfig.forEach(o -> {
            EBConfig ebConfig = new EBConfig();
            ebConfig.setFieldValue(o.getAttrValue());
            ebConfig.setFieldName(o.getAttrKey());
            globalReceiptConfigs.add(ebConfig);
        });
        List<GlobalObjectParamConfig> ebgGlobalEBGConfigByCustomID = this.globalConfigRepository.findGlobalEBGConfigByCustomID(customNo);
        ebgGlobalEBGConfigByCustomID.forEach(o -> {
            EBConfig ebConfig = new EBConfig();
            ebConfig.setFieldValue(o.getAttrValue());
            ebConfig.setFieldName(o.getAttrKey());
            globalReceiptConfigs.add(ebConfig);
        });
        return globalReceiptConfigs;
    }

    private List<EBConfig> getConfigFromDB(String bankVersionId, String loginId, String customNo) {
        List<GlobalObjectParamConfig> receiptGlobalObjectParamConfig = this.globalConfigRepository.findGlobalReceiptConfigByCustomID(customNo);
        List<EBConfig> ebgConfigs = this.ebConfigRepository.findEGBConfigByBankVersionIDAndBankLoginIdAndCustomId(bankVersionId, loginId, customNo);
        List<EBConfig> receiptConfigs = this.ebConfigRepository.findReceiptConfigByBankVersionIDAndBankLoginIdAndCustomId(bankVersionId, loginId, customNo);
        List<GlobalObjectParamConfig> globalObjectParamConfig = this.globalConfigRepository.findBusinessConfigByCustomIDAndFromId(customNo, bankVersionId);
        ArrayList<EBConfig> allConfig = new ArrayList<EBConfig>(16);
        ArrayList globalReceiptConfigs = new ArrayList(4);
        receiptGlobalObjectParamConfig.forEach(o -> {
            EBConfig ebConfig = new EBConfig();
            ebConfig.setId(o.getId());
            ebConfig.setFieldValue(o.getAttrValue());
            ebConfig.setFieldName(o.getAttrKey());
            ebConfig.setConfigType(ConfigInputType.TEXT.getInputType());
            globalReceiptConfigs.add(ebConfig);
        });
        globalObjectParamConfig.forEach(o -> {
            EBConfig ebConfig = new EBConfig();
            ebConfig.setId(o.getId());
            ebConfig.setFieldValue(o.getAttrValue());
            ebConfig.setFieldName(o.getAttrKey());
            ebConfig.setConfigType(ConfigInputType.TEXT.getInputType());
            globalReceiptConfigs.add(ebConfig);
        });
        allConfig.addAll(receiptConfigs);
        allConfig.addAll(ebgConfigs);
        allConfig.addAll(globalReceiptConfigs);
        return allConfig;
    }

    private List<EBConfig> getBusinessConfigFromDB(String customNo, String bankVersionId) {
        List<GlobalObjectParamConfig> globalObjectParamConfig = this.globalConfigRepository.findBusinessConfigByCustomIDAndFromId(customNo, bankVersionId);
        ArrayList<EBConfig> allConfig = new ArrayList<EBConfig>(16);
        ArrayList globalReceiptConfigs = new ArrayList(4);
        globalObjectParamConfig.forEach(o -> {
            EBConfig ebConfig = new EBConfig();
            ebConfig.setId(o.getId());
            ebConfig.setFieldValue(o.getAttrValue());
            ebConfig.setFieldName(o.getAttrKey());
            globalReceiptConfigs.add(ebConfig);
        });
        allConfig.addAll(globalReceiptConfigs);
        return allConfig;
    }
}

