/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.dlb.dc.service.receipt;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.receipt.banks.dlb.dc.service.receipt.util.ReceiptPacker;
import kd.ebg.receipt.banks.dlb.dc.service.receipt.util.ReceiptParser;
import kd.ebg.receipt.banks.dlb.dc.service.receipt.util.SocketSender;
import kd.ebg.receipt.business.receipt.atom.AbstractBankReceiptHandleImpl;
import kd.ebg.receipt.business.receipt.atom.IBankReceiptHandle;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleRequest;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleResponseEB;
import kd.ebg.receipt.business.receipt.entity.TaskStatus;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.framework.services.receipt.DownloadListDetailService;
import kd.ebg.receipt.common.framework.services.receipt.DownloadTaskService;
import kd.ebg.receipt.common.model.receipt.DownloadListDetail;
import kd.ebg.receipt.common.model.receipt.DownloadListTask;
import kd.ebg.receipt.common.utils.SpringContextUtil;

public class BankReceiptFetchListImpl
extends AbstractBankReceiptHandleImpl
implements IBankReceiptHandle {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(BankReceiptFetchListImpl.class);
    public DownloadListDetailService downloadListDetailService;
    public DownloadTaskService downloadTaskService;

    public void init(BankReceiptHandleRequest request) {
        this.downloadListDetailService = (DownloadListDetailService)SpringContextUtil.getBean(DownloadListDetailService.class);
        this.downloadTaskService = (DownloadTaskService)SpringContextUtil.getBean(DownloadTaskService.class);
    }

    public boolean match(BankReceiptHandleRequest request) {
        if (request == null) {
            return false;
        }
        Integer status = request.getTaskStatus();
        if (status == null) {
            return false;
        }
        return status.intValue() == TaskStatus.PROCESSING.getId();
    }

    public BankReceiptHandleResponseEB doBiz(BankReceiptHandleRequest request) {
        this.init(request);
        long taskId = request.getTaskId();
        DownloadListTask downloadListTask = this.downloadTaskService.findById(taskId);
        List<Object> result = new ArrayList(16);
        result = this.doJob(downloadListTask);
        return BankReceiptHandleResponseEB.success(result);
    }

    public List<DownloadListDetail> doJob(DownloadListTask task) {
        ArrayList<DownloadListDetail> detailList = new ArrayList<DownloadListDetail>(16);
        DownloadListDetail detail = null;
        String accNo = task.getAccNo();
        String detailRequest = ReceiptPacker.detailtPack(task);
        logger.info("\u5927\u8fde\u94f6\u884c\u67e5\u8be2\u4ea4\u6613\u660e\u7ec6\u8bf7\u6c42\uff1a{}", (Object)detailRequest);
        String detailResponse = SocketSender.sendRequestBySocket(detailRequest, task.getBankLoginId());
        logger.info("\u5927\u8fde\u94f6\u884c\u67e5\u8be2\u4ea4\u6613\u660e\u7ec6\u54cd\u5e94\uff1a{}", (Object)detailResponse);
        List<String> host_serial_no_list = ReceiptParser.detailParser(task, detailResponse);
        String receiptRequest = "";
        String receiptResponse = "";
        Map<Object, Object> map = new HashMap(16);
        for (String host_serial_no : host_serial_no_list) {
            receiptRequest = ReceiptPacker.receiptPack(task, host_serial_no);
            logger.info("\u5927\u8fde\u94f6\u884c\u67e5\u8be2\u7535\u5b50\u56de\u5355\u8bf7\u6c42\uff1a{}", (Object)receiptRequest);
            receiptResponse = SocketSender.sendRequestBySocket(receiptRequest, task.getBankLoginId());
            logger.info("\u5927\u8fde\u94f6\u884c\u67e5\u8be2\u7535\u5b50\u56de\u5355\u54cd\u5e94\uff1a{}", (Object)receiptResponse);
            map = ReceiptParser.receiptParser(receiptResponse);
            String tr_acdt = (String)map.get("tr_acdt");
            String amt = (String)map.get("amt");
            String crdr_flag = (String)map.get("crdr_flag");
            String ReportFileName = (String)map.get("ReportFileName");
            String newFileName = accNo + "_" + tr_acdt + "_" + host_serial_no + "_" + amt + "_" + crdr_flag + ".pdf";
            detail = new DownloadListDetail();
            detail.setFileLink(ReportFileName);
            detail.setFileName(newFileName);
            detailList.add(detail);
        }
        return detailList;
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "ABC_DC_BankReceiptFetchList";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u83b7\u53d6\u519c\u4e1a\u94f6\u884c\u516c\u7f51\u7248\u56de\u5355\u6587\u4ef6\u5217\u8868", (String)"BankReceiptFetchListImpl_0", (String)"ebg-receipt-banks-dlb-dc", (Object[])new Object[0]);
    }
}

