/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.business.receipt;

import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.biz.EBServiceMethod;
import kd.ebg.egf.common.framework.lock.FEPAccess;
import kd.ebg.egf.common.framework.lock.FEPAccessUtil;
import kd.ebg.receipt.business.receipt.atom.reconciliation.IBankBalanceReconciliation;
import kd.ebg.receipt.business.receipt.bank.task.balanceReconciliation.BalanceReconciliationRequestEB;
import kd.ebg.receipt.business.receipt.bank.task.balanceReconciliation.BalanceReconciliationResponseEB;
import kd.ebg.receipt.business.receipt.utils.AccessUtils;
import kd.ebg.receipt.business.receipt.utils.BalanceReconciliationConvert;
import kd.ebg.receipt.common.entity.biz.reconciliation.balanceReconciliation.BalanceReconciliationRequest;
import kd.ebg.receipt.common.entity.biz.reconciliation.balanceReconciliation.BalanceReconciliationResponse;
import kd.ebg.receipt.common.framework.frame.BankBundleManager;
import org.slf4j.MDC;

public class BalanceReconciliationMethod
implements EBServiceMethod<BalanceReconciliationRequest, BalanceReconciliationResponse> {
    public BalanceReconciliationResponse executeClientRequest(BalanceReconciliationRequest request, EBContext context) {
        AccessUtils.checkQueryAllowed(context);
        BalanceReconciliationRequestEB receiptRequest = BalanceReconciliationConvert.convert(request);
        BalanceReconciliationResponseEB response = null;
        EBContext.initParameter();
        FEPAccess access = null;
        try {
            IBankBalanceReconciliation bankBalanceReconciliation = (IBankBalanceReconciliation)BankBundleManager.getInstance().getImpl(context.getBankVersionID(), IBankBalanceReconciliation.class, (Object)receiptRequest);
            if (bankBalanceReconciliation.needLock()) {
                MDC.put((String)"bussiness_type", (String)"bussiness_bank");
                access = FEPAccessUtil.access((String)context.getBankVersionID(), (String)context.getBankVersionID());
                AccessUtils.checkQueryAllowed(context);
            }
            response = bankBalanceReconciliation.balanceReconciliation(receiptRequest);
        }
        catch (Exception e) {
            throw EBExceiptionUtil.serviceException((Throwable)e);
        }
        finally {
            FEPAccessUtil.release(access);
            MDC.put((String)"bussiness_type", (String)"bussiness_process");
        }
        return BalanceReconciliationConvert.convert(response);
    }

    public boolean needCheckAccNo() {
        return true;
    }

    public String bizName() {
        return "receipt";
    }
}

