/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.business.receipt.impl.handler;

import com.google.common.collect.Maps;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.threads.ThreadPool;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.framework.frame.Sequence;
import kd.ebg.egf.common.framework.service.acnt.BankAcntService;
import kd.ebg.egf.common.framework.service.bank.BankLoginService;
import kd.ebg.egf.common.framework.service.bank.BankVersionService;
import kd.ebg.egf.common.model.bank.BankListEntity;
import kd.ebg.egf.common.model.bank.login.BankLogin;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.receipt.business.receipt.entity.ReceiptHandlerRequest;
import kd.ebg.receipt.business.receipt.framework.EBThreadPools;
import kd.ebg.receipt.business.receipt.framework.ScheduleHanlder;
import kd.ebg.receipt.business.receipt.framework.TaskActuator;
import kd.ebg.receipt.business.receipt.framework.TaskFactory;
import kd.ebg.receipt.common.constant.UploadStatusEnum;
import kd.ebg.receipt.common.framework.context.RequestContextUtils;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.framework.receipt.bank.ReceiptSystemProperties;
import kd.ebg.receipt.common.framework.receipt.util.EBConfigBuilder;
import kd.ebg.receipt.common.framework.services.receipt.DownloadListDetailService;
import kd.ebg.receipt.common.framework.services.receipt.DownloadTaskService;
import kd.ebg.receipt.common.model.receipt.DownloadListDetail;
import kd.ebg.receipt.common.model.receipt.DownloadListTask;
import kd.ebg.receipt.common.utils.SpringContextUtil;

public class ReceiptUploadHandler
extends ScheduleHanlder {
    EBGLogger logger = EBGLogger.getInstance().getLogger(ReceiptUploadHandler.class);
    private BankLoginService bankLoginService;
    private BankVersionService bankVersionService;
    private BankAcntService bankAcntService;
    private DownloadTaskService downloadTaskService;
    private static final String APPLICATION_WATCH_NODE = "/receipt_application_watch_node:%s";

    public ReceiptUploadHandler(String name) {
        super(name);
    }

    @Override
    public boolean preJob() {
        this.bankLoginService = BankLoginService.getInstance();
        this.bankVersionService = BankVersionService.getInstance();
        this.bankAcntService = BankAcntService.getInstance();
        this.downloadTaskService = (DownloadTaskService)SpringContextUtil.getBean(DownloadTaskService.class);
        String customId = RequestContext.get().getTenantId();
        EBContext.setContext((EBContext)EBContext.builder().customID(customId).logBizSeqID(Sequence.genSequence()).logRequestSeqID(Sequence.genSequence()).bizName("receipt").build());
        this.applicationReSatrtHandle();
        return true;
    }

    public void applicationReSatrtHandle() {
        try {
            DownloadListDetailService detailService = (DownloadListDetailService)SpringContextUtil.getBean(DownloadListDetailService.class);
            int retryHour = RequestContextUtils.getRetryHour();
            ArrayList<Integer> uploadStatus = new ArrayList<Integer>(2);
            uploadStatus.add(UploadStatusEnum.UPLOAD_PROCESSING.getId());
            List jobList = detailService.selectByUploadFlag(uploadStatus);
            ArrayList<DownloadListDetail> updateList = new ArrayList<DownloadListDetail>(1);
            for (DownloadListDetail detail : jobList) {
                long seconds;
                LocalDateTime dateTime = detail.getCompleteTime();
                if (detail.getCompleteTime() == null && detail.getModifytime() != null) {
                    dateTime = detail.getModifytime();
                }
                if (dateTime == null || (seconds = Duration.between(detail.getModifytime(), LocalDateTime.now()).getSeconds()) < (long)(3600 * retryHour)) continue;
                detail.setUploadRedo(0);
                detail.setUploadFlag(Integer.valueOf(UploadStatusEnum.UN_UPLOAD.getId()));
                updateList.add(detail);
            }
            detailService.updateAll(updateList);
        }
        catch (Exception e) {
            this.logger.error("\u56de\u5355\u5e94\u7528\u76d1\u542c\u5f02\u5e38\uff1a{}", new Object[]{e.getMessage()});
        }
    }

    @Override
    public void subProcess() {
        this.MDC_Schedule();
        String customId = RequestContext.get().getTenantId();
        this.logger.info("\u6587\u4ef6\u4e0a\u4f20\u4efb\u52a1\u5904\u7406\u5f00\u59cb-{}", (Object)customId);
        List<BankListEntity> bankListEntities = super.getBankListEntities();
        if (bankListEntities.size() == 0) {
            this.logger.info("\u6587\u4ef6\u4e0a\u4f20\u8c03\u5ea6-\u8be5\u79df\u6237-{}-\u542f\u7528\u7684\u94f6\u884c\u5217\u8868\u4e3a\u7a7a", (Object)customId);
            return;
        }
        List<BankLogin> bankLoginList = super.getBankLoginList();
        if (bankLoginList.size() == 0) {
            this.logger.info("\u6587\u4ef6\u4e0a\u4f20\u8c03\u5ea6-\u8be5\u79df\u6237-{}-\u672a\u914d\u7f6e\u524d\u7f6e\u673a", (Object)customId);
            return;
        }
        HashMap allBankLoginMap = Maps.newHashMapWithExpectedSize((int)bankLoginList.size());
        for (BankLogin bankLogin : bankLoginList) {
            Set<String> bankLoginSet = new HashSet<String>();
            if (allBankLoginMap.containsKey(bankLogin.getBankVersionId())) {
                bankLoginSet = (Set)allBankLoginMap.get(bankLogin.getBankVersionId());
            }
            bankLoginSet.add(bankLogin.getKey().getBankLoginId());
            allBankLoginMap.put(bankLogin.getBankVersionId(), bankLoginSet);
        }
        for (BankListEntity bankListEntity : bankListEntities) {
            String bankVersionId = bankListEntity.getNumber();
            String enable = bankListEntity.getEnable();
            if (Objects.equals(enable, "0")) {
                this.logger.info("\u6587\u4ef6\u4e0a\u4f20\u8c03\u5ea6-\u8be5\u79df\u6237-{}-\u672a\u542f\u7528\u8be5\u94f6\u884c-{}", new Object[]{customId, bankVersionId});
                continue;
            }
            if (!allBankLoginMap.containsKey(bankVersionId)) {
                this.logger.info("\u6587\u4ef6\u4e0a\u4f20\u8c03\u5ea6-\u8be5\u79df\u6237-{}-\u8be5\u94f6\u884c-{}-\u672a\u914d\u7f6e\u524d\u7f6e\u673a", new Object[]{customId, bankVersionId});
                continue;
            }
            if (!RequestContextUtils.receiptFormatIsFile((String)bankVersionId)) continue;
            Set bankLoginSet = (Set)allBankLoginMap.get(bankVersionId);
            ReceiptSystemProperties systemProperties = (ReceiptSystemProperties)EBConfigBuilder.getInstance().buildConfig(ReceiptSystemProperties.class);
            int uploadPeriod = systemProperties.getUploadPeriod();
            LocalDate startDate = LocalDate.now().minusDays(uploadPeriod);
            this.logger.info("\u6587\u4ef6\u4e0a\u4f20\u8c03\u5ea6-\u8be5\u79df\u6237{}-\u8be5\u94f6\u884c-{}-\u4e00\u5171\u914d\u7f6e\u4e86{}\u4e2a\u524d\u7f6e\u673a", new Object[]{customId, bankVersionId, bankLoginSet.size()});
            for (String bankLoginId : bankLoginSet) {
                List<Object> bankAcntList = super.getAcntsListByBankLogin(bankVersionId, bankLoginId);
                if ((bankAcntList = bankAcntList.stream().filter(item -> Objects.equals(RequestContext.get().getTenantId(), item.getCustomID())).collect(Collectors.toList())).size() == 0) {
                    this.logger.info("\u6587\u4ef6\u4e0a\u4f20\u8c03\u5ea6-\u8be5\u79df\u6237-{}-\u8be5\u94f6\u884c-{}-{}-\u4e0d\u5b58\u5728\u94f6\u884c\u56de\u5355\u8d26\u6237", new Object[]{customId, bankVersionId, bankLoginId});
                    continue;
                }
                List<DownloadListTask> downloadListTasks = super.getDownloadListTasksOfUpload(bankVersionId, bankLoginId, startDate, bankAcntList);
                for (DownloadListTask downloadListTask : downloadListTasks) {
                    ReceiptHandlerRequest receiptRequest = new ReceiptHandlerRequest();
                    receiptRequest.setBankVersion(bankVersionId);
                    receiptRequest.setType(this.name);
                    receiptRequest.setBankLoginId(bankLoginId);
                    receiptRequest.setCustomId(customId);
                    receiptRequest.setAccNo(downloadListTask.getAccNo());
                    receiptRequest.setTaskId(downloadListTask.getId());
                    receiptRequest.setTransDate(LocalDateUtil.formatDate((LocalDate)downloadListTask.getTransDate()));
                    receiptRequest.setBatchSeqId(downloadListTask.getBatchNo());
                    TaskActuator task = TaskFactory.getTask(receiptRequest);
                    ThreadPool threadPool = EBThreadPools.getThreadPool(this.name, bankLoginId, customId);
                    this.logger.info("\u5c06\u4efb\u52a1ID:{}-\u94f6\u884c\u7248\u672c\uff1a{}-\u8d26\u53f7\uff1a{}\u653e\u5165\u7ebf\u7a0b\u6c60\u4e2d\u8fdb\u884c\u4e0a\u4f20\u4efb\u52a1", new Object[]{downloadListTask.getId(), bankVersionId, downloadListTask.getAccNo()});
                    threadPool.submit((Callable)((Object)task));
                }
            }
        }
        this.logger.info("\u6587\u4ef6\u4e0a\u4f20\u4efb\u52a1\u5904\u7406\u5b8c\u6210-{}", (Object)customId);
    }

    @Override
    public boolean afterJob() {
        EBContext.destroy();
        return true;
    }
}

