/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.business.receipt.impl.handler.monitor;

import java.util.Date;
import java.util.List;
import java.util.Objects;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.framework.frame.Sequence;
import kd.ebg.egf.common.utils.datetime.DateUtil;
import kd.ebg.receipt.business.receipt.framework.ScheduleHanlder;
import kd.ebg.receipt.business.receipt.utils.MessageToUserUtil;
import kd.ebg.receipt.business.receipt.utils.ReceiptDownloadConnectMonitorUtils;
import kd.ebg.receipt.common.constant.monitor.ReceiptPushWayEnum;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.framework.receipt.bank.ReceiptSystemProperties;
import kd.ebg.receipt.common.framework.receipt.util.EBConfigBuilder;
import kd.ebg.receipt.common.framework.services.monitor.ReceiptConnectMonitorService;
import kd.ebg.receipt.common.model.monitor.ReceiptConnectMonitorInfo;
import kd.ebg.receipt.common.model.repository.monitor.AlertMessageRepository;
import kd.ebg.receipt.common.utils.FileCommonUtils;
import kd.ebg.receipt.common.utils.SpringContextUtil;

public class ConnectMonitorHandler
extends ScheduleHanlder {
    EBGLogger logger = EBGLogger.getInstance().getLogger(ConnectMonitorHandler.class);
    private ReceiptConnectMonitorService receiptConnectMonitorService;
    private AlertMessageRepository alertMessageRepository;

    public ConnectMonitorHandler(String name) {
        super(name);
    }

    @Override
    public boolean preJob() {
        this.receiptConnectMonitorService = (ReceiptConnectMonitorService)SpringContextUtil.getBean(ReceiptConnectMonitorService.class);
        this.alertMessageRepository = (AlertMessageRepository)SpringContextUtil.getBean(AlertMessageRepository.class);
        String customId = RequestContext.get().getTenantId();
        EBContext.setContext((EBContext)EBContext.builder().customID(customId).logBizSeqID(Sequence.genSequence()).logRequestSeqID(Sequence.genSequence()).bizName("receipt").build());
        return true;
    }

    @Override
    public void subProcess() {
        String customId = RequestContext.get().getTenantId();
        ReceiptSystemProperties receiptSystemProperties = (ReceiptSystemProperties)EBConfigBuilder.getInstance().buildConfig(ReceiptSystemProperties.class);
        ReceiptDownloadConnectMonitorUtils receiptDownloadConnectMonitorUtils = new ReceiptDownloadConnectMonitorUtils();
        this.logger.info("\u56de\u5355\u4e0b\u8f7d\u8fde\u63a5\u76d1\u63a7-\u4efb\u52a1\u5904\u7406\u5f00\u59cb-{}", (Object)customId);
        if (!this.isMeetSeedTime(receiptSystemProperties) && !FileCommonUtils.isTestEnv()) {
            return;
        }
        List receiptConnectMonitorInfos = this.receiptConnectMonitorService.selectAll();
        for (ReceiptConnectMonitorInfo connectMonitorInfo : receiptConnectMonitorInfos) {
            Long id = connectMonitorInfo.getId();
            String ip = connectMonitorInfo.getIp();
            String port = connectMonitorInfo.getPort();
            try {
                receiptDownloadConnectMonitorUtils.testConnect(id);
            }
            catch (Exception e) {
                this.logger.error("\u56de\u5355\u4e0b\u8f7d\u8fde\u63a5\u76d1\u63a7-\u6d4b\u8bd5\u8fde\u63a5\u5f02\u5e38-{}-ip:{}-port:{},\u5f02\u5e38\u539f\u56e0\uff1a", new Object[]{customId, ip, port, e.getMessage()});
                if (!this.isMeetSeedTime(receiptSystemProperties) && !FileCommonUtils.isTestEnv()) continue;
                String msg = this.packAlertMsg(ip, port, connectMonitorInfo.getReceipt_way());
                MessageToUserUtil messageToUserUtil = new MessageToUserUtil();
                messageToUserUtil.sendAlertMsgToUser(receiptSystemProperties, msg, "3");
            }
        }
        this.logger.info("\u56de\u5355\u4e0b\u8f7d\u8fde\u63a5\u76d1\u63a7-\u4efb\u52a1\u5904\u7406\u5b8c\u6210-{}", (Object)customId);
    }

    public String packAlertMsg(String ip, String port, String way) {
        String msg;
        StringBuilder alertMsg = new StringBuilder();
        if (Objects.equals(way, ReceiptPushWayEnum.SFTP.getCode())) {
            msg = String.format(ResManager.loadKDString((String)"\u3010\u7535\u5b50\u56de\u5355\u3011-\u3010\u56de\u5355\u4e0b\u8f7d\u8fde\u63a5\u76d1\u63a7\u3011\u8fdc\u7a0bSFTP\u670d\u52a1%1$s:%2$s\u8fde\u63a5\u5f02\u5e38\uff0c\u8bf7\u53ca\u65f6\u5173\u6ce8\u3002", (String)"ConnectMonitorHandler_2", (String)"ebg-receipt-business", (Object[])new Object[0]), ip, port);
            alertMsg.append(msg);
        }
        if (Objects.equals(way, ReceiptPushWayEnum.BANK_LOGIN.getCode())) {
            msg = String.format(ResManager.loadKDString((String)"\u3010\u7535\u5b50\u56de\u5355\u3011-\u3010\u56de\u5355\u4e0b\u8f7d\u8fde\u63a5\u76d1\u63a7\u3011\u524d\u7f6e\u673a\u4ee3\u7406\u670d\u52a1%1$s:%2$s\u8fde\u63a5\u5f02\u5e38\uff0c\u8bf7\u53ca\u65f6\u5173\u6ce8\u3002", (String)"ConnectMonitorHandler_3", (String)"ebg-receipt-business", (Object[])new Object[0]), ip, port);
            alertMsg.append(msg);
        }
        return alertMsg.toString();
    }

    public boolean isMeetSeedTime(ReceiptSystemProperties receiptSystemProperties) {
        Integer monitorTimeStr = receiptSystemProperties.getConnect_monitor_time();
        String time = DateUtil.formatDate((Date)new Date(), (String)"yyyyMMddHHmm");
        int hour = Integer.parseInt(time.substring(8, 10));
        int min = Integer.parseInt(time.substring(10, 12));
        int nowSec = hour * 3600 + min * 60;
        monitorTimeStr = monitorTimeStr - 2100;
        int end = monitorTimeStr + 300;
        return monitorTimeStr <= nowSec && nowSec <= end;
    }

    @Override
    public boolean afterJob() {
        EBContext.destroy();
        return true;
    }
}

