/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.business.receipt.impl.handler.reconciliation;

import com.google.common.collect.Maps;
import java.time.LocalDate;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Callable;
import kd.bos.context.RequestContext;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.framework.frame.Sequence;
import kd.ebg.egf.common.framework.service.acnt.BankAcntService;
import kd.ebg.egf.common.framework.service.bank.BankLoginService;
import kd.ebg.egf.common.framework.service.bank.BankVersionService;
import kd.ebg.egf.common.model.bank.BankListEntity;
import kd.ebg.egf.common.model.bank.login.BankLogin;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.receipt.business.receipt.entity.ReceiptHandlerRequest;
import kd.ebg.receipt.business.receipt.framework.EBThreadPools;
import kd.ebg.receipt.business.receipt.framework.ScheduleHanlder;
import kd.ebg.receipt.business.receipt.framework.TaskActuator;
import kd.ebg.receipt.business.receipt.framework.TaskFactory;
import kd.ebg.receipt.common.framework.context.RequestContextUtils;
import kd.ebg.receipt.common.framework.frame.BankBundleManager;
import kd.ebg.receipt.common.framework.frame.BankVersion;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.framework.receipt.bank.BankReconciliationProperties;
import kd.ebg.receipt.common.framework.receipt.util.EBConfigBuilder;

public class CreateTaskHandler
extends ScheduleHanlder {
    EBGLogger logger = EBGLogger.getInstance().getLogger(CreateTaskHandler.class);

    public CreateTaskHandler(String name) {
        super(name);
    }

    @Override
    public boolean preJob() {
        String customId = RequestContext.get().getTenantId();
        EBContext.setContext((EBContext)EBContext.builder().customID(customId).logBizSeqID(Sequence.genSequence()).logRequestSeqID(Sequence.genSequence()).bizName("receipt").build());
        return true;
    }

    @Override
    public void subProcess() {
        BankLoginService bankLoginService = BankLoginService.getInstance();
        BankVersionService bankVersionService = BankVersionService.getInstance();
        BankAcntService bankAcntService = BankAcntService.getInstance();
        BankBundleManager bankBundleManager = BankBundleManager.getInstance();
        String customId = RequestContext.get().getTenantId();
        List<BankListEntity> bankListEntities = super.getBankListEntities();
        if (bankListEntities.size() == 0) {
            this.logger.info("\u8be5\u79df\u6237-{}-\u542f\u7528\u7684\u94f6\u884c\u5217\u8868\u4e3a\u7a7a", (Object)customId);
            return;
        }
        List<BankLogin> bankLoginList = super.getBankLoginList();
        if (bankLoginList.size() == 0) {
            this.logger.info("\u8be5\u79df\u6237-{}-\u672a\u914d\u7f6e\u524d\u7f6e\u673a", (Object)customId);
            return;
        }
        HashMap allBankLoginMap = Maps.newHashMapWithExpectedSize((int)8);
        for (BankLogin bankLogin : bankLoginList) {
            Set<String> bankLoginSet = new HashSet<String>();
            if (allBankLoginMap.containsKey(bankLogin.getBankVersionId())) {
                bankLoginSet = (Set)allBankLoginMap.get(bankLogin.getBankVersionId());
            }
            bankLoginSet.add(bankLogin.getKey().getBankLoginId());
            allBankLoginMap.put(bankLogin.getBankVersionId(), bankLoginSet);
        }
        LocalDate startDate = LocalDate.now().minusDays(1L);
        String startDateStr = LocalDateUtil.formatDate((LocalDate)startDate);
        for (BankListEntity bankListEntity : bankListEntities) {
            String bankVersionId = bankListEntity.getNumber();
            String enable = bankListEntity.getEnable();
            if (!RequestContextUtils.isSupportReconciliationOfBankVersion((String)bankVersionId)) {
                this.logger.info("\u5bf9\u8d26\u5355\u4e0b\u8f7d\u8c03\u5ea6-\u8be5\u79df\u6237-{}-\u8be5\u94f6\u884c\u672a\u5f00\u53d1\u5bf9\u8d26\u5355\u6a21\u5757-{}", new Object[]{customId, bankVersionId});
                continue;
            }
            if (Objects.equals(enable, "0")) {
                this.logger.info("\u8be5\u79df\u6237-{}-\u672a\u542f\u7528\u8be5\u94f6\u884c-{}", new Object[]{customId, bankVersionId});
                continue;
            }
            if (!allBankLoginMap.containsKey(bankVersionId)) {
                this.logger.info("\u8be5\u79df\u6237-{}-\u8be5\u94f6\u884c-{}-\u672a\u914d\u7f6e\u524d\u7f6e\u673a", new Object[]{customId, bankVersionId});
                continue;
            }
            Set bankLoginSet = (Set)allBankLoginMap.get(bankVersionId);
            this.logger.info("\u8be5\u79df\u6237{}-\u8be5\u94f6\u884c-{}-\u4e00\u5171\u914d\u7f6e\u4e86{}\u4e2a\u524d\u7f6e\u673a", new Object[]{customId, bankVersionId, bankLoginSet.size()});
            BankVersion versionInfo = bankBundleManager.getBankVersionInfo(bankVersionId);
            if (Objects.isNull(versionInfo)) {
                this.logger.info("\u8be5\u79df\u6237{}-\u8be5\u94f6\u884c-{}-\u8fd8\u672a\u5f00\u53d1\u5bf9\u8d26\u5355\u6a21\u5757", new Object[]{customId, bankVersionId});
                continue;
            }
            EBContext.getContext().setBankVersionID(bankVersionId);
            for (String bankLoginId : bankLoginSet) {
                if (!RequestContextUtils.isSupportReconciliation((String)bankLoginId)) continue;
                BankReconciliationProperties bankBusinessProperties = (BankReconciliationProperties)EBConfigBuilder.getInstance().buildConfig(BankReconciliationProperties.class, bankLoginId);
                if (Objects.equals(bankBusinessProperties.getIsMonthReconciliation(), "true")) {
                    startDate = LocalDate.now().minusMonths(1L);
                    startDateStr = LocalDateUtil.formatDate((LocalDate)startDate, (String)"yyyyMM") + "01";
                }
                EBContext.getContext().setBankLoginID(bankLoginId);
                ReceiptHandlerRequest receiptHandlerRequest = new ReceiptHandlerRequest();
                receiptHandlerRequest.setBankVersion(bankVersionId);
                receiptHandlerRequest.setBatchSeqId(Sequence.genSequence());
                receiptHandlerRequest.setTransDate(startDateStr);
                receiptHandlerRequest.setType(this.name);
                receiptHandlerRequest.setBankLoginId(bankLoginId);
                receiptHandlerRequest.setCustomId(customId);
                TaskActuator task = TaskFactory.getTask(receiptHandlerRequest);
                EBThreadPools.getThreadPool(this.name, bankLoginId, customId).submit((Callable)((Object)task));
            }
        }
        this.logger.info("\u521b\u5efa\u4efb\u52a1\u5904\u7406\u5b8c\u6210-{}", (Object)customId);
    }

    @Override
    public boolean afterJob() {
        EBContext.destroy();
        return true;
    }
}

