/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.business.receipt.impl.handler.reconciliation;

import com.google.common.collect.Maps;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.util.ConfigurationUtil;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.framework.frame.Sequence;
import kd.ebg.egf.common.framework.service.acnt.BankAcntService;
import kd.ebg.egf.common.framework.service.bank.BankLoginService;
import kd.ebg.egf.common.framework.service.bank.BankVersionService;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.model.bank.BankListEntity;
import kd.ebg.egf.common.model.bank.login.BankLogin;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.receipt.business.receipt.entity.ReceiptHandlerRequest;
import kd.ebg.receipt.business.receipt.entity.TaskStatus;
import kd.ebg.receipt.business.receipt.framework.EBThreadPools;
import kd.ebg.receipt.business.receipt.framework.ScheduleHanlder;
import kd.ebg.receipt.business.receipt.framework.TaskActuator;
import kd.ebg.receipt.business.receipt.framework.TaskFactory;
import kd.ebg.receipt.common.core.utils.EBGStringUtils;
import kd.ebg.receipt.common.framework.context.RequestContextUtils;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.framework.services.reconciliation.ReconciliationDownloadListDetailService;
import kd.ebg.receipt.common.framework.services.reconciliation.ReconciliationDownloadTaskService;
import kd.ebg.receipt.common.model.reconciliation.ReconciliationInfo;
import kd.ebg.receipt.common.utils.SpringContextUtil;

public class DownLoadTaskHandler
extends ScheduleHanlder {
    EBGLogger logger = EBGLogger.getInstance().getLogger(DownLoadTaskHandler.class);
    private BankLoginService bankLoginService;
    private BankVersionService bankVersionService;
    private BankAcntService bankAcntService;
    private ReconciliationDownloadTaskService reconciliationDownloadTaskService;
    private ReconciliationDownloadListDetailService reconciliationDownloadListDetailService;
    private int hour = 9;

    public DownLoadTaskHandler(String name) {
        super(name);
    }

    @Override
    public boolean preJob() {
        String hourStr = ConfigurationUtil.getString((String)"receipt.download.hour");
        try {
            if (!EBGStringUtils.isEmpty((String)hourStr)) {
                this.hour = Integer.parseInt(hourStr);
                if (this.hour < 1) {
                    this.hour = 1;
                }
            }
        }
        catch (Exception e) {
            this.hour = 2;
        }
        this.bankLoginService = BankLoginService.getInstance();
        this.bankVersionService = BankVersionService.getInstance();
        this.bankAcntService = BankAcntService.getInstance();
        this.reconciliationDownloadTaskService = (ReconciliationDownloadTaskService)SpringContextUtil.getBean(ReconciliationDownloadTaskService.class);
        this.reconciliationDownloadListDetailService = (ReconciliationDownloadListDetailService)SpringContextUtil.getBean(ReconciliationDownloadListDetailService.class);
        String customId = RequestContext.get().getTenantId();
        EBContext.setContext((EBContext)EBContext.builder().customID(customId).logBizSeqID(Sequence.genSequence()).logRequestSeqID(Sequence.genSequence()).bizName("receipt").build());
        return true;
    }

    @Override
    public boolean afterJob() {
        EBContext.destroy();
        return true;
    }

    @Override
    public void subProcess() {
        List<BankListEntity> bankListEntities;
        String customId = RequestContext.get().getTenantId();
        LocalDateTime nowTime = LocalDateTime.now();
        if (nowTime.getHour() < this.hour) {
            this.logger.info("\u5bf9\u8d26\u5355\u4e0b\u8f7d\u8c03\u5ea6-\u8be5\u79df\u6237-{}-\u4e0d\u80fd\u5728\u8bbe\u5b9a\u7684\u6307\u5b9a\u65f6\u95f4\u4e4b\u524d\u6267\u884c-\u76ee\u524d\u8bbe\u7f6e\u7684\u65f6\u95f4\u70b9\u662f-{}\u70b9", new Object[]{customId, this.hour});
        }
        if ((bankListEntities = super.getBankListEntities()).size() == 0) {
            this.logger.info("\u5bf9\u8d26\u5355\u4e0b\u8f7d\u8c03\u5ea6-\u8be5\u79df\u6237-{}-\u542f\u7528\u7684\u94f6\u884c\u5217\u8868\u4e3a\u7a7a", (Object)customId);
            return;
        }
        List<BankLogin> bankLoginList = super.getBankLoginList();
        if (bankLoginList.size() == 0) {
            this.logger.info("\u5bf9\u8d26\u5355\u4e0b\u8f7d\u8c03\u5ea6-\u8be5\u79df\u6237-{}-\u672a\u914d\u7f6e\u524d\u7f6e\u673a", (Object)customId);
            return;
        }
        HashMap allBankLoginMap = Maps.newHashMapWithExpectedSize((int)16);
        for (BankLogin bankLogin : bankLoginList) {
            Set<String> bankLoginSet = new HashSet<String>();
            if (allBankLoginMap.containsKey(bankLogin.getBankVersionId())) {
                bankLoginSet = (Set)allBankLoginMap.get(bankLogin.getBankVersionId());
            }
            bankLoginSet.add(bankLogin.getKey().getBankLoginId());
            allBankLoginMap.put(bankLogin.getBankVersionId(), bankLoginSet);
        }
        for (BankListEntity bankListEntity : bankListEntities) {
            String bankVersionId = bankListEntity.getNumber();
            String enable = bankListEntity.getEnable();
            if (!RequestContextUtils.isSupportReconciliationOfBankVersion((String)bankVersionId)) {
                this.logger.info("\u5bf9\u8d26\u5355\u4e0b\u8f7d\u8c03\u5ea6-\u8be5\u79df\u6237-{}-\u8be5\u94f6\u884c\u672a\u5f00\u53d1\u5bf9\u8d26\u5355\u6a21\u5757-{}", new Object[]{customId, bankVersionId});
                continue;
            }
            if (Objects.equals(enable, "0")) {
                this.logger.info("\u5bf9\u8d26\u5355\u4e0b\u8f7d\u8c03\u5ea6-\u8be5\u79df\u6237-{}-\u672a\u542f\u7528\u8be5\u94f6\u884c-{}", new Object[]{customId, bankVersionId});
                continue;
            }
            if (!allBankLoginMap.containsKey(bankVersionId)) {
                this.logger.info("\u5bf9\u8d26\u5355\u4e0b\u8f7d\u8c03\u5ea6-\u8be5\u79df\u6237-{}-\u8be5\u94f6\u884c-{}-\u672a\u914d\u7f6e\u524d\u7f6e\u673a", new Object[]{customId, bankVersionId});
                continue;
            }
            ArrayList<Integer> statusList = new ArrayList<Integer>(16);
            statusList.add(TaskStatus.CREATE.getId());
            statusList.add(TaskStatus.COMPLETED.getId());
            List downloadListTasks = this.reconciliationDownloadTaskService.findByCoustomIdAndStatusListAndBankVersion(customId, statusList, bankVersionId);
            boolean isAccNoOfReconciliationByBank = RequestContextUtils.isAccNoOfReconciliationByBank((String)bankVersionId);
            Set bankLoginSet = (Set)allBankLoginMap.get(bankVersionId);
            this.logger.info("\u8be5\u79df\u6237{}-\u8be5\u94f6\u884c-{}-\u4e00\u5171\u914d\u7f6e\u4e86{}\u4e2a\u524d\u7f6e\u673a", new Object[]{customId, bankVersionId, bankLoginSet.size()});
            for (String bankLoginId : bankLoginSet) {
                if (!RequestContextUtils.isSupportReconciliation((String)bankLoginId)) continue;
                List<BankAcnt> bankAcntList = super.getAcntsListByBankLogin(bankVersionId, bankLoginId);
                if (bankAcntList.size() == 0) {
                    this.logger.info("\u5bf9\u8d26\u5355\u4e0b\u8f7d\u8c03\u5ea6-\u8be5\u79df\u6237-{}-\u8be5\u94f6\u884c-{}-{}-\u4e0d\u5b58\u5728\u94f6\u884c\u56de\u5355\u8d26\u6237", new Object[]{customId, bankVersionId, bankLoginId});
                    continue;
                }
                RequestContextUtils.handBankAcntListByBankVersion(bankAcntList);
                Map<String, String> accNoMap = bankAcntList.stream().collect(Collectors.toMap(item -> item.getAccNo(), item -> item.getAccNo()));
                List result = isAccNoOfReconciliationByBank ? downloadListTasks.stream().filter(o -> accNoMap.containsKey(o.getAccNo()) && o.getBankLoginId().equals(bankLoginId)).collect(Collectors.toList()) : downloadListTasks.stream().filter(o -> o.getBankLoginId().equals(bankLoginId)).collect(Collectors.toList());
                for (ReconciliationInfo downloadListTask : result) {
                    if (!Objects.equals(downloadListTask.getBankLoginId(), bankLoginId)) {
                        downloadListTask.setBankLoginId(bankLoginId);
                        this.reconciliationDownloadTaskService.update(downloadListTask);
                        List detailList = this.reconciliationDownloadListDetailService.selectByRefId(Long.valueOf(downloadListTask.getId()));
                        detailList.forEach(o -> o.setBankLoginId(bankLoginId));
                        this.reconciliationDownloadListDetailService.updateAll(detailList);
                    }
                    ReceiptHandlerRequest receiptRequest = new ReceiptHandlerRequest();
                    receiptRequest.setBankVersion(bankVersionId);
                    receiptRequest.setBatchSeqId(Sequence.gen8Sequence());
                    receiptRequest.setTransDate(LocalDateUtil.formatDate((LocalDate)downloadListTask.getTransDate()));
                    receiptRequest.setType(this.name);
                    receiptRequest.setBankLoginId(bankLoginId);
                    receiptRequest.setCustomId(downloadListTask.getCustomNo());
                    receiptRequest.setTaskId(downloadListTask.getId());
                    receiptRequest.setAccNo(downloadListTask.getAccNo());
                    TaskActuator task = TaskFactory.getTask(receiptRequest);
                    EBThreadPools.getThreadPool(this.name, bankLoginId, customId).submit((Callable)((Object)task));
                }
            }
        }
        this.logger.info("\u4e0b\u8f7d\u4efb\u52a1\u5904\u7406\u5b8c\u6210-{}", (Object)customId);
    }
}

