/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.business.receipt.impl.task;

import com.google.common.collect.Maps;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.util.StringUtils;
import kd.ebg.egf.common.cache.CosmicCache;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.framework.service.properties.ObjectPropertyService;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.receipt.business.receipt.entity.HandlerType;
import kd.ebg.receipt.business.receipt.entity.ReceiptHandlerRequest;
import kd.ebg.receipt.business.receipt.entity.TaskStatus;
import kd.ebg.receipt.business.receipt.framework.TaskActuator;
import kd.ebg.receipt.common.constant.DetailDownloadStatusEnum;
import kd.ebg.receipt.common.constant.MatchStatusEnum;
import kd.ebg.receipt.common.constant.UploadStatusEnum;
import kd.ebg.receipt.common.constant.defect.ReceiptDefectTypeEnum;
import kd.ebg.receipt.common.framework.context.RequestContextUtils;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.framework.receipt.bank.ReceiptSystemProperties;
import kd.ebg.receipt.common.framework.receipt.util.EBConfigBuilder;
import kd.ebg.receipt.common.framework.services.receipt.DownloadListDetailService;
import kd.ebg.receipt.common.framework.services.receipt.DownloadTaskService;
import kd.ebg.receipt.common.framework.services.receipt.EBCReceiptInfoJsonService;
import kd.ebg.receipt.common.framework.utils.ReceiptCommonAipUtil;
import kd.ebg.receipt.common.model.DetailInfo;
import kd.ebg.receipt.common.model.receipt.DownloadListDetail;
import kd.ebg.receipt.common.model.receipt.DownloadListTask;
import kd.ebg.receipt.common.model.repository.DetailInfoRepository;
import kd.ebg.receipt.common.utils.SpringContextUtil;
import org.slf4j.MDC;

public class IntegrityTask
extends TaskActuator {
    EBGLogger logger = EBGLogger.getInstance().getLogger(IntegrityTask.class);
    private DownloadTaskService downloadTaskService;
    private DownloadListDetailService downloadListDetailService;
    private DetailInfoRepository detailInfoRepository;
    public EBCReceiptInfoJsonService receiptInfoJsonService;
    private int checkReceiptNum = 3;

    public IntegrityTask(ReceiptHandlerRequest request) {
        super(request);
    }

    @Override
    public boolean preTask() {
        String cacheKey = String.format("upload_key_%s_%s", RequestContext.get().getAccountId(), Long.toString(this.receiptHandlerRequest.getTaskId()));
        String value = CosmicCache.get((String)cacheKey);
        if (StringUtils.isNotEmpty((String)value) && Objects.equals(value, "uploading")) {
            return false;
        }
        this.downloadListDetailService = (DownloadListDetailService)SpringContextUtil.getBean(DownloadListDetailService.class);
        this.downloadTaskService = (DownloadTaskService)SpringContextUtil.getBean(DownloadTaskService.class);
        this.detailInfoRepository = (DetailInfoRepository)SpringContextUtil.getBean(DetailInfoRepository.class);
        this.receiptInfoJsonService = (EBCReceiptInfoJsonService)SpringContextUtil.getBean(EBCReceiptInfoJsonService.class);
        String bankVersionId = this.receiptHandlerRequest.getBankVersion();
        String bankLoginId = this.receiptHandlerRequest.getBankLoginId();
        String customId = this.receiptHandlerRequest.getCustomId();
        String batchNo = this.receiptHandlerRequest.getBatchSeqId();
        long taskId = this.receiptHandlerRequest.getTaskId();
        String transDate = this.receiptHandlerRequest.getTransDate();
        EBContext.setContext((EBContext)EBContext.builder().customID(customId).bankLoginID(bankLoginId).bankVersionID(bankVersionId).logBizSeqID(taskId + "").logRequestSeqID(taskId + "").bizName("receipt").build());
        MDC.put((String)"bankVersion", (String)bankVersionId);
        MDC.put((String)"transDate", (String)transDate);
        String accNo = this.receiptHandlerRequest.getAccNo();
        BankAcnt bankAcnt = new BankAcnt();
        bankAcnt.setAccNo(accNo);
        EBContext.getContext().setBankAcnt(bankAcnt);
        ReceiptSystemProperties receiptSystemProperties = (ReceiptSystemProperties)EBConfigBuilder.getInstance().buildConfig(ReceiptSystemProperties.class);
        this.checkReceiptNum = receiptSystemProperties.getRetryingNum();
        DownloadListTask downloadListTask = this.downloadTaskService.findById(taskId);
        if (downloadListTask.getStatus().intValue() == TaskStatus.DOWNLOADED.getId()) {
            this.updateTaskStatus(downloadListTask, TaskStatus.CHECKING.getId());
        }
        EBContext.getContext().setType("integrity");
        return true;
    }

    @Override
    public boolean afterTask() {
        MDC.remove((String)"bankVersion");
        MDC.remove((String)"type");
        EBContext.destroy();
        return true;
    }

    public void updateTaskStatus(DownloadListTask task, Integer status) {
        task.setStatus(status);
        task.setCompleteTime(LocalDateTime.now());
        this.downloadTaskService.update(task);
    }

    @Override
    public void subProcess() {
        this.logger.info("\u4efb\u52a1\u6267\u884c\u5668\uff1a\u5b8c\u6574\u5ea6\u68c0\u67e5\u4efb\u52a1");
        String bankVersionId = this.receiptHandlerRequest.getBankVersion();
        String accNo = this.receiptHandlerRequest.getAccNo();
        long taskId = this.receiptHandlerRequest.getTaskId();
        DownloadListTask downloadListTask = this.downloadTaskService.findById(taskId);
        String customId = downloadListTask.getCustomNo();
        LocalDate transDate = downloadListTask.getTransDate();
        this.logger.info("\u4efb\u52a1\u6267\u884c\u5668\uff1a\u5b8c\u6574\u5ea6\u68c0\u67e5\u4efb\u52a1-{}-{}", new Object[]{accNo, transDate});
        List downloadListDetailList = this.downloadListDetailService.selectByRefId(Long.valueOf(taskId));
        List detailInfoList = this.detailInfoRepository.findByAccNoAndBankVersionIDAndTransDateBetween(accNo, bankVersionId, transDate, transDate);
        HashMap detailInfoMap = Maps.newHashMapWithExpectedSize((int)detailInfoList.size());
        detailInfoList.forEach(o -> detailInfoMap.put(o.getReceiptNo(), o));
        List yesterdayDetails = this.detailInfoRepository.findByAccNoAndBankVersionIDAndTransDateBetween(accNo, bankVersionId, transDate.minusDays(1L), transDate.minusDays(1L));
        this.logger.info("\u5339\u914d\u56de\u5355\u4efb\u52a1-{}-{}-\u660e\u7ec6\u6570\u91cf\uff1a{}", new Object[]{accNo, transDate, detailInfoList.size()});
        HashMap yesterdayDetailInfoMap = Maps.newHashMapWithExpectedSize((int)yesterdayDetails.size());
        yesterdayDetails.forEach(o -> yesterdayDetailInfoMap.put(o.getReceiptNo(), o));
        this.logger.info("\u4efb\u52a1\u6267\u884c\u5668\uff1a\u5b8c\u6574\u5ea6\u68c0\u67e5\u4efb\u52a1-{}-{}-\u4ea4\u6613\u660e\u7ec6\u6570\u91cf\uff1a{} \u56de\u5355\u6570\u91cf\uff1a{}", new Object[]{accNo, transDate, detailInfoList.size(), detailInfoList.size()});
        boolean isPullDetail = ReceiptCommonAipUtil.isPullRecordByCustomIdTransDateAndAccNo((String)customId, (LocalDate)downloadListTask.getTransDate(), (String)accNo);
        this.logger.info("\u4efb\u52a1\u6267\u884c\u5668\uff1a\u5b8c\u6574\u5ea6\u68c0\u67e5\u4efb\u52a1-{}-{}-\u4ea4\u6613\u660e\u7ec6\u6570\u91cf\uff1a{}-\u662f\u5426\u62c9\u53d6\u8fc7\u6d41\u6c34\uff1a{}", new Object[]{accNo, transDate, detailInfoList.size(), isPullDetail});
        ObjectPropertyService objectPropertyService = ObjectPropertyService.getInstance();
        String bankVersionID = this.receiptHandlerRequest.getBankVersion();
        String detailSerachDateStr = objectPropertyService.getBankSearchDetailDate(bankVersionID);
        if (StringUtils.isNotEmpty((String)detailSerachDateStr)) {
            LocalDate detailSearchDate = LocalDate.parse(detailSerachDateStr.replace("-", ""), DateTimeFormatter.BASIC_ISO_DATE);
            if (downloadListTask.getTransDate().isBefore(detailSearchDate)) {
                downloadListTask.setRedo(Integer.valueOf(0));
                downloadListTask.setDetailFlag(Integer.valueOf(DetailDownloadStatusEnum.DOWNLOAD_SUCCESS.getId()));
                this.updateTaskStatus(downloadListTask, TaskStatus.CHECKED.getId());
                return;
            }
        }
        if (detailInfoList.size() == 0) {
            boolean isBeforeThreeMonth;
            long diffDays = ChronoUnit.DAYS.between(transDate, LocalDate.now());
            boolean bl = isBeforeThreeMonth = diffDays > 90L;
            if (isPullDetail && transDate.isBefore(LocalDate.now()) || isBeforeThreeMonth || LocalDate.now().isBefore(transDate)) {
                downloadListTask.setRedo(Integer.valueOf(0));
                downloadListTask.setMatchNum(Integer.valueOf(0));
                downloadListTask.setReceiptNum(Integer.valueOf(downloadListDetailList.size()));
                downloadListTask.setTxDetailNum(Integer.valueOf(0));
                downloadListTask.setDefectType(ReceiptDefectTypeEnum.NULL.getCode());
                downloadListTask.setRedo(Integer.valueOf(0));
                downloadListTask.setDetailFlag(Integer.valueOf(DetailDownloadStatusEnum.DOWNLOAD_SUCCESS.getId()));
                if (isBeforeThreeMonth && downloadListDetailList.size() > 0) {
                    downloadListTask.setExpmsg(ResManager.loadKDString((String)"\u5f53\u65e5\u8fd8\u672a\u4e0b\u8f7d\u4ea4\u6613\u660e\u7ec6", (String)"IntegrityTask_0", (String)"ebg-receipt-business", (Object[])new Object[0]));
                    downloadListTask.setDetailFlag(Integer.valueOf(DetailDownloadStatusEnum.UN_DOWNLOAD.getId()));
                }
                this.updateTaskStatus(downloadListTask, TaskStatus.FINISH.getId());
                Iterator iterable = downloadListDetailList.iterator();
                while (iterable.hasNext()) {
                    DownloadListDetail detail = (DownloadListDetail)iterable.next();
                    if (this.handleDailyCut(detail, yesterdayDetailInfoMap)) {
                        iterable.remove();
                        continue;
                    }
                    detail.setMatchFlag(Integer.valueOf(MatchStatusEnum.FAIL.getId()));
                    detail.setStatus(Integer.valueOf(TaskStatus.FINISH.getId()));
                }
                this.downloadListDetailService.updateAll(downloadListDetailList);
                return;
            }
            downloadListTask.setDetailFlag(Integer.valueOf(isPullDetail ? DetailDownloadStatusEnum.DOWNLOAD_SUCCESS.getId() : DetailDownloadStatusEnum.UN_DOWNLOAD.getId()));
            this.updateTaskStatus(downloadListTask, downloadListTask.getStatus());
            return;
        }
        String cacheName = String.format("checkReceiptNum-%s-%s", downloadListTask.getAccNo(), LocalDateUtil.formatDate((LocalDate)downloadListTask.getTransDate()));
        String checkReceiptNumCache = CosmicCache.get((String)cacheName);
        int checkReceiptNumInt = 1;
        if (StringUtils.isNotEmpty((String)checkReceiptNumCache)) {
            checkReceiptNumInt = Integer.parseInt(checkReceiptNumCache);
        }
        if (detailInfoList.size() > downloadListDetailList.size() && RequestContextUtils.isCheckReceiptNum() && checkReceiptNumInt <= this.checkReceiptNum) {
            this.logger.info("\u56de\u5355\u6570\u91cf\u8ddf\u4ea4\u6613\u660e\u7ec6\u6570\u91cf\u4e0d\u4e00\u81f4\uff0c\u56de\u5355\u6570\u91cf\uff1a{} \u4ea4\u6613\u660e\u7ec6\u6570\u91cf\uff1a{}-\u8d26\u53f7\uff1a{}-\u65e5\u671f\uff1a{}-\u56de\u5355\u4efb\u52a1\u91cd\u7f6e\u4e3a\u521b\u5efa\u72b6\u6001\u91cd\u65b0\u4e0b\u8f7d-\u7b2c{}\u6b21", new Object[]{downloadListDetailList.size(), detailInfoList.size(), accNo, transDate, checkReceiptNumInt});
            downloadListTask.setRedo(Integer.valueOf(0));
            downloadListTask.setDefectType(ReceiptDefectTypeEnum.PUSH_DEFECT_RECEIPT.getCode());
            downloadListTask.setExpmsg(String.format(ResManager.loadKDString((String)"\u672c\u6b21\u4efb\u52a1\u83b7\u53d6\u7684\u56de\u5355\u6570\u91cf%1$s\u6761\uff0c\u4ea4\u6613\u660e\u7ec6%2$s\u6761\uff0c\u8bf7\u8054\u7cfb\u94f6\u884c\u63a8\u9001\u56de\u5355\u6587\u4ef6\u540e\u518d\u91cd\u65b0\u4e0b\u8f7d\u3002", (String)"IntegrityTask_2", (String)"ebg-receipt-business", (Object[])new Object[0]), Integer.toString(downloadListDetailList.size()), Integer.toString(detailInfoList.size())));
            downloadListTask.setDetailFlag(Integer.valueOf(DetailDownloadStatusEnum.DOWNLOAD_SUCCESS.getId()));
            this.updateTaskStatus(downloadListTask, TaskStatus.CREATE.getId());
            ArrayList<Long> ids = new ArrayList<Long>(16);
            for (DownloadListDetail detail : downloadListDetailList) {
                String receiptNo = detail.getDetailNo();
                if (detailInfoMap.containsKey(receiptNo) && detail.getMatchFlag().intValue() != MatchStatusEnum.SUCCESS.getId()) {
                    detail.setMatchFlag(Integer.valueOf(MatchStatusEnum.SUCCESS.getId()));
                    DetailInfo detailInfo = (DetailInfo)detailInfoMap.get(receiptNo);
                    detail.setDetailId(detailInfo.getId());
                    this.updateTaskDetailStatus(detail, TaskStatus.FINISH.getId());
                    this.receiptInfoJsonService.deleteByDetailId(detail.getId());
                }
                if (this.isNeedSkip(detail)) continue;
                ids.add(detail.getId());
            }
            this.downloadListDetailService.deleteAll(ids);
            this.receiptInfoJsonService.deleteByDetailIdList(ids);
            CosmicCache.putWithExpire((String)cacheName, (String)String.valueOf(checkReceiptNumInt + 1), (int)24, (TimeUnit)TimeUnit.HOURS);
            return;
        }
        CosmicCache.delete((String)cacheName);
        if (detailInfoList.size() > downloadListDetailList.size()) {
            downloadListTask.setExpmsg(String.format(ResManager.loadKDString((String)"\u672c\u6b21\u4efb\u52a1\u83b7\u53d6\u7684\u56de\u5355\u6570\u91cf%1$s\u6761\uff0c\u4ea4\u6613\u660e\u7ec6%2$s\u6761\uff0c\u8bf7\u8054\u7cfb\u94f6\u884c\u63a8\u9001\u56de\u5355\u6587\u4ef6\u540e\u518d\u91cd\u65b0\u4e0b\u8f7d\u3002", (String)"IntegrityTask_2", (String)"ebg-receipt-business", (Object[])new Object[0]), Integer.toString(downloadListDetailList.size()), Integer.toString(detailInfoList.size())));
            downloadListTask.setDefectType(ReceiptDefectTypeEnum.PUSH_DEFECT_RECEIPT.getCode());
        }
        downloadListTask.setRedo(Integer.valueOf(0));
        downloadListTask.setDetailFlag(Integer.valueOf(DetailDownloadStatusEnum.DOWNLOAD_SUCCESS.getId()));
        this.updateTaskStatus(downloadListTask, TaskStatus.CHECKED.getId());
        this.logger.info("\u4efb\u52a1\u6267\u884c\u5668\uff1a\u5b8c\u6574\u5ea6\u68c0\u67e5\u5b8c\u6210");
    }

    public void updateTaskDetailStatus(DownloadListDetail detail, Integer status) {
        detail.setStatus(status);
        detail.setCompleteTime(LocalDateTime.now());
        this.downloadListDetailService.update(detail);
    }

    @Override
    public boolean match() {
        return HandlerType.INTEGRITY.getName().equals(this.receiptHandlerRequest.getType());
    }

    private boolean isNeedSkip(DownloadListDetail downloadListDetail) {
        return downloadListDetail.getMatchFlag().intValue() == MatchStatusEnum.SUCCESS.getId() || downloadListDetail.getUploadFlag().intValue() == UploadStatusEnum.UPLOAD_SUCCESS.getId();
    }

    public boolean handleDailyCut(DownloadListDetail detail, Map<String, DetailInfo> yesterdayDetailInfoMap) {
        String transDateStr = LocalDateUtil.formatDate((LocalDate)detail.getTransDate());
        String yesterdayDateStr = LocalDateUtil.formatDate((LocalDate)detail.getTransDate().minusDays(1L));
        String receiptNo = detail.getDetailNo();
        String againReceiptNo = receiptNo.replace(String.format("-%s-", transDateStr), String.format("-%s-", yesterdayDateStr));
        if (yesterdayDetailInfoMap.containsKey(againReceiptNo)) {
            detail.setDetailNo(againReceiptNo);
            detail.setMatchFlag(Integer.valueOf(MatchStatusEnum.SUCCESS.getId()));
            try {
                this.updateTaskDetailStatus(detail, TaskStatus.FINISH.getId());
            }
            catch (Throwable e) {
                this.logger.error("handleDailyCut-error:", e);
            }
            return true;
        }
        return false;
    }
}

