/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.business.receipt.schedule.test;

import java.util.Map;
import java.util.Objects;
import java.util.Stack;
import kd.bos.context.RequestContext;
import kd.bos.exception.KDException;
import kd.ebg.receipt.business.receipt.entity.HandlerType;
import kd.ebg.receipt.business.receipt.framework.ScheduleHanlder;
import kd.ebg.receipt.business.receipt.impl.handler.CreateTaskHandler;
import kd.ebg.receipt.business.receipt.impl.handler.DownLoadTaskHandler;
import kd.ebg.receipt.business.receipt.impl.handler.IntegrityHandler;
import kd.ebg.receipt.business.receipt.impl.handler.MatchHandler;
import kd.ebg.receipt.business.receipt.impl.handler.RetryHandler;
import kd.ebg.receipt.business.receipt.impl.handler.TaskStatusHandler;
import kd.ebg.receipt.business.receipt.schedule.ReceiptScheduleJob;

public class ReceiptTestScheduleJob
extends ReceiptScheduleJob {
    public ScheduleHanlder hanlder;

    @Override
    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        long start = System.currentTimeMillis();
        String type = (String)map.get("type");
        if (this.hanlder == null) {
            this.hanlder = this.init(type);
        }
        this.hanlder.process();
        long end = System.currentTimeMillis();
    }

    public ScheduleHanlder init(String type) {
        Stack<ScheduleHanlder> scheduleHanlderStack = new Stack<ScheduleHanlder>();
        if (Objects.equals(type, HandlerType.CREATE.getName())) {
            CreateTaskHandler createTaskHandler = new CreateTaskHandler(HandlerType.CREATE.getName());
            scheduleHanlderStack.push(createTaskHandler);
        }
        if (Objects.equals(type, HandlerType.STATUS.getName())) {
            TaskStatusHandler taskStatusHandler = new TaskStatusHandler(HandlerType.STATUS.getName());
            scheduleHanlderStack.push(taskStatusHandler);
        }
        if (Objects.equals(type, HandlerType.DOWNLOAD.getName())) {
            DownLoadTaskHandler downLoadTaskHandler = new DownLoadTaskHandler(HandlerType.DOWNLOAD.getName());
            scheduleHanlderStack.push(downLoadTaskHandler);
        }
        if (Objects.equals(type, HandlerType.INTEGRITY.getName())) {
            IntegrityHandler integrityHandler = new IntegrityHandler(HandlerType.INTEGRITY.getName());
            scheduleHanlderStack.push(integrityHandler);
        }
        if (Objects.equals(type, HandlerType.MATCH.getName())) {
            MatchHandler matchHandler = new MatchHandler(HandlerType.MATCH.getName());
            scheduleHanlderStack.push(matchHandler);
        }
        RetryHandler retryHandler = new RetryHandler(HandlerType.RETRY.getName());
        scheduleHanlderStack.push(retryHandler);
        ScheduleHanlder hanlder = null;
        ScheduleHanlder nextHanlder = null;
        while (!scheduleHanlderStack.empty()) {
            hanlder = (ScheduleHanlder)scheduleHanlderStack.pop();
            hanlder.setNextHandler(nextHanlder);
            nextHanlder = hanlder;
        }
        return hanlder;
    }
}

