/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.business.receipt.utils;

import java.time.LocalDate;
import java.util.List;
import java.util.Objects;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.receipt.common.constant.DetailDownloadStatusEnum;
import kd.ebg.receipt.common.constant.TaskStatusEnum;
import kd.ebg.receipt.common.constant.defect.ReceiptDefectTypeEnum;
import kd.ebg.receipt.common.framework.context.RequestContextUtils;
import kd.ebg.receipt.common.framework.receipt.bank.ReceiptSystemProperties;
import kd.ebg.receipt.common.framework.receipt.util.EBConfigBuilder;
import kd.ebg.receipt.common.framework.utils.ReceiptCommonAipUtil;
import kd.ebg.receipt.common.model.receipt.DownloadListTask;
import kd.ebg.receipt.common.model.repository.DetailInfoRepository;
import kd.ebg.receipt.common.utils.FileCommonUtils;
import kd.ebg.receipt.common.utils.PropertiesConstantsUtils;
import kd.ebg.receipt.common.utils.SpringContextUtil;

public class ErrorHandUtils {
    public static ErrorHandUtils getInstance() {
        return new ErrorHandUtils();
    }

    public void classifyByErrorInfo(Throwable e, DownloadListTask task) {
        String message;
        String defectTypeEnum = ReceiptDefectTypeEnum.OTHER.getCode();
        if (e == null || StringUtils.isEmpty((String)e.getMessage())) {
            defectTypeEnum = ReceiptDefectTypeEnum.OTHER.getCode();
            task.setDefectType(defectTypeEnum);
            task.setSuggest(defectTypeEnum);
            return;
        }
        if (e != null && StringUtils.isNotEmpty((String)(message = e.getMessage()))) {
            this.judgeReceiptIsPushAll(task);
            defectTypeEnum = task.getDefectType();
            if (!Objects.equals(defectTypeEnum, ReceiptDefectTypeEnum.NULL.getCode())) {
                if (message.contains(ResManager.loadKDString((String)"\u94f6\u884c\u524d\u7f6e\u673a\u63a5\u53e3\u8bf7\u6c42\u8fc7\u7a0b\u4e2d\u51fa\u73b0\u5f02\u5e38\u3002", (String)"ErrorHandUtils_0", (String)"ebg-receipt-business", (Object[])new Object[0]))) {
                    defectTypeEnum = ReceiptDefectTypeEnum.HTTP_ERROR.getCode();
                } else if (message.contains(ResManager.loadKDString((String)"\u660e\u7ec6\u67e5\u8be2\u51fa\u73b0\u5f02\u5e38\u3002", (String)"ErrorHandUtils_1", (String)"ebg-receipt-business", (Object[])new Object[0]))) {
                    defectTypeEnum = ReceiptDefectTypeEnum.HTTP_ERROR.getCode();
                } else if (message.contains(ResManager.loadKDString((String)"SFTP\u670d\u52a1\u5f02\u5e38", (String)"ErrorHandUtils_2", (String)"ebg-receipt-business", (Object[])new Object[0]))) {
                    defectTypeEnum = ReceiptDefectTypeEnum.SFTP_ERROR.getCode();
                } else if (message.contains(PropertiesConstantsUtils.getValue((String)"PERMISSION")) || message.contains(PropertiesConstantsUtils.getValue((String)"UN_APPLY_PERMISSION")) || message.contains(PropertiesConstantsUtils.getValue((String)"UN_OPEN"))) {
                    defectTypeEnum = ReceiptDefectTypeEnum.ACC_UN_PERMISSION.getCode();
                }
                if (message.contains(ResManager.loadKDString((String)"\u56de\u5355\u6587\u4ef6\u540d\u4e3a\u7a7a\u3002", (String)"ErrorHandUtils_6", (String)"ebg-receipt-business", (Object[])new Object[0])) && task.getTxDetailNum() == 0) {
                    task.setStatus(Integer.valueOf(TaskStatusEnum.FINISH.getId()));
                    task.setReceiptNum(Integer.valueOf(0));
                    defectTypeEnum = ReceiptDefectTypeEnum.NULL.getCode();
                }
                if (!ErrorHandUtils.isOnlyBySyncRecord() && task.getTxDetailNum() == 0) {
                    task.setStatus(Integer.valueOf(TaskStatusEnum.FINISH.getId()));
                    task.setReceiptNum(Integer.valueOf(0));
                    defectTypeEnum = ReceiptDefectTypeEnum.NULL.getCode();
                }
            }
            task.setDefectType(defectTypeEnum);
            task.setSuggest(defectTypeEnum);
        }
    }

    public static boolean isOnlyBySyncRecord() {
        ReceiptSystemProperties receiptSystemProperties = (ReceiptSystemProperties)EBConfigBuilder.getInstance().buildConfig(ReceiptSystemProperties.class);
        String isOnlyBySyncRecord = receiptSystemProperties.getIsOnlyBySyncRecord();
        return Objects.equals(isOnlyBySyncRecord, "true");
    }

    public void judgeReceiptIsPushAll(DownloadListTask task) {
        DetailInfoRepository detailInfoRepository = (DetailInfoRepository)SpringContextUtil.getBean(DetailInfoRepository.class);
        String customId = task.getCustomNo();
        String accNo = task.getAccNo();
        LocalDate transDate = task.getTransDate();
        String bankVersionId = task.getBankVersionId();
        boolean isPullDetail = ReceiptCommonAipUtil.isPullRecordByCustomIdTransDateAndAccNo((String)customId, (LocalDate)transDate, (String)accNo);
        List detailInfoList = detailInfoRepository.findByAccNoAndBankVersionIDAndTransDateBetween(accNo, bankVersionId, transDate, transDate);
        task.setTxDetailNum(Integer.valueOf(detailInfoList.size()));
        int detailCount = detailInfoList.size();
        if (isPullDetail || FileCommonUtils.isTestEnv() || detailInfoList.size() > 0) {
            int receiptCount = task.getReceiptNum();
            task.setTxDetailNum(Integer.valueOf(detailCount));
            task.setDetailFlag(Integer.valueOf(DetailDownloadStatusEnum.DOWNLOAD_SUCCESS.getId()));
            if (detailCount > 0) {
                if (receiptCount == 0) {
                    task.setDefectType(ReceiptDefectTypeEnum.UN_PUSH_RECEIPT.getCode());
                    return;
                }
                if (receiptCount > 0 && receiptCount < detailCount) {
                    task.setDefectType(ReceiptDefectTypeEnum.PUSH_DEFECT_RECEIPT.getCode());
                    task.setExpmsg(String.format(ResManager.loadKDString((String)"\u672c\u6b21\u4efb\u52a1\u83b7\u53d6\u7684\u56de\u5355\u6570\u91cf%1$s\u6761\uff0c\u4ea4\u6613\u660e\u7ec6%2$s\u6761\uff0c\u8bf7\u8054\u7cfb\u94f6\u884c\u63a8\u9001\u56de\u5355\u6587\u4ef6\u540e\u518d\u91cd\u65b0\u4e0b\u8f7d\u3002", (String)"ErrorHandUtils_8", (String)"ebg-receipt-business", (Object[])new Object[0]), Integer.toString(receiptCount), Integer.toString(detailCount)));
                    return;
                }
            }
            if (detailCount == 0 && receiptCount == 0 && (RequestContextUtils.getRetryReceiptTaskNum() == 1 || isPullDetail)) {
                task.setStatus(Integer.valueOf(TaskStatusEnum.FINISH.getId()));
                task.setReceiptNum(Integer.valueOf(0));
                task.setDefectType(ReceiptDefectTypeEnum.NULL.getCode());
                return;
            }
        } else {
            task.setDetailFlag(Integer.valueOf(DetailDownloadStatusEnum.UN_DOWNLOAD.getId()));
        }
        if (StringUtils.isEmpty((String)task.getDefectType()) || !Objects.equals(task.getDefectType(), ReceiptDefectTypeEnum.FINISH.getCode())) {
            task.setDefectType(ReceiptDefectTypeEnum.OTHER.getCode());
        }
        if (!ErrorHandUtils.isOnlyBySyncRecord() && task.getTxDetailNum() == 0 && (RequestContextUtils.getRetryReceiptTaskNum() == 1 || isPullDetail)) {
            task.setStatus(Integer.valueOf(TaskStatusEnum.FINISH.getId()));
            task.setReceiptNum(Integer.valueOf(0));
            task.setDefectType(ReceiptDefectTypeEnum.NULL.getCode());
        }
    }
}

