/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.ccqtgb.dc.service.detail;

import java.time.LocalDate;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankHeader;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.receipt.banks.ccqtgb.dc.service.helper.BankCode;
import kd.ebg.receipt.banks.ccqtgb.dc.service.helper.DC_RequestPacker;
import kd.ebg.receipt.banks.ccqtgb.dc.service.helper.DC_ResponseParser;
import kd.ebg.receipt.business.detail.atomic.AbstractDetailImpl;
import kd.ebg.receipt.business.detail.atomic.IDetail;
import kd.ebg.receipt.business.detail.atomic.IHisDetail;
import kd.ebg.receipt.business.detail.bank.BankDetailRequest;
import kd.ebg.receipt.business.detail.bank.EBBankDetailResponse;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.model.DetailInfo;

public class DetailImpl
extends AbstractDetailImpl
implements IDetail,
IHisDetail {
    private EBGLogger logger = EBGLogger.getInstance().getLogger(DetailImpl.class);

    public void configFactory(ConnectionFactory factory) {
        factory.setHttpHeader("content-type", "text/xml; charset=UTF-8");
        super.configFactory(factory);
    }

    public String getDeveloper() {
        return "ht";
    }

    public String getBizCode() {
        return BankCode.DETAIL_CODE;
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u67e5\u8be2\u4ea4\u6613\u660e\u7ec6", (String)"DetailImpl_0", (String)"ebg-receipt-banks-ccqtgb-dc", (Object[])new Object[0]);
    }

    public String pack(BankDetailRequest rqst) {
        return DC_RequestPacker.getDetailsMessageFYI(rqst.getAcnt(), rqst.getStartDate(), rqst.getEndDate());
    }

    public EBBankDetailResponse parse(BankDetailRequest rqst, String rspStr) {
        BankResponse response = DC_ResponseParser.parserCommonHead(rspStr);
        if (!BankCode.SUCCESS_CODE.equals(response.getResponseCode())) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u4ea4\u6613\u660e\u7ec6\u5f02\u5e38\uff0c\u94f6\u884c\u8fd4\u56de\u975e\u6b63\u5e38\u7684\u5916\u5c42\u72b6\u6001\u7801\uff1a%s\u3002", (String)"DetailImpl_2", (String)"ebg-receipt-banks-ccqtgb-dc", (Object[])new Object[0]), response.getResponseCode()));
        }
        List<DetailInfo> detailInfos = DC_ResponseParser.parserDeatilsMessage(rqst, rspStr);
        return new EBBankDetailResponse(detailInfos);
    }

    public static List<DetailInfo> queryTransDetail(String accNo, LocalDate transDate) {
        DetailImpl detail = new DetailImpl();
        BankDetailRequest request = new BankDetailRequest();
        BankHeader header = new BankHeader();
        BankAcnt acnt = new BankAcnt();
        acnt.setAccNo(accNo);
        header.setAcnt(acnt);
        request.setHeader(header);
        request.setStartDate(transDate);
        request.setEndDate(transDate);
        EBBankDetailResponse ebBankDetailResponse = detail.detail(request);
        List detailInfos = ebBankDetailResponse.getDetails();
        return detailInfos;
    }
}

