/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.crbc.dc.service.receipt.fetch;

import com.alibaba.fastjson.JSONObject;
import java.io.File;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import kd.ebg.egf.common.cache.CosmicCache;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.receipt.banks.crbc.dc.service.receipt.api.BankReceiptApiApplyImpl;
import kd.ebg.receipt.banks.crbc.dc.service.receipt.api.QuerySignAccListImpl;
import kd.ebg.receipt.business.receipt.atom.AbstractBankReceiptHandleImpl;
import kd.ebg.receipt.business.receipt.atom.IBankReceiptHandle;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptRequest;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleRequest;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleResponseEB;
import kd.ebg.receipt.business.receipt.entity.TaskStatus;
import kd.ebg.receipt.common.core.utils.GZFileUtils;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.framework.receipt.util.FileStorageUtil;
import kd.ebg.receipt.common.model.receipt.DownloadListDetail;
import kd.ebg.receipt.common.utils.DownloadUtils;
import kd.ebg.receipt.common.utils.FileCommonUtils;

public class BankReceiptFetchListImpl
extends AbstractBankReceiptHandleImpl
implements IBankReceiptHandle {
    private static EBGLogger log = EBGLogger.getInstance().getLogger(BankReceiptFetchListImpl.class);

    public boolean match(BankReceiptHandleRequest request) {
        if (request == null) {
            return false;
        }
        Integer status = request.getTaskStatus();
        if (status == null) {
            return false;
        }
        return status.intValue() == TaskStatus.PROCESSING.getId();
    }

    public BankReceiptHandleResponseEB doBiz(BankReceiptHandleRequest request) {
        boolean isZip;
        String accNo = request.getAccNo();
        LocalDate transDate = request.getTransDate();
        String transDateStr = LocalDateUtil.formatDate((LocalDate)request.getTransDate());
        String bakFilePath = FileStorageUtil.getFileBakPathByAccNoAndDate((String)"CRBC_DC", (String)accNo, (String)LocalDateUtil.formatDate((LocalDate)transDate));
        ArrayList<DownloadListDetail> result = new ArrayList<DownloadListDetail>(16);
        BankReceiptRequest bankReceiptRequest = BankReceiptRequest.builder().accNo(accNo).transDate(transDate).build();
        String cacheName = String.format("receipt_signed_%s", accNo);
        String value = CosmicCache.get((String)cacheName);
        boolean isSign = false;
        if (Objects.equals(value, "true")) {
            isSign = true;
        }
        if (!isSign) {
            QuerySignAccListImpl querySignAccList = new QuerySignAccListImpl();
            try {
                List detailInfoList = querySignAccList.queryTransDetail(accNo, transDate, transDate);
                Map<String, String> signedAccNoMap = detailInfoList.stream().filter(o -> Objects.equals(o.getReversed1(), "1")).collect(Collectors.toMap(o -> o.getAccNo(), o -> o.getReversed1()));
                if (!signedAccNoMap.containsKey(accNo)) {
                    BankReceiptApiApplyImpl bankReceiptApiApply = new BankReceiptApiApplyImpl();
                    bankReceiptApiApply.doBiz(bankReceiptRequest);
                } else {
                    CosmicCache.putWithExpire((String)cacheName, (String)"true", (int)1, (TimeUnit)TimeUnit.DAYS);
                }
            }
            catch (Throwable e) {
                log.error(e.getMessage(), e);
            }
        }
        String ip = RequestContextUtils.getBankParameterValue((String)"ip");
        String port = RequestContextUtils.getBankParameterValue((String)"exchangePort");
        String url = String.format("http://%s:%s/presystem/download?action=200007EProofDownload&cust_account=%s&queryDate=%s", ip, port, accNo, transDateStr);
        String zipName = String.format("%s_%s.zip", accNo, transDateStr);
        DownloadUtils.download((String)url, (String)zipName, (String)bakFilePath);
        File zipFile = FileCommonUtils.getFileByPath((String)(bakFilePath + File.separator + zipName));
        String unZipPath = bakFilePath + File.separator + "temp";
        if (zipFile.exists() && (isZip = GZFileUtils.unZipFiles((String)zipFile.getPath(), (String)unZipPath))) {
            File unZipFile = FileCommonUtils.getFileByPath((String)unZipPath);
            for (File file : unZipFile.listFiles()) {
                if (!file.isFile() || !file.getName().toLowerCase(Locale.ENGLISH).endsWith(".pdf")) continue;
                String fileName = file.getName();
                String[] files = (fileName = fileName.replace(".pdf", "")).split("_");
                if (files.length != 3) continue;
                String serialNo = files[1];
                String seqNo = files[2];
                String newFileName = accNo + "_" + transDateStr + "_" + serialNo + "_" + seqNo + ".pdf";
                if (!FileCommonUtils.moveFile((File)file, (String)bakFilePath, (String)newFileName)) continue;
                DownloadListDetail downloadListDetail = new DownloadListDetail();
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("SEQ_NO", (Object)serialNo);
                jsonObject.put("SEQ_ACC_NO", (Object)seqNo);
                downloadListDetail.setFileLink(file.getName());
                downloadListDetail.setFileName(newFileName);
                downloadListDetail.setReceiptJson(jsonObject.toJSONString());
                result.add(downloadListDetail);
                FileCommonUtils.deleteFile((String)file.getPath());
            }
            FileCommonUtils.deleteFile((File)zipFile);
        }
        return BankReceiptHandleResponseEB.success(result);
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "";
    }

    public String getBizDesc() {
        return null;
    }
}

