/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.jxnsb.cmp.service.receipt.api;

import com.alibaba.fastjson.JSONObject;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.Sequence;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.receipt.banks.jxnsb.cmp.service.receipt.proxy.FileUpload;
import kd.ebg.receipt.banks.jxnsb.cmp.service.receipt.utils.Common;
import kd.ebg.receipt.banks.jxnsb.cmp.service.receipt.utils.EncodeAnDecodeHandler;
import kd.ebg.receipt.banks.jxnsb.cmp.service.receipt.utils.Packer;
import kd.ebg.receipt.business.receipt.atom.AbstractBankReceiptImpl;
import kd.ebg.receipt.business.receipt.atom.IBankReceipt;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptRequest;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptResponseEB;
import kd.ebg.receipt.business.receipt.utils.ShowTipUtil;
import org.jdom2.Element;

public class OneReceiptDownloadImpl
extends AbstractBankReceiptImpl
implements IBankReceipt {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(OneReceiptDownloadImpl.class);

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "562151";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u7535\u5b50\u56de\u5355\u5bfc\u51fa\u3002", (String)"OneReceiptDownloadImpl_0", (String)"ebg-receipt-banks-jxnsb-cmp", (Object[])new Object[0]);
    }

    public String pack(BankReceiptRequest bankReceiptRequest) {
        String json = bankReceiptRequest.getRequestStr();
        JSONObject jsonObject = JSONObject.parseObject((String)json);
        StringBuilder sb = new StringBuilder("tr_acdt|serial_no|crdr_flag|acno|kind|");
        sb.append("\r\n");
        sb.append(jsonObject.getString("tr_acdt")).append("|");
        sb.append(jsonObject.getString("serial_no")).append("|");
        sb.append(jsonObject.getString("crdr_flag")).append("|");
        sb.append(jsonObject.getString("acno")).append("|");
        sb.append(jsonObject.getString("kind")).append("|");
        String req_no = Sequence.gen18Sequence();
        String tr_code = this.getBizCode();
        Element ap = Packer.createCommonHead(tr_code, req_no, "1");
        Element body = ap.getChild("body");
        String fileName = String.format("%s_receipt.txt", req_no);
        JDomUtils.addChild((Element)body, (String)"file_name", (String)fileName);
        JDomUtils.addChild((Element)body, (String)"field_num", (String)"5");
        JDomUtils.addChild((Element)body, (String)"record_num", (String)"1");
        String encoding = RequestContextUtils.getCharset();
        String xmlMsg = JDomUtils.root2StringWithoutXMLDeclaration((Element)ap, (String)encoding);
        xmlMsg = EncodeAnDecodeHandler.encode(xmlMsg);
        FileUpload fileUpload = new FileUpload();
        fileUpload.setFileContent(sb.toString());
        fileUpload.doBiz(fileName);
        return Common.createCommonMsg(xmlMsg);
    }

    public BankReceiptResponseEB parse(BankReceiptRequest bankReceiptRequest, String responseStr) {
        responseStr = Common.parseRecvMsg(responseStr);
        responseStr = EncodeAnDecodeHandler.decode(responseStr);
        Element ap = JDomUtils.string2Root((String)responseStr, (String)RequestContextUtils.getCharset());
        Element head = ap.getChild("head");
        Element body = ap.getChild("body");
        BankResponse response = Common.parseBankResponse(head);
        if (!"0_0000".equals(response.getResponseCode())) {
            String errorMsg = ShowTipUtil.getResponseErrorTips((String)response.getResponseCode(), (String)response.getResponseMessage());
            logger.error(errorMsg);
            return BankReceiptResponseEB.fail();
        }
        String file_name = body.getChildTextTrim("file_name");
        return BankReceiptResponseEB.success((Object)file_name);
    }
}

