/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.cdcb.cms.service;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.framework.bank.info.BankHeader;
import kd.ebg.egf.common.framework.service.acnt.BankAcntService;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.receipt.banks.cdcb.cms.service.api.DetailImpl;
import kd.ebg.receipt.banks.cdcb.cms.service.api.ReceiptRequestImpl;
import kd.ebg.receipt.business.detail.bank.BankDetailRequest;
import kd.ebg.receipt.business.detail.bank.EBBankDetailResponse;
import kd.ebg.receipt.business.receipt.atom.AbstractBankReceiptHandleImpl;
import kd.ebg.receipt.business.receipt.atom.IBankReceiptHandle;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptRequest;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptResponseEB;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleRequest;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleResponseEB;
import kd.ebg.receipt.business.receipt.entity.TaskStatus;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.framework.utils.CurrencyUtils;
import kd.ebg.receipt.common.model.DetailInfo;
import kd.ebg.receipt.common.model.receipt.DownloadListDetail;

public class BankReceiptFetchListImpl
extends AbstractBankReceiptHandleImpl
implements IBankReceiptHandle {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(BankReceiptFetchListImpl.class);

    public boolean match(BankReceiptHandleRequest request) {
        if (request == null) {
            return false;
        }
        Integer status = request.getTaskStatus();
        if (status == null) {
            return false;
        }
        return status.intValue() == TaskStatus.PROCESSING.getId();
    }

    public BankReceiptHandleResponseEB doBiz(BankReceiptHandleRequest request) {
        String accNo = request.getAccNo();
        LocalDate transDate = request.getTransDate();
        ArrayList<DownloadListDetail> result = new ArrayList<DownloadListDetail>(16);
        logger.info("\u83b7\u53d6\u7535\u5b50\u56de\u5355\u8bf7\u6c42\u4fe1\u606f\uff1a\n accNo = " + accNo + " and transDate = " + transDate + "\n");
        BankAcnt acnt = new BankAcnt();
        logger.info("\u5373\u5c06\u67e5\u8be2>>>>>>>>" + accNo + "  " + EBContext.getContext().getCustomID());
        BankAcnt mainAcnt = BankAcntService.getInstance().selectByCustomIDAndAccNo(accNo, EBContext.getContext().getCustomID());
        logger.info("\u67e5\u8be2\u7ed3\u679c>>>>>>>>" + mainAcnt.getAccNo() + "  " + mainAcnt.getCurrency());
        String currency = mainAcnt.getCurrency();
        String bankCurrency = CurrencyUtils.convert2Bank((String)currency);
        logger.info("\u8f6c\u6362\u7ed3\u679c>>>>>>>>" + mainAcnt.getAccNo() + "  " + bankCurrency);
        acnt.setAccNo(accNo);
        acnt.setCurrency(bankCurrency);
        BankDetailRequest req = this.buildDetailRequest(acnt, transDate);
        EBBankDetailResponse detailResponse = new DetailImpl().detail(req);
        List details = detailResponse.getDetails();
        for (DetailInfo detail : details) {
            BankReceiptResponseEB responseEB = new ReceiptRequestImpl().doBiz(this.buildReceiptRequest(acnt, transDate, detail.getReceiptNo()));
            if (!Objects.nonNull(responseEB.getData())) continue;
            String fileName = (String)responseEB.getData();
            String newFileName = detail.getUniqueSeq();
            logger.info("\u56de\u5355\u6587\u4ef6\u540d {}\uff0c\u65b0\u6587\u4ef6\u540d {}", new Object[]{fileName, newFileName});
            DownloadListDetail downloadListDetail = new DownloadListDetail();
            downloadListDetail.setFileName(newFileName);
            downloadListDetail.setFileLink(fileName);
            result.add(downloadListDetail);
        }
        return BankReceiptHandleResponseEB.success(result);
    }

    public BankDetailRequest buildDetailRequest(BankAcnt acnt, LocalDate localDate) {
        BankDetailRequest request = new BankDetailRequest();
        BankHeader header = new BankHeader();
        header.setAcnt(acnt);
        request.setHeader(header);
        request.setStartDate(localDate);
        request.setEndDate(localDate);
        return request;
    }

    public BankReceiptRequest buildReceiptRequest(BankAcnt acnt, LocalDate localDate, String seqNo) {
        BankReceiptRequest req = BankReceiptRequest.builder().accNo(acnt.getAccNo()).transDate(localDate).requestStr(seqNo).build();
        BankHeader header = new BankHeader();
        header.setAcnt(acnt);
        req.setHeader(header);
        return req;
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "CDCB_BankReceiptFetchListAndDownloadTheList";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u83b7\u53d6\u56de\u5355\u6587\u4ef6\u5217\u8868", (String)"BankReceiptFetchListImpl_0", (String)"ebg-receipt-banks-arcu-dc", (Object[])new Object[0]);
    }
}

