/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.adbc.dc.service.receipt;

import com.jcraft.jsch.ChannelSftp;
import java.io.File;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.receipt.business.receipt.atom.AbstractBankReceiptHandleImpl;
import kd.ebg.receipt.business.receipt.atom.IBankReceiptHandle;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleRequest;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleResponseEB;
import kd.ebg.receipt.business.receipt.entity.TaskStatus;
import kd.ebg.receipt.business.receipt.utils.BankReceiptApiUtil;
import kd.ebg.receipt.common.core.utils.EBGStringUtils;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.framework.receipt.bank.BankFtpProperties;
import kd.ebg.receipt.common.framework.receipt.exception.ReceiptDownLoadException;
import kd.ebg.receipt.common.framework.receipt.exception.ReceiptException;
import kd.ebg.receipt.common.framework.receipt.util.EBConfigBuilder;
import kd.ebg.receipt.common.framework.receipt.util.FileStorageUtil;
import kd.ebg.receipt.common.framework.receipt.util.SFTPUtils;
import kd.ebg.receipt.common.framework.services.receipt.DownloadListDetailService;
import kd.ebg.receipt.common.model.receipt.DownloadListDetail;
import kd.ebg.receipt.common.utils.FileCommonUtils;
import kd.ebg.receipt.common.utils.SpringContextUtil;

public class BankReceiptDownloadImpl
extends AbstractBankReceiptHandleImpl
implements IBankReceiptHandle {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(BankReceiptDownloadImpl.class);
    public DownloadListDetailService downloadListDetailService;

    public void init(BankReceiptHandleRequest request) {
        this.downloadListDetailService = (DownloadListDetailService)SpringContextUtil.getBean(DownloadListDetailService.class);
    }

    public boolean match(BankReceiptHandleRequest request) {
        if (request == null) {
            return false;
        }
        Integer status = request.getTaskStatus();
        if (status == null) {
            return false;
        }
        return status.intValue() == TaskStatus.DOWNLOADING.getId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BankReceiptHandleResponseEB doBiz(BankReceiptHandleRequest request) {
        this.init(request);
        ChannelSftp sftp = null;
        String bankVersionId = request.getBankVersionId();
        String accNo = request.getAccNo();
        LocalDate transDate = request.getTransDate();
        String bankLoginId = request.getBankLoginId();
        String bakFilePath = FileStorageUtil.getFileBakPathByAccNoAndDate((String)bankVersionId, (String)accNo, (String)LocalDateUtil.formatDate((LocalDate)transDate));
        long taskId = request.getTaskId();
        List downloadListDetails = this.downloadListDetailService.selectByRefId(Long.valueOf(taskId));
        ArrayList<DownloadListDetail> result = new ArrayList<DownloadListDetail>(16);
        boolean isLastFile = false;
        BankFtpProperties bankFtpProperties = (BankFtpProperties)EBConfigBuilder.getInstance().buildConfig(BankFtpProperties.class, bankLoginId);
        if (bankFtpProperties.getReceiptAchieveWay().equals("sftp")) {
            BankReceiptDownloadImpl bankReceiptDownloadImpl = this;
            synchronized (bankReceiptDownloadImpl) {
                if (SFTPUtils.getInstance().isAbort(sftp)) {
                    sftp = SFTPUtils.getInstance().getSftp(bankLoginId);
                }
            }
        }
        for (int i = 0; i < downloadListDetails.size(); ++i) {
            if (i == downloadListDetails.size() - 1) {
                isLastFile = true;
            }
            DownloadListDetail downloadListDetail = (DownloadListDetail)downloadListDetails.get(i);
            List<DownloadListDetail> details = this.download(downloadListDetail, isLastFile, bankLoginId, bakFilePath, sftp, accNo, transDate);
            result.addAll(details);
        }
        return BankReceiptHandleResponseEB.success(result);
    }

    public List<DownloadListDetail> download(DownloadListDetail detail, boolean isLastFile, String bankLoginId, String bakFilePath, ChannelSftp sftp, String accNo, LocalDate transDate) {
        boolean download;
        String fileName = detail.getFileLink();
        String newFileName = detail.getFileName();
        ArrayList<DownloadListDetail> result = new ArrayList<DownloadListDetail>(16);
        if (fileName != null && fileName.length() > 0 && (download = this.ftpDownload(fileName, newFileName, bankLoginId, isLastFile, bakFilePath, sftp, accNo, transDate))) {
            result.add(detail);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean ftpDownload(String fileName, String newFileName, String bankLogin, boolean isLastFile, String bakFilePath, ChannelSftp sftp, String accNo, LocalDate transDate) {
        boolean result;
        block24: {
            result = false;
            BankFtpProperties bankFtpProperties = (BankFtpProperties)EBConfigBuilder.getInstance().buildConfig(BankFtpProperties.class, bankLogin);
            String sftp_path = bankFtpProperties.getFtpPath();
            logger.info("\u4e0b\u8f7d\u4e2d\u56fd\u519c\u4e1a\u53d1\u5c55\u94f6\u884c\u76f4\u8054\u7248\u56de\u5355\u6587\u4ef6\u540d\uff1a{}", (Object)fileName);
            String filePath = fileName.substring(0, fileName.lastIndexOf("/"));
            fileName = fileName.substring(fileName.lastIndexOf("/") + 1);
            try {
                File isExistOldFile = FileCommonUtils.getFileByPath((String)(bakFilePath + File.separator + newFileName));
                if (isExistOldFile.exists()) {
                    boolean bl = true;
                    return bl;
                }
                if (bankFtpProperties.getReceiptAchieveWay().equals("sftp")) {
                    BankReceiptDownloadImpl bankReceiptDownloadImpl = this;
                    synchronized (bankReceiptDownloadImpl) {
                        if (SFTPUtils.getInstance().isAbort(sftp)) {
                            sftp = SFTPUtils.getInstance().getSftp(bankLogin);
                        }
                    }
                    sftp_path = EBGStringUtils.isNotEmpty((String)sftp_path) ? sftp_path + filePath : filePath;
                    File saveFile = FileCommonUtils.getFileByPath((String)bakFilePath);
                    if (!saveFile.exists()) {
                        boolean isSuccess = saveFile.mkdirs();
                        logger.info("\u5f53\u524d\u76ee\u5f55{}\u4e0d\u5b58\u5728\uff0c\u9700\u8981\u521b\u5efa -- \u7ed3\u679c\uff1a{}", new Object[]{bakFilePath, isSuccess});
                    }
                    result = SFTPUtils.getInstance().downloadSingleFile(sftp_path, fileName, bakFilePath, sftp);
                    File file = FileCommonUtils.getFileByPath((String)(bakFilePath + File.separator + fileName));
                    if (file.exists()) {
                        boolean bl = result = FileCommonUtils.moveFile((File)file, (String)bakFilePath, (String)newFileName);
                        return bl;
                    }
                    break block24;
                }
                if (bankFtpProperties.getReceiptAchieveWay().equals("bank_login")) {
                    BankReceiptApiUtil bankReceiptApiUtil = new BankReceiptApiUtil(accNo, transDate);
                    String ftpPath = bankFtpProperties.getFrontProxyPath() + filePath;
                    result = bankReceiptApiUtil.downloadReceiptFileWithPath(ftpPath, fileName, bakFilePath);
                    if (result) {
                        File file = FileCommonUtils.getFileByPath((String)(bakFilePath + File.separator + fileName));
                        if (file.exists()) {
                            File newFile = FileCommonUtils.getFileByPath((String)(bakFilePath + File.separator + newFileName));
                            if (newFile.exists()) {
                                boolean bl = true;
                                return bl;
                            }
                            result = FileCommonUtils.moveFile((File)file, (String)bakFilePath, (String)newFileName);
                            if (!result) {
                                logger.error("path:{} {} \u8f6c\u79fb\u6587\u4ef6\u5230 {} \u5931\u8d25", new Object[]{bakFilePath, fileName, newFileName});
                                throw new ReceiptDownLoadException(String.format(ResManager.loadKDString((String)"\u6587\u4ef6\u91cd\u547d\u540d\u5931\u8d25\uff0c\u539f\u6587\u4ef6:%s\u3002", (String)"BankReceiptDownloadImpl_4", (String)"ebg-receipt-banks-adbc-dc", (Object[])new Object[0]), fileName) + String.format(ResManager.loadKDString((String)";\u65b0\u6587\u4ef6\u540d\uff1a%s", (String)"BankReceiptDownloadImpl_5", (String)"ebg-receipt-banks-adbc-dc", (Object[])new Object[0]), newFileName));
                            }
                        } else {
                            result = false;
                            logger.error("\u4e0b\u8f7d\u6587\u4ef6\u4e0d\u5b58\u5728\uff0c\u6587\u4ef6\u540d\uff1a" + fileName);
                            throw new ReceiptDownLoadException(String.format(ResManager.loadKDString((String)"\u4e0b\u8f7d\u6587\u4ef6\u4e0d\u5b58\u5728\uff0c\u6587\u4ef6\u540d\uff1a%s\u3002", (String)"BankReceiptDownloadImpl_6", (String)"ebg-receipt-banks-adbc-dc", (Object[])new Object[0]), fileName));
                        }
                    }
                    if (!result) {
                        logger.error("\u8c03\u7528\u4e0b\u8f7d\u65b9\u6cd5\u5931\u8d25" + fileName);
                    }
                }
            }
            catch (Exception e) {
                result = false;
                logger.error("\u6587\u4ef6\u4e0b\u8f7d\u5931\u8d25\uff0c\u6587\u4ef6\u540d\uff1a" + fileName, new Object[]{e.getMessage()});
                throw new ReceiptException((Throwable)e);
            }
            finally {
                if (isLastFile) {
                    SFTPUtils.getInstance().close(sftp);
                }
            }
        }
        return result;
    }

    public String getDeveloper() {
        return "lw";
    }

    public String getBizCode() {
        return "ADBC_DC_BankReceiptDownload";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u4e2d\u56fd\u519c\u4e1a\u53d1\u5c55\u94f6\u884c\u76f4\u8054\u7248\u56de\u5355\u6587\u4ef6\u4e0b\u8f7d", (String)"BankReceiptDownloadImpl_3", (String)"ebg-receipt-banks-adbc-dc", (Object[])new Object[0]);
    }
}

