/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.ebg.trd.banks.pab.opa;

import com.cfca.util.pki.PKIException;
import com.cfca.util.pki.api.CertUtil;
import com.cfca.util.pki.cert.X509Cert;
import com.cfca.util.pki.cipher.Session;
import kd.sdk.ebg.trd.banks.pab.opa.SDKSession;
import kd.sdk.ebg.trd.banks.pab.opa.SDKX509Cert;
import kd.sdk.ebg.trd.exception.SDKException;

public class SDKCertUtil {
    public static boolean verifyCertSign(SDKX509Cert cert, SDKX509Cert[] caCerts, SDKSession session) throws SDKException {
        try {
            X509Cert[] x509Certs = SDKX509Cert.getX509Certs(caCerts);
            return CertUtil.verifyCertSign((X509Cert)cert.getX509Cert(), (X509Cert[])x509Certs, (Session)session.getSession());
        }
        catch (PKIException e) {
            throw new SDKException("PKIException", e);
        }
    }

    public static SDKX509Cert getCert(byte[] pfxData, String pfxCipher) throws SDKException {
        try {
            return new SDKX509Cert(CertUtil.getCert((byte[])pfxData, (String)pfxCipher));
        }
        catch (PKIException e) {
            throw new SDKException("PKIException", e);
        }
    }

    public static SDKX509Cert[] parseP7b(byte[] data) throws SDKException {
        try {
            return SDKX509Cert.getSDKX509Certs(CertUtil.parseP7b((byte[])data));
        }
        catch (PKIException e) {
            throw new SDKException("PKIException", e);
        }
    }
}

