/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.ebg.trd.banks.pab.opa;

import com.cfca.util.pki.PKIException;
import com.cfca.util.pki.api.SignatureUtil;
import com.cfca.util.pki.cert.X509Cert;
import kd.sdk.ebg.trd.banks.pab.opa.SDKJKey;
import kd.sdk.ebg.trd.banks.pab.opa.SDKSession;
import kd.sdk.ebg.trd.banks.pab.opa.SDKX509Cert;
import kd.sdk.ebg.trd.exception.SDKException;

public class SDKSignatureUtil {
    public static String SHA1_RSA = "SHA1withRSAEncryption";
    private SignatureUtil signatureUtil = new SignatureUtil();

    public boolean p1VerifySignMessage(byte[] srcBytes, byte[] signData, String encryption, SDKX509Cert signCert, SDKSession session) throws SDKException {
        try {
            return this.signatureUtil.p1VerifySignMessage(srcBytes, signData, encryption, signCert.getX509Cert(), session.getSession());
        }
        catch (PKIException e) {
            throw new SDKException("PKIException", e);
        }
    }

    public byte[] p1SignMessage(byte[] data, String algo, SDKJKey priKey, SDKSession session) throws SDKException {
        try {
            return this.signatureUtil.p1SignMessage(data, algo, priKey.getKey(), session.getSession());
        }
        catch (PKIException e) {
            throw new SDKException("PKIException", e);
        }
    }

    public byte[] p7SignMessage(boolean encapsulated, byte[] data, String algo, SDKJKey priKey, SDKX509Cert[] certs, SDKSession session) throws SDKException {
        try {
            return this.signatureUtil.p7SignMessage(encapsulated, data, algo, priKey.getKey(), SDKX509Cert.getX509Certs(certs), session.getSession());
        }
        catch (PKIException e) {
            throw new SDKException("PKIException", e);
        }
    }

    public boolean p7VerifySignMessageDetached(byte[] srcBytes, byte[] signData, SDKSession session) throws SDKException {
        try {
            return this.signatureUtil.p7VerifySignMessageDetached(srcBytes, signData, session.getSession());
        }
        catch (PKIException e) {
            throw new SDKException("PKIException", e);
        }
    }

    public SDKX509Cert[] getSigerCert() throws SDKException {
        try {
            SDKX509Cert[] x509Certs = new SDKX509Cert[]{};
            X509Cert[] certs = this.signatureUtil.getSigerCert();
            if (certs != null && certs.length > 0) {
                x509Certs = new SDKX509Cert[certs.length];
                for (int i = 0; i < certs.length; ++i) {
                    x509Certs[i] = new SDKX509Cert(certs[i]);
                }
            }
            return x509Certs;
        }
        catch (PKIException e) {
            throw new SDKException("PKIException", e);
        }
    }
}

