/*
 * Decompiled with CFR 0.152.
 */
package kd.imsc.cc.business.helper.installprogress;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.Map;
import java.util.UUID;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.schedule.form.JobFormInfo;
import kd.bos.servicehelper.schedule.ScheduleServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.util.StringUtils;
import kd.imsc.cc.common.entity.InstallFeedbackResult;

public class InstallProgressHelper {
    private static final Log logger = LogFactory.getLog(InstallProgressHelper.class);

    public static void buildAndCommitJobFormInfo(IFormView iFormView, String taskClassName, Map<String, Object> params, CloseCallBack closeCallBack) {
        JobFormInfo jobFormInfo = InstallProgressHelper.createJobInfo(taskClassName, params, closeCallBack);
        InstallProgressHelper.dispatchJobFromInfo(jobFormInfo, iFormView);
    }

    private static JobFormInfo createJobInfo(String taskClassName, Map<String, Object> params, CloseCallBack closeCallBack) {
        JobInfo jobInfo = new JobInfo();
        jobInfo.setJobType(JobType.REALTIME);
        jobInfo.setAppId("cc");
        jobInfo.setlName(new LocaleString("cc_installprogress"));
        jobInfo.setRunByLang(Lang.get());
        jobInfo.setTaskClassname(taskClassName);
        jobInfo.setRunByUserId(UserServiceHelper.getCurrentUserId());
        jobInfo.setId(UUID.randomUUID().toString());
        if (params != null && !params.isEmpty()) {
            jobInfo.setParams(params);
        }
        JobFormInfo jobFormInfo = new JobFormInfo(jobInfo);
        jobFormInfo.setCanBackground(true);
        jobFormInfo.setCanStop(true);
        jobFormInfo.setCloseCallBack(closeCallBack);
        return jobFormInfo;
    }

    private static void dispatchJobFromInfo(JobFormInfo jobFormInfo, IFormView view) {
        if (view == null) {
            return;
        }
        jobFormInfo.setRootPageId(view.getFormShowParameter().getRootPageId());
        jobFormInfo.setParentPageId(view.getPageId());
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("cc_installprogress");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        if (StringUtils.isNotEmpty((String)jobFormInfo.getCaption())) {
            showParameter.setCaption(jobFormInfo.getCaption());
        } else if (StringUtils.isNotEmpty((String)jobFormInfo.getJobInfo().getlName().getLocaleValue())) {
            showParameter.setCaption(jobFormInfo.getJobInfo().getlName().getLocaleValue());
        }
        String jobInfoStr = SerializationUtils.toJsonString((Object)jobFormInfo);
        showParameter.getCustomParams().put("install_job_info", jobInfoStr);
        showParameter.setCloseCallBack(jobFormInfo.getCloseCallBack());
        view.showForm(showParameter);
    }

    public static TaskInfo getTaskInfoById(String taskId) {
        if (StringUtils.isEmpty((String)taskId)) {
            return null;
        }
        return ScheduleServiceHelper.queryTask((String)taskId);
    }

    public static void stopTaskById(String taskId) {
        if (StringUtils.isEmpty((String)taskId)) {
            return;
        }
        ScheduleServiceHelper.stopTask((String)taskId);
    }

    public static InstallFeedbackResult getImportResultByTaskId(String taskId) {
        logger.info("\u52a0\u8f7d\u5185\u5bb9\u5305|\u83b7\u53d6\u4efb\u52a1ID|{}", (Object)taskId);
        TaskInfo taskInfo = InstallProgressHelper.getTaskInfoById(taskId);
        logger.info("\u52a0\u8f7d\u5185\u5bb9\u5305|\u83b7\u53d6\u4efb\u52a1\u4fe1\u606f|{}", (Object)JSONObject.toJSONString((Object)taskInfo));
        if (taskInfo == null) {
            return null;
        }
        InstallFeedbackResult result = new InstallFeedbackResult();
        result.setProgress(taskInfo.getProgress());
        result.setStatus(taskInfo.getStatus());
        String infoData = taskInfo.getData();
        if ("FAILED".equals(result.getStatus()) || "COMPLETED".equals(result.getStatus())) {
            if (StringUtils.isEmpty((String)infoData)) {
                result.setStatus("FAILED");
                result.setErrMsg(ResManager.loadKDString((String)"\u4efb\u52a1\u6267\u884c\u5f02\u5e38\uff0c\u8bf7\u63d0\u4ea4\u8bc4\u4ef7\u53cd\u9988\u6216\u7a0d\u540e\u518d\u8bd5\u3002", (String)"InstallProgressHelper_0", (String)"imsc-cc", (Object[])new Object[0]));
                return result;
            }
            try {
                JSONObject dataObj = JSON.parseObject((String)infoData);
                result = (InstallFeedbackResult)JSON.parseObject((String)dataObj.getString("installFeedbackResult"), InstallFeedbackResult.class);
                result.setProgress(taskInfo.getProgress());
                result.setStatus(taskInfo.getStatus());
                if (StringUtils.isNotEmpty((String)result.getErrMsg())) {
                    result.setStatus("FAILED");
                }
            }
            catch (Exception e) {
                logger.error("\u52a0\u8f7d\u5185\u5bb9\u5305|\u83b7\u53d6\u6267\u884c\u4efb\u52a1\u6570\u636e\u5f02\u5e38|{}", (Object)infoData);
                result.setStatus("FAILED");
                result.setErrMsg(ResManager.loadKDString((String)"\u89e3\u6790\u4efb\u52a1\u6267\u884c\u8fd4\u56de\u7ed3\u679c\u5f02\u5e38\u3002", (String)"InstallProgressHelper_1", (String)"imsc-cc", (Object[])new Object[0]));
                return result;
            }
        }
        return result;
    }
}

