/*
 * Decompiled with CFR 0.152.
 */
package kd.imsc.cc.business.install.excel;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.imsc.cc.business.helper.PermissionHelper;
import kd.imsc.cc.business.install.AbstractSubPackageHandler;
import kd.imsc.cc.business.install.excel.ExcelSheetHandler;
import kd.imsc.cc.business.install.excel.ExcelTableHelper;
import kd.imsc.cc.business.install.excel.StdImportHelper;
import kd.imsc.cc.business.utils.IprmFileUtils;
import kd.imsc.cc.common.entity.DataPackageModifyResult;
import kd.imsc.cc.common.entity.SubDataCheckResult;
import kd.imsc.cc.common.entity.SubDataConfigureInfo;
import kd.imsc.cc.common.entity.SubDataInstallInfo;
import kd.imsc.cc.common.entity.SubDataInstallResult;
import kd.imsc.cc.common.exception.KdXkIprmException;

public class ExcelSubPackageHandlerImpl
extends AbstractSubPackageHandler {
    private static final Log logger = LogFactory.getLog(ExcelSubPackageHandlerImpl.class);
    private static final String XLXS = ".xlsx";
    private static final String KEY_FIELDS = "keyfields";
    private static final String ISOVERRIDEENTRY = "isoverrideentry";
    private static final String DATAIMPORTTYPE = "dataimporttype";
    public static final String CUSTOM = "custom";

    @Override
    public SubDataCheckResult checkSubDataPackageFile(SubDataConfigureInfo configInfo) {
        SubDataCheckResult checkResult = super.checkSubDataPackageFile(configInfo);
        if (!checkResult.isSuccess()) {
            return checkResult;
        }
        logger.info("\u5f00\u59cbExcel\u683c\u5f0f\u6570\u636e\u5305{}\u7279\u5b9a\u68c0\u67e5!", (Object)configInfo.getFileName());
        if (!IprmFileUtils.isFileZipFormatWithFileName(configInfo.getFileName()) && !configInfo.getFileName().endsWith(XLXS)) {
            checkResult.setFail(String.format(ResManager.loadKDString((String)"\u5b50\u6570\u636e\u5305\u201c%1$s\u201d\u6587\u4ef6\u683c\u5f0f\u5f02\u5e38\uff0c\u53ea\u5141\u8bb8zip\u6216xlsx\u683c\u5f0f\u3002", (String)"ExcelSubPackageHandlerImpl_0", (String)"imsc-cc", (Object[])new Object[0]), configInfo.getFileName()));
            return checkResult;
        }
        if (IprmFileUtils.isFileZipFormatWithFileName(configInfo.getFileName())) {
            File dataFilePath = new File(configInfo.getFileDirectory());
            File dataPackageDirectory = new File(dataFilePath.getAbsoluteFile() + File.separator + IprmFileUtils.getFileNameWithOutExtension(configInfo.getFileName()));
            File[] dataFiles = dataPackageDirectory.listFiles();
            for (int i = 0; i < dataFiles.length; ++i) {
                File dataFile = dataFiles[i];
                if (dataFile.getName().endsWith(XLXS)) continue;
                checkResult.setFail(String.format(ResManager.loadKDString((String)"\u5b50\u6570\u636e\u5305\u201c%1$s\u201d\u6587\u4ef6\u683c\u5f0f\u5f02\u5e38\uff0c\u53ea\u5141\u8bb8xlsx\u683c\u5f0f\u3002", (String)"ExcelSubPackageHandlerImpl_1", (String)"imsc-cc", (Object[])new Object[0]), configInfo.getFileName()));
                return checkResult;
            }
        }
        checkResult.setSuccess(true);
        return checkResult;
    }

    @Override
    public SubDataInstallResult installPacket(SubDataConfigureInfo configInfo, SubDataInstallInfo installInfo) {
        SubDataInstallResult installResult = new SubDataInstallResult(configInfo.getFileName());
        String formId = installInfo.getFormId();
        if (!PermissionHelper.hasImportPermission(formId)) {
            installResult.setSuccess(false);
            installResult.setError(String.format(ResManager.loadKDString((String)"\u5f15\u5165\u5931\u8d25\uff0c\u53ef\u80fd\u672a\u5f00\u653e\u8be5\u4e1a\u52a1\u5bf9\u8c61\u7684\u5f15\u5165\u64cd\u4f5c\u6216\u7528\u6237\u6ca1\u6709\u5f15\u5165\u6743\u9650\u3002\u8bf7\u5c1d\u8bd5\u66f4\u6362\u767b\u5f55\u7528\u6237\u6216\u5206\u914d\u8be5\u4e1a\u52a1\u5bf9\u8c61\u7684\u6743\u9650\u4e4b\u540e\u518d\u8bd5\u3002", (String)"ExcelSubPackageHandlerImpl_2", (String)"imsc-cc", (Object[])new Object[0]), installInfo.getName()));
            return installResult;
        }
        List<Map<String, String>> fileInfoList = null;
        try {
            fileInfoList = this.uploadExcelsIntoFileService(configInfo.getFileName(), configInfo.getFileDirectory(), installInfo);
        }
        catch (KdXkIprmException e) {
            installResult.setSuccess(false);
            installResult.setError(e.getMessage());
            return installResult;
        }
        if (fileInfoList == null || fileInfoList.isEmpty()) {
            installResult.setError(ResManager.loadKDString((String)"\u6267\u884c\u6807\u51c6\u5f15\u5165\u5931\u8d25\uff0c\u5b50\u5305\u4e0a\u4f20\u4e34\u65f6\u6587\u4ef6\u5f02\u5e38\u3002", (String)"ExcelSubPackageHandlerImpl_3", (String)"imsc-cc", (Object[])new Object[0]));
            return installResult;
        }
        HashMap<String, String> excelMap = new HashMap<String, String>();
        excelMap.put(KEY_FIELDS, installInfo.getKeyFields());
        excelMap.put(ISOVERRIDEENTRY, String.valueOf(true));
        excelMap.put(DATAIMPORTTYPE, installInfo.getDataImportType());
        String pageType = CUSTOM.equals(installInfo.getPageType().trim()) ? installInfo.getCustomPage() : installInfo.getPageType();
        return StdImportHelper.batchExecuteExcelImport(fileInfoList, formId, installInfo.getPageEnterParam(), pageType, excelMap);
    }

    @Override
    public void subPackageDataModify(SubDataConfigureInfo configInfo, DataPackageModifyResult result) {
        if (configInfo == null) {
            return;
        }
        if (!this.isModifySourceData(result)) {
            return;
        }
        try {
            if (IprmFileUtils.isFileZipFormatWithFileName(configInfo.getFileName())) {
                File xlsxDirectory = new File(new File(configInfo.getFileDirectory()) + File.separator + IprmFileUtils.getFileNameWithOutExtension(configInfo.getFileName()));
                File[] listFiles = xlsxDirectory.listFiles();
                for (int i = 0; i < listFiles.length; ++i) {
                    this.simpleExcelFileModify(result.getReplaceRegMap(), listFiles[i]);
                }
            } else {
                this.simpleExcelFileModify(result.getReplaceRegMap(), new File(new File(configInfo.getFileDirectory()) + File.separator + configInfo.getFileName()));
            }
        }
        catch (IOException e) {
            logger.error("\u6570\u636e\u4fee\u6b63\u5931\u8d25", (Throwable)e);
        }
    }

    @Override
    public boolean isZipFileNeedUnzip() {
        return true;
    }

    private List<Map<String, String>> uploadExcelsIntoFileService(String fileName, String filePath, SubDataInstallInfo installInfo) throws KdXkIprmException {
        if (IprmFileUtils.isFileZipFormatWithFileName(fileName)) {
            File xlsxDirectory = new File(new File(filePath) + File.separator + IprmFileUtils.getFileNameWithOutExtension(fileName));
            return StdImportHelper.handlerMultipleXlsxZipFile(xlsxDirectory, installInfo.getFormId());
        }
        return StdImportHelper.handleSimpleExcelIntoFileService(new File(filePath + File.separator + fileName), installInfo.getFormId());
    }

    private void simpleExcelFileModify(Map<String, Object> entrySet, File srcFile) throws IOException {
        ExcelSheetHandler sheetHandler = new ExcelSheetHandler(entrySet);
        File newFile = ExcelTableHelper.readExcelDataByModify(srcFile, sheetHandler);
        if (newFile != null && newFile.exists()) {
            String absolutePath = srcFile.getAbsolutePath();
            boolean bakup = srcFile.renameTo(new File(absolutePath + "_bak"));
            boolean delete = newFile.renameTo(new File(absolutePath));
            logger.info("bakUp {} renameTo {}", (Object)bakup, (Object)delete);
        }
    }
}

