/*
 * Decompiled with CFR 0.152.
 */
package kd.imsc.cc.business.install.excel;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.service.DispatchServiceHelper;
import kd.bos.mvc.SessionManager;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.imsc.cc.business.install.FileUploadTask;
import kd.imsc.cc.business.install.excel.StdImportLoggerHelper;
import kd.imsc.cc.business.proxy.ImportParamAdapterProxy;
import kd.imsc.cc.common.entity.SubDataInstallResult;
import kd.imsc.cc.common.exception.KdXkIprmException;
import kd.imsc.cc.common.utils.CommonUtils;

public class StdImportHelper {
    private static final Log LOGGER = LogFactory.getLog(StdImportHelper.class);

    private StdImportHelper() {
        throw new IllegalStateException("Utility class");
    }

    public static List<Map<String, String>> handleSimpleExcelIntoFileService(File xlsxFile, String formId) throws KdXkIprmException {
        if (xlsxFile == null || !xlsxFile.exists()) {
            throw new KdXkIprmException(ResManager.loadKDString((String)"\u6570\u636e\u5305\u6587\u4ef6\u4e0d\u5b58\u5728", (String)"StdImportHelper_0", (String)"imsc-cc", (Object[])new Object[0]), 1001);
        }
        ArrayList<Map<String, String>> fileInfoList = new ArrayList<Map<String, String>>();
        String threadPoolName = "upload_" + formId + "_" + System.currentTimeMillis();
        String appId = (String)DispatchServiceHelper.invokeBOSService((String)"FormService", (String)"getAppId", (Object[])new Object[]{formId});
        ThreadPool threadPool = ThreadPools.newCachedThreadPool((String)threadPoolName, (int)1, (int)2, (String)appId);
        Future uploadTask = threadPool.submit((Callable)new FileUploadTask(appId, formId, xlsxFile.getName(), xlsxFile));
        try {
            HashMap fileInfo = new HashMap(2);
            fileInfo.put("url", uploadTask.get(1L, TimeUnit.MINUTES));
            fileInfo.put("fileName", xlsxFile.getName());
            fileInfoList.add(fileInfo);
            ArrayList<Map<String, String>> arrayList = fileInfoList;
            return arrayList;
        }
        catch (InterruptedException | ExecutionException e1) {
            throw new KdXkIprmException(ResManager.loadKDString((String)"\u6807\u51c6\u5f15\u5165\u4e0a\u4f20\u4e34\u65f6\u6587\u4ef6\u5f02\u5e38", (String)"StdImportHelper_1", (String)"imsc-cc", (Object[])new Object[0]), e1, 2002);
        }
        catch (TimeoutException e2) {
            throw new KdXkIprmException(ResManager.loadKDString((String)"\u6807\u51c6\u5f15\u5165\u4e0a\u4f20\u4e34\u65f6\u6587\u4ef6\u8d85\u65f6", (String)"StdImportHelper_2", (String)"imsc-cc", (Object[])new Object[0]), e2, 2002);
        }
        finally {
            threadPool.close();
        }
    }

    public static List<Map<String, String>> handlerMultipleXlsxZipFile(File xlsxDirectory, String formId) throws KdXkIprmException {
        Future future;
        int i;
        if (xlsxDirectory == null || !xlsxDirectory.exists() || !xlsxDirectory.isDirectory()) {
            throw new KdXkIprmException(ResManager.loadKDString((String)"\u5b50\u6570\u636e\u5305\u89e3\u538b\u6587\u4ef6\u4e0d\u5b58\u5728", (String)"StdImportHelper_3", (String)"imsc-cc", (Object[])new Object[0]), 1001);
        }
        ArrayList<Map<String, String>> fileInfoList = new ArrayList<Map<String, String>>();
        File[] listFiles = xlsxDirectory.listFiles(pathname -> pathname.getName().endsWith(".xlsx"));
        if (listFiles == null) {
            throw new KdXkIprmException(ResManager.loadKDString((String)"\u5b50\u6570\u636e\u5305\u89e3\u538b\u6587\u4ef6\u5939\u4e3a\u7a7a", (String)"StdImportHelper_4", (String)"imsc-cc", (Object[])new Object[0]), 1001);
        }
        int liseSize = listFiles.length;
        if (liseSize == 0) {
            throw new KdXkIprmException(ResManager.loadKDString((String)"\u5b50\u6570\u636e\u5305\u89e3\u538b\u6587\u4ef6\u5939\u4e3a\u7a7a", (String)"StdImportHelper_4", (String)"imsc-cc", (Object[])new Object[0]), 1001);
        }
        if (liseSize >= 4) {
            liseSize = 4;
        }
        ArrayList<Future> futureList = new ArrayList<Future>(liseSize);
        String threadPoolName = "upload_" + formId + "_" + System.currentTimeMillis();
        String appId = (String)DispatchServiceHelper.invokeBOSService((String)"FormService", (String)"getAppId", (Object[])new Object[]{formId});
        ThreadPool threadPool = ThreadPools.newCachedThreadPool((String)threadPoolName, (int)liseSize, (int)liseSize, (String)appId);
        for (i = 0; i < liseSize; ++i) {
            File childFile = listFiles[i];
            future = threadPool.submit((Callable)new FileUploadTask(appId, formId, childFile.getName(), childFile));
            futureList.add(future);
        }
        try {
            int size = futureList.size();
            for (i = 0; i < size; ++i) {
                future = (Future)futureList.get(i);
                HashMap mapInfo = new HashMap(2);
                mapInfo.put("url", future.get(1L, TimeUnit.MINUTES));
                mapInfo.put("fileName", listFiles[i].getName());
                fileInfoList.add(mapInfo);
            }
            ArrayList<Map<String, String>> i2 = fileInfoList;
            return i2;
        }
        catch (InterruptedException | ExecutionException e1) {
            throw new KdXkIprmException(ResManager.loadKDString((String)"\u6807\u51c6\u5f15\u5165\u4e0a\u4f20\u4e34\u65f6\u6587\u4ef6\u5f02\u5e38", (String)"StdImportHelper_1", (String)"imsc-cc", (Object[])new Object[0]), e1, 2002);
        }
        catch (TimeoutException e2) {
            throw new KdXkIprmException(ResManager.loadKDString((String)"\u6807\u51c6\u5f15\u5165\u4e0a\u4f20\u4e34\u65f6\u6587\u4ef6\u8d85\u65f6", (String)"StdImportHelper_2", (String)"imsc-cc", (Object[])new Object[0]), e2, 2002);
        }
        finally {
            threadPool.close();
        }
    }

    public static SubDataInstallResult batchExecuteExcelImport(List<Map<String, String>> fileInfos, String formId, String pageEnterParam, String pageType, Map<String, String> excelParams) {
        FormShowParameter showParameter;
        SubDataInstallResult sumResult = new SubDataInstallResult(ResManager.loadKDString((String)"\u6279\u91cf\u5f15\u5165\u7ed3\u679c", (String)"StdImportHelper_5", (String)"imsc-cc", (Object[])new Object[0]));
        if (fileInfos == null || fileInfos.isEmpty()) {
            return sumResult.setError(ResManager.loadKDString((String)"\u5f15\u5165\u7684\u5185\u5bb9\u4e3a\u7a7a", (String)"StdImportHelper_6", (String)"imsc-cc", (Object[])new Object[0]));
        }
        sumResult.setFileName(fileInfos.get(0).get("fileName"));
        try {
            showParameter = ImportParamAdapterProxy.createFormShowParamForImport(formId, pageType, excelParams);
        }
        catch (KdXkIprmException e) {
            LOGGER.error("\u521b\u5efa\u5f15\u5165\u8df3\u8f6c\u9875\u9762\u5f02\u5e38", (Throwable)e);
            return sumResult.setError(e.getMessage());
        }
        if (showParameter == null) {
            return sumResult.setError(ResManager.loadKDString((String)"\u521b\u5efa\u5f15\u5165\u8df3\u8f6c\u9875\u9762\u5f02\u5e38", (String)"StdImportHelper_7", (String)"imsc-cc", (Object[])new Object[0]));
        }
        ImportParamAdapterProxy.specialFormParameters(pageEnterParam, showParameter);
        if (fileInfos.size() == 1) {
            return StdImportHelper.executeExcelImport(fileInfos.get(0).get("url"), fileInfos.get(0).get("fileName"), showParameter);
        }
        for (int i = 1; i <= fileInfos.size(); ++i) {
            Map<String, String> fileInfo = fileInfos.get(i - 1);
            long start = System.currentTimeMillis();
            SubDataInstallResult subResult = StdImportHelper.executeExcelImport(fileInfo.get("url"), fileInfo.get("fileName"), showParameter);
            sumResult.append(String.format(ResManager.loadKDString((String)"\n\u7b2c%1$d\u6279    \u5f15\u5165\u8017\u65f6%2$s \n%3$s", (String)"StdImportHelper_8", (String)"imsc-cc", (Object[])new Object[0]), i, CommonUtils.getUsedTime(start, System.currentTimeMillis()), subResult.getReport()));
            if (!subResult.isSuccess()) {
                sumResult.setSuccess(false);
            }
            sumResult.setTotal(sumResult.getTotal() + subResult.getTotal());
            sumResult.setFailed(sumResult.getFailed() + subResult.getFailed());
        }
        return sumResult;
    }

    private static SubDataInstallResult executeExcelImport(String fileUrl, String fileName, FormShowParameter showParameter) {
        SubDataInstallResult result = new SubDataInstallResult(fileName);
        String formId = (String)showParameter.getCustomParam("BillFormId");
        String serviceAppId = (String)showParameter.getCustomParam("ServiceAppId");
        String entityDisplayName = (String)showParameter.getCustomParam("ListName");
        Object logId = StdImportLoggerHelper.createImportLog(entityDisplayName);
        showParameter.setCustomParam("Url", (Object)CommonUtils.checkUrl(fileUrl));
        showParameter.setCustomParam("logId", logId);
        try {
            String pageId = ImportParamAdapterProxy.openFormView(formId, showParameter);
            IFormView view = SessionManager.getCurrent().getViewNoPlugin(pageId);
            if (view == null) {
                return result.setError(ResManager.loadKDString((String)"\u5f15\u5165\u5931\u8d25\uff0c\u53ef\u80fd\u672a\u5f00\u653e\u8be5\u4e1a\u52a1\u5bf9\u8c61\u7684\u5f15\u5165\u64cd\u4f5c\u6216\u7528\u6237\u6ca1\u6709\u5f15\u5165\u6743\u9650\u3002\u8bf7\u5c1d\u8bd5\u66f4\u6362\u767b\u5f55\u7528\u6237\u6216\u5206\u914d\u8be5\u4e1a\u52a1\u5bf9\u8c61\u7684\u6743\u9650\u4e4b\u540e\u518d\u8bd5\u3002", (String)"StdImportHelper_9", (String)"imsc-cc", (Object[])new Object[0]));
            }
            DispatchServiceHelper.invokeBOSServiceByAppId((String)serviceAppId, (String)"importService", (String)"startImport", (Object[])new Object[]{pageId, logId.toString()});
            String msg = StdImportLoggerHelper.wait2ImportEnd(logId, formId, pageId);
            if (!StringUtils.isEmpty((CharSequence)msg)) {
                result.setError(msg);
                return result;
            }
            StdImportLoggerHelper.parseExcelImportResult(logId, result);
        }
        catch (Exception e) {
            return result.setError(ResManager.loadKDString((String)"\u5f15\u5165\u65f6\u51fa\u73b0\u672a\u77e5\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u3002", (String)"StdImportHelper_10", (String)"imsc-cc", (Object[])new Object[0])).append(CommonUtils.getExceptionDetailInfo(e));
        }
        return result;
    }
}

