/*
 * Decompiled with CFR 0.152.
 */
package kd.imsc.cc.business.install.log;

import com.alibaba.fastjson.JSON;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.imsc.cc.business.gcpmanage.GcpManager;
import kd.imsc.cc.common.constants.iprm.model.BizOperationResult;
import kd.imsc.cc.common.entity.DataPackageInputModel;
import kd.imsc.cc.common.entity.SubDataConfigureInfo;
import kd.imsc.cc.common.entity.SubDataInstallResult;
import kd.imsc.cc.common.utils.CommonUtils;

public class DataPackageInstallLogHelper {
    private static final Log LOGGER = LogFactory.getLog(DataPackageInstallLogHelper.class);

    private DataPackageInstallLogHelper() {
        throw new IllegalStateException("Utility class");
    }

    public static int getDataPackageInstallCount(String pId, String subDataId, int status) {
        if (StringUtils.isEmpty((CharSequence)pId) || StringUtils.isEmpty((CharSequence)subDataId)) {
            return 0;
        }
        QFilter qFilter = new QFilter("pid", "=", (Object)pId);
        QFilter[] filters = new QFilter[]{qFilter};
        Map resultMap = BusinessDataServiceHelper.loadFromCache((String)"cc_installlog", (QFilter[])filters);
        if (resultMap == null || resultMap.isEmpty()) {
            return 0;
        }
        AtomicInteger count = new AtomicInteger();
        resultMap.values().forEach(c -> {
            DynamicObjectCollection collection = c.getDynamicObjectCollection("sub_install_entry");
            if (collection == null || collection.isEmpty()) {
                return;
            }
            for (DynamicObject subInstallObj : collection) {
                if (!subDataId.equals(subInstallObj.getString("subtitle")) || subInstallObj.getInt("substatus") != status) continue;
                count.getAndIncrement();
            }
        });
        return count.get();
    }

    public static String saveDataPackageInstallInfo(DynamicObject installDyObj) {
        if (installDyObj == null) {
            return "";
        }
        DynamicObject[] dyArray = new DynamicObject[]{installDyObj};
        OperationResult operationResult = SaveServiceHelper.saveOperate((String)"cc_installlog", (DynamicObject[])dyArray, (OperateOption)OperateOption.create());
        if (operationResult == null || !operationResult.isSuccess() || CollectionUtils.isEmpty((Collection)operationResult.getSuccessPkIds())) {
            return "";
        }
        return operationResult.getSuccessPkIds().get(0).toString();
    }

    public static DynamicObject convertInstallLogObj(DataPackageInputModel inputModel, String msg, Map<SubDataConfigureInfo, SubDataInstallResult> installResultMap, long startTime, long endTime) {
        if (inputModel == null || StringUtils.isEmpty((CharSequence)msg) || installResultMap == null || installResultMap.isEmpty()) {
            LOGGER.error("\u5185\u5bb9\u5305\u52a0\u8f7d\u8bb0\u5f55\u65e5\u5fd7\u5f02\u5e38|inputModel\uff1a{}|msg\uff1a{}|installResultMap\uff1a{}", new Object[]{JSON.toJSONString((Object)inputModel), msg, JSON.toJSONString(installResultMap)});
            return null;
        }
        Map<String, String> billNameMap = inputModel.getObjInfoMap();
        DynamicObject installLog = BusinessDataServiceHelper.newDynamicObject((String)"cc_installlog");
        installLog.set("logno", (Object)CodeRuleServiceHelper.getNumber((String)"cc_installlog", (DynamicObject)installLog, null));
        installLog.set("pid", (Object)inputModel.getId());
        installLog.set("pname", (Object)inputModel.getName());
        installLog.set("duration", (Object)CommonUtils.getUsedTime(startTime, endTime));
        installLog.set("starttime", (Object)new Date(startTime));
        installLog.set("endtime", (Object)new Date(endTime));
        installLog.set("logcreater", (Object)RequestContext.get().getCurrUserId());
        installLog.set("installmsg_tag", (Object)msg);
        int successCount = 0;
        int failCount = 0;
        int partSuccessCount = 0;
        DynamicObjectCollection subPackageLogObj = installLog.getDynamicObjectCollection("sub_install_entry");
        if (installResultMap != null && !installResultMap.isEmpty()) {
            Set<Map.Entry<SubDataConfigureInfo, SubDataInstallResult>> entrySet = installResultMap.entrySet();
            for (Map.Entry<SubDataConfigureInfo, SubDataInstallResult> entry : entrySet) {
                SubDataInstallResult result = entry.getValue();
                SubDataConfigureInfo configureInfo = entry.getKey();
                if (result == null) {
                    ++failCount;
                    continue;
                }
                DynamicObject subInstallObj = subPackageLogObj.addNew();
                int subStatus = 0;
                if (result.isSuccess()) {
                    ++successCount;
                    subStatus = 1;
                } else if (result.getTotal() - result.getFailed() > 0) {
                    ++partSuccessCount;
                    subStatus = 3;
                } else {
                    ++failCount;
                    subStatus = 2;
                }
                String billName = configureInfo.getFileName();
                if (billNameMap != null && billNameMap.containsKey(configureInfo.getFileName())) {
                    billName = billNameMap.get(configureInfo.getFileName());
                }
                subInstallObj.set("subobj", (Object)billName);
                subInstallObj.set("subname", (Object)configureInfo.getInstallInfo().getFormId());
                subInstallObj.set("substatus", (Object)subStatus);
                subInstallObj.set("subtype", (Object)configureInfo.getFileName());
                subInstallObj.set("subtitle", (Object)configureInfo.getFileName());
                subInstallObj.set("subinstallstarttime", (Object)new Date(result.getStartTime()));
                subInstallObj.set("subduration", (Object)(result.getEndTime() - result.getStartTime()));
                subInstallObj.set("successcount", (Object)(result.getTotal() - result.getFailed()));
                subInstallObj.set("failcount", (Object)result.getFailed());
                subInstallObj.set("subinstallmsg_tag", (Object)result.getReport());
            }
        }
        installLog.set("subsuccesssize", (Object)successCount);
        installLog.set("subfailsize", (Object)failCount);
        int status = 2;
        if (partSuccessCount > 0) {
            status = 3;
        } else if (failCount > 0 && successCount > 0) {
            status = 3;
        } else if (failCount == 0 && successCount > 0) {
            status = 1;
        }
        installLog.set("status", (Object)status);
        return installLog;
    }

    public static void sendInstallLogToGcp(DynamicObject logDyObj) {
        try {
            HashMap<String, Object> params = new HashMap<String, Object>(6);
            params.put("lognunber", logDyObj.getString("logno"));
            params.put("number", logDyObj.getString("pid"));
            params.put("pkgname", logDyObj.getString("pname"));
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            params.put("installationstarttime", sdf.format(logDyObj.getDate("starttime")));
            ArrayList subPackage = new ArrayList(2);
            DynamicObjectCollection subCollection = logDyObj.getDynamicObjectCollection("sub_install_entry");
            for (DynamicObject sub : subCollection) {
                HashMap<String, String> subMap = new HashMap<String, String>();
                subMap.put("businessobjnumber", sub.getString("subname"));
                subMap.put("businessobjname", sub.getString("subobj"));
                subMap.put("loaddate", sdf.format(sub.getDate("subinstallstarttime")));
                subPackage.add(subMap);
            }
            params.put("subPackage", subPackage);
            BizOperationResult bizOperationResult = GcpManager.sendInstallLog(params);
            if (!bizOperationResult.getSuccess()) {
                LOGGER.error("\u4e91\u5185\u5bb9\u52a0\u8f7d\u65e5\u5fd7\u540c\u6b65|\u8fdc\u7a0b\u5f02\u5e38|{}", (Object)JSON.toJSONString((Object)bizOperationResult));
            }
        }
        catch (Exception e) {
            LOGGER.error("\u4e91\u5185\u5bb9\u52a0\u8f7d\u65e5\u5fd7\u540c\u6b65|\u8fdc\u7a0b\u5f02\u5e38|{}", (Object)e.getMessage(), (Object)e);
        }
    }
}

