/*
 * Decompiled with CFR 0.152.
 */
package kd.imsc.cc.business.iprm.gcpapi;

import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dbversion.IndustryVersionInfo;
import kd.bos.dbversion.VersionCaptionInfo;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.dbversion.IndustryVersionServiceHelper;
import kd.bos.util.StringUtils;

public class PermissionHelper {
    private static final Log logger = LogFactory.getLog(PermissionHelper.class);
    private static final String PERMISSION = "permission";
    private static final String COSMIC = "cosmic_bos";
    private static final String KD = "kingdee";
    private static final String STARRY = "starry";

    public static String getKdCosmicVersion() {
        IndustryVersionInfo versionInfo = IndustryVersionServiceHelper.getVersion((String)COSMIC, (String)KD);
        if (versionInfo == null) {
            return null;
        }
        return versionInfo.getVersion();
    }

    public static String getKdStarryVersion() {
        List captionList = IndustryVersionServiceHelper.getCaption((String)KD, (String)STARRY);
        if (captionList == null || captionList.isEmpty()) {
            return null;
        }
        List galaxyVersions = captionList.stream().filter(v -> StringUtils.isNotEmpty((String)v.getProductNumber()) && v.getProductNumber().startsWith("constellation")).collect(Collectors.toList());
        if (galaxyVersions == null || galaxyVersions.isEmpty()) {
            return null;
        }
        IndustryVersionInfo galaxyVersion = galaxyVersions.stream().max(Comparator.comparing(IndustryVersionInfo::getVersion)).get();
        List verCaption = galaxyVersion.getVerCaption();
        if (CollectionUtils.isEmpty((Collection)verCaption)) {
            return null;
        }
        return ((VersionCaptionInfo)verCaption.get(0)).getCaption();
    }

    public static String getIsv() {
        IndustryVersionInfo versionInfo = IndustryVersionServiceHelper.getVersion((String)COSMIC, (String)KD);
        if (versionInfo == null) {
            return null;
        }
        return versionInfo.getIsv();
    }
}

