/*
 * Decompiled with CFR 0.152.
 */
package kd.imsc.cc.business.proxy;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.JSONObject;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.StringUtils;
import kd.bos.schedule.executor.TaskHelper;
import kd.imsc.cc.business.factory.SubDataPackageDispatchFactory;
import kd.imsc.cc.business.helper.PermissionHelper;
import kd.imsc.cc.business.install.IDataPackageInstallListener;
import kd.imsc.cc.business.install.IDataPackagePreviewListener;
import kd.imsc.cc.business.install.ISubPackageHandler;
import kd.imsc.cc.business.install.log.DataPackageInstallLogHelper;
import kd.imsc.cc.business.install.microservice.MicroSubPackageHandlerImpl;
import kd.imsc.cc.business.install.plugin.PluginAdapterHelper;
import kd.imsc.cc.business.resource.ResourceListProxy;
import kd.imsc.cc.business.utils.IprmFileUtils;
import kd.imsc.cc.common.entity.DataPackageInputModel;
import kd.imsc.cc.common.entity.DataPackageModifyConfig;
import kd.imsc.cc.common.entity.DataPackageModifyResult;
import kd.imsc.cc.common.entity.SubDataCheckResult;
import kd.imsc.cc.common.entity.SubDataConfigureInfo;
import kd.imsc.cc.common.entity.SubDataInstallResult;
import kd.imsc.cc.common.enums.InstallWay;
import kd.imsc.cc.common.exception.KdXkIprmException;
import kd.imsc.cc.common.utils.CommonUtils;
import org.apache.commons.io.FileUtils;

public class DataPackageInstallerProxy {
    private static final Log logger = LogFactory.getLog(DataPackageInstallerProxy.class);
    private DataPackageInputModel inputModel;
    private File dataPackageRootFile;
    private Map<SubDataConfigureInfo, ISubPackageHandler> subDataInstallMap;
    private JSONObject configObj;
    private List<SubDataConfigureInfo> subDataConfigList;
    private Map<String, DataPackageModifyResult> modifyResultMap;
    private IDataPackageInstallListener listener;
    private String taskId;
    private IDataPackagePreviewListener prewListener;

    public DataPackageInstallerProxy(DataPackageInputModel inputModel) {
        this.inputModel = inputModel;
        this.subDataInstallMap = new HashMap<SubDataConfigureInfo, ISubPackageHandler>();
    }

    public DataPackageInstallerProxy(DataPackageInputModel inputModel, IDataPackageInstallListener listener) {
        this(inputModel);
        this.listener = listener;
    }

    public DataPackageInstallerProxy(DataPackageInputModel inputModel, IDataPackageInstallListener listener, String taskId) {
        this(inputModel);
        this.listener = listener;
        this.taskId = taskId;
    }

    public DataPackageInstallerProxy(DataPackageInputModel inputModel, IDataPackagePreviewListener prewListener) {
        this(inputModel);
        this.prewListener = prewListener;
    }

    public void invokeDataPackageInstallCheck() {
        this.invokeDataPackageInstallCheck(true);
    }

    public void invokeDataPackageInstallCheck(boolean release) {
        try {
            if (this.inputModel == null) {
                throw new KdXkIprmException(ResManager.loadKDString((String)"\u5b89\u88c5\u6d41\u7a0b\u5165\u53c2\u5f02\u5e38\u3002", (String)"DataPackageInstallerProxy_0", (String)"imsc-cc", (Object[])new Object[0]), 404);
            }
            this.init();
            this.subDataPackageInstallPreCheck();
        }
        catch (KdXkIprmException e) {
            logger.error((Throwable)e);
            this.sendInstallFailEvent(e.getCode(), e.getMessage());
        }
        finally {
            if (release) {
                this.release();
            }
        }
    }

    public void invokeDataPackageInstallStage() {
        try {
            if (this.inputModel == null) {
                throw new KdXkIprmException(ResManager.loadKDString((String)"\u5b89\u88c5\u6d41\u7a0b\u5165\u53c2\u5f02\u5e38\u3002", (String)"DataPackageInstallerProxy_0", (String)"imsc-cc", (Object[])new Object[0]), 404);
            }
            this.init();
            this.totalDataPackageFileCheck();
            this.startSubDataPackageInstall();
        }
        catch (KdXkIprmException e) {
            logger.error("\u5185\u5bb9\u5305\u52a0\u8f7d\u5f02\u5e38\uff1a", (Throwable)e);
            this.sendInstallFailEvent(e.getCode(), e.getMessage());
        }
        catch (Exception e) {
            logger.error("\u5185\u5bb9\u5305\u52a0\u8f7d\u5f02\u5e38\uff1a", (Throwable)e);
            this.sendInstallFailEvent(500, ResManager.loadKDString((String)"\u5185\u5bb9\u5305\u52a0\u8f7d\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\u3002", (String)"DataPackageInstallerProxy_1", (String)"imsc-cc", (Object[])new Object[0]));
        }
        finally {
            this.release();
        }
    }

    private void dataPackageDownload() throws KdXkIprmException {
        logger.info("inputModel {}", (Object)this.inputModel.toString());
        try {
            String dirName = String.format("%s-", this.inputModel.getId());
            File downloadDir = IprmFileUtils.createTempFile(dirName);
            File dFile = new File(downloadDir.getAbsolutePath() + File.separator + this.inputModel.getId() + ".zip");
            if ("localtab".equals(this.inputModel.getType())) {
                String resourceFileUrl = this.inputModel.getResourceFileUrl();
                if (StringUtils.isEmpty((Object)resourceFileUrl)) {
                    throw new KdXkIprmException(ResManager.loadKDString((String)"\u6587\u4ef6\u4e0b\u8f7d\u5730\u5740\u4e3a\u7a7a\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u3002", (String)"DataPackageInstallerProxy_2", (String)"imsc-cc", (Object[])new Object[0]), 10001);
                }
                FileService fs = FileServiceFactory.getAttachmentFileService();
                InputStream in = fs.getInputStream(resourceFileUrl);
                Files.copy(in, dFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
                this.dataPackageRootFile = IprmFileUtils.unzipPackage(dFile);
            } else {
                String url = ResourceListProxy.downloadFile(this.inputModel.getId());
                if (StringUtils.isEmpty((Object)url)) {
                    throw new KdXkIprmException(ResManager.loadKDString((String)"\u6587\u4ef6\u4e0b\u8f7d\u5730\u5740\u4e3a\u7a7a\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u3002", (String)"DataPackageInstallerProxy_2", (String)"imsc-cc", (Object[])new Object[0]), 10001);
                }
                FileUtils.copyURLToFile((URL)IprmFileUtils.linkToURL(url), (File)dFile, (int)5000, (int)120000);
                this.dataPackageRootFile = IprmFileUtils.unzipPackage(dFile);
            }
            logger.info("downLoad file finish  dirPath {}", (Object)this.dataPackageRootFile.getAbsolutePath());
        }
        catch (Exception e) {
            logger.error("\u6587\u4ef6\u4e0b\u8f7d\u5931\u8d25|", (Throwable)e);
            throw new KdXkIprmException(ResManager.loadKDString((String)"\u6587\u4ef6\u4e0b\u8f7d\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u5305\u662f\u5426\u5b58\u5728\u5e76\u4e14\u53ef\u7528\u3002", (String)"DataPackageInstallerProxy_3", (String)"imsc-cc", (Object[])new Object[0]), e, 1004);
        }
    }

    private void init() throws KdXkIprmException {
        if (this.subDataConfigList == null || this.subDataConfigList.isEmpty()) {
            this.dataPackageDownload();
            this.initDataPackageStreamParse();
        }
    }

    private void initDataPackageStreamParse() throws KdXkIprmException {
        if (this.dataPackageRootFile == null || !this.dataPackageRootFile.exists()) {
            throw new KdXkIprmException(ResManager.loadKDString((String)"\u6570\u636e\u5b89\u88c5\u5305\u6587\u4ef6\u5f02\u5e38\u6216\u672c\u5730\u4e0d\u5b58\u5728\u3002", (String)"DataPackageInstallerProxy_4", (String)"imsc-cc", (Object[])new Object[0]), 401);
        }
        File configureFile = new File(this.dataPackageRootFile.getAbsolutePath() + File.separator + "datapackage_configure.json");
        if (!configureFile.exists() && !(configureFile = new File(this.dataPackageRootFile.getAbsolutePath() + File.separator + "cc_datapackage_configure.json")).exists()) {
            throw new KdXkIprmException(ResManager.loadKDString((String)"\u6570\u636e\u5b89\u88c5\u5305\u914d\u7f6e\u6587\u4ef6\u4e0d\u5b58\u5728", (String)"DataPackageInstallerProxy_5", (String)"imsc-cc", (Object[])new Object[0]), 401);
        }
        try {
            String configureInfo = FileUtils.readFileToString((File)configureFile, (String)"UTF-8");
            if (StringUtils.isEmpty((Object)configureInfo)) {
                throw new KdXkIprmException(ResManager.loadKDString((String)"\u6570\u636e\u5b89\u88c5\u5305\u5b89\u88c5\u914d\u7f6e\u6587\u4ef6\u4e3a\u7a7a\u3002", (String)"DataPackageInstallerProxy_6", (String)"imsc-cc", (Object[])new Object[0]), 401);
            }
            this.configObj = JSON.parseObject((String)configureInfo);
            JSONArray subDataArray = this.configObj.getJSONArray("subdatapacket");
            if (subDataArray == null || subDataArray.isEmpty()) {
                throw new KdXkIprmException(ResManager.loadKDString((String)"\u6570\u636e\u5b89\u88c5\u5305\u4e2d\u6ca1\u6709\u5b50\u5305\u4fe1\u606f\u3002", (String)"DataPackageInstallerProxy_7", (String)"imsc-cc", (Object[])new Object[0]), 401);
            }
            this.subDataConfigList = subDataArray.toJavaList(SubDataConfigureInfo.class);
            if (this.subDataConfigList == null || this.subDataConfigList.isEmpty()) {
                throw new KdXkIprmException(ResManager.loadKDString((String)"\u6570\u636e\u5b89\u88c5\u5305\u4e2d\u6ca1\u6709\u5b50\u5305\u5b89\u88c5\u8f6c\u6362\u4fe1\u606f\u3002", (String)"DataPackageInstallerProxy_8", (String)"imsc-cc", (Object[])new Object[0]), 401);
            }
            logger.info("subDataConfigList\uff1a{}", (Object)JSON.toJSONString(this.subDataConfigList));
        }
        catch (IOException e) {
            throw new KdXkIprmException(e, 401);
        }
        catch (JSONException e2) {
            throw new KdXkIprmException(ResManager.loadKDString((String)"\u6570\u636e\u5b89\u88c5\u5305JSON\u914d\u7f6e\u6587\u4ef6\u683c\u5f0f\u5316\u5f02\u5e38\u3002", (String)"DataPackageInstallerProxy_9", (String)"imsc-cc", (Object[])new Object[0]), e2, 401);
        }
    }

    private void totalDataPackageFileCheck() throws KdXkIprmException {
        if (this.configObj == null || this.configObj.isEmpty()) {
            throw new KdXkIprmException(ResManager.loadKDString((String)"\u914d\u7f6e\u6570\u636e\u4e3a\u7a7a\u3002", (String)"DataPackageInstallerProxy_10", (String)"imsc-cc", (Object[])new Object[0]), 402);
        }
        int totalCount = 1;
        int subCount = this.subDataConfigList.size();
        this.sendDataPackageInfoEvent(totalCount, subCount);
        StringBuilder totalCheckMsgBuilder = new StringBuilder();
        for (SubDataConfigureInfo configInfo : this.subDataConfigList) {
            String fileName = configInfo.getFileName();
            configInfo.setFileDirectory(this.dataPackageRootFile.getAbsolutePath());
            String path = configInfo.getFileDirectory() + File.separator + fileName;
            String md5 = IprmFileUtils.getFileMd5(path);
            logger.info("\u6587\u4ef6 {} md5\u68c0\u67e5 \u539f\u59cb\u503c {} \u8ba1\u7b97\u503c {}", new Object[]{fileName, this.configObj.getString(fileName), md5});
            if (md5.equals(this.configObj.getString(fileName))) continue;
            totalCheckMsgBuilder.append(String.format(ResManager.loadKDString((String)"\u68c0\u67e5\u5230\u6587\u4ef6\u201c%1$s\u201d\u5185\u5bb9\u88ab\u4fee\u6539\uff0c\u65e0\u6cd5\u52a0\u8f7d\u3002", (String)"DataPackageInstallerProxy_11", (String)"imsc-cc", (Object[])new Object[0]), fileName)).append("\n");
        }
        String totalMsg = totalCheckMsgBuilder.toString();
        if (!StringUtils.isEmpty((Object)totalMsg)) {
            throw new KdXkIprmException(totalMsg, 3001);
        }
        this.subDataPackageFileCheck();
    }

    private void subDataPackageFileCheck() throws KdXkIprmException {
        StringBuilder errorMsgBuilder = new StringBuilder();
        boolean checkResult = true;
        int size = this.subDataConfigList.size();
        for (int i = 0; i < size; ++i) {
            SubDataConfigureInfo configInfo = this.subDataConfigList.get(i);
            logger.info("Start Check SubDataPackage fileName {} code {} ", (Object)configInfo.getFileName(), (Object)configInfo.getInstallCode());
            InstallWay installWay = InstallWay.findInstallWayWithType(configInfo.getInstallWay());
            ISubPackageHandler subDataPackageHandler = null;
            try {
                switch (installWay) {
                    case EXCEL: 
                    case JSON: {
                        subDataPackageHandler = SubDataPackageDispatchFactory.getSubDataPackageWithInstallWay(installWay);
                        break;
                    }
                    case CUSTOM_PLUGIN: {
                        configInfo.setPlugin(PluginAdapterHelper.pluginAdapter(configInfo.getPlugin()));
                        subDataPackageHandler = SubDataPackageDispatchFactory.getSubDataPackageWithClassName(configInfo.getPlugin());
                        break;
                    }
                    case MICRO_SERVICE: {
                        subDataPackageHandler = (ISubPackageHandler)TypesContainer.getOrRegisterSingletonInstance((String)MicroSubPackageHandlerImpl.class.getName());
                    }
                }
            }
            catch (IllegalArgumentException e) {
                logger.error((Throwable)e);
            }
            catch (RuntimeException e2) {
                logger.error((Throwable)e2);
            }
            if (subDataPackageHandler == null) {
                String msg = String.format(ResManager.loadKDString((String)"\u5b50\u5305\u201c%1$s\u201d\u4e0d\u652f\u6301\u9009\u5b9a\u7684\u5b89\u88c5\u65b9\u5f0f\u3002", (String)"DataPackageInstallerProxy_12", (String)"imsc-cc", (Object[])new Object[0]), installWay.name());
                if (installWay == InstallWay.CUSTOM_PLUGIN) {
                    msg = configInfo.getFileName() + " " + String.format(ResManager.loadKDString((String)"\u5b50\u5305\u201c%1$s\u201d\u4e0d\u652f\u6301\u5b89\u88c5\u65b9\u5f0f\u201c%2$s\u201d\u3002", (String)"DataPackageInstallerProxy_13", (String)"imsc-cc", (Object[])new Object[0]), installWay.name(), configInfo.getPlugin());
                }
                logger.warn(msg);
                continue;
            }
            logger.info("SubDataPackageHandler {}", (Object)subDataPackageHandler.getClass().getName());
            SubDataCheckResult subDataCheckResult = subDataPackageHandler.checkSubDataPackageFile(configInfo);
            this.subDataInstallMap.put(configInfo, subDataPackageHandler);
            boolean bl = checkResult = checkResult && subDataCheckResult.isSuccess();
            if (subDataCheckResult.isSuccess()) continue;
            errorMsgBuilder.append(ResManager.loadKDString((String)"\u5b50\u5305\u6570\u636e\uff1a", (String)"DataPackageInstallerProxy_14", (String)"imsc-cc", (Object[])new Object[0])).append(configInfo.getConfigItemName()).append(ResManager.loadKDString((String)"\u5f02\u5e38\u539f\u56e0\uff1a", (String)"DataPackageInstallerProxy_15", (String)"imsc-cc", (Object[])new Object[0])).append(subDataCheckResult.getErrorMsg()).append("\r\n");
        }
        if (!checkResult) {
            throw new KdXkIprmException(errorMsgBuilder.toString(), 402);
        }
        logger.info("\u6240\u6709\u5b50\u5305\u68c0\u67e5\u901a\u8fc7");
    }

    private void subDataPackageInstallPreCheck() {
        String pid = this.inputModel.getId();
        LinkedHashMap<String, DataPackageModifyConfig> dataModifyConfigMap = new LinkedHashMap<String, DataPackageModifyConfig>(this.subDataConfigList.size());
        for (SubDataConfigureInfo configInfo : this.subDataConfigList) {
            int installCount = DataPackageInstallLogHelper.getDataPackageInstallCount(pid, configInfo.getFileName(), 1);
            DataPackageModifyConfig modifyConfig = new DataPackageModifyConfig();
            modifyConfig.setInstallCount(installCount);
            if (configInfo.getInstallInfo() != null) {
                modifyConfig.setReplaceRegMap(configInfo.getInstallInfo().getDataModifyMap());
                modifyConfig.setOpen(configInfo.getInstallInfo().isOpen());
            }
            configInfo.setFileDirectory(this.dataPackageRootFile.getAbsolutePath());
            modifyConfig.setPath(configInfo.getFileDirectory() + File.separator + configInfo.getFileName());
            modifyConfig.setFormId(configInfo.getInstallInfo().getFormId());
            modifyConfig.setDyObjName(configInfo.getConfigItemName());
            modifyConfig.setDyObjType(configInfo.getDyType());
            modifyConfig.setDataEncrypt(Boolean.parseBoolean(String.valueOf(this.inputModel.getObjInfoMap().get("dataencrypt"))));
            dataModifyConfigMap.put(configInfo.getFileName(), modifyConfig);
        }
        this.sendDataPackageModifyEvent(dataModifyConfigMap);
    }

    private void startSubDataPackageInstall() throws KdXkIprmException {
        StringBuilder msg = new StringBuilder();
        Collections.sort(this.subDataConfigList, Comparator.comparing(SubDataConfigureInfo::getInstallCode));
        LinkedHashMap<SubDataConfigureInfo, SubDataInstallResult> installResultMap = new LinkedHashMap<SubDataConfigureInfo, SubDataInstallResult>(this.subDataConfigList.size());
        long startTime = System.currentTimeMillis();
        ArrayList<String> fileNames = new ArrayList<String>();
        for (int i = 0; i < this.subDataConfigList.size(); ++i) {
            SubDataConfigureInfo info = this.subDataConfigList.get(i);
            logger.info("Start Load SubDataPackage fileName {} code {} ", (Object)info.getFileName(), (Object)info.getInstallCode());
            if (!this.isSubDataPackageInstall(info)) continue;
            ISubPackageHandler subHandler = this.subDataInstallMap.get(info);
            SubDataInstallResult result = null;
            long subStartTime = System.currentTimeMillis();
            if (subHandler == null) {
                result = new SubDataInstallResult(info.getFileName());
                result.setTotal(1);
                result.setFailed(1);
                result.setError(String.format(ResManager.loadKDString((String)"\u65e0\u6cd5\u5b89\u88c5\u8be5\u6570\u636e\u5305\u3002\u627e\u4e0d\u5230\u6570\u636e\u5305\u52a0\u8f7d\u5668\u201c%1$s\u201d\u3002", (String)"DataPackageInstallerProxy_16", (String)"imsc-cc", (Object[])new Object[0]), info.getPlugin()));
            } else {
                subHandler.subPackageDataModify(info, this.modifyResultMap.get(info.getFileName()));
                result = subHandler.installPacket(info, info.getInstallInfo());
            }
            if (info.getInstallInfo().isOpen()) {
                result.setFormId(info.getInstallInfo().getFormId());
            }
            long endTime = System.currentTimeMillis();
            result.setStartTime(subStartTime);
            result.setUserTime(CommonUtils.getUsedTime(subStartTime, endTime));
            result.setEndTime(endTime);
            msg.append(i + 1).append(": ").append(result.getSimpleReport()).append('\n');
            fileNames.add(info.getFileName());
            String fileInfo = IprmFileUtils.getFileNameWithOutExtension(info.getFileName());
            installResultMap.put(info, result);
            logger.info("\u6267\u884c\u7ed3\u679c\u4e3a{}", (Object)result);
            int subStatus = this.getSubStatus(result);
            this.sendInstallProgressEvent(fileInfo, result, subStatus);
            if (!StringUtils.isEmpty((Object)this.taskId) && TaskHelper.isStop((String)this.taskId)) break;
        }
        long endTime = System.currentTimeMillis();
        DynamicObject logDyObj = DataPackageInstallLogHelper.convertInstallLogObj(this.inputModel, msg.toString(), installResultMap, startTime, endTime);
        int status = logDyObj.getInt("status");
        String logId = DataPackageInstallLogHelper.saveDataPackageInstallInfo(logDyObj);
        DataPackageInstallLogHelper.sendInstallLogToGcp(logDyObj);
        this.sendInstallFinishEvent(msg.toString(), logId, status, fileNames);
    }

    private int getSubStatus(SubDataInstallResult result) {
        int subStatus = 0;
        subStatus = result.isSuccess() ? 1 : (result.getTotal() - result.getFailed() > 0 ? 3 : 2);
        return subStatus;
    }

    private boolean isSubDataPackageInstall(SubDataConfigureInfo info) throws KdXkIprmException {
        if (this.listener != null && this.modifyResultMap == null) {
            this.modifyResultMap = this.listener.getDataPackageReplaceAsync();
        }
        if (this.modifyResultMap == null || this.modifyResultMap.isEmpty()) {
            throw new KdXkIprmException(ResManager.loadKDString((String)"\u8bf7\u9009\u4e2d\u8981\u5b89\u88c5\u7684\u5b50\u5305\u5217\u8868\u3002", (String)"DataPackageInstallerProxy_17", (String)"imsc-cc", (Object[])new Object[0]), 1001);
        }
        DataPackageModifyResult modifyResult = this.modifyResultMap.get(info.getFileName());
        return modifyResult != null && modifyResult.isInstall();
    }

    private void sendInstallProgressEvent(String fileName, SubDataInstallResult result, int subStatus) {
        if (this.listener != null) {
            this.listener.dataPackageInstallProgress(fileName, result, subStatus);
        }
    }

    private void sendInstallFinishEvent(String msg, String logPKId, int status, List<String> fileNames) {
        if (this.listener != null) {
            this.listener.dataPackageInstallFinish(msg, logPKId, status, fileNames);
        }
    }

    private void sendInstallFailEvent(int code, String errMsg) {
        if (this.listener != null) {
            this.listener.dataPackageInstallFail(code, errMsg);
        }
        if (this.prewListener != null) {
            this.prewListener.dataPackageInstallFail(code, errMsg);
        }
    }

    private void sendDataPackageInfoEvent(int totalPackageCount, int subPackageCount) {
        if (this.listener != null) {
            this.listener.dataPackageInstallInfoCallback(totalPackageCount, subPackageCount);
        }
    }

    private void sendDataPackageModifyEvent(Map<String, DataPackageModifyConfig> modifyConfigMap) {
        Set<Map.Entry<String, DataPackageModifyConfig>> entrySet = modifyConfigMap.entrySet();
        for (Map.Entry<String, DataPackageModifyConfig> pair : entrySet) {
            Map<String, String> metaDisplayName;
            DataPackageModifyConfig pairValue = pair.getValue();
            Map<String, JSONObject> regMap = pairValue.getReplaceRegMap();
            if (regMap == null || regMap.isEmpty() || (metaDisplayName = PermissionHelper.getMetaDisplayName(pairValue.getFormId(), regMap.keySet())) == null || metaDisplayName.isEmpty()) continue;
            Set<Map.Entry<String, JSONObject>> modifyKeySet = regMap.entrySet();
            for (Map.Entry<String, JSONObject> modifyPair : modifyKeySet) {
                String key = modifyPair.getKey();
                String displayName = metaDisplayName.get(key);
                if (StringUtils.isEmpty((Object)displayName)) {
                    displayName = key;
                }
                modifyPair.getValue().put("display_name", (Object)displayName);
            }
        }
        if (this.listener != null) {
            this.modifyResultMap = this.listener.checkDataPackageReplaceCallBack(modifyConfigMap);
        }
        if (this.prewListener != null) {
            this.prewListener.checkDataPackageReplaceCallBack(modifyConfigMap);
        }
    }

    private void release() {
        logger.info("\u8d44\u6e90\u91ca\u653e,\u5220\u9664\u4e0b\u8f7d\u53ca\u89e3\u538b\u7684\u8d44\u6e90");
        try {
            this.subDataInstallMap = null;
            this.configObj = null;
            this.subDataConfigList = null;
            this.modifyResultMap = null;
            if (this.dataPackageRootFile != null) {
                logger.info("release Directory {}", (Object)this.dataPackageRootFile.getParentFile().getAbsolutePath());
                FileUtils.deleteDirectory((File)this.dataPackageRootFile.getParentFile());
            }
            this.dataPackageRootFile = null;
        }
        catch (IOException e) {
            logger.error("\u8d44\u6e90\u91ca\u653e\u5f02\u5e38", (Throwable)e);
        }
    }
}

