/*
 * Decompiled with CFR 0.152.
 */
package kd.imsc.cc.common.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.Tips;
import kd.bos.form.IFormView;
import kd.bos.form.control.Label;
import kd.bos.lang.Lang;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.imsc.cc.business.utils.ResourceInfoUtil;
import kd.imsc.cc.common.model.ContentDetailModel;

public class ContentHelper {
    public static void setScene(List<String> sceneList, IFormView view) {
        int i;
        if (sceneList == null) {
            sceneList = new ArrayList<String>();
        }
        int noScene = 0;
        if (sceneList.size() > 5) {
            Label label = (Label)view.getControl("scene6");
            label.setText(String.format("+%s", sceneList.size() - 5));
            StringBuilder st = new StringBuilder();
            for (int i2 = 5; i2 < sceneList.size(); ++i2) {
                st.append(sceneList.get(i2)).append(',');
            }
            st.deleteCharAt(st.lastIndexOf(","));
            Tips tips = new Tips();
            tips.setType("text");
            tips.setContent(new LocaleString(st.toString()));
            tips.setTriggerType("hover");
            tips.setShowIcon(false);
            label.addTips(tips);
        } else {
            noScene = 5 - sceneList.size();
            view.setVisible(Boolean.FALSE, new String[]{"scene6"});
        }
        ArrayList<String> sceneVisibleList = new ArrayList<String>(10);
        ArrayList<String> sceneNoVisibleList = new ArrayList<String>(10);
        for (i = 1; i <= sceneList.size() && i <= 5; ++i) {
            String sceneValue = sceneList.get(i - 1);
            if (!StringUtils.isEmpty((String)sceneValue)) {
                sceneVisibleList.add(String.format("scene%s", i));
                Label label = (Label)view.getControl(String.format("scene%s", i));
                label.setText(sceneValue);
                continue;
            }
            sceneNoVisibleList.add(String.format("scene%s", i));
        }
        if (noScene != 0) {
            for (i = 1; i <= noScene; ++i) {
                sceneNoVisibleList.add(String.format("scene%s", sceneList.size() + i));
            }
        }
        view.setVisible(Boolean.TRUE, sceneVisibleList.toArray(new String[0]));
        view.setVisible(Boolean.FALSE, sceneNoVisibleList.toArray(new String[0]));
    }

    public static String getLanguageAuthenTips() {
        Lang lang = RequestContext.get().getLang();
        String langTag = lang.getLocale().toString();
        DynamicObject langObj = QueryServiceHelper.queryOne((String)"inte_language", (String)"name", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)langTag)});
        return String.format(ResManager.loadKDString((String)"\u5f53\u524d\u5185\u5bb9\u5305\u4e0d\u652f\u6301\u201c%1$s\u201d", (String)"ContentHelper_0", (String)"imsc-cc", (Object[])new Object[0]), langObj.getString("name"));
    }

    public static String languageAuthenTips(ContentDetailModel dataMap) {
        String supportlanguage = dataMap.getSupportlanguage();
        if (StringUtils.isBlank((String)supportlanguage)) {
            return "";
        }
        Lang lang = RequestContext.get().getLang();
        String langTag = lang.getLangTag();
        String[] supportlanguages = supportlanguage.split(",");
        ArrayList<String> langList = new ArrayList<String>();
        for (String suLang : supportlanguages) {
            if (StringUtils.isBlank((String)suLang)) continue;
            String manyExpense = ResourceInfoUtil.getManyExpense(suLang);
            langList.add(manyExpense);
        }
        String currentLang = ResourceInfoUtil.getManyExpense(langTag);
        DynamicObject curDyn = BusinessDataServiceHelper.loadSingle((String)"inte_language", (String)"id,name", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)currentLang)});
        DynamicObject[] supportDyns = BusinessDataServiceHelper.load((String)"inte_language", (String)"id,name", (QFilter[])new QFilter[]{new QFilter("number", "in", langList)});
        Map localeNameMap = (Map)DB.query((DBRoute)DBRoute.base, (String)"select fid,fname from t_int_language", (Object[])null, rs -> {
            HashMap<Long, String> map = new HashMap<Long, String>(1);
            while (rs.next()) {
                map.put(rs.getLong("fid"), rs.getString("fname"));
            }
            return map;
        });
        String currentLangguage = (String)localeNameMap.get(curDyn.get("id"));
        String supportLangname = Arrays.stream(supportDyns).map(e -> (String)localeNameMap.get(e.get("id"))).collect(Collectors.joining("/"));
        return String.format(ResManager.loadKDString((String)"\u5f53\u524d\u5185\u5bb9\u5305\u4e0d\u652f\u6301\u201c%1$s\u201d\uff0c\u8bf7\u5c06\u7cfb\u7edf\u8bed\u8a00\u5207\u6362\u4e3a\u201c%2$s\u201d\u518d\u52a0\u8f7d\u3002", (String)"MyContentPlugin_12", (String)"imsc-cc", (Object[])new Object[0]), currentLangguage, supportLangname);
    }
}

