/*
 * Decompiled with CFR 0.152.
 */
package kd.imsc.cc.common.utils;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.fileservice.FileItem;
import kd.bos.fileservice.FileService;
import kd.imsc.cc.common.exception.CcBizException;

public class FileUtils {
    public static byte[] inputStreamToByte(InputStream is) {
        byte[] resBytes;
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
            byte[] bytes = new byte[1024];
            int i = -1;
            while ((i = is.read(bytes)) != -1) {
                bos.write(bytes, 0, i);
            }
            resBytes = bos.toByteArray();
        }
        catch (Exception e) {
            String msgTpl = ResManager.loadKDString((String)"inputStream\u8f6cbyte\u6570\u7ec4\u5f02\u5e38\u3002", (String)"FileUtils_0", (String)"imsc-cc", (Object[])new Object[0]);
            throw new CcBizException(msgTpl, e);
        }
        return resBytes;
    }

    public static String uploadToFileService(FileService fs, FileItem fileItem) {
        try {
            String string = fs.upload(fileItem);
            return string;
        }
        catch (Exception e) {
            String msg = ResManager.loadKDString((String)"\u4e0a\u4f20\u5931\u8d25\u3002", (String)"FileUtils_2", (String)"imsc-cc", (Object[])new Object[0]);
            throw new CcBizException(msg, e);
        }
        finally {
            fileItem.close();
        }
    }

    public static Map<String, Object> createUploadFileMap(String formId, Object pkid, String attachKey, String uploadPath, String fileName, long size, String type) {
        HashMap<String, Object> uploadFileMap = new HashMap<String, Object>(16);
        uploadFileMap.put("entityNum", formId);
        uploadFileMap.put("billPkId", String.valueOf(pkid));
        uploadFileMap.put("lastModified", System.currentTimeMillis());
        uploadFileMap.put("uid", "rc-upload-" + DB.genGlobalLongId());
        uploadFileMap.put("attachKey", attachKey);
        uploadFileMap.put("client", "web");
        uploadFileMap.put("name", fileName);
        uploadFileMap.put("url", uploadPath);
        uploadFileMap.put("size", size);
        uploadFileMap.put("type", type);
        uploadFileMap.put("status", "success");
        return uploadFileMap;
    }

    public static void inputStreamToOutputStream(InputStream inputStream, OutputStream outputStream) throws IOException {
        int index;
        byte[] bytes = new byte[4096];
        while ((index = inputStream.read(bytes)) != -1) {
            outputStream.write(bytes, 0, index);
        }
    }
}

