/*
 * Decompiled with CFR 0.152.
 */
package kd.imsc.cc.common.utils;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.fileservice.FileItem;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.control.Image;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.url.UrlService;
import kd.bos.util.FileNameUtils;
import kd.imsc.cc.common.utils.PackUploader;

public class PackUploadUtils {
    private static final Log logger = LogFactory.getLog(PackUploadUtils.class);

    public static String packageCheck(AttachmentPanel attachmentPanel, List<Map<String, Object>> list) {
        for (Map<String, Object> map : list) {
            String url = (String)map.get("url");
            PackUploader uploader = new PackUploader(url);
            String name = (String)map.get("name");
            uploader.setUploadName(StringUtils.substringBeforeLast((String)name, (String)".zip"));
            uploader.doUpload();
            if (!uploader.isSuccess()) {
                return uploader.getMsg();
            }
            attachmentPanel.remove(map);
        }
        return null;
    }

    public static String getUploadPrefixPath() {
        String date = LocalDate.now().format(DateTimeFormatter.ofPattern("yyyyMM"));
        String tenantId = RequestContext.get().getTenantId();
        String accountId = RequestContext.get().getAccountId();
        return String.format("/%s/%s/%s", tenantId, accountId, date);
    }

    public static String uploadPicture(String oldPath, String value) {
        byte[] decodedBytes = Base64.getDecoder().decode(value);
        ByteArrayInputStream inputStream = new ByteArrayInputStream(decodedBytes);
        CharSequence[] parts = oldPath.split("/");
        String path = null;
        String fileName = parts[parts.length - 1];
        if (parts.length < 3) {
            String tag = String.format("%s/%s/", "images", UUID.randomUUID().toString().replaceAll("-", ""));
            path = FileNameUtils.getExportFileName((String)RequestContext.get().getTenantId(), (String)RequestContext.get().getAccountId(), (String)"CC", (String)tag, (String)fileName);
        } else {
            String currentYearMonth;
            String tenantId = RequestContext.get().getTenantId();
            String accountId = RequestContext.get().getAccountId();
            parts[1] = tenantId;
            parts[2] = accountId;
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyyMMdd");
            parts[3] = currentYearMonth = LocalDateTime.now().format(formatter);
            path = String.join((CharSequence)"/", parts);
        }
        FileItem item = new FileItem(fileName, path, (InputStream)inputStream);
        FileService imageFileService = FileServiceFactory.getImageFileService();
        return imageFileService.upload(item);
    }

    public static String getPictureInfo(List<Map<String, String>> pictureInfo, Image image) {
        ArrayList<String> pictUrlCache = new ArrayList<String>(10);
        if (pictureInfo != null && !pictureInfo.isEmpty()) {
            for (int i = 0; i < pictureInfo.size(); ++i) {
                Map<String, String> pictInfoMap = pictureInfo.get(i);
                String pictUrl = pictInfoMap.get("picurl");
                String pictTag = pictInfoMap.get("pic");
                if (kd.bos.util.StringUtils.isEmpty((String)pictTag)) continue;
                int commaIndex = pictTag.indexOf(",");
                pictTag = commaIndex != -1 ? pictTag.substring(commaIndex + 1) : pictTag;
                String newUrl = PackUploadUtils.uploadPicture(pictUrl, pictTag);
                logger.info("\u4e0a\u4f20\u56fe\u7247\u7684\u5730\u5740\u4e3a\uff1a{}", (Object)newUrl);
                if (i == 0) {
                    String imageFullUrl = UrlService.getImageFullUrl((String)newUrl);
                    image.setUrl(imageFullUrl);
                }
                pictUrlCache.add(newUrl);
            }
        }
        return SerializationUtils.toJsonString(pictUrlCache);
    }
}

