/*
 * Decompiled with CFR 0.152.
 */
package kd.imsc.dmw.engine.eas.action.impl.repair;

import com.alibaba.fastjson.JSONObject;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.imsc.dmw.engine.eas.action.impl.repair.IRepairExec;
import kd.imsc.dmw.engine.eas.action.impl.repair.RepairExecPluginImpl;
import kd.imsc.dmw.engine.eas.core.log.RepairLog;
import kd.imsc.dmw.engine.eas.core.model.RepairResponse;

public class RepairExecMicroImpl
implements IRepairExec {
    private static final Log logger = LogFactory.getLog(RepairExecPluginImpl.class);
    private static final String[] BOS_CLOUD = new String[]{"WFS", "DEV", "EIP", "SYS"};
    private Long dbLinkId;
    private DynamicObject checkRepairEntry;
    private RepairLog repairLog;

    public RepairExecMicroImpl(Long dbLinkId, DynamicObject checkRepairEntry, RepairLog repairLog) {
        this.dbLinkId = dbLinkId;
        this.checkRepairEntry = checkRepairEntry;
        this.repairLog = repairLog;
    }

    @Override
    public RepairResponse doRepair() {
        try {
            String micro = this.checkRepairEntry.getString("entryentity.repairmicro");
            Map microMap = (Map)JSONObject.parseObject((String)micro, Map.class);
            Map<String, Object> paramMap = this.buildRequestParams(microMap);
            paramMap.put("dbLink", this.dbLinkId);
            List<String> bosCloudList = Arrays.asList(BOS_CLOUD);
            Object result = null;
            String cloudNumber = ((String)microMap.get("cloud")).toLowerCase();
            String appNum = (String)microMap.get("appid");
            String serviceName = (String)microMap.get("servicename");
            String method = (String)microMap.get("method");
            result = bosCloudList.contains(cloudNumber) ? DispatchServiceHelper.invokeBOSService((String)appNum, (String)serviceName, (String)method, (Object[])new Object[]{paramMap}) : DispatchServiceHelper.invokeBizService((String)cloudNumber, (String)appNum, (String)serviceName, (String)method, (Object[])new Object[]{paramMap});
            Map map = (Map)result;
            logger.info("\u5fae\u670d\u52a1\u4fee\u590d\u8fd4\u56de\u7ed3\u679c\u4e3a:" + JSONObject.toJSONString((Object)map));
            this.repairLog.setValue("repairstatus", map.get("repairStatus"));
            this.repairLog.setValue("successcount", map.get("successCount"));
            this.repairLog.setValue("failcount", map.get("failcount"));
            this.repairLog.setlogDetail((String)map.get("detail"));
        }
        catch (Exception e) {
            this.repairLog.setValue("repairstatus", "B");
            this.repairLog.setlogDetail(e.getMessage());
        }
        return null;
    }

    private Map<String, Object> buildRequestParams(Map<String, Object> microMap) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>(16);
        paramMap.put("dbLinkId", this.dbLinkId);
        List custormParams = (List)microMap.get("list");
        if (!CollectionUtils.isEmpty((Collection)custormParams)) {
            for (Map custormParam : custormParams) {
                String key = (String)custormParam.get("key");
                String value = (String)custormParam.get("val");
                paramMap.put(key, value);
            }
        }
        return paramMap;
    }
}

