/*
 * Decompiled with CFR 0.152.
 */
package kd.imsc.dmw.engine.eas.core.progress;

import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.imsc.dmw.engine.eas.core.progress.MigrateProgress;
import kd.imsc.dmw.engine.eas.core.progress.Progress;

public class ActionProgress
extends Progress {
    private static final Log log = LogFactory.getLog(ActionProgress.class);
    private MigrateProgress parentProgress;
    private int total;
    private int complete;

    public ActionProgress(int weight, MigrateProgress parentProgress, int total) {
        super(weight);
        this.parentProgress = parentProgress;
        parentProgress.addSubProgress(this);
        this.total = total;
    }

    @Override
    public void update(int progres) {
        super.update(progres);
        this.notice();
    }

    public void updateComplete(int complete) {
        if (this.total <= 0) {
            this.update(100);
        } else {
            if (complete <= 0) {
                complete = 0;
            }
            int progress = complete * 100 / this.total;
            log.info("\u6267\u884c\u8fdb\u5ea6:" + progress);
            this.update(progress);
        }
    }

    @Override
    public void complete() {
        super.complete();
        this.notice();
        log.info("\u6267\u884c\u8fdb\u5ea6:100");
    }

    public void addComplete(int completeQty) {
        this.complete += completeQty;
    }

    public int getComplete() {
        return this.complete;
    }

    public String getTaskId() {
        return this.parentProgress.getTaskId();
    }

    public MigrateProgress getParentProgress() {
        return this.parentProgress;
    }

    @Override
    public void notice() {
        this.parentProgress.notice();
    }
}

