/*
 * Decompiled with CFR 0.152.
 */
package kd.imsc.dmw.engine.multiimport.install;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.form.FormConfig;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.service.DispatchServiceHelper;
import kd.bos.mvc.FormConfigFactory;
import kd.bos.util.StringUtils;
import kd.imsc.dmw.engine.multiimport.install.ShowParameterBuilder;

public class ImportParamAdapterProxy {
    private static final Log LOGGER = LogFactory.getLog(ImportParamAdapterProxy.class);
    public static final String KEY_FIELDS = "KeyFields";
    public static final String ISOVERRIDEENTRY = "OverrideEntry";
    public static final String IMPORTTYPE = "Type";
    public static final String SETNULL = "SetNULL";
    public static final String SERVICEAPPID = "ServiceAppId";
    public static final String CHECKRIGHTAPPID = "CheckRightAppId";
    public static final String BILLFORMID = "BillFormId";
    public static final String LISTNAME = "ListName";
    public static final String OPSAVE = "OpSave";
    public static final String IMPORTPLUGIN = "ImportPlugin";
    public static final String OPERATEKEY = "OperateKey";
    public static final String APPID = "appId";
    public static final String URL = "Url";
    public static final String LOGID = "logId";
    public static final String IMPORTCUSTONPARAM = "customParamMap";

    private ImportParamAdapterProxy() {
        throw new IllegalStateException("Utility class");
    }

    public static FormShowParameter createFormShowParamForImport(String formId, String pageType, Map<String, String> excelParams) {
        if (StringUtils.isEmpty((String)formId)) {
            return null;
        }
        Object showParameter = "bos_dynamicform".equals(pageType) ? ShowParameterBuilder.formShowParameter(formId, ShowType.MainNewTabPage, null, null, null) : ShowParameterBuilder.listShowParameter(formId, pageType, ShowType.MainNewTabPage, null, null, "", "");
        if (showParameter == null) {
            return null;
        }
        FormConfig formConfig = ImportParamAdapterProxy.getFormConfig(formId, showParameter);
        String bizAppNumber = formConfig.getBizAppNumber();
        String serviceAppId = ImportParamAdapterProxy.getServiceAppId(formConfig.getAppId(), bizAppNumber, showParameter.getServiceAppId());
        LOGGER.info(String.format("createFormShowParameter4Import serviceAppId:%1$s,appid:%2$s", serviceAppId, formConfig.getAppId()));
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)formId);
        String entityDisplayName = entityType.getDisplayName().getLocaleValue();
        String entityName = entityType.getName();
        String saveOp = EntityMetadataCache.getDataEntityOperations((String)entityName).getSave();
        String importPlugin = ImportParamAdapterProxy.getImportPlugin(entityName);
        if (excelParams != null && !excelParams.isEmpty()) {
            String importType = excelParams.get(IMPORTTYPE);
            if (StringUtils.isEmpty((String)importType)) {
                showParameter.setCustomParam(IMPORTTYPE, (Object)"overridenew");
            } else {
                showParameter.setCustomParam(IMPORTTYPE, (Object)importType);
            }
            String keyFields = excelParams.get(KEY_FIELDS);
            if (StringUtils.isEmpty((String)keyFields) || keyFields.replace(",", "").length() == 0) {
                showParameter.setCustomParam(KEY_FIELDS, (Object)",id,");
            } else {
                showParameter.setCustomParam(KEY_FIELDS, (Object)keyFields);
            }
            String isOverrideEntry = excelParams.get(ISOVERRIDEENTRY);
            showParameter.setCustomParam(ISOVERRIDEENTRY, (Object)isOverrideEntry);
        } else {
            showParameter.setCustomParam(IMPORTTYPE, (Object)"overridenew");
            showParameter.setCustomParam(KEY_FIELDS, (Object)",id,");
            showParameter.setCustomParam(ISOVERRIDEENTRY, (Object)"true");
        }
        showParameter.setAppId(bizAppNumber);
        showParameter.setCustomParam(SETNULL, (Object)"true");
        showParameter.setCustomParam(SERVICEAPPID, (Object)serviceAppId);
        showParameter.setCustomParam(CHECKRIGHTAPPID, (Object)bizAppNumber);
        showParameter.setCustomParam(BILLFORMID, (Object)formId);
        showParameter.setCustomParam(LISTNAME, (Object)entityDisplayName);
        showParameter.setCustomParam(OPSAVE, (Object)saveOp);
        showParameter.setCustomParam(IMPORTPLUGIN, (Object)importPlugin);
        showParameter.setCustomParam(OPERATEKEY, (Object)saveOp);
        showParameter.setCustomParam(APPID, (Object)bizAppNumber);
        showParameter.getOpenStyle().setShowType(ShowType.NonModal);
        return showParameter;
    }

    private static FormConfig getFormConfig(String formId, FormShowParameter showParameter) {
        FormConfig formConfig = null;
        formConfig = showParameter instanceof ListShowParameter ? FormMetadataCache.getListFormConfig((String)((ListShowParameter)showParameter).getBillFormId()) : FormMetadataCache.getFormConfig((String)formId);
        return formConfig;
    }

    private static String getServiceAppId(String appId, String bizAppNumber, String serviceAppId) {
        return serviceAppId;
    }

    private static String getImportPlugin(String entityName) {
        Map importOpMap = EntityMetadataCache.getDataEntityOperate((String)entityName, (String)"importdata");
        if (importOpMap == null || !importOpMap.containsKey("parameter")) {
            return "";
        }
        LinkedHashMap opParam = (LinkedHashMap)importOpMap.get("parameter");
        if (!opParam.containsKey("plugins")) {
            return "";
        }
        ArrayList plugins = (ArrayList)opParam.get("plugins");
        if (plugins == null || plugins.isEmpty()) {
            return "";
        }
        for (int i = 0; i < plugins.size(); ++i) {
            Map p = (Map)plugins.get(i);
            if (!Boolean.TRUE.equals(p.get("Enabled"))) continue;
            return String.valueOf(p.get("ClassName"));
        }
        return "";
    }

    public static String openFormView(String formId, FormShowParameter parameter) {
        FormConfigFactory.createConfig((FormShowParameter)parameter);
        DispatchServiceHelper.invokeBOSServiceByFormId((String)formId, (String)"FormService", (String)"batchInvokeAction", (Object[])new Object[]{parameter.getPageId(), "[{\"key\":\"\",\"methodName\":\"loadData\",\"args\":[],\"postData\":[]}]"});
        return parameter.getPageId();
    }

    public static void closeFormView(String formId, String pageId) {
        DispatchServiceHelper.invokeBOSServiceByFormId((String)formId, (String)"FormService", (String)"batchInvokeAction", (Object[])new Object[]{pageId, "[{\"key\":\"toolbarap\",\"methodName\":\"itemClick\",\"args\":[\"tblclose\",\"close\"],\"postData\":[{},[]]}]"});
    }
}

