/*
 * Decompiled with CFR 0.152.
 */
package kd.imsc.dmw.helper;

import java.io.InputStream;
import java.util.UUID;
import kd.bos.cache.CacheFactory;
import kd.bos.context.RequestContext;
import kd.bos.fileservice.FileItem;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.service.DispatchServiceHelper;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.util.FileNameUtils;
import kd.bos.util.StringUtils;

public class CopyFileHelper {
    private static final Log logger = LogFactory.getLog(CopyFileHelper.class);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String uploadFile(String url, String fileName) {
        if (StringUtils.isEmpty((String)url)) return null;
        if (StringUtils.isEmpty((String)fileName)) {
            return null;
        }
        try (InputStream inputStream = CacheFactory.getCommonCacheFactory().getTempFileCache().getInputStream(url);){
            String string = CopyFileHelper.uploadFile(url, fileName, "dmw_impscheme", inputStream);
            return string;
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            return null;
        }
    }

    public static String uploadFile(String url, String fileName, String targetBill, InputStream inputStream) {
        if (StringUtils.isEmpty((String)url) || StringUtils.isEmpty((String)fileName) || StringUtils.isEmpty((String)targetBill) || inputStream == null) {
            return null;
        }
        String tenantId = RequestContext.get().getTenantId();
        String accountId = RequestContext.get().getAccountId();
        String uuid = UUID.randomUUID().toString().replace("-", "");
        String appId = (String)DispatchServiceHelper.invokeBOSService((String)"FormService", (String)"getAppId", (Object[])new Object[]{targetBill});
        String path = FileNameUtils.getAttachmentFileName((String)tenantId, (String)accountId, (String)appId, (String)targetBill, (Object)uuid, (String)CopyFileHelper.replaceSpeSymbol(fileName));
        FileItem fileItem = new FileItem(fileName, path, inputStream);
        return FileServiceFactory.getAttachmentFileService().upload(fileItem);
    }

    private static String replaceSpeSymbol(String str) {
        for (String specialSymbol : AttachmentServiceHelper.SPECIAL_SYMBOLS) {
            if (!str.contains(specialSymbol)) continue;
            str = str.replace(specialSymbol, "_");
        }
        return str;
    }
}

