/*
 * Decompiled with CFR 0.152.
 */
package kd.imsc.dmw.helper.license;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.license.api.LicenseCheckResult;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.license.LicenseServiceHelper;

public class LicenseDomainHelper {
    private static final String BASEFI = "BASEFI";
    private static final String BASESCM = "BASESCM";
    private static final String EXPR = "EXPR";
    private static final String IPO_PG = "IPO_PG";
    private static final String SCX = "SCX";
    private static final Set<String> BASEFISET = new HashSet<String>(1);
    private static final Set<String> BASESCMSET;
    private static final Set<String> EXPRSET;
    private static final Set<String> IPO_PGSET;
    private static final Set<String> SCXSET;

    public LicenseCheckResult checkPerformGroup(String groupNumber, boolean isIncludePackage) {
        LicenseCheckResult licenseCheckResult = LicenseServiceHelper.checkPerformGroup((String)groupNumber);
        if (Boolean.TRUE.equals(licenseCheckResult.getHasLicense())) {
            return licenseCheckResult;
        }
        if (isIncludePackage) {
            boolean pass;
            Set licenseModules = LicenseServiceHelper.getLicenseModules();
            boolean bl = pass = BASEFISET.contains(groupNumber) && licenseModules.contains(BASEFI) || BASESCMSET.contains(groupNumber) && licenseModules.contains(BASESCM) || EXPRSET.contains(groupNumber) && licenseModules.contains(EXPR) || IPO_PGSET.contains(groupNumber) && licenseModules.contains(IPO_PG) || SCXSET.contains(groupNumber) && licenseModules.contains(SCX);
            if (pass) {
                licenseCheckResult.setHasLicense(Boolean.TRUE);
                licenseCheckResult.setMsg("");
            }
        }
        return licenseCheckResult;
    }

    public LicenseCheckResult checkPerformModule(String moduleNumber, boolean isIncludePackage) {
        LicenseCheckResult licenseCheckResult = new LicenseCheckResult();
        Set licenseModules = LicenseServiceHelper.getLicenseModules();
        if (CollectionUtils.isEmpty((Collection)licenseModules) || !licenseModules.contains(moduleNumber)) {
            String name = moduleNumber;
            DynamicObject licenseModule = BusinessDataServiceHelper.loadSingleFromCache((String)"lic_module", (String)"id,number,name", (QFilter[])new QFilter[]{new QFilter("number", "in", (Object)moduleNumber)});
            if (licenseModule != null) {
                name = licenseModule.getString("name");
            }
            licenseCheckResult.setHasLicense(Boolean.FALSE);
            licenseCheckResult.setMsg(String.format(ResManager.loadKDString((String)"\u65e0%s\u5e94\u7528\u6a21\u5757\u8bb8\u53ef\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"LicenseDomainHelper_0", (String)"imsc-dmw-platform", (Object[])new Object[0]), name));
            if (CollectionUtils.isEmpty((Collection)licenseModules)) {
                return licenseCheckResult;
            }
        } else {
            licenseCheckResult.setHasLicense(Boolean.TRUE);
            return licenseCheckResult;
        }
        if (isIncludePackage) {
            boolean pass;
            boolean bl = pass = BASEFISET.contains(moduleNumber) && licenseModules.contains(BASEFI) || BASESCMSET.contains(moduleNumber) && licenseModules.contains(BASESCM) || EXPRSET.contains(moduleNumber) && licenseModules.contains(EXPR) || IPO_PGSET.contains(moduleNumber) && licenseModules.contains(IPO_PG) || SCXSET.contains(moduleNumber) && licenseModules.contains(SCX);
            if (pass) {
                licenseCheckResult.setHasLicense(Boolean.TRUE);
                licenseCheckResult.setMsg("");
            }
        }
        return licenseCheckResult;
    }

    static {
        BASEFISET.add("GL");
        BASEFISET.add("PRO_FMB");
        BASEFISET.add("IEP");
        BASEFISET.add("XKRPT");
        BASEFISET.add("FA");
        BASEFISET.add("CAS");
        BASESCMSET = new HashSet<String>(1);
        BASESCMSET.add("SM");
        BASESCMSET.add("PRO_CS");
        BASESCMSET.add("IM");
        BASESCMSET.add("PRO_ST");
        BASESCMSET.add("PM");
        EXPRSET = new HashSet<String>(1);
        EXPRSET.add("TRA");
        EXPRSET.add("EXP");
        EXPRSET.add("CEXP");
        EXPRSET.add("EM");
        IPO_PGSET = new HashSet<String>(1);
        IPO_PGSET.add("THEME");
        IPO_PGSET.add("IQ");
        IPO_PGSET.add("IPM");
        SCXSET = new HashSet<String>(1);
        SCXSET.add("SRM");
        SCXSET.add("SOU");
        SCXSET.add("PUR");
    }
}

