/*
 * Decompiled with CFR 0.152.
 */
package kd.imsc.dmw.helper.tpl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlParameter;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Label;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.LinkQueryPkIdCollection;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.schedule.form.BackgroundTaskSubscriber;
import kd.bos.schedule.form.JobFormInfo;
import kd.bos.schedule.form.TaskClientProxy;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.schedule.ScheduleServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.imsc.dmw.errorcode.DmwBizException;
import kd.imsc.dmw.helper.PermissionHelper;
import kd.imsc.dmw.helper.ScheduleHelper;
import kd.imsc.dmw.helper.tpl.MigrateUserGuideProjectHelper;
import kd.imsc.dmw.plugin.formplugin.schedule.task.CheckItemTask;
import kd.imsc.dmw.plugin.formplugin.schedule.taskclick.CheckItemTaskClick;
import kd.imsc.dmw.utils.CommonUtils;
import kd.imsc.dmw.utils.DynamicObjectUtils;
import kd.imsc.dmw.utils.StringUtil;

public class MigrateUserGuideCheckHelper {
    private static final Log logger = LogFactory.getLog(MigrateUserGuideCheckHelper.class);
    private static final String CHECK_TO_BACKGROUND_CONFIRM = "checkToBackgroundConfirm";
    private static final String CHECK_TASKID_CACHE = "check_taskid_cache";
    private IFormView view;
    private IDataModel model;
    private static final int FIVE_MINUTES = 300000;

    private MigrateUserGuideCheckHelper(IFormView view) {
        this.view = view;
        this.model = view.getModel();
    }

    public static MigrateUserGuideCheckHelper build(IFormView view) {
        return new MigrateUserGuideCheckHelper(view);
    }

    public void checkInit(Boolean isCopy) {
        String status;
        String checkTaskId = (String)this.getModel().getValue("checktaskid");
        ProgressBar checkProgressBar = (ProgressBar)this.getView().getControl("check_progressbarap");
        Label checkStatusLabel = (Label)this.getView().getControl("checkstatuslab");
        Tab tab = (Tab)this.getView().getControl("guidecontent");
        this.getView().setVisible(Boolean.FALSE, new String[]{"check_progressbarap", "checkstatuslab", "gocheck", "gocheckparam", "saveparamvalue"});
        this.getView().setEnable(Boolean.FALSE, new String[]{"checkbackground"});
        switch (status = this.getProjectStatus()) {
            case "A": {
                if (this.getProjectId() != 0L) {
                    tab.activeTab("tabpageap2");
                    break;
                }
                if (isCopy == null || !isCopy.booleanValue()) break;
                tab.activeTab("tabpageap1");
                break;
            }
            case "B": {
                tab.activeTab("tabpageap3");
                this.getView().setVisible(Boolean.FALSE, new String[]{"startcheck", "retrycheck"});
                checkProgressBar.start();
                this.setProgress(checkProgressBar, checkTaskId);
                checkStatusLabel.setText(ResManager.loadKDString((String)"\u68c0\u67e5\u4e2d", (String)"MigrateUserGuideCheckHelper_0", (String)"imsc-dmw-platform", (Object[])new Object[0]));
                break;
            }
            case "C": {
                tab.activeTab("tabpageap3");
                this.setProgress(checkProgressBar, checkTaskId);
                checkStatusLabel.setText(ResManager.loadKDString((String)"\u68c0\u67e5\u4e0d\u901a\u8fc7", (String)"MigrateUserGuideCheckHelper_1", (String)"imsc-dmw-platform", (Object[])new Object[0]));
                this.getView().setEnable(Boolean.TRUE, new String[]{"retrycheck"});
                this.getView().setVisible(Boolean.TRUE, new String[]{"retrycheck"});
                break;
            }
            case "D": {
                tab.activeTab("tabpageap3");
                this.getView().setVisible(Boolean.TRUE, new String[]{"startcheck"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"retrycheck"});
                this.getView().setEnable(Boolean.FALSE, new String[]{"startcheck"});
                checkProgressBar.setPercent(100);
                checkStatusLabel.setText(ResManager.loadKDString((String)"\u68c0\u67e5\u901a\u8fc7", (String)"MigrateUserGuideCheckHelper_2", (String)"imsc-dmw-platform", (Object[])new Object[0]));
                break;
            }
        }
    }

    private void setProgress(ProgressBar checkProgressBar, String checkTaskId) {
        TaskInfo taskInfo = ScheduleServiceHelper.queryTask((String)checkTaskId);
        int progress = taskInfo.getProgress();
        checkProgressBar.setPercent(progress);
    }

    public void startCheckClick() {
        PermissionHelper.checkPermission(this.getView(), "dmw_migrateproject", "4LZ15+4444IQ");
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("checktreeentryentity");
        List<Object> checkItemIds = entryEntity.stream().map(n -> n.getDynamicObject("checkitem").getPkValue()).collect(Collectors.toList());
        String taskId = this.dispatchCheckTask(checkItemIds);
        this.afterStartCheck(this.getProjectId(), taskId, checkItemIds);
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u8fc1\u79fb\u9879\u68c0\u67e5\u8fd0\u884c\u6210\u529f\u3002", (String)"MigrateUserGuideCheckHelper_3", (String)"imsc-dmw-platform", (Object[])new Object[0]));
    }

    public void retryCheckClick() {
        PermissionHelper.checkPermission(this.getView(), "dmw_migrateproject", "4LZ15+4444IQ");
        if (!"C".equals(this.getProjectStatus())) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u68c0\u67e5\u4e0d\u901a\u8fc7\u7684\u60c5\u51b5\u624d\u53ef\u4ee5\u91cd\u8bd5\u3002", (String)"MigrateUserGuideCheckHelper_4", (String)"imsc-dmw-platform", (Object[])new Object[0]));
            return;
        }
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("checktreeentryentity");
        List<Object> checkItemIds = entryEntity.stream().filter(p -> "A".equals(p.getString("checkstatus")) || "C".equals(p.getString("checkstatus"))).map(n -> n.getDynamicObject("checkitem").getPkValue()).collect(Collectors.toList());
        if (!CommonUtils.isNull(checkItemIds)) {
            String taskId = this.dispatchCheckTask(checkItemIds);
            this.afterStartCheck(this.getProjectId(), taskId, checkItemIds);
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u8fc1\u79fb\u9879\u68c0\u67e5\u8fd0\u884c\u6210\u529f\u3002", (String)"MigrateUserGuideCheckHelper_3", (String)"imsc-dmw-platform", (Object[])new Object[0]));
        }
    }

    public void checkToBackgroundConfirm(IFormPlugin formPlugin) {
        String checkTaskId = (String)this.getModel().getValue("checktaskid");
        if (StringUtil.isEmpty(checkTaskId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4efb\u52a1\u672a\u5f00\u59cb\uff0c\u65e0\u9700\u8f6c\u540e\u53f0\u3002", (String)"MigrateUserGuideCheckHelper_5", (String)"imsc-dmw-platform", (Object[])new Object[0]));
            return;
        }
        TaskInfo checkTask = ScheduleServiceHelper.queryTask((String)checkTaskId);
        if (checkTask.isTaskEnd()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4efb\u52a1\u5df2\u7ed3\u675f\uff0c\u65e0\u9700\u8f6c\u540e\u53f0\u3002", (String)"MigrateUserGuideCheckHelper_6", (String)"imsc-dmw-platform", (Object[])new Object[0]));
            return;
        }
        this.getView().showConfirm(ResManager.loadKDString((String)"\u786e\u8ba4\u8981\u628a\u5f53\u524d\u4efb\u52a1\u8f6c\u4e3a\u540e\u53f0\u6267\u884c\uff1f\u8f6c\u4e3a\u540e\u53f0\u6267\u884c\u540e\uff0c\u53ef\u4ee5\u518d\u6b21\u901a\u8fc7\u53f3\u4e0b\u89d2\u7684\u540e\u53f0\u8fd0\u884c\u8fdb\u5ea6\u7403\u518d\u6b21\u6253\u5f00\u3002", (String)"MigrateUserGuideCheckHelper_7", (String)"imsc-dmw-platform", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(CHECK_TO_BACKGROUND_CONFIRM, formPlugin));
    }

    public void interruptCheckConfirm(IFormPlugin formPlugin) {
        TaskInfo checkTask;
        PermissionHelper.checkPermission(this.getView(), "dmw_migrateproject", "4LZ15+4444IQ");
        String checkTaskId = (String)this.getModel().getValue("checktaskid");
        if (StringUtil.isEmpty(checkTaskId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4efb\u52a1\u672a\u5f00\u59cb\uff0c\u65e0\u9700\u8f6c\u4e2d\u6b62\u3002", (String)"MigrateUserGuideCheckHelper_8", (String)"imsc-dmw-platform", (Object[])new Object[0]));
            return;
        }
        if (StringUtil.isNotEmpty(checkTaskId) && (checkTask = ScheduleServiceHelper.queryTask((String)checkTaskId)) != null && checkTask.isTaskEnd()) {
            this.updateCheckStatusIfSystemError();
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4efb\u52a1\u5df2\u7ed3\u675f\uff0c\u65e0\u9700\u4e2d\u6b62\u3002", (String)"MigrateUserGuideCheckHelper_9", (String)"imsc-dmw-platform", (Object[])new Object[0]));
            return;
        }
        this.getView().showConfirm(ResManager.loadKDString((String)"\u786e\u8ba4\u8981\u4e2d\u6b62\u68c0\u67e5\uff1f", (String)"MigrateUserGuideCheckHelper_10", (String)"imsc-dmw-platform", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("interruptCheckConfirm", formPlugin));
    }

    private void updateCheckStatusIfSystemError() {
        String projectFormId = MigrateUserGuideProjectHelper.getProjectFormIdByUserGuide(this.view);
        if (StringUtil.isEmpty(projectFormId)) {
            return;
        }
        boolean hasStatusError = false;
        DynamicObject project = BusinessDataServiceHelper.loadSingle((Object)this.getProjectId(), (String)projectFormId);
        DynamicObjectCollection checkItemEntrys = project.getDynamicObjectCollection("checktreeentryentity");
        for (DynamicObject checkItemEntry : checkItemEntrys) {
            String checkStatus = checkItemEntry.getString("checkstatus");
            if (!"F".equals(checkStatus) && !"B".equals(checkStatus)) continue;
            hasStatusError = true;
            checkItemEntry.set("checkstatus", (Object)"C");
            checkItemEntry.set("checkdetail", (Object)ResManager.loadKDString((String)"\u670d\u52a1\u5f02\u5e38\uff0c\u8bf7\u91cd\u8bd5\u3002", (String)"MigrateUserGuideCheckHelper_11", (String)"imsc-dmw-platform", (Object[])new Object[0]));
            checkItemEntry.set("checkdetail_tag", (Object)ResManager.loadKDString((String)"\u670d\u52a1\u5f02\u5e38\uff0c\u8bf7\u91cd\u8bd5\u3002", (String)"MigrateUserGuideCheckHelper_11", (String)"imsc-dmw-platform", (Object[])new Object[0]));
        }
        if (hasStatusError) {
            project.set("projectstatus", (Object)"C");
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{project});
            this.checkRefresh();
        }
    }

    public void interruptCheck(MessageBoxClosedEvent messageBoxClosedEvent) {
        String checkTaskId;
        if (MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult()) && StringUtil.isNotEmpty(checkTaskId = (String)this.getModel().getValue("checktaskid"))) {
            ScheduleServiceHelper.stopTask((String)checkTaskId);
        }
    }

    private void afterStartCheck(Long pk, String taskId, List<Object> checkItemIds) {
        String projectFormId = MigrateUserGuideProjectHelper.getProjectFormIdByUserGuide(this.view);
        if (StringUtil.isEmpty(projectFormId)) {
            return;
        }
        DynamicObject project = BusinessDataServiceHelper.loadSingle((Object)pk, (String)projectFormId);
        DynamicObjectCollection checkItemEntrys = project.getDynamicObjectCollection("checktreeentryentity");
        for (DynamicObject checkItemEntry : checkItemEntrys) {
            DynamicObject checkItem = checkItemEntry.getDynamicObject("checkitem");
            if (!checkItemIds.contains(DynamicObjectUtils.getPkId(checkItem, "id"))) continue;
            checkItemEntry.set("checkstatus", (Object)"F");
            checkItemEntry.set("checkdetail", (Object)"");
            checkItemEntry.set("checkdetail_tag", (Object)"");
        }
        project.set("projectstatus", (Object)"B");
        project.set("checktaskid", (Object)taskId);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{project});
        ProgressBar checkProgressBar = (ProgressBar)this.getView().getControl("check_progressbarap");
        checkProgressBar.start();
        ProgressBar checkProgressShow = (ProgressBar)this.getView().getControl("check_progressbar_show");
        checkProgressShow.start();
        checkProgressBar.setPercent(0, ResManager.loadKDString((String)"\u5f00\u59cb\u6267\u884c\u68c0\u67e5...", (String)"MigrateUserGuideCheckHelper_12", (String)"imsc-dmw-platform", (Object[])new Object[0]));
        this.getView().setVisible(Boolean.FALSE, new String[]{"startcheck", "retrycheck"});
        this.checkRefresh();
    }

    private String dispatchCheckTask(List<Object> checkItemIds) {
        String taskIdOld = this.getView().getPageCache().get(CHECK_TASKID_CACHE);
        TaskInfo taskInfo = ScheduleServiceHelper.queryTask((String)taskIdOld);
        if (StringUtils.isNotEmpty((CharSequence)taskIdOld) && !taskInfo.isTaskEnd()) {
            throw new DmwBizException(ResManager.loadKDString((String)"\u6b63\u5728\u68c0\u67e5\u4e2d\uff0c\u8bf7\u5148\u7b49\u5f85\u6267\u884c\u5b8c\u6210\u3002", (String)"MigrateUserGuideCheckHelper_13", (String)"imsc-dmw-platform", (Object[])new Object[0]));
        }
        HashMap<String, Object> param = new HashMap<String, Object>(4);
        param.put("checkitemids", checkItemIds);
        Object dbLinkId = ((DynamicObject)this.getModel().getValue("dblink")).getPkValue();
        param.put("dblinkid", dbLinkId);
        param.put("projectid", this.getProjectId());
        param.put("projectFormId", MigrateUserGuideProjectHelper.getProjectFormIdByUserGuide(this.view));
        param.put("checkitemFormId", MigrateUserGuideProjectHelper.getCheckItemFormIdByUserGuide(this.view));
        param.put("guideFormId", this.getView().getModel().getDataEntity().getDataEntityType().getName());
        JobFormInfo jobFormInfo = ScheduleHelper.buildJobFormInfo(ResManager.loadKDString((String)"\u68c0\u67e5\u9879\u68c0\u67e5\u4efb\u52a1", (String)"MigrateUserGuideCheckHelper_14", (String)"imsc-dmw-platform", (Object[])new Object[0]), CheckItemTask.class.getName(), CheckItemTaskClick.class.getName(), this.getView(), param);
        jobFormInfo.getJobInfo().setAppId("dmw");
        String taskId = ScheduleServiceHelper.dispatch((JobInfo)jobFormInfo.getJobInfo());
        this.getView().getPageCache().put(CHECK_TASKID_CACHE, taskId);
        String jsonString = "";
        try {
            jsonString = JSON.toJSONString((Object)jobFormInfo);
        }
        catch (Exception e) {
            logger.error((Throwable)e);
        }
        this.getView().getPageCache().put("imsc_jobforminfo", jsonString);
        return taskId;
    }

    public void promptErrorInfo(List<Long> checkItemIds, String name) {
        String title = ResManager.loadKDString((String)"\u5f88\u62b1\u6b49\uff01\u5f53\u524d\u6709\u68c0\u67e5\u9879\u5728\u6267\u884c\u64cd\u4f5c\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"MigrateUserGuideCheckHelper_15", (String)"imsc-dmw-platform", (Object[])new Object[0]);
        StringBuilder builder = new StringBuilder();
        DynamicObjectCollection checkEntry = this.getModel().getEntryEntity("checktreeentryentity");
        for (int i = 0; i < checkEntry.size(); ++i) {
            DynamicObject checkItem = ((DynamicObject)checkEntry.get(i)).getDynamicObject("checkitem");
            Object checkItemId = checkItem.getPkValue();
            if (!checkItemIds.contains(checkItemId)) continue;
            builder.append(String.format(ResManager.loadKDString((String)"\u5e8f\u53f7%1$s\u68c0\u67e5\u9879\u5458\u5de5\u4fe1\u606f\u68c0\u67e5\u7528\u6237%2$s\u6b63\u5728\u6267\u884c\u68c0\u67e5\u3002", (String)"MigrateUserGuideCheckHelper_16", (String)"imsc-dmw-platform", (Object[])new Object[0]), i + 1, name));
            builder.append('\n');
        }
        MessageBoxOptions options = MessageBoxOptions.OK;
        HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>(8);
        btnNameMaps.put(2, ResManager.loadKDString((String)"\u6211\u77e5\u9053\u4e86", (String)"MigrateUserGuideCheckHelper_17", (String)"imsc-dmw-platform", (Object[])new Object[0]));
        this.getView().showConfirm(title, builder.toString(), options, null, new ConfirmCallBackListener("", this.getView().getRootControl()), btnNameMaps);
    }

    public void singleCheck() {
        PermissionHelper.checkPermission(this.getView(), "dmw_migrateproject", "4LZ15+4444IQ");
        int selectRow = this.getModel().getEntryCurrentRowIndex("checktreeentryentity");
        DynamicObject checkItemObj = (DynamicObject)this.model.getValue("checkitem", selectRow);
        Long checkItemId = Long.parseLong(checkItemObj.getPkValue().toString());
        List<Object> checkItemIds = Collections.singletonList(checkItemId);
        String taskId = this.dispatchCheckTask(checkItemIds);
        this.afterStartCheck(this.getProjectId(), taskId, checkItemIds);
    }

    public void ignoreCheck() {
        PermissionHelper.checkPermission(this.getView(), "dmw_migrateproject", "4LZ15+4444IQ");
        if ("B".equals(this.getProjectStatus())) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6b63\u5728\u68c0\u67e5\u4e2d\uff0c\u8bf7\u5728\u68c0\u67e5\u6267\u884c\u5b8c\u6210\u540e\u5ffd\u7565\u3002", (String)"MigrateUserGuideCheckHelper_18", (String)"imsc-dmw-platform", (Object[])new Object[0]));
            return;
        }
        String projectFormId = MigrateUserGuideProjectHelper.getProjectFormIdByUserGuide(this.view);
        if (StringUtil.isEmpty(projectFormId)) {
            return;
        }
        ProgressBar checkProgressShow = (ProgressBar)this.getView().getControl("check_progressbar_show");
        checkProgressShow.start();
        int selectRow = this.getModel().getEntryCurrentRowIndex("checktreeentryentity");
        DynamicObject checkItem = (DynamicObject)this.getModel().getValue("checkitem", selectRow);
        String tableName = MigrateUserGuideProjectHelper.getMigCheckTableNameByUserGuide(this.view);
        String sql = "update " + tableName + " set fcheckstatus = ? where fid = ? and fcheckitem = ?";
        DB.execute((DBRoute)DBRoute.of((String)"imsc"), (String)sql, (Object[])new Object[]{new SqlParameter(":fcheckstatus", 12, (Object)"E"), new SqlParameter(":fid", -5, (Object)this.getProjectId()), new SqlParameter(":fcheckitem", -5, checkItem.getPkValue())});
        String migProject = MigrateUserGuideProjectHelper.getProjectFormIdByUserGuide(this.view);
        String paramTableName = MigrateUserGuideProjectHelper.getMigCheckParamTableNameByProjectFormId(migProject);
        String paramSql = "update " + paramTableName + " set fcheckstatusvar = ? where fid = ? and fcheckitemvar = ?";
        DB.execute((DBRoute)DBRoute.of((String)"imsc"), (String)paramSql, (Object[])new Object[]{new SqlParameter(":fcheckstatusvar", 12, (Object)"E"), new SqlParameter(":fid", -5, (Object)this.getProjectId()), new SqlParameter(":fcheckitemvar", -5, checkItem.getPkValue())});
        DynamicObject project = BusinessDataServiceHelper.loadSingle((Object)this.getProjectId(), (String)projectFormId);
        DynamicObjectCollection checkEntry = project.getDynamicObjectCollection("checktreeentryentity");
        boolean needUpdateProjectStatus = checkEntry.stream().allMatch(p -> "D".equals(p.getString("checkstatus")) || "E".equals(p.getString("checkstatus")));
        if (needUpdateProjectStatus) {
            project.set("projectstatus", (Object)"D");
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{project});
            MigrateUserGuideProjectHelper.setProjectStatus(this.getView(), "D");
        }
        this.checkRefresh();
        this.saveIgnoreLog(selectRow);
    }

    private void saveIgnoreLog(int row) {
        DynamicObject project = BusinessDataServiceHelper.loadSingle((Object)this.getProjectId(), (String)MigrateUserGuideProjectHelper.getProjectFormIdByUserGuide(this.view));
        if (CommonUtils.isNull(project)) {
            return;
        }
        String ignoreFormId = MigrateUserGuideProjectHelper.getIgnoreLogFormIdByUserGuide(this.view);
        if (StringUtil.isEmpty(ignoreFormId)) {
            return;
        }
        DynamicObject checkItem = (DynamicObject)this.getModel().getValue("checkitem", row);
        DynamicObject ignoreLog = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)ignoreFormId));
        DynamicObjectCollection checkEntry = this.view.getModel().getEntryEntity("checktreeentryentity");
        long id = DB.genLongId((String)"dmw_ignorelog_eas");
        ignoreLog.set("id", (Object)id);
        ignoreLog.set("number", (Object)CodeRuleServiceHelper.getNumber((String)ignoreFormId, (DynamicObject)project, null));
        ignoreLog.set("checkitemnumber", checkItem.get("number"));
        ignoreLog.set("checkitemname", checkItem.get("name"));
        ignoreLog.set("projectnumber", project.get("number"));
        ignoreLog.set("projectname", project.get("name"));
        ignoreLog.set("checkdetail", ((DynamicObject)checkEntry.get(row)).get("checkdetail"));
        ignoreLog.set("checkdetail_tag", ((DynamicObject)checkEntry.get(row)).get("checkdetail_tag"));
        DynamicObjectCollection checkParams = project.getDynamicObjectCollection("checkparamentry");
        String checkItemId = checkItem.getString("id");
        for (DynamicObject checkParam : checkParams) {
            DynamicObject checkItemVar = checkParam.getDynamicObject("checkitemvar");
            if (!checkItemId.equals(checkItemVar.getString("id"))) continue;
            String checkParamTag = checkParam.getString("autoparam_tag");
            String checkParamSub = "";
            if (checkParamTag.length() > 50) {
                checkParamSub = checkParamTag.substring(0, 50) + "...";
            }
            ignoreLog.set("checkparam", (Object)checkParamSub);
            ignoreLog.set("checkparam_tag", (Object)checkParamTag);
            break;
        }
        ignoreLog.set("creator", (Object)UserServiceHelper.getCurrentUserId());
        ignoreLog.set("modifytime", (Object)new Date());
        try {
            OperationResult result = SaveServiceHelper.saveOperate((String)ignoreFormId, (DynamicObject[])new DynamicObject[]{ignoreLog}, (OperateOption)OperateOption.create());
            if (!result.isSuccess()) {
                String errMsg = CommonUtils.getErrDetail(result);
                this.getView().showErrorNotification(errMsg);
            }
        }
        catch (Exception e) {
            this.getView().showErrorNotification(e.getMessage());
        }
    }

    public void toBackground(MessageBoxClosedEvent messageBoxClosedEvent, String taskId) {
        if (MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
            JobFormInfo jobFormInfo;
            if (StringUtils.isBlank((CharSequence)taskId)) {
                return;
            }
            TaskInfo taskInfo = ScheduleServiceHelper.queryTask((String)taskId);
            if (!TaskClientProxy.isExistTask((String)taskId) && (jobFormInfo = this.getJobFormInfo()) != null) {
                TaskClientProxy.addTask((IFormView)this.getView(), (JobFormInfo)Objects.requireNonNull(jobFormInfo), (TaskInfo)taskInfo);
                BackgroundTaskSubscriber subscriber = new BackgroundTaskSubscriber(RequestContext.get(), jobFormInfo, taskId);
                ThreadPools.executeOnce((String)(this.getClass().getSimpleName() + "-background-monitor"), (Runnable)subscriber);
            }
            TaskClientProxy.setProgressPageId((String)taskId, (String)"");
            this.getView().close();
        }
    }

    public void checkOnProgress(ProgressEvent progressEvent, List<Long> checkItemIds) {
        String checkTaskId = (String)this.getModel().getValue("checktaskid");
        TaskInfo checkTask = ScheduleServiceHelper.queryTask((String)checkTaskId);
        if (checkTask.isFailure()) {
            Map<String, Object> taskCustomData = ScheduleHelper.getTaskCustomData(checkTask);
            String errorInfo = (String)taskCustomData.get("errorMessage");
            if (StringUtil.isNotEmpty(errorInfo)) {
                int startMarker = 58;
                String endMarker = ResManager.loadKDString((String)"\u6b63\u5728PC\u7aef\u7f16\u8f91\u8be5\u8bb0\u5f55\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u6216\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"MigrateUserGuideCheckHelper_19", (String)"imsc-dmw-platform", (Object[])new Object[0]);
                int startIndex = errorInfo.indexOf(startMarker);
                int endIndex = errorInfo.indexOf(endMarker);
                if (checkItemIds != null && errorInfo.contains(endMarker)) {
                    String name = errorInfo.substring(startIndex, endIndex);
                    if (checkItemIds.size() > 1) {
                        this.promptErrorInfo(checkItemIds, name);
                    } else {
                        this.getView().showErrorNotification(name + endMarker);
                    }
                } else {
                    this.getView().showErrorNotification(errorInfo);
                }
            }
            progressEvent.setProgress(100);
            ProgressBar checkProgressBar = (ProgressBar)this.getView().getControl("check_progressbarap");
            checkProgressBar.stop();
            return;
        }
        Label checkStatusLabel = (Label)this.getView().getControl("checkstatuslab");
        ProgressBar checkProgressBar = (ProgressBar)this.getView().getControl("check_progressbarap");
        this.checkRefresh();
        switch (this.getProjectStatus()) {
            case "B": {
                int progress;
                boolean isTimeOut;
                if (StringUtils.isEmpty((CharSequence)checkTaskId)) break;
                if (checkTask.isFailure()) {
                    progressEvent.setProgress(100);
                    this.handleErrorTaskStatus(checkTask.getFailureReason(), checkProgressBar);
                    checkStatusLabel.setText(ResManager.loadKDString((String)"\u68c0\u67e5\u4e0d\u901a\u8fc7", (String)"MigrateUserGuideCheckHelper_1", (String)"imsc-dmw-platform", (Object[])new Object[0]));
                    break;
                }
                boolean isScheduled = StringUtils.equals((CharSequence)checkTask.getStatus(), (CharSequence)"SCHEDULED");
                boolean bl = isTimeOut = System.currentTimeMillis() - checkTask.getDispachTime() > 300000L;
                if (isScheduled && isTimeOut) {
                    progressEvent.setProgress(0);
                    this.handleScheduleSystemError(checkProgressBar);
                    checkStatusLabel.setText(ResManager.loadKDString((String)"\u68c0\u67e5\u4e0d\u901a\u8fc7", (String)"MigrateUserGuideCheckHelper_1", (String)"imsc-dmw-platform", (Object[])new Object[0]));
                }
                progressEvent.setProgress((progress = checkTask.getProgress()) >= 100 ? 98 : progress);
                checkStatusLabel.setText(ResManager.loadKDString((String)"\u68c0\u67e5\u4e2d", (String)"MigrateUserGuideCheckHelper_0", (String)"imsc-dmw-platform", (Object[])new Object[0]));
                break;
            }
            case "D": {
                this.getView().setVisible(Boolean.TRUE, new String[]{"startcheck"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"retrycheck"});
                progressEvent.setProgress(100);
                checkProgressBar.stop();
                break;
            }
            default: {
                this.getView().setVisible(Boolean.TRUE, new String[]{"retrycheck"});
                this.getView().setEnable(Boolean.TRUE, new String[]{"retrycheck"});
                progressEvent.setProgress(100);
                checkProgressBar.stop();
            }
        }
        this.getView().updateView("check_progressbarap");
    }

    public void setCheckProgressPercent(ProgressEvent progressEvent, String projectStatus) {
        DynamicObjectCollection checkItemEntrys = this.getModel().getEntryEntity("checktreeentryentity");
        ArrayList<String> passList = new ArrayList<String>(8);
        for (DynamicObject checkItemEntry : checkItemEntrys) {
            String status = checkItemEntry.getString("checkstatus");
            if (!status.equals("D") && !status.equals("E")) continue;
            passList.add(status);
        }
        if (!checkItemEntrys.isEmpty()) {
            int percent = passList.size() * 100 / checkItemEntrys.size();
            progressEvent.setProgress(percent);
        } else {
            progressEvent.setProgress(100);
        }
        HashMap<String, String> styleMap = new HashMap<String, String>(2);
        if (projectStatus.equals("C")) {
            styleMap.put("fc", "#FB2323");
        } else if (projectStatus.equals("D") || projectStatus.equals("E") || projectStatus.equals("F") || projectStatus.equals("G") || projectStatus.equals("H")) {
            styleMap.put("fc", "#1BA854");
        } else {
            styleMap.put("fc", "#276FF5");
        }
        this.getView().updateControlMetadata("check_progressbar_show", styleMap);
        this.view.updateView("check_progressbar_show");
        String checkTaskId = (String)this.getModel().getValue("checktaskid");
        TaskInfo checkTask = ScheduleServiceHelper.queryTask((String)checkTaskId);
        this.checkRefresh();
        if (checkTask.isTaskEnd() || checkTask.isFailure() || checkTaskId.isEmpty()) {
            ProgressBar checkProgressShow = (ProgressBar)this.view.getControl("check_progressbar_show");
            checkProgressShow.stop();
        }
    }

    private void handleScheduleSystemError(ProgressBar progressBar) {
        String error = ResManager.loadKDString((String)"\u4efb\u52a1\u957f\u65f6\u95f4\u7b49\u5f85\u540e\u4ecd\u5904\u4e8e\u8ba1\u5212\u72b6\u6001\u800c\u672a\u5f00\u59cb\u6267\u884c\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u68c0\u67e5\u8c03\u5ea6\u670d\u52a1\u662f\u5426\u6b63\u5e38\u8fd0\u8f6c\u3002", (String)"MigrateUserGuideCheckHelper_20", (String)"imsc-dmw-platform", (Object[])new Object[0]);
        this.handleErrorTaskStatus(error, progressBar);
    }

    private void handleErrorTaskStatus(String error, ProgressBar progressBar) {
        String projectFormId = MigrateUserGuideProjectHelper.getProjectFormIdByUserGuide(this.view);
        if (StringUtil.isEmpty(projectFormId)) {
            return;
        }
        DynamicObject project = BusinessDataServiceHelper.loadSingle((Object)this.getProjectId(), (String)projectFormId);
        if ("check_progressbarap".equals(progressBar.getKey())) {
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u68c0\u67e5\u4efb\u52a1\u6267\u884c\u5931\u8d25:%s", (String)"MigrateUserGuideCheckHelper_21", (String)"imsc-dmw-platform", (Object[])new Object[0]), error));
            project.set("projectstatus", (Object)"C");
        } else {
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u8fc1\u79fb\u4efb\u52a1\u6267\u884c\u5931\u8d25:%s", (String)"MigrateUserGuideCheckHelper_22", (String)"imsc-dmw-platform", (Object[])new Object[0]), error));
            project.set("projectstatus", (Object)"F");
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{project});
        progressBar.stop();
    }

    private Long getProjectId() {
        String project = this.getView().getPageCache().get("existProject");
        if (StringUtils.isEmpty((CharSequence)project)) {
            return 0L;
        }
        return Long.parseLong(project);
    }

    private String getProjectStatus() {
        return this.getView().getPageCache().get("projectstatus");
    }

    public void viewlog() {
        PermissionHelper.checkPermission(this.getView(), "dmw_migrateproject", "4M/HDY7QQ6KA");
        int rowIndex = this.getModel().getEntryCurrentRowIndex("migtreeentryentity");
        Object iscSchemeType = this.getModel().getValue("schemetype", rowIndex);
        String id = (String)this.getModel().getValue("iscexcutionid", rowIndex);
        long resultId = StringUtils.isEmpty((CharSequence)id) ? 0L : Long.parseLong(id);
        ListShowParameter parameter = new ListShowParameter();
        LinkQueryPkIdCollection pkIds = new LinkQueryPkIdCollection();
        pkIds.addLinkQueryPkId((Object)resultId);
        parameter.setLinkQueryPkIdCollection(pkIds);
        if ("isc_data_copy_trigger".equals(iscSchemeType)) {
            parameter.setBillFormId("isc_data_copy_execution");
        } else if ("isc_service_flow".equals(iscSchemeType)) {
            parameter.setBillFormId("isc_sf_proc_inst");
        }
        parameter.setFormId("bos_list");
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        parameter.setPermissionItemId("47150e89000000ac");
        this.getView().showForm((FormShowParameter)parameter);
    }

    private void checkRefresh() {
        String projectFormId = MigrateUserGuideProjectHelper.getProjectFormIdByUserGuide(this.view);
        if (StringUtil.isEmpty(projectFormId)) {
            return;
        }
        DynamicObject project = BusinessDataServiceHelper.loadSingle((Object)this.getProjectId(), (String)projectFormId);
        MigrateUserGuideProjectHelper.setMigrateCheckData(this.getView(), project);
        String status = project.getString("projectstatus");
        MigrateUserGuideProjectHelper.setProjectStatus(this.getView(), status);
        this.getModel().updateCache();
        this.getView().updateView("checktreeentryentity");
    }

    private JobFormInfo getJobFormInfo() {
        String str = this.getView().getPageCache().get("imsc_jobforminfo");
        if (StringUtils.isBlank((CharSequence)str)) {
            return null;
        }
        return (JobFormInfo)JSONObject.parseObject((String)str, JobFormInfo.class);
    }

    private IDataModel getModel() {
        return this.model;
    }

    private IFormView getView() {
        return this.view;
    }
}

