/*
 * Decompiled with CFR 0.152.
 */
package kd.imsc.dmw.helper.tpl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlParameter;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormConfig;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Label;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.parameter.ParameterShowParameter;
import kd.bos.report.ReportShowParameter;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.schedule.form.JobFormInfo;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.schedule.ScheduleServiceHelper;
import kd.imsc.dmw.errorcode.DmwBizException;
import kd.imsc.dmw.helper.PermissionHelper;
import kd.imsc.dmw.helper.ScheduleHelper;
import kd.imsc.dmw.helper.tpl.MigrateUserGuideProjectHelper;
import kd.imsc.dmw.plugin.formplugin.schedule.task.MigrateItemTask;
import kd.imsc.dmw.plugin.formplugin.schedule.taskclick.CheckItemTaskClick;
import kd.imsc.dmw.utils.CommonUtils;
import kd.imsc.dmw.utils.DynamicObjectUtils;
import kd.imsc.dmw.utils.StringUtil;

public class MigrateUserGuideExcuteHelper {
    private static final String MIGRATE_TO_BACKGROUND_CONFIRM = "migrateToBackgroundConfirm";
    private static final String INTERRUPT_MIGRATE_CONFIRM = "interrupt_migrate_confirm";
    private static final String MIGRATE_TASKID_CACHE = "MIGRATE_TASKID_CACHE";
    private static final int FIVE_MINUTES = 300000;
    private IFormView view;
    private IDataModel model;

    private MigrateUserGuideExcuteHelper(IFormView view) {
        this.view = view;
        this.model = view.getModel();
    }

    public static MigrateUserGuideExcuteHelper build(IFormView view) {
        return new MigrateUserGuideExcuteHelper(view);
    }

    public void openManualPage(int selectRow) {
        DynamicObject migExcuteEntryDynObj = this.getModel().getEntryRowEntity("migtreeentryentity", selectRow);
        String manaulPageFormId = DynamicObjectUtils.getString(migExcuteEntryDynObj.getDynamicObject("migratemanualpage"), "number");
        if (StringUtil.isEmpty(manaulPageFormId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u624b\u5de5\u6267\u884c\u9875\u9762\u4e3a\u7a7a\u3002", (String)"MigrateUserGuideExcuteHelper_0", (String)"imsc-dmw-platform", (Object[])new Object[0]));
            return;
        }
        String manaulPageParam = migExcuteEntryDynObj.getString("migratemanualpageparam");
        if (StringUtil.isEmpty(manaulPageParam)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u624b\u5de5\u6267\u884c\u9875\u9762\u53c2\u6570\u4e3a\u7a7a\u3002", (String)"MigrateUserGuideExcuteHelper_1", (String)"imsc-dmw-platform", (Object[])new Object[0]));
            return;
        }
        JSONObject paramJson = JSON.parseObject((String)manaulPageParam);
        String parameterType = paramJson.getString("parametertype");
        ListShowParameter showParameter = null;
        boolean isEntity = false;
        switch (parameterType) {
            case "ListShowParameter": {
                showParameter = new ListShowParameter();
                isEntity = true;
                break;
            }
            case "FormShowParameter": {
                showParameter = new FormShowParameter();
                break;
            }
            case "BillShowParameter": 
            case "BaseShowParameter": {
                isEntity = true;
                showParameter = new BillShowParameter();
                break;
            }
            case "ReportShowParameter": {
                showParameter = new ReportShowParameter();
                break;
            }
            case "ParameterShowParameter": {
                showParameter = new ParameterShowParameter();
                break;
            }
            case "MobileFormShowParameter": {
                showParameter = new MobileFormShowParameter();
                break;
            }
            default: {
                showParameter = new FormShowParameter();
                showParameter.setFormId(manaulPageFormId);
            }
        }
        List<Object> pkIdList = new ArrayList(16);
        String filterConditionStr = paramJson.getString("filtercondition");
        QFilter filter = null;
        if (StringUtil.isNotEmpty(filterConditionStr)) {
            FilterCondition filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)filterConditionStr, FilterCondition.class);
            MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)manaulPageFormId);
            FilterBuilder filterBuilder = new FilterBuilder(entityType, filterCondition);
            filterBuilder.buildFilter();
            filter = filterBuilder.getQFilter();
        }
        if (isEntity) {
            pkIdList = QueryServiceHelper.queryPrimaryKeys((String)manaulPageFormId, (QFilter[])(filter == null ? null : filter.toArray()), null, (int)2);
        }
        if (pkIdList.size() > 1) {
            showParameter = new ListShowParameter();
        }
        if (showParameter instanceof BillShowParameter) {
            if (CommonUtils.isNull(pkIdList)) {
                showParameter = new ListShowParameter();
            } else {
                ((BillShowParameter)showParameter).setPkId(pkIdList.get(0));
                showParameter.setFormId(manaulPageFormId);
            }
        }
        if (showParameter instanceof ListShowParameter) {
            if (filter != null) {
                ArrayList<QFilter> qFilterList = new ArrayList<QFilter>();
                qFilterList.add(filter);
                showParameter.getListFilterParameter().setQFilters(qFilterList);
            }
            showParameter.setBillFormId(manaulPageFormId);
            FormConfig formConfig = FormMetadataCache.getListFormConfig((String)manaulPageFormId);
            showParameter.setFormId(formConfig.getListFormId());
        } else {
            showParameter.setFormId(manaulPageFormId);
            showParameter.setStatus(OperationStatus.VIEW);
        }
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setPageId(this.buildNewPageId(manaulPageFormId, pkIdList));
        showParameter.setPermissionItemId("47150e89000000ac");
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private String buildNewPageId(String formId, List<Object> pkIdList) {
        String rootPageId = this.getView().getFormShowParameter().getRootPageId();
        StringBuilder newPageId = new StringBuilder();
        newPageId.append(formId).append("_");
        newPageId.append(rootPageId).append("_");
        if (!CommonUtils.isNull(pkIdList)) {
            int index = 0;
            for (Object pkId : pkIdList) {
                newPageId.append(pkId).append("_");
                if (index > 3) break;
                ++index;
            }
        }
        return newPageId.toString();
    }

    public void startMigrateClick(IFormPlugin formPlugin) {
        PermissionHelper.checkPermission(this.getView(), "dmw_migrateproject", "4M/H7HJLM6=V");
        this.getView().getPageCache().put("param_showmanual", "");
        if (!("D".equals(this.getProjectStatus()) || "F".equals(this.getProjectStatus()) || "H".equals(this.getProjectStatus()))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u9879\u76ee\u72b6\u6001\u4e3a\u68c0\u67e5\u901a\u8fc7\u3001\u8fc1\u79fb\u5931\u8d25\u3001\u8fc1\u79fb\u90e8\u5206\u5b8c\u6210\u624d\u53ef\u4ee5\u5f00\u59cb\u8fc1\u79fb\u3002", (String)"MigrateUserGuideExcuteHelper_2", (String)"imsc-dmw-platform", (Object[])new Object[0]));
            return;
        }
        DynamicObjectCollection migrateItemEntrys = this.getModel().getEntryEntity("migtreeentryentity");
        ArrayList<Long> migEntryIds = new ArrayList<Long>(migrateItemEntrys.size());
        for (DynamicObject migrateItemEntry : migrateItemEntrys) {
            boolean isManual = "2".equals(migrateItemEntry.getString("migrateexecutetype"));
            if (!"D".equals(migrateItemEntry.getString("migratestatus")) && !"A".equals(migrateItemEntry.getString("migratestatus")) && !"E".equals(migrateItemEntry.getString("migratestatus")) && (!isManual || !"B".equals(migrateItemEntry.getString("migratestatus")))) continue;
            Object scheme = migrateItemEntry.get("startscheme");
            if (scheme != null) {
                migEntryIds.add(migrateItemEntry.getLong("id"));
                continue;
            }
            if (!isManual) continue;
            migEntryIds.add(migrateItemEntry.getLong("id"));
            if (migEntryIds.size() != 1 || !"B".equals(migrateItemEntry.getString("migratestatus"))) break;
            String msg = String.format(ResManager.loadKDString((String)"\u5f88\u62b1\u6b49\uff0c\u8bf7\u4eba\u5de5\u5904\u7406\u8fc1\u79fb\u5bf9\u8c61\uff1a%s\u3002", (String)"MigrateUserGuideExcuteHelper_3", (String)"imsc-dmw-platform", (Object[])new Object[0]), migrateItemEntry.getString("migrateobjname"));
            this.getView().showConfirm(msg, "", MessageBoxOptions.YesNo, ConfirmTypes.Default, new ConfirmCallBackListener("manualpage", formPlugin), null, migrateItemEntry.getString("seq"));
            this.getView().getPageCache().put("param_showmanual", "1");
            return;
        }
        this.excuteMigTask(migEntryIds);
    }

    public void singleMigrate(IFormPlugin formPlugin) {
        PermissionHelper.checkPermission(this.getView(), "dmw_migrateproject", "4M/H7HJLM6=V");
        this.getView().getPageCache().put("param_showmanual", "");
        int selectRow = this.getModel().getEntryCurrentRowIndex("migtreeentryentity");
        DynamicObject entryRowEntity = this.getModel().getEntryRowEntity("migtreeentryentity", selectRow);
        DynamicObject scheme = (DynamicObject)entryRowEntity.get("startscheme");
        if (scheme == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u542f\u52a8\u65b9\u6848/\u670d\u52a1\u6d41\u7a0b\u4e3a\u7a7a\uff0c\u53ef\u80fd\u5df2\u88ab\u5220\u9664\u3002", (String)"MigrateUserGuideExcuteHelper_4", (String)"imsc-dmw-platform", (Object[])new Object[0]));
            return;
        }
        DynamicObjectCollection migrateItemEntrys = this.getModel().getEntryEntity("migtreeentryentity");
        ArrayList<Long> migEntryIds = new ArrayList<Long>(migrateItemEntrys.size());
        for (DynamicObject migrateItemEntry : migrateItemEntrys) {
            boolean isManual = "2".equals(migrateItemEntry.getString("migrateexecutetype"));
            if (!"D".equals(migrateItemEntry.getString("migratestatus")) && !"A".equals(migrateItemEntry.getString("migratestatus")) && !"E".equals(migrateItemEntry.getString("migratestatus")) && (!isManual || !"B".equals(migrateItemEntry.getString("migratestatus")))) continue;
            Object schemeObj = migrateItemEntry.get("startscheme");
            if (schemeObj != null) {
                migEntryIds.add(migrateItemEntry.getLong("id"));
                continue;
            }
            if (!isManual) continue;
            migEntryIds.add(migrateItemEntry.getLong("id"));
            if (migEntryIds.size() != 1 || !"B".equals(migrateItemEntry.getString("migratestatus"))) break;
            String msg = String.format(ResManager.loadKDString((String)"\u5f88\u62b1\u6b49\uff0c\u8bf7\u4eba\u5de5\u5904\u7406\u8fc1\u79fb\u5bf9\u8c61\uff1a%s\u3002", (String)"MigrateUserGuideExcuteHelper_3", (String)"imsc-dmw-platform", (Object[])new Object[0]), migrateItemEntry.getString("migrateobjname"));
            this.getView().showConfirm(msg, "", MessageBoxOptions.YesNo, ConfirmTypes.Default, new ConfirmCallBackListener("manualpage", formPlugin), null, migrateItemEntry.getString("seq"));
            this.getView().getPageCache().put("param_showmanual", "1");
            return;
        }
        List<Long> migEntry = Collections.singletonList((Long)entryRowEntity.getPkValue());
        this.excuteMigTask(migEntry);
    }

    public boolean markComplete() {
        int selectRow = this.getModel().getEntryCurrentRowIndex("migtreeentryentity");
        DynamicObject entryRowEntity = this.getModel().getEntryRowEntity("migtreeentryentity", selectRow);
        DynamicObject migExec = entryRowEntity.getDynamicObject("migrateobjectexec");
        if (migExec == null) {
            return false;
        }
        String tableName = MigrateUserGuideProjectHelper.getMigObjectTableNameByUserGuide(this.view);
        if (StringUtil.isEmpty(tableName)) {
            return false;
        }
        ProgressBar execProgressShow = (ProgressBar)this.getView().getControl("exec_progressbar_show");
        execProgressShow.start();
        String sql = "update " + tableName + " set fmigratestatus = ? where fid = ? and fmigrateobject = ?";
        boolean isSucess = DB.execute((DBRoute)DBRoute.of((String)"imsc"), (String)sql, (Object[])new Object[]{new SqlParameter(":fmigratestatus", 12, (Object)"G"), new SqlParameter(":fid", -5, (Object)this.getProjectId()), new SqlParameter(":fmigrateobject", -5, migExec.getPkValue())});
        if (isSucess) {
            DynamicObject project = MigrateUserGuideExcuteHelper.updateProjectStatus(this.getProjectId(), MigrateUserGuideProjectHelper.getProjectFormIdByUserGuide(this.view));
            MigrateUserGuideProjectHelper.setProjectStatus(this.getView(), project.getString("projectstatus"));
        }
        this.refreshExecData();
        this.getView().getModel().setEntryCurrentRowIndex("migtreeentryentity", selectRow);
        return isSucess;
    }

    public void migrateInit() {
        String status;
        String execTaskId = (String)this.getModel().getValue("exectaskid");
        ProgressBar execProgressBar = (ProgressBar)this.getView().getControl("exec_progressbarap");
        Label execStatusLabel = (Label)this.getView().getControl("execstatuslab");
        Tab tab = (Tab)this.getView().getControl("guidecontent");
        switch (status = this.getProjectStatus()) {
            case "E": {
                tab.activeTab("tabpageap4");
                this.getView().setEnable(Boolean.FALSE, new String[]{"retrymigrate", "tabpageap1", "tabpageap3"});
                this.setScopeEnable();
                if (!MigrateUserGuideProjectHelper.verifyManualEntryMigrateStatus(this.getView())) {
                    execProgressBar.start();
                    this.setProgress(execProgressBar, execTaskId);
                }
                execStatusLabel.setText(ResManager.loadKDString((String)"\u8fc1\u79fb\u4e2d", (String)"MigrateUserGuideExcuteHelper_5", (String)"imsc-dmw-platform", (Object[])new Object[0]));
                break;
            }
            case "G": {
                tab.activeTab("tabpageap4");
                this.getView().setEnable(Boolean.FALSE, new String[]{"tabpageap1", "tabpageap3", "migrateinfoflex"});
                this.setScopeEnable();
                execProgressBar.setPercent(100);
                execStatusLabel.setText(ResManager.loadKDString((String)"\u8fc1\u79fb\u5b8c\u6210", (String)"MigrateUserGuideExcuteHelper_6", (String)"imsc-dmw-platform", (Object[])new Object[0]));
                break;
            }
            case "F": {
                tab.activeTab("tabpageap4");
                this.getView().setEnable(Boolean.FALSE, new String[]{"tabpageap1", "tabpageap3", "migrateinfoflex"});
                this.setScopeEnable();
                this.setProgress(execProgressBar, execTaskId);
                execStatusLabel.setText(ResManager.loadKDString((String)"\u8fc1\u79fb\u5931\u8d25", (String)"MigrateUserGuideExcuteHelper_7", (String)"imsc-dmw-platform", (Object[])new Object[0]));
                break;
            }
            case "H": {
                tab.activeTab("tabpageap4");
                this.getView().setEnable(Boolean.FALSE, new String[]{"tabpageap1", "tabpageap3", "migrateinfoflex"});
                this.setScopeEnable();
                this.setProgress(execProgressBar, execTaskId);
                execStatusLabel.setText(ResManager.loadKDString((String)"\u8fc1\u79fb\u5b8c\u6210", (String)"MigrateUserGuideExcuteHelper_6", (String)"imsc-dmw-platform", (Object[])new Object[0]));
                break;
            }
        }
    }

    private void setScopeEnable() {
        this.getView().setEnable(Boolean.FALSE, new String[]{"scopeflex", "splitcontainer", "migsequenceflex"});
        this.getView().setEnable(Boolean.TRUE, new String[]{"advancedset"});
    }

    private void setProgress(ProgressBar checkProgressBar, String checkTaskId) {
        TaskInfo taskInfo = ScheduleServiceHelper.queryTask((String)checkTaskId);
        int progress = taskInfo.getProgress();
        checkProgressBar.setPercent(progress);
    }

    public void retryMigrateClick(IFormPlugin formPlugin) {
        PermissionHelper.checkPermission(this.getView(), "dmw_migrateproject", "4M/H7HJLM6=V");
        this.getView().getPageCache().put("param_showmanual", "");
        boolean isExist = MigrateUserGuideProjectHelper.verifyManualEntryMigrateStatus(this.view);
        if (!("F".equals(this.getProjectStatus()) || "H".equals(this.getProjectStatus()) || isExist)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u72b6\u6001\u4e3a\u68c0\u67e5\u901a\u8fc7\u3001\u8fc1\u79fb\u5931\u8d25\u3001\u8fc1\u79fb\u90e8\u5206\u5b8c\u6210\u624d\u53ef\u4ee5\u91cd\u65b0\u8fc1\u79fb\u3002", (String)"MigrateUserGuideExcuteHelper_8", (String)"imsc-dmw-platform", (Object[])new Object[0]));
            return;
        }
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("migtreeentryentity");
        ArrayList<Long> migrateEntryIds = new ArrayList<Long>(entryEntity.size());
        for (DynamicObject migrateItemEntry : entryEntity) {
            boolean isManual = "2".equals(migrateItemEntry.getString("migrateexecutetype"));
            if (!"D".equals(migrateItemEntry.getString("migratestatus")) && !"F".equals(migrateItemEntry.getString("migratestatus")) && !"A".equals(migrateItemEntry.getString("migratestatus")) && !"E".equals(migrateItemEntry.getString("migratestatus")) && (!isManual || !"B".equals(migrateItemEntry.getString("migratestatus")))) continue;
            Object scheme = migrateItemEntry.get("startscheme");
            if (scheme != null) {
                migrateEntryIds.add(migrateItemEntry.getLong("id"));
                continue;
            }
            if (!isManual) continue;
            migrateEntryIds.add(migrateItemEntry.getLong("id"));
            if (migrateEntryIds.size() != 1 || !"B".equals(migrateItemEntry.getString("migratestatus"))) break;
            this.getView().getModel().setEntryCurrentRowIndex("migtreeentryentity", migrateItemEntry.getInt("seq") - 1);
            String msg = String.format(ResManager.loadKDString((String)"\u5f88\u62b1\u6b49\uff0c\u8bf7\u4eba\u5de5\u5904\u7406\u8fc1\u79fb\u5bf9\u8c61\uff1a%s\u3002", (String)"MigrateUserGuideExcuteHelper_3", (String)"imsc-dmw-platform", (Object[])new Object[0]), migrateItemEntry.getString("migrateobjname"));
            this.getView().showConfirm(msg, "", MessageBoxOptions.YesNo, ConfirmTypes.Default, new ConfirmCallBackListener("manualpage", formPlugin), null, migrateItemEntry.getString("seq"));
            this.getView().getPageCache().put("param_showmanual", "1");
            return;
        }
        this.excuteMigTask(migrateEntryIds);
    }

    private void excuteMigTask(List<Long> migrateEntryIds) {
        DynamicObjectCollection execItemEntryColl;
        if (migrateEntryIds.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u542f\u52a8\u65b9\u6848/\u670d\u52a1\u6d41\u7a0b\u4e3a\u7a7a\uff0c\u53ef\u80fd\u5df2\u88ab\u5220\u9664\u3002", (String)"MigrateUserGuideExcuteHelper_4", (String)"imsc-dmw-platform", (Object[])new Object[0]));
            return;
        }
        String projectFormId = MigrateUserGuideProjectHelper.getProjectFormIdByUserGuide(this.view);
        if (StringUtil.isNotEmpty(projectFormId) && !CommonUtils.isNull(execItemEntryColl = this.getModel().getEntryEntity("migtreeentryentity"))) {
            DynamicObject project = BusinessDataServiceHelper.loadSingle((Object)this.getProjectId(), (String)projectFormId);
            DynamicObjectCollection projectExcuteEntrys = project.getDynamicObjectCollection("treeentryentity");
            boolean isSave = false;
            for (DynamicObject excuteEntry : execItemEntryColl) {
                for (DynamicObject projectExcuteEntry : projectExcuteEntrys) {
                    if (!projectExcuteEntry.getPkValue().equals(excuteEntry.getPkValue())) continue;
                    projectExcuteEntry.set("isignoreexistdata", (Object)excuteEntry.getBoolean("isignoreexistdata"));
                    isSave = true;
                }
            }
            if (isSave) {
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{project});
            }
        }
        String taskId = this.dispatchMigrateTask(migrateEntryIds);
        this.afterStartExecTask(this.getProjectId(), taskId, migrateEntryIds);
    }

    public void interruptMigrate(MessageBoxClosedEvent event) {
        if (MessageBoxResult.Yes.equals((Object)event.getResult())) {
            String execTaskId = (String)this.getModel().getValue("exectaskid");
            ScheduleServiceHelper.stopTask((String)execTaskId);
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5df2\u53d1\u9001\u4e2d\u6b62\u8bf7\u6c42\u3002", (String)"MigrateUserGuideExcuteHelper_9", (String)"imsc-dmw-platform", (Object[])new Object[0]));
        }
    }

    public void migrateToBackgroundConfirm(IFormPlugin formPlugin) {
        String checkTaskId = (String)this.getModel().getValue("exectaskid");
        TaskInfo checkTask = ScheduleServiceHelper.queryTask((String)checkTaskId);
        if (checkTask.isTaskEnd()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4efb\u52a1\u5df2\u7ed3\u675f\uff0c\u65e0\u9700\u8f6c\u540e\u53f0\u3002", (String)"MigrateUserGuideExcuteHelper_10", (String)"imsc-dmw-platform", (Object[])new Object[0]));
            return;
        }
        if (!"E".equals(this.getProjectStatus())) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u9879\u76ee\u72b6\u6001\u4e3a\u8fc1\u79fb\u4e2d\u624d\u53ef\u4ee5\u540e\u53f0\u8fd0\u884c\u3002", (String)"MigrateUserGuideExcuteHelper_11", (String)"imsc-dmw-platform", (Object[])new Object[0]));
            return;
        }
        this.getView().showConfirm(ResManager.loadKDString((String)"\u786e\u8ba4\u8981\u628a\u5f53\u524d\u4efb\u52a1\u8f6c\u4e3a\u540e\u53f0\u6267\u884c\uff1f\u8f6c\u4e3a\u540e\u53f0\u6267\u884c\u540e\uff0c\u53ef\u4ee5\u518d\u6b21\u901a\u8fc7\u53f3\u4e0b\u89d2\u7684\u540e\u53f0\u8fd0\u884c\u8fdb\u5ea6\u7403\u518d\u6b21\u6253\u5f00\u3002", (String)"MigrateUserGuideExcuteHelper_12", (String)"imsc-dmw-platform", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(MIGRATE_TO_BACKGROUND_CONFIRM, formPlugin));
    }

    public void interruptMigrateConfirm(IFormPlugin formPlugin) {
        PermissionHelper.checkPermission(this.getView(), "dmw_migrateproject", "4M/H7HJLM6=V");
        String execTaskId = (String)this.getModel().getValue("exectaskid");
        if (StringUtil.isEmpty(execTaskId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4efb\u52a1\u8012\u5f00\u59cb\uff0c\u65e0\u9700\u4e2d\u6b62\u3002", (String)"MigrateUserGuideExcuteHelper_13", (String)"imsc-dmw-platform", (Object[])new Object[0]));
            return;
        }
        TaskInfo execTask = ScheduleServiceHelper.queryTask((String)execTaskId);
        if (execTask.isTaskEnd()) {
            this.updateMigrateStatusIfSystemError();
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4efb\u52a1\u5df2\u7ed3\u675f\uff0c\u65e0\u9700\u4e2d\u6b62\u3002", (String)"MigrateUserGuideExcuteHelper_14", (String)"imsc-dmw-platform", (Object[])new Object[0]));
            return;
        }
        if (!"E".equals(this.getProjectStatus())) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u9879\u76ee\u72b6\u6001\u4e3a\u8fc1\u79fb\u4e2d\u624d\u53ef\u4ee5\u4e2d\u6b62\u8fc1\u79fb\u3002", (String)"MigrateUserGuideExcuteHelper_15", (String)"imsc-dmw-platform", (Object[])new Object[0]));
            return;
        }
        String msg = ResManager.loadKDString((String)"\u786e\u8ba4\u8981\u4e2d\u6b62\u8fc1\u79fb\u6267\u884c\uff1f", (String)"MigrateUserGuideExcuteHelper_16", (String)"imsc-dmw-platform", (Object[])new Object[0]);
        this.getView().showConfirm(msg, MessageBoxOptions.OKCancel, new ConfirmCallBackListener(INTERRUPT_MIGRATE_CONFIRM, formPlugin));
    }

    private void updateMigrateStatusIfSystemError() {
        boolean hasServerError = false;
        DynamicObject project = BusinessDataServiceHelper.loadSingle((Object)this.getProjectId(), (String)MigrateUserGuideProjectHelper.getProjectFormIdByUserGuide(this.view));
        DynamicObjectCollection migrateExecEntrys = project.getDynamicObjectCollection("treeentryentity");
        for (DynamicObject migrateExecEntry : migrateExecEntrys) {
            String migrateStatus;
            String executeType = migrateExecEntry.getString("executetype");
            if ("2".equals(executeType) || !"F".equals(migrateStatus = migrateExecEntry.getString("migratestatus")) && !"B".equals(migrateStatus)) continue;
            migrateExecEntry.set("migratestatus", (Object)"D");
            migrateExecEntry.set("migratelog", (Object)ResManager.loadKDString((String)"\u670d\u52a1\u5f02\u5e38\uff0c\u8bf7\u91cd\u8bd5\u3002", (String)"MigrateUserGuideExcuteHelper_17", (String)"imsc-dmw-platform", (Object[])new Object[0]));
            hasServerError = true;
        }
        if (hasServerError) {
            project.set("projectstatus", (Object)"F");
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{project});
            this.refreshExecData();
        }
    }

    private void afterStartExecTask(Long pk, String taskId, List<Long> migrateEntryIds) {
        DynamicObject project = BusinessDataServiceHelper.loadSingle((Object)pk, (String)MigrateUserGuideProjectHelper.getProjectFormIdByUserGuide(this.view));
        DynamicObjectCollection migrateExecEntrys = project.getDynamicObjectCollection("treeentryentity");
        int i = 0;
        for (DynamicObject migrateExecEntry : migrateExecEntrys) {
            Object scheme = migrateExecEntry.get("startscheme");
            if (scheme != null && migrateEntryIds.contains((Long)migrateExecEntry.getPkValue())) {
                migrateExecEntry.set("migratestatus", (Object)"F");
                this.getView().getModel().setValue("migratestatus", (Object)"F", i);
            }
            ++i;
        }
        project.set("projectstatus", (Object)"E");
        project.set("exectaskid", (Object)taskId);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{project});
        this.getView().setEnable(Boolean.FALSE, new String[]{"tabpageap1", "tabpageap2", "tabpageap3", "migrateinfoflex"});
        ProgressBar execProgressShow = (ProgressBar)this.getView().getControl("exec_progressbar_show");
        execProgressShow.start();
        ProgressBar execProgressBar = (ProgressBar)this.getView().getControl("exec_progressbarap");
        execProgressBar.start();
        execProgressBar.setPercent(0, ResManager.loadKDString((String)"\u5f00\u59cb\u6267\u884c...", (String)"MigrateUserGuideExcuteHelper_18", (String)"imsc-dmw-platform", (Object[])new Object[0]));
        this.getModel().setValue("exectaskid", (Object)taskId);
        MigrateUserGuideProjectHelper.setProjectStatus(this.getView(), "E");
    }

    private Map<Long, Object> getMigOldStatus(Long pk, List<Long> migrateEntryIds) {
        HashMap<Long, Object> map = new HashMap<Long, Object>(16);
        DynamicObject project = BusinessDataServiceHelper.loadSingle((Object)pk, (String)MigrateUserGuideProjectHelper.getProjectFormIdByUserGuide(this.view));
        DynamicObjectCollection migrateExecEntrys = project.getDynamicObjectCollection("treeentryentity");
        for (DynamicObject migrateExecEntry : migrateExecEntrys) {
            Object scheme = migrateExecEntry.get("startscheme");
            if (scheme == null && !"2".equals(migrateExecEntry.getString("executetype")) || !migrateEntryIds.contains((Long)migrateExecEntry.getPkValue())) continue;
            map.put(migrateExecEntry.getLong("id"), migrateExecEntry.getString("migratestatus"));
        }
        return map;
    }

    private String dispatchMigrateTask(List<Long> migrateEntryIds) {
        String taskIdOld = this.getView().getPageCache().get(MIGRATE_TASKID_CACHE);
        TaskInfo taskInfo = ScheduleServiceHelper.queryTask((String)taskIdOld);
        if (StringUtils.isNotEmpty((CharSequence)taskIdOld) && !taskInfo.isTaskEnd()) {
            throw new DmwBizException(ResManager.loadKDString((String)"\u6b63\u5728\u8fc1\u79fb\u4e2d\uff0c\u8bf7\u5148\u7b49\u5f85\u6267\u884c\u5b8c\u6210\u3002", (String)"MigrateUserGuideExcuteHelper_19", (String)"imsc-dmw-platform", (Object[])new Object[0]));
        }
        Map<Long, Object> migOldStatus = this.getMigOldStatus(this.getProjectId(), migrateEntryIds);
        HashMap<String, Object> param = new HashMap<String, Object>(8);
        param.put("migrateEntryIds", migrateEntryIds);
        param.put("migOldStatus", migOldStatus);
        Object dbLinkId = ((DynamicObject)this.getModel().getValue("dblink")).getPkValue();
        param.put("dblinkid", dbLinkId);
        param.put("projectid", this.getProjectId());
        String migrateModel = (String)this.getModel().getValue("migrationmodel");
        param.put("migratemodel", migrateModel);
        param.put("projectFormId", MigrateUserGuideProjectHelper.getProjectFormIdByUserGuide(this.view));
        param.put("guideFormId", this.getView().getModel().getDataEntity().getDataEntityType().getName());
        String orgNumber = MigrateUserGuideProjectHelper.getOrgNumber(this.getView());
        String orgNumberArray = MigrateUserGuideProjectHelper.getOrgNumberArray(this.getView());
        String startPeriod = MigrateUserGuideProjectHelper.getStartPeriod(this.getView());
        String startDate = MigrateUserGuideProjectHelper.getStartDate(this.getView());
        param.put("companyNumber", orgNumber);
        param.put("companyNumberArray", orgNumberArray);
        param.put("fromPeriodNumber", startPeriod);
        param.put("fromBillDate", startDate);
        JobFormInfo jobFormInfo = ScheduleHelper.buildJobFormInfo(ResManager.loadKDString((String)"\u8fc1\u79fb\u6267\u884c\u4efb\u52a1", (String)"MigrateUserGuideExcuteHelper_20", (String)"imsc-dmw-platform", (Object[])new Object[0]), MigrateItemTask.class.getName(), CheckItemTaskClick.class.getName(), this.getView(), param);
        jobFormInfo.getJobInfo().setAppId("dmw");
        String taskId = ScheduleServiceHelper.dispatch((JobInfo)jobFormInfo.getJobInfo());
        this.getView().getPageCache().put(MIGRATE_TASKID_CACHE, taskId);
        this.getView().getPageCache().put("imsc_jobforminfo", JSON.toJSONString((Object)jobFormInfo));
        return taskId;
    }

    public void execOnProgress(ProgressEvent progressEvent) {
        String execTaskId = (String)this.getModel().getValue("exectaskid");
        TaskInfo execTask = ScheduleServiceHelper.queryTask((String)execTaskId);
        Label execStatusLabel = (Label)this.getView().getControl("execstatuslab");
        ProgressBar execProgressBar = (ProgressBar)this.getView().getControl("exec_progressbarap");
        switch (this.getProjectStatus()) {
            case "E": {
                if (StringUtils.isEmpty((CharSequence)execTaskId)) break;
                if (execTask.isFailure()) {
                    this.handleErrorTaskStatus(execTask.getFailureReason(), execProgressBar);
                    execStatusLabel.setText(ResManager.loadKDString((String)"\u8fc1\u79fb\u5931\u8d25", (String)"MigrateUserGuideExcuteHelper_7", (String)"imsc-dmw-platform", (Object[])new Object[0]));
                } else {
                    int progress;
                    boolean isTimeOut;
                    boolean isScheduled = StringUtils.equals((CharSequence)execTask.getStatus(), (CharSequence)"SCHEDULED");
                    boolean bl = isTimeOut = System.currentTimeMillis() - execTask.getDispachTime() > 300000L;
                    if (isScheduled && isTimeOut) {
                        progressEvent.setProgress(100);
                        this.handleScheduleSystemError(execProgressBar);
                    }
                    progressEvent.setProgress((progress = execTask.getProgress()) >= 100 ? 98 : progress);
                    execStatusLabel.setText(ResManager.loadKDString((String)"\u8fc1\u79fb\u6267\u884c\u4e2d", (String)"MigrateUserGuideExcuteHelper_21", (String)"imsc-dmw-platform", (Object[])new Object[0]));
                }
                if (!MigrateUserGuideProjectHelper.verifyManualEntryMigrateStatus(this.getView())) break;
                progressEvent.setProgress(100);
                execProgressBar.stop();
                break;
            }
            case "F": {
                this.getView().setEnable(Boolean.TRUE, new String[]{"retrymigrate"});
                progressEvent.setProgress(100);
                execProgressBar.stop();
                break;
            }
            case "G": 
            case "H": {
                progressEvent.setProgress(100);
                execProgressBar.stop();
                break;
            }
            default: {
                this.getView().setEnable(Boolean.TRUE, new String[]{"retrymigrate"});
                execProgressBar.stop();
            }
        }
        this.refreshExecData();
    }

    public void setExecProgressPercent(ProgressEvent progressEvent, String projectStatus) {
        DynamicObjectCollection execItemEntry = this.getModel().getEntryEntity("migtreeentryentity");
        ArrayList<String> passList = new ArrayList<String>(8);
        for (DynamicObject checkItemEntry : execItemEntry) {
            String status = checkItemEntry.getString("migratestatus");
            if (!status.equals("C") && !status.equals("G")) continue;
            passList.add(status);
        }
        int persent = passList.size() * 100 / execItemEntry.size();
        progressEvent.setProgress(persent);
        HashMap<String, String> styleMap = new HashMap<String, String>(2);
        if (projectStatus.equals("F")) {
            styleMap.put("fc", "#FB2323");
        } else if (projectStatus.equals("G") || projectStatus.equals("H")) {
            styleMap.put("fc", "#1BA854");
        } else {
            styleMap.put("fc", "#276FF5");
        }
        this.getView().updateControlMetadata("exec_progressbar_show", styleMap);
        this.view.updateView("exec_progressbar_show");
        String execTaskId = (String)this.getModel().getValue("exectaskid");
        TaskInfo execTask = ScheduleServiceHelper.queryTask((String)execTaskId);
        if (execTask.isTaskEnd() || execTask.isFailure() || execTaskId.isEmpty()) {
            ProgressBar checkProgressShow = (ProgressBar)this.view.getControl("exec_progressbar_show");
            checkProgressShow.stop();
        }
    }

    private void handleErrorTaskStatus(String error, ProgressBar progressBar) {
        DynamicObject project = BusinessDataServiceHelper.loadSingle((Object)this.getProjectId(), (String)MigrateUserGuideProjectHelper.getProjectFormIdByUserGuide(this.view));
        if ("check_progressbarap".equals(progressBar.getKey())) {
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u68c0\u67e5\u4efb\u52a1\u6267\u884c\u5931\u8d25:%s", (String)"MigrateUserGuideExcuteHelper_22", (String)"imsc-dmw-platform", (Object[])new Object[0]), error));
            project.set("projectstatus", (Object)"C");
        } else {
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u8fc1\u79fb\u4efb\u52a1\u6267\u884c\u5931\u8d25:%s", (String)"MigrateUserGuideExcuteHelper_23", (String)"imsc-dmw-platform", (Object[])new Object[0]), error));
            project.set("projectstatus", (Object)"F");
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{project});
        progressBar.stop();
    }

    private void handleScheduleSystemError(ProgressBar progressBar) {
        String error = ResManager.loadKDString((String)"\u4efb\u52a1\u957f\u65f6\u95f4\u7b49\u5f85\u540e\u4ecd\u5904\u4e8e\u8ba1\u5212\u72b6\u6001\u800c\u672a\u5f00\u59cb\u6267\u884c\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u68c0\u67e5\u8c03\u5ea6\u670d\u52a1\u662f\u5426\u6b63\u5e38\u8fd0\u8f6c\u3002", (String)"MigrateUserGuideExcuteHelper_24", (String)"imsc-dmw-platform", (Object[])new Object[0]);
        this.handleErrorTaskStatus(error, progressBar);
    }

    private void refreshExecData() {
        DynamicObject project = BusinessDataServiceHelper.loadSingle((Object)this.getProjectId(), (String)MigrateUserGuideProjectHelper.getProjectFormIdByUserGuide(this.view));
        String status = project.getString("projectstatus");
        MigrateUserGuideProjectHelper.updateMigrateExecData(this.getView(), project);
        MigrateUserGuideProjectHelper.setProjectStatus(this.getView(), status);
        this.getModel().updateCache();
        this.getView().updateView("migtreeentryentity");
    }

    private Long getProjectId() {
        String project = this.getView().getPageCache().get("existProject");
        if (StringUtils.isEmpty((CharSequence)project)) {
            return 0L;
        }
        return Long.parseLong(project);
    }

    private String getProjectStatus() {
        return this.getView().getPageCache().get("projectstatus");
    }

    private IDataModel getModel() {
        return this.model;
    }

    private IFormView getView() {
        return this.view;
    }

    public static DynamicObject updateProjectStatus(long projectId, String projectFormId) {
        DynamicObject project = BusinessDataServiceHelper.loadSingle((Object)projectId, (String)projectFormId);
        DynamicObjectCollection execObjects = project.getDynamicObjectCollection("treeentryentity");
        boolean matchResult = execObjects.stream().anyMatch(n -> !"C".equals(n.getString("migratestatus")) && !"G".equals(n.getString("migratestatus")));
        if (matchResult) {
            project.set("projectstatus", (Object)"G");
        }
        ArrayList<String> successList = new ArrayList<String>(16);
        ArrayList<String> noStartList = new ArrayList<String>(16);
        ArrayList<String> migrateInList = new ArrayList<String>(16);
        for (DynamicObject dyna : execObjects) {
            String migStatus = dyna.getString("migratestatus");
            if ("C".equals(migStatus) || "G".equals(migStatus)) {
                successList.add(migStatus);
                continue;
            }
            if ("A".equals(migStatus)) {
                noStartList.add(migStatus);
                continue;
            }
            if (!"B".equals(migStatus)) continue;
            migrateInList.add(migStatus);
        }
        if (!migrateInList.isEmpty()) {
            project.set("projectstatus", (Object)"E");
        } else if (successList.size() == execObjects.size()) {
            project.set("projectstatus", (Object)"G");
        } else if (!successList.isEmpty() && successList.size() + noStartList.size() == execObjects.size()) {
            project.set("projectstatus", (Object)"H");
        } else {
            project.set("projectstatus", (Object)"F");
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{project});
        return project;
    }
}

