/*
 * Decompiled with CFR 0.152.
 */
package kd.imsc.dmw.helper.tpl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.imsc.dmw.common.pagemodel.DmwMigrateuserguide;
import kd.imsc.dmw.helper.tpl.MigrateUserGuideProjectHelper;
import kd.imsc.dmw.utils.CommonUtils;
import kd.imsc.dmw.utils.DynamicObjectUtils;
import kd.imsc.dmw.utils.QFilterUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;

public class MigrateUserGuideSourceVerifyHelper {
    private static final String KEY_STATUS_S = "S";
    private static final String KEY_STATUS_F = "F";
    private static final String SCHEME = "scheme";
    private static final String SERVICE = "service";
    private static final Long SERVICEFLOWID = 2043558740204004352L;
    private static final Log logger = LogFactory.getLog(MigrateUserGuideSourceVerifyHelper.class);

    private MigrateUserGuideSourceVerifyHelper() {
    }

    public static boolean verifyErrorEntries(IFormView view) {
        IDataModel model = view.getModel();
        DynamicObjectCollection migObjEntity = model.getEntryEntity("treeentryentity");
        StringBuilder errMsg = new StringBuilder();
        for (int i = 0; i < migObjEntity.size(); ++i) {
            DynamicObject entry = (DynamicObject)migObjEntity.get(i);
            DynamicObject migObj = entry.getDynamicObject("migrateobject");
            if (migObj == null) continue;
            String executeType = migObj.getString("executetype");
            Long initSchemeId = migObj.getLong("initschemeid");
            Long allSchemeId = migObj.getLong("allschemeid");
            if (!initSchemeId.equals(0L) || !allSchemeId.equals(0L) || !"1".equalsIgnoreCase(executeType)) continue;
            errMsg.append(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u8fc1\u79fb\u5bf9\u8c61\u7ed1\u5b9a\u7684\u542f\u52a8\u65b9\u6848/\u670d\u52a1\u6d41\u7a0bID\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u8be5\u6570\u636e\u3002", (String)"MigrateUserGuideSourceVerifyHelper_7", (String)"imsc-dmw-platform", (Object[])new Object[0]), i + 1)).append('\n');
        }
        if (errMsg.length() > 0) {
            view.showErrorNotification(errMsg.toString());
        }
        return errMsg.length() > 0;
    }

    public static void verifyCheckItemServiceFlowResource(IFormView view, Map<Object, Map<String, Object>> entryEntityMap) {
        DynamicObjectCollection checkEntryEntity = view.getModel().getEntryEntity("checktreeentryentity");
        Set serviceFlowIdSet = checkEntryEntity.stream().filter(o -> "C".equals(DynamicObjectUtils.getString(o.getDynamicObject("checkitem"), "callmethod"))).map(o -> DynamicObjectUtils.getPkValue(o.getDynamicObject("checkitem"), "serviceflowid")).collect(Collectors.toSet());
        if (CommonUtils.isNull(serviceFlowIdSet)) {
            return;
        }
        List existFlowIdList = QueryServiceHelper.queryPrimaryKeys((String)"isc_service_flow", (QFilter[])new QFilter("id", "in", serviceFlowIdSet).toArray(), null, (int)-1);
        long packageId = 0L;
        String packageNum = "";
        String packageName = "";
        for (DynamicObject checkEntryDynObj : checkEntryEntity) {
            DynamicObject checkItemDynObj = checkEntryDynObj.getDynamicObject("checkitem");
            if (checkItemDynObj == null || !"C".equals(DynamicObjectUtils.getString(checkItemDynObj, "callmethod"))) continue;
            packageId = checkItemDynObj.getLong("solutionpackageid");
            packageNum = checkItemDynObj.getString("solutionpackagenum");
            packageName = checkItemDynObj.getString("solutionpackage");
            long serviceFlowId = checkItemDynObj.getLong("serviceflowid");
            if (!CommonUtils.isNull(existFlowIdList) && existFlowIdList.contains(serviceFlowId)) continue;
            MigrateUserGuideSourceVerifyHelper.buildEntryMap(view, entryEntityMap, null, "isc_service_flow", checkItemDynObj.getString("serviceflowname"), serviceFlowId, packageId, packageNum, packageName);
        }
    }

    public static Map<Object, Map<String, Object>> verifyScheme(IFormView view) {
        IDataModel model = view.getModel();
        DynamicObjectCollection migObjEntity = model.getEntryEntity("migtreeentryentity");
        HashMap<Object, Map<String, Object>> entryEntityMap = new HashMap<Object, Map<String, Object>>(8);
        Map<String, Set<Long>> migSchemeMap = MigrateUserGuideSourceVerifyHelper.getObjSchemeIdMap(view);
        Set<Long> migSchemeIdSet = migSchemeMap.get(SCHEME);
        Set<Long> migServiceIdSet = migSchemeMap.get(SERVICE);
        String migrationModel = (String)model.getValue("migrationmodel");
        QFilter schemeFilter = new QFilter("id", "in", migSchemeIdSet);
        QFilter serviceFilter = new QFilter("id", "in", migServiceIdSet);
        List schemeIdList = QueryServiceHelper.queryPrimaryKeys((String)"isc_data_copy_trigger", (QFilter[])new QFilter[]{schemeFilter}, (String)"id", (int)-1);
        List serviceIdList = QueryServiceHelper.queryPrimaryKeys((String)"isc_service_flow", (QFilter[])new QFilter[]{serviceFilter}, (String)"id", (int)-1);
        for (int i = 0; i < migObjEntity.size(); ++i) {
            Object schemeId;
            String initAllName;
            String initAllId;
            DynamicObject entry = (DynamicObject)migObjEntity.get(i);
            DynamicObject migObj = entry.getDynamicObject("migrateobjectexec");
            if (migObj == null) continue;
            if (migrationModel.equals("A")) {
                initAllId = "initschemeid";
                initAllName = "initschemename";
            } else {
                initAllId = "allschemeid";
                initAllName = "allschemename";
            }
            long id = migObj.getLong(initAllId);
            if (id == 0L || schemeIdList.contains(schemeId = migObj.get(initAllId)) || serviceIdList.contains(schemeId)) continue;
            MigrateUserGuideSourceVerifyHelper.buildEntryMap(view, entryEntityMap, migObj.getPkValue(), entry.getString("schemetype"), migObj.getString(initAllName), migObj.getLong(initAllId), migObj.getLong("solutionpackageid"), migObj.getString("solutionpackagenum"), migObj.getString("solutionpackage"));
        }
        return entryEntityMap;
    }

    public static void verifyFixedSource(IFormView view, Map<Object, Map<String, Object>> entryEntityMap) {
        String billFormId = MigrateUserGuideProjectHelper.getProjectFormIdByUserGuide(view);
        if ("dmw_migrateproject_eas".equals(billFormId)) {
            MigrateUserGuideSourceVerifyHelper.verifyIntegrateObject(view, entryEntityMap);
            MigrateUserGuideSourceVerifyHelper.verifyApi(view, entryEntityMap);
            MigrateUserGuideSourceVerifyHelper.findIscRule(view, entryEntityMap);
        }
    }

    public static void findIscRule(IFormView view, Map<Object, Map<String, Object>> entryEntityMap) {
        DynamicObjectCollection queryList = QueryServiceHelper.query((String)"dmw_preonline_deploy", (String)"restype,resnumber,resname,resid,respackage,respackageid,respackagenum", (QFilter[])QFilterUtils.getAllDataQFilter().toArray());
        HashMap resDatas = new HashMap(16);
        for (DynamicObject query : queryList) {
            String resType = query.getString("restype");
            Long resId = query.getLong("resid");
            resDatas.putIfAbsent(resType, new ArrayList(16));
            List longs = (List)resDatas.get(resType);
            longs.add(resId);
        }
        HashMap resDbDatas = new HashMap(16);
        for (Map.Entry entry : resDatas.entrySet()) {
            if (CollectionUtils.isEmpty((Collection)((Collection)entry.getValue()))) continue;
            QFilter qFilter = new QFilter("id", "in", entry.getValue());
            DynamicObjectCollection ids = QueryServiceHelper.query((String)((String)entry.getKey()), (String)"id", (QFilter[])qFilter.toArray());
            Set idList = ids.stream().map(n -> n.getLong("id")).collect(Collectors.toSet());
            resDbDatas.put(entry.getKey(), idList);
        }
        for (DynamicObject query : queryList) {
            String resType = query.getString("restype");
            String resName = query.getString("resname");
            Long resId = query.getLong("resid");
            Long resPackageId = query.getLong("respackageid");
            String resPackageNum = query.getString("respackagenum");
            String resPackageName = query.getString("respackage");
            Set dbIds = (Set)resDbDatas.get(resType);
            if (dbIds.contains(resId)) continue;
            MigrateUserGuideSourceVerifyHelper.buildEntryMap(view, entryEntityMap, null, resType, resName, resId, resPackageId, resPackageNum, resPackageName);
        }
    }

    public static void verifyRelyResources(IFormView view, Map<Object, Map<String, Object>> entryEntityMap) {
        String billFormId = MigrateUserGuideProjectHelper.getProjectFormIdByUserGuide(view);
        if (!"dmw_migrateproject_eas".equals(billFormId)) {
            return;
        }
        IDataModel model = view.getModel();
        DynamicObjectCollection migObjEntity = model.getEntryEntity("migtreeentryentity");
        ArrayList<Long> migSchemeIdList = new ArrayList<Long>(8);
        ArrayList<String> migSchemeNameList = new ArrayList<String>(8);
        ArrayList<Long> migServiceIdList = new ArrayList<Long>(8);
        ArrayList<String> migServiceNameList = new ArrayList<String>(8);
        String migrationModel = (String)model.getValue("migrationmodel");
        boolean ifMigMidTable = false;
        boolean ifEnableInvalid = false;
        for (DynamicObject entry : migObjEntity) {
            boolean tempInvalid;
            boolean migRecord;
            boolean migDap;
            boolean migBotp;
            DynamicObject migObj = entry.getDynamicObject("migrateobjectexec");
            String objectMapMapStr = view.getPageCache().get("changeDataMark");
            Map objectMapMap = (Map)JSON.parseObject((String)objectMapMapStr, Map.class);
            if (!MapUtils.isNotEmpty((Map)objectMapMap) || migObj == null) continue;
            Map dataMap = (Map)objectMapMap.get(migObj.getPkValue());
            if (dataMap != null && !dataMap.isEmpty()) {
                migBotp = Boolean.parseBoolean((String)dataMap.get("migbotp"));
                migDap = Boolean.parseBoolean((String)dataMap.get("migdap"));
                migRecord = Boolean.parseBoolean((String)dataMap.get("migrecord"));
                tempInvalid = Boolean.parseBoolean((String)dataMap.get("enableinvaliddata"));
            } else {
                String migrateModel = (String)model.getValue("migrationmodel");
                if ("B".equals(migrateModel)) {
                    migBotp = migObj.getBoolean("migbotpall");
                    migDap = migObj.getBoolean("migdapall");
                    migRecord = migObj.getBoolean("migrecordall");
                } else {
                    migBotp = migObj.getBoolean("migbotpini");
                    migDap = migObj.getBoolean("migdapini");
                    migRecord = migObj.getBoolean("migrecordini");
                }
                tempInvalid = migObj.getBoolean("enableinvaliddata");
            }
            if (tempInvalid) {
                ifEnableInvalid = true;
            }
            if (!migBotp && !migDap && !migRecord) continue;
            if (migBotp || migDap) {
                ifMigMidTable = true;
            }
            MigrateUserGuideSourceVerifyHelper.setMigObjSchemeFlowId(migrationModel, migSchemeIdList, migSchemeNameList, migServiceIdList, migServiceNameList, migObj, migBotp, migDap, migRecord);
        }
        if (ifMigMidTable) {
            migServiceIdList.add(SERVICEFLOWID);
            String botpMidTable = ResManager.loadKDString((String)"\u9884\u5236flow_IMSC_BOTP\u4e2d\u95f4\u8868_\u521d\u59cb\u5316\uff08EAS-\u661f\u701a\uff09", (String)"MigrateUserGuideSourceVerifyHelper_8", (String)"imsc-dmw-platform", (Object[])new Object[0]);
            migServiceNameList.add(botpMidTable);
        }
        if (ifEnableInvalid) {
            migServiceIdList.add(DmwMigrateuserguide.ENABLE_SCHEME_ID);
            String tempName = ResManager.loadKDString((String)"\u9884\u5236flow_IMSC_EAS\u5931\u6548\u72b6\u6001\u6570\u636e\u5904\u7406\uff08EAS-\u661f\u701a\uff09", (String)"MigrateUserGuideSourceVerifyHelper_10", (String)"imsc-dmw-platform", (Object[])new Object[0]);
            migServiceNameList.add(tempName);
        }
        String packageName = ResManager.loadKDString((String)"\u5b9e\u65bd\u670d\u52a1\u4e91\u8865\u5145\u65b9\u6848forEAS\uff08EAS-\u661f\u701a\uff09", (String)"MigrateUserGuideSourceVerifyHelper_6", (String)"imsc-dmw-platform", (Object[])new Object[0]);
        QFilter schemeFilter = new QFilter("id", "in", migSchemeIdList);
        List existSchemeIdList = QueryServiceHelper.queryPrimaryKeys((String)"isc_data_copy_trigger", (QFilter[])schemeFilter.toArray(), (String)"id", (int)-1);
        for (int i = 0; i < migSchemeIdList.size(); ++i) {
            if (existSchemeIdList.contains(migSchemeIdList.get(i))) continue;
            MigrateUserGuideSourceVerifyHelper.buildEntryMap(view, entryEntityMap, null, "isc_data_copy_trigger", (String)migSchemeNameList.get(i), (Long)migSchemeIdList.get(i), 2021892349952640000L, "KD_ISC_IMSC_EAS(EAS-IERP)", packageName);
        }
        QFilter serviceFilter = new QFilter("id", "in", migServiceIdList);
        List existServiceIdList = QueryServiceHelper.queryPrimaryKeys((String)"isc_service_flow", (QFilter[])serviceFilter.toArray(), (String)"id", (int)-1);
        HashSet<Long> specialFlow = new HashSet<Long>(2);
        specialFlow.add(2084281971063778304L);
        specialFlow.add(2084278913038552064L);
        for (int i = 0; i < migServiceIdList.size(); ++i) {
            if (existServiceIdList.contains(migServiceIdList.get(i))) continue;
            long packageId = 2021892349952640000L;
            String packageNum = "KD_ISC_IMSC_EAS(EAS-IERP)";
            if (specialFlow.contains(migServiceIdList.get(i))) {
                packageId = 2073850447197634560L;
                packageNum = "KD_ISC_CAL_EAS(EAS-IERP)";
                packageName = ResManager.loadKDString((String)"\u5b58\u8d27\u6838\u7b97forEAS\uff08EAS-\u661f\u701a\uff09", (String)"MigrateUserGuideSourceVerifyHelper_9", (String)"imsc-dmw-platform", (Object[])new Object[0]);
            }
            MigrateUserGuideSourceVerifyHelper.buildEntryMap(view, entryEntityMap, null, "isc_service_flow", (String)migServiceNameList.get(i), (Long)migServiceIdList.get(i), packageId, packageNum, packageName);
        }
    }

    public static void setMigObjSchemeFlowId(String migrationModel, List<Long> migSchemeIdList, List<String> migSchemeNameList, List<Long> migServiceIdList, List<String> migServiceNameList, DynamicObject migObj, boolean migBotp, boolean migDap, boolean migRecord) {
        String integrateTypeBotp = migObj.getString("inittypebotp");
        String integrateTypeDap = migObj.getString("inittypedap");
        String integrateTypeRecord = migObj.getString("inittyperecord");
        long integrateIdBotp = migObj.getLong("initschemebotpid");
        long integrateIdDap = migObj.getLong("initschemedapid");
        long integrateIdRecord = migObj.getLong("initschemerecordid");
        String integrateNameBotp = migObj.getString("initschemebotp");
        String integrateNameDap = migObj.getString("initschemedap");
        String integrateNameRecord = migObj.getString("initschemerecord");
        if ("B".equals(migrationModel)) {
            integrateTypeBotp = migObj.getString("alltypebotp");
            integrateTypeDap = migObj.getString("alltypedap");
            integrateTypeRecord = migObj.getString("alltyperecord");
            integrateIdBotp = migObj.getLong("allschemebotpid");
            integrateIdDap = migObj.getLong("allschemedapid");
            integrateIdRecord = migObj.getLong("allschemerecordid");
            integrateNameBotp = migObj.getString("allschemebotp");
            integrateNameDap = migObj.getString("allschemedap");
            integrateNameRecord = migObj.getString("allschemerecord");
        }
        ArrayList<Boolean> boolMigList = new ArrayList<Boolean>(3);
        boolMigList.add(migBotp);
        boolMigList.add(migDap);
        boolMigList.add(migRecord);
        ArrayList<String> integrateList = new ArrayList<String>(3);
        integrateList.add(integrateTypeBotp);
        integrateList.add(integrateTypeDap);
        integrateList.add(integrateTypeRecord);
        ArrayList<Long> integrateIdList = new ArrayList<Long>(3);
        integrateIdList.add(integrateIdBotp);
        integrateIdList.add(integrateIdDap);
        integrateIdList.add(integrateIdRecord);
        ArrayList<String> integrateNameList = new ArrayList<String>(3);
        integrateNameList.add(integrateNameBotp);
        integrateNameList.add(integrateNameDap);
        integrateNameList.add(integrateNameRecord);
        for (int i = 0; i < boolMigList.size(); ++i) {
            boolean boolMig = (Boolean)boolMigList.get(i);
            String integrateType = (String)integrateList.get(i);
            Long integrateId = (Long)integrateIdList.get(i);
            String integrateName = (String)integrateNameList.get(i);
            if (boolMig && "isc_data_copy_trigger".equals(integrateType)) {
                migSchemeIdList.add(integrateId);
                migSchemeNameList.add(integrateName);
                continue;
            }
            if (!boolMig) continue;
            migServiceIdList.add(integrateId);
            migServiceNameList.add(integrateName);
        }
    }

    private static void verifyIntegrateObject(IFormView view, Map<Object, Map<String, Object>> entryEntityMap) {
        long[] integrateObjIdArray;
        Map<String, Set<Long>> migSchemeMap = MigrateUserGuideSourceVerifyHelper.getObjSchemeIdMap(view);
        Set<Long> migSchemeIdSet = migSchemeMap.get(SCHEME);
        Set<Long> migServiceIdSet = migSchemeMap.get(SERVICE);
        if ((migSchemeIdSet.contains(1544281110320896000L) || migServiceIdSet.contains(1721678845897315328L)) && !MigrateUserGuideSourceVerifyHelper.isExist("isc_metadata_schema", integrateObjIdArray = new long[]{7361187006201355229L})) {
            String packageName = ResManager.loadKDString((String)"\u603b\u8d26\u96c6\u6210forEAS(EAS-\u661f\u701a)", (String)"MigrateUserGuideSourceVerifyHelper_0", (String)"imsc-dmw-platform", (Object[])new Object[0]);
            MigrateUserGuideSourceVerifyHelper.buildEntryMap(view, entryEntityMap, null, "isc_metadata_schema", "mservice://gl.OperationWebApi.executeOperation", 7361187006201355229L, 1545634643930252288L, "KD_ISC_EAS_Voucher(EAS-IERP)", packageName);
        }
    }

    private static void verifyApi(IFormView view, Map<Object, Map<String, Object>> entryEntityMap) {
        Map<String, Set<Long>> migSchemeMap = MigrateUserGuideSourceVerifyHelper.getObjSchemeIdMap(view);
        Set<Long> migSchemeIdSet = migSchemeMap.get(SCHEME);
        Set<Long> migServiceIdSet = migSchemeMap.get(SERVICE);
        if (!CommonUtils.isNull(migSchemeIdSet) || !CommonUtils.isNull(migServiceIdSet)) {
            String name;
            String packageName = ResManager.loadKDString((String)"\u5b9e\u65bd\u670d\u52a1\u4e91\u8865\u5145\u65b9\u6848forEAS\uff08EAS-\u661f\u701a\uff09", (String)"MigrateUserGuideSourceVerifyHelper_6", (String)"imsc-dmw-platform", (Object[])new Object[0]);
            if (!QueryServiceHelper.exists((String)"isc_apic_script", (Object)2049889130527129600L)) {
                name = ResManager.loadKDString((String)"EASID\u751f\u6210\u661f\u701aID\u63a5\u53e3", (String)"MigrateUserGuideSourceVerifyHelper_1", (String)"imsc-dmw-platform", (Object[])new Object[0]);
                MigrateUserGuideSourceVerifyHelper.buildEntryMap(view, entryEntityMap, null, "isc_apic_script", name, 2049889130527129600L, 2021892349952640000L, "KD_ISC_IMSC_EAS(EAS-IERP)", packageName);
            }
            if (!QueryServiceHelper.exists((String)"isc_apic_script", (Object)2050134440520253440L)) {
                name = ResManager.loadKDString((String)"EASID\u62c6\u5355\u751f\u6210\u661f\u701aID\u6279\u91cf\u63a5\u53e3", (String)"MigrateUserGuideSourceVerifyHelper_2", (String)"imsc-dmw-platform", (Object[])new Object[0]);
                MigrateUserGuideSourceVerifyHelper.buildEntryMap(view, entryEntityMap, null, "isc_apic_script", name, 2050134440520253440L, 2021892349952640000L, "KD_ISC_IMSC_EAS(EAS-IERP)", packageName);
            }
            if (!QueryServiceHelper.exists((String)"isc_apic_script", (Object)2061500702538085376L)) {
                name = ResManager.loadKDString((String)"EASID\u751f\u6210\u661f\u701aID\u6279\u91cf\u63a5\u53e3", (String)"MigrateUserGuideSourceVerifyHelper_3", (String)"imsc-dmw-platform", (Object[])new Object[0]);
                MigrateUserGuideSourceVerifyHelper.buildEntryMap(view, entryEntityMap, null, "isc_apic_script", name, 2061500702538085376L, 2021892349952640000L, "KD_ISC_IMSC_EAS(EAS-IERP)", packageName);
            }
            if (!QueryServiceHelper.exists((String)"isc_apic_script", (Object)2089284213516860416L)) {
                name = ResManager.loadKDString((String)"\u68c0\u67e5\u9879\u81ea\u5b9a\u4e49api", (String)"MigrateUserGuideSourceVerifyHelper_5", (String)"imsc-dmw-platform", (Object[])new Object[0]);
                MigrateUserGuideSourceVerifyHelper.buildEntryMap(view, entryEntityMap, null, "isc_apic_script", name, 2089284213516860416L, 2021892349952640000L, "KD_ISC_IMSC_EAS(EAS-IERP)", packageName);
            }
        }
    }

    public static boolean isExist(String entityName, long[] idArray) {
        QFilter qFilter = new QFilter("id", "in", (Object)idArray);
        List idList = QueryServiceHelper.queryPrimaryKeys((String)entityName, (QFilter[])qFilter.toArray(), (String)"id", (int)-1);
        return idList.size() == idArray.length;
    }

    private static void buildEntryMap(IFormView view, Map<Object, Map<String, Object>> entryEntityMap, Object migObj, String type, String schemeName, Long schemeId, Long packageId, String packageNum, String packageName) {
        HashMap<String, Object> map = new HashMap<String, Object>(4);
        map.put("migobjtype", MigrateUserGuideProjectHelper.getObjectFormIdByUserGuide(view));
        map.put("migrateobject", migObj);
        map.put("integrattype", type);
        map.put("schemename", schemeName);
        map.put("schemeid", schemeId);
        map.put("solutionpackageid", packageId);
        map.put("solutionpackagenum", packageNum);
        map.put("solutionpackage", packageName);
        entryEntityMap.put(schemeId, map);
    }

    private static Map<String, Set<Long>> getObjSchemeIdMap(IFormView view) {
        IDataModel model = view.getModel();
        DynamicObjectCollection migObjEntity = model.getEntryEntity("migtreeentryentity");
        HashMap<String, Set<Long>> schemeIdMap = new HashMap<String, Set<Long>>(2);
        HashSet<Long> migSchemeIdSet = new HashSet<Long>(8);
        HashSet<Long> migServiceIdSet = new HashSet<Long>(8);
        String migrationModel = (String)model.getValue("migrationmodel");
        for (int i = 0; i < migObjEntity.size(); ++i) {
            String initAllId;
            long id;
            DynamicObject entry = (DynamicObject)migObjEntity.get(i);
            DynamicObject migObj = entry.getDynamicObject("migrateobjectexec");
            String initType = entry.getString("schemetype");
            if (migObj == null || (id = migObj.getLong(initAllId = migrationModel.equals("A") ? "initschemeid" : "allschemeid")) == 0L) continue;
            if (initType.equals("isc_data_copy_trigger")) {
                migSchemeIdSet.add(id);
                continue;
            }
            migServiceIdSet.add(id);
        }
        schemeIdMap.put(SCHEME, migSchemeIdSet);
        schemeIdMap.put(SERVICE, migServiceIdSet);
        return schemeIdMap;
    }

    public static boolean verifyWebsite() {
        DynamicObject cloudApp = MigrateUserGuideSourceVerifyHelper.getCloudApp(true);
        if (cloudApp == null) {
            return false;
        }
        String urlString = cloudApp.getString("targeturl");
        try {
            URL url = new URL(urlString);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("GET");
            connection.setConnectTimeout(1000);
            int responseCode = connection.getResponseCode();
            return responseCode == 200;
        }
        catch (IOException e) {
            logger.error("\u7f51\u5740\u65e0\u6cd5\u8fde\u63a5", (Throwable)e);
            return false;
        }
    }

    public static void openImportInterface(IFormPlugin plugin, IFormView view, boolean isConnected, Map<Object, Map<String, Object>> entryEntityMap) {
        IDataModel model = view.getModel();
        FormShowParameter parameter = new FormShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        DynamicObject cloudApp = MigrateUserGuideSourceVerifyHelper.getCloudApp(false);
        String json = JSONObject.toJSONString(entryEntityMap);
        if (isConnected) {
            boolean keyStatus = cloudApp != null && KEY_STATUS_S.equals(cloudApp.get("billstatus"));
            parameter.setFormId("dmw_res_import_online");
            parameter.setCustomParam("migobjentryentity", (Object)json);
            parameter.setCloseCallBack(new CloseCallBack(plugin, "dmw_res_import_online"));
            String projectName = (String)model.getValue("projectname");
            if ("WUQUENANFEI".equals(projectName)) {
                keyStatus = !keyStatus;
            }
            parameter.setCustomParam("keystatus", (Object)keyStatus);
        } else {
            parameter.setFormId("dmw_res_import_manual");
            parameter.setCustomParam("migobjentryentity", (Object)json);
        }
        view.showForm(parameter);
    }

    public static DynamicObject getCloudApp(boolean isPing) {
        DynamicObjectCollection cloudApplication;
        String accountId = RequestContext.get().getAccountId();
        String tenantId = RequestContext.get().getTenantId();
        ArrayList<String> statusList = new ArrayList<String>(2);
        statusList.add(KEY_STATUS_S);
        statusList.add(KEY_STATUS_F);
        QFilter qFilter = new QFilter("tenantid", "=", (Object)tenantId);
        qFilter.and(new QFilter("accountid", "=", (Object)accountId));
        if (!isPing) {
            qFilter.and(new QFilter("billstatus", "in", statusList));
        }
        if ((cloudApplication = QueryServiceHelper.query((String)"res_pub_thirdapp_apply", (String)"billstatus,targeturl,version", (QFilter[])new QFilter[]{qFilter}, (String)"version DESC", (int)1)) == null || cloudApplication.isEmpty()) {
            return null;
        }
        return (DynamicObject)cloudApplication.get(0);
    }

    public static void enableScheme(IFormView view) {
        Map<String, Set<Long>> migSchemeMap = MigrateUserGuideSourceVerifyHelper.getObjSchemeIdMap(view);
        Set<Long> migSchemeIdSet = migSchemeMap.get(SCHEME);
        Set<Long> migServiceIdSet = migSchemeMap.get(SERVICE);
        DynamicObjectCollection checkEntryEntity = view.getModel().getEntryEntity("checktreeentryentity");
        Set serviceFlowIdSet = checkEntryEntity.stream().filter(o -> "C".equals(DynamicObjectUtils.getString(o.getDynamicObject("checkitem"), "callmethod"))).map(o -> DynamicObjectUtils.getPkValue(o.getDynamicObject("checkitem"), "serviceflowid")).collect(Collectors.toSet());
        if (!CommonUtils.isNull(serviceFlowIdSet)) {
            migServiceIdSet.addAll(serviceFlowIdSet);
        }
        Object[] migServiceIdArray = migServiceIdSet.toArray(new Long[0]);
        Object[] apiId = new Long[]{2049889130527129600L, 2050134440520253440L, 2061500702538085376L, 2089284213516860416L};
        QFilter serviceFilter = new QFilter("id", "in", (Object)migServiceIdArray);
        serviceFilter.and("resources.res_category", "in", (Object)new String[]{"isc_service_flow", "isc_data_copy_trigger"});
        DynamicObjectCollection serviceArray = QueryServiceHelper.query((String)"isc_service_flow", (String)"id,resources,resources.res_category,resources.res_ref,resources.res_alias,resources.res_source_text", (QFilter[])serviceFilter.toArray());
        HashSet<Long> serviceSourceIdSet = new HashSet<Long>(8);
        for (DynamicObject service : serviceArray) {
            String category = service.getString("resources.res_category");
            Long serviceSourceId = service.getLong("resources.res_ref");
            if (CommonUtils.isNull(serviceSourceId)) continue;
            if ("isc_data_copy_trigger".equals(category)) {
                migSchemeIdSet.add(serviceSourceId);
                continue;
            }
            if (!"isc_service_flow".equals(category)) continue;
            serviceSourceIdSet.add(serviceSourceId);
        }
        serviceSourceIdSet.add(2084281971063778304L);
        serviceSourceIdSet.add(2084278913038552064L);
        serviceSourceIdSet.add(2046660515790369792L);
        serviceSourceIdSet.add(2046535188065858560L);
        serviceSourceIdSet.add(2043581056250094592L);
        serviceSourceIdSet.add(2043558740204004352L);
        serviceSourceIdSet.add(2219128533463083008L);
        serviceSourceIdSet.add(2218138475830544384L);
        serviceSourceIdSet.add(2197941812012780544L);
        Object[] serviceSourceArray = serviceSourceIdSet.toArray(new Long[0]);
        Object[] migSchemeIdArray = migSchemeIdSet.toArray(new Long[0]);
        OperationServiceHelper.executeOperate((String)"release", (String)"isc_service_flow", (Object[])serviceSourceArray, (OperateOption)OperateOption.create());
        OperationServiceHelper.executeOperate((String)"enable", (String)"isc_data_copy_trigger", (Object[])migSchemeIdArray, (OperateOption)OperateOption.create());
        OperationServiceHelper.executeOperate((String)"release", (String)"isc_service_flow", (Object[])migServiceIdArray, (OperateOption)OperateOption.create());
        OperationServiceHelper.executeOperate((String)"enable", (String)"isc_apic_script", (Object[])apiId, (OperateOption)OperateOption.create());
    }
}

