/*
 * Decompiled with CFR 0.152.
 */
package kd.imsc.dmw.plugin.formplugin.migwizard;

import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FloatingDirection;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.Control;
import kd.bos.list.ListShowParameter;
import kd.imsc.dmw.helper.ShowFormHelper;
import kd.imsc.dmw.helper.migwizard.MigrationWizardHelper;
import kd.imsc.dmw.utils.StringUtils;
import kd.imsc.imbd.formplugin.tpl.ImbdDymicTplEditPlugin;

public class MigrationWizardPlugin
extends ImbdDymicTplEditPlugin {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"opguideone", "opguidetwo", "opguidethree", "opguidefour", "opschemeguide", "personalscheme", "seconddevelop", "objectconfig", "checkitemconfig", "universalconvert", "accountconvert", "cashconvert", "reverseconfig", "migrationflow", "createproject"});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Map<String, String> userMemory = MigrationWizardHelper.getUserMemory();
        if (userMemory.size() != 0) {
            this.getModel().setValue("sourcesystem", (Object)userMemory.get("sourcesystem"));
            this.getView().getPageCache().put("migrationmodel", userMemory.get("migrationmodel"));
        } else {
            this.getModel().setValue("sourcesystem", (Object)"EAS");
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.switchSystemAndChangeInterface();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name;
        switch (name = e.getProperty().getName()) {
            case "sourcesystem": {
                this.switchSystemAndChangeInterface();
                MigrationWizardHelper.setUserMemory(String.valueOf(this.getModel().getValue("sourcesystem")), this.getView().getPageCache().get("migrationmodel"));
                break;
            }
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        HashMap<String, String> map = new HashMap<String, String>(2);
        switch (key) {
            case "opguideone": {
                this.jumpToFrom("dmw_environment_prepare");
                break;
            }
            case "opguidetwo": {
                this.jumpToFrom("dmw_migration_content");
                break;
            }
            case "opguidethree": {
                this.jumpToFrom("dmw_customized_require");
                break;
            }
            case "opguidefour": {
                this.jumpToFrom("dmw_mig_tool_learn");
                break;
            }
            case "opschemeguide": {
                this.jumpToFrom("dmw_scheme_guide");
                break;
            }
            case "personalscheme": {
                map.put("EAS", "dmw_migratescheme_eas");
                map.put("NC", "dmw_migratescheme_nc");
                map.put("ECC", "dmw_migratescheme_ecc");
                this.jumpToListBySystem(map);
                break;
            }
            case "seconddevelop": {
                break;
            }
            case "objectconfig": {
                map.put("EAS", "dmw_migrateobject_eas");
                map.put("NC", "dmw_migrateobject_nc");
                map.put("ECC", "dmw_migrateobject_ecc");
                this.jumpToListBySystem(map);
                break;
            }
            case "checkitemconfig": {
                map.put("EAS", "dmw_migratecheckitem_eas");
                map.put("NC", "dmw_migratecheckitem_nc");
                map.put("ECC", "dmw_migratecheckitem_ecc");
                this.jumpToListBySystem(map);
                break;
            }
            case "universalconvert": {
                map.put("EAS", "dmw_universal_convert");
                this.jumpToListBySystem(map);
                break;
            }
            case "accountconvert": {
                map.put("EAS", "dmw_acc_convert");
                this.jumpToListBySystem(map);
                break;
            }
            case "cashconvert": {
                map.put("EAS", "dmw_cash_convert");
                this.jumpToListBySystem(map);
                break;
            }
            case "reverseconfig": {
                map.put("EAS", "dmw_migration_control");
                this.jumpToListBySystem(map);
                break;
            }
            case "migrationflow": {
                this.jumpToFrom("dmw_exec_process");
                break;
            }
            case "createproject": {
                map.put("EAS", "dmw_migrateuserguide_eas");
                map.put("NC", "dmw_migrateuserguide_nc");
                map.put("ECC", "dmw_migrateuserguide_ecc");
                this.jumpToFormBySystem(map);
                break;
            }
        }
    }

    private void switchSystemAndChangeInterface() {
        String name = (String)this.getModel().getValue("sourcesystem");
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"easprompttag", "isomerismflex", "reverseflex", "ncprompttag", "eccprompttag"});
        if (StringUtils.isNotEmpty(name)) {
            switch (name) {
                case "EAS": {
                    this.getView().setVisible(Boolean.valueOf(true), new String[]{"easprompttag", "isomerismflex", "reverseflex"});
                    break;
                }
                case "NC": {
                    this.getView().setVisible(Boolean.valueOf(true), new String[]{"ncprompttag"});
                    break;
                }
                case "ECC": {
                    this.getView().setVisible(Boolean.valueOf(true), new String[]{"eccprompttag"});
                    break;
                }
            }
        }
    }

    private void jumpToFormBySystem(Map<String, String> map) {
        String system = (String)this.getModel().getValue("sourcesystem");
        if (StringUtils.isBlank(system)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6e90\u7cfb\u7edf", (String)"MigrationWizardPlugin_0", (String)"imsc-dmw-platform", (Object[])new Object[0]));
            return;
        }
        String formId = map.get(system);
        HashMap<String, Object> customParams = new HashMap<String, Object>(2);
        String migrationModel = this.getView().getPageCache().get("migrationmodel");
        if (StringUtils.isNotBlank(migrationModel)) {
            customParams.put("migrationmodel", "initmodel".equals(migrationModel) ? "A" : "B");
        }
        FormShowParameter formShowParameter = ShowFormHelper.showForm(formId, ShowType.MainNewTabPage, customParams);
        this.getView().showForm(formShowParameter);
    }

    private void jumpToFrom(String formId) {
        String system = (String)this.getModel().getValue("sourcesystem");
        if (StringUtils.isBlank(system)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6e90\u7cfb\u7edf", (String)"MigrationWizardPlugin_0", (String)"imsc-dmw-platform", (Object[])new Object[0]));
            return;
        }
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId(formId);
        parameter.setCustomParam("sourcesystem", (Object)system);
        parameter.setCustomParam("migrationmodel", (Object)this.getView().getPageCache().get("migrationmodel"));
        StyleCss styleCss = new StyleCss();
        parameter.getOpenStyle().setInlineStyleCss(styleCss);
        parameter.getOpenStyle().setPlaceholder(false);
        parameter.getOpenStyle().setShowType(ShowType.PageDrawer);
        parameter.getOpenStyle().setFloatingDirection(FloatingDirection.BottomRight);
        this.getView().showForm(parameter);
    }

    private void jumpToListBySystem(Map<String, String> map) {
        String system = (String)this.getModel().getValue("sourcesystem");
        if (StringUtils.isBlank(system)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6e90\u7cfb\u7edf", (String)"MigrationWizardPlugin_0", (String)"imsc-dmw-platform", (Object[])new Object[0]));
            return;
        }
        String formId = map.get(system);
        ListShowParameter listShowParameter = ShowFormHelper.showListForm(formId, null, ShowType.MainNewTabPage, null);
        this.getView().showForm((FormShowParameter)listShowParameter);
    }
}

