/*
 * Decompiled with CFR 0.152.
 */
package kd.imsc.dmw.plugin.formplugin.schedule.task;

import java.util.HashMap;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormConfig;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.lang.Lang;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.FormConfigFactory;
import kd.bos.mvc.SessionManager;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.schedule.executor.ExecutorService;
import kd.bos.schedule.form.JobFormInfo;
import kd.bos.service.lookup.ServiceLookup;
import kd.bos.servicehelper.schedule.ScheduleServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.web.DispatchServiceHelper;
import kd.imsc.dmw.helper.ScheduleHelper;
import kd.imsc.dmw.plugin.formplugin.datacollect.ProjectAllBaseUtil;
import kd.imsc.dmw.plugin.formplugin.datacollect.impt.ImportUtil;
import kd.imsc.dmw.plugin.formplugin.schedule.task.TaskHandler;
import kd.imsc.dmw.plugin.formplugin.schedule.task.TaskIf;
import kd.imsc.dmw.utils.CommonUtils;

public class DataCollectImportTask
extends AbstractTask {
    private static final Log logger = LogFactory.getLog(DataCollectImportTask.class);
    private static final String BILL_FORM_ID = "BillFormId";
    private static final String LOG_ID = "logId";
    private IFormView view;
    private String importTaskId;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        StringBuilder errorInfo;
        long logId;
        block11: {
            String formId = (String)map.get(BILL_FORM_ID);
            logId = 0L;
            if (map.containsKey(LOG_ID)) {
                logId = Long.parseLong(map.get(LOG_ID).toString());
            }
            errorInfo = new StringBuilder();
            String pageId = null;
            FormShowParameter formShowParameter4Import = this.createFormShowParameter4Import(map);
            pageId = this.openFormView(formId, formShowParameter4Import);
            this.view = SessionManager.getCurrent().getViewNoPlugin(pageId);
            this.dispatchTask();
            new TaskHandler(this.importTaskId, new TaskIf(){

                @Override
                public void ifUpdate(TaskInfo taskInfo) {
                    Map<String, Object> taskCustomData = ScheduleHelper.getTaskCustomData(taskInfo);
                    ExecutorService.getInstance().getObjectFactory().getTaskDao().updateProgress(DataCollectImportTask.this.taskId, taskInfo.getProgress() - 5, taskInfo.getDesc(), taskCustomData);
                }
            }).wait2End();
            try {
                this.closeFormView(formId, pageId);
            }
            catch (Exception e) {
                logger.error("\u6570\u636e\u63d0\u62a5\u6587\u4ef6\u5bfc\u5165\u5173\u95ed\u9875\u9762\u5931\u8d25", (Throwable)e);
            }
            break block11;
            catch (Exception e) {
                try {
                    logger.error("\u6570\u636e\u63d0\u62a5\u6587\u4ef6\u5bfc\u5165\u5f02\u5e38", (Throwable)e);
                    errorInfo.append(String.format(ResManager.loadKDString((String)"\u5bfc\u5165\u53d1\u751f\u5f02\u5e38\uff0ctraceId\uff1a%1$s\uff0c\u5177\u4f53\u9519\u8bef\uff1a%2$s", (String)"DataCollectImportTask_3", (String)"imsc-dmw-platform", (Object[])new Object[0]), RequestContext.get().getTraceId(), e.getMessage()));
                }
                catch (Throwable throwable) {
                    try {
                        this.closeFormView(formId, pageId);
                    }
                    catch (Exception e2) {
                        logger.error("\u6570\u636e\u63d0\u62a5\u6587\u4ef6\u5bfc\u5165\u5173\u95ed\u9875\u9762\u5931\u8d25", (Throwable)e2);
                    }
                    throw throwable;
                }
                try {
                    this.closeFormView(formId, pageId);
                }
                catch (Exception e3) {
                    logger.error("\u6570\u636e\u63d0\u62a5\u6587\u4ef6\u5bfc\u5165\u5173\u95ed\u9875\u9762\u5931\u8d25", (Throwable)e3);
                }
            }
        }
        long entryId = CommonUtils.getLongCustomParamValue(this.view, "entryid");
        ProjectAllBaseUtil.updateDataCollectStatusByStandard(entryId, logId, errorInfo);
        TaskInfo taskInfo = ScheduleServiceHelper.queryTask((String)this.importTaskId);
        ExecutorService.getInstance().getObjectFactory().getTaskDao().updateCustomData(this.taskId, ScheduleHelper.getTaskCustomData(taskInfo));
    }

    private FormShowParameter createFormShowParameter4Import(Map<String, Object> map) {
        String formId = (String)map.get(BILL_FORM_ID);
        ListShowParameter listShowParameter = new ListShowParameter();
        listShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        FormConfig listFormConfig = FormMetadataCache.getListFormConfig((String)formId);
        String pageTypeList = listFormConfig.getListFormId();
        listShowParameter.setFormId(pageTypeList);
        listShowParameter.setBillFormId(formId);
        listShowParameter.setCustomParams(map);
        Map<String, Object> importOpMap = ImportUtil.getImportOpInfo(formId);
        listShowParameter.setCustomParam("ImportPlugin", (Object)ImportUtil.getImportPlugin(importOpMap));
        return listShowParameter;
    }

    private String openFormView(String formId, FormShowParameter parameter) {
        FormConfigFactory.createConfig((FormShowParameter)parameter);
        DispatchServiceHelper.invokeBOSServiceByFormId((String)formId, (String)"FormService", (String)"batchInvokeAction", (Object[])new Object[]{parameter.getPageId(), "[{\"key\":\"\",\"methodName\":\"loadData\",\"args\":[],\"postData\":[]}]"});
        return parameter.getPageId();
    }

    private void closeFormView(String formId, String pageId) {
        DispatchServiceHelper.invokeBOSServiceByFormId((String)formId, (String)"FormService", (String)"batchInvokeAction", (Object[])new Object[]{pageId, "[{\"key\":\"toolbarap\",\"methodName\":\"itemClick\",\"args\":[\"tblclose\",\"close\"],\"postData\":[{},[]]}]"});
    }

    private void dispatchTask() {
        Object logId = this.view.getFormShowParameter().getCustomParam(LOG_ID);
        JobFormInfo jobFormInfo = this.buildJobFormInfo(logId);
        this.importTaskId = ScheduleServiceHelper.dispatch((JobInfo)jobFormInfo.getJobInfo());
    }

    private JobFormInfo buildJobFormInfo(Object logId) {
        JobInfo jobInfo = new JobInfo();
        jobInfo.setRunByLang(Lang.get());
        jobInfo.setName(String.format(ResManager.loadKDString((String)"\u5bfc\u5165 - %s", (String)"DataCollectImportTask_2", (String)"imsc-dmw-platform", (Object[])new Object[0]), (Object[])this.view.getFormShowParameter().getCustomParam("listName")));
        jobInfo.setJobType(JobType.REALTIME);
        jobInfo.setRunByUserId(UserServiceHelper.getCurrentUserId());
        jobInfo.setRunByLang(Lang.get());
        jobInfo.setRunByOrgId(RequestContext.get().getOrgId());
        String routeAppId = this.view.getFormShowParameter().getServiceAppId();
        if (StringUtils.isNotBlank((CharSequence)routeAppId)) {
            String subRouteAppId = routeAppId + ".import";
            if (subRouteAppId.equals(ServiceLookup.getServiceAppId((String)subRouteAppId))) {
                routeAppId = subRouteAppId;
            } else if (ServiceLookup.hasDeployedAppId((String)"imp-exp")) {
                routeAppId = "imp-exp";
            }
        }
        logger.info("buildJobFormInfo ---- routeAppId : " + routeAppId);
        jobInfo.setAppId(routeAppId);
        jobInfo.setTaskClassname("kd.bos.form.plugin.impt.ImportService");
        HashMap<String, Object> params = new HashMap<String, Object>(8);
        params.put("requestcontext", RequestContext.get());
        params.put("pageId", this.view.getPageId());
        params.put(LOG_ID, logId);
        params.put(BILL_FORM_ID, this.view.getFormShowParameter().getCustomParam(BILL_FORM_ID));
        params.put("Url", this.view.getFormShowParameter().getCustomParam("Url"));
        params.put("imgZipUrl", this.view.getFormShowParameter().getCustomParam("imgZipUrl"));
        params.put("attZipUrl", this.view.getFormShowParameter().getCustomParam("attZipUrl"));
        jobInfo.setParams(params);
        JobFormInfo jobFormInfo = new JobFormInfo(jobInfo);
        jobFormInfo.setParentPageId(this.view.getFormShowParameter().getParentPageId());
        jobFormInfo.setRootPageId(this.view.getFormShowParameter().getRootPageId());
        jobFormInfo.getParams().putAll(this.view.getFormShowParameter().getCustomParams());
        jobFormInfo.getParams().put(LOG_ID, logId);
        if (this.view.getFormShowParameter().getCloseCallBack() != null) {
            jobFormInfo.setCloseCallBack(this.view.getFormShowParameter().getCloseCallBack());
        } else {
            CloseCallBack closeCallBack = new CloseCallBack("kd.bos.form.plugin.expt.ExportCallBack", "background_actionid");
            jobFormInfo.setCloseCallBack(closeCallBack);
        }
        jobFormInfo.setClickClassName("kd.bos.form.impt.background.ImportTaskClick");
        return jobFormInfo;
    }
}

