/*
 * Decompiled with CFR 0.152.
 */
package kd.imsc.dmw.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import kd.bos.orm.util.CollectionUtils;

public class ObjectUtils {
    private ObjectUtils() {
    }

    public static <T> List<List<T>> paging(List<T> list, int pageSize) {
        if (CollectionUtils.isEmpty(list)) {
            return new ArrayList<List<T>>();
        }
        ArrayList<List<T>> ret = new ArrayList<List<T>>(128);
        int total = list.size();
        int count = (int)Math.ceil((double)total * 1.0 / (double)pageSize);
        int from = 0;
        for (int i = 0; i < count; ++i) {
            int to = (i + 1) * pageSize;
            if (to > total) {
                to = total;
            }
            List<T> subList = list.subList(from, to);
            ret.add(subList);
            from = to;
        }
        return ret;
    }

    public static <T> List<List<T>> paging(Set<T> set, int pageSize) {
        return ObjectUtils.paging(new ArrayList<T>(set), pageSize);
    }

    public static void reverseArray(byte[] src) {
        if (src == null || src.length <= 1) {
            return;
        }
        int start = 0;
        for (int end = src.length - 1; start < end; ++start, --end) {
            byte temp = src[start];
            src[start] = src[end];
            src[end] = temp;
        }
    }

    public static Boolean toBoolean(Object value) {
        if (value == null) {
            return Boolean.FALSE;
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        String s = String.valueOf(value).trim();
        if ("1".equals(s)) {
            return Boolean.TRUE;
        }
        return Boolean.valueOf(s);
    }

    public static String toString(Object value) {
        if (value == null) {
            return null;
        }
        return String.valueOf(value);
    }
}

