/*
 * Decompiled with CFR 0.152.
 */
package kd.imsc.dmw.utils;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kd.bos.attachment.util.BillFileMappingWriter;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.cache.tempfile.TempFileCacheDownloadable;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.fileservice.FileItem;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.form.control.UrlUtil;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mservice.attachment.AttachmentInfo;
import kd.bos.mservice.attachment.AttachmentType;
import kd.bos.mservice.attachment.FieldType;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.servicehelper.attachment.AttachmentFieldServiceHelper;
import kd.imsc.dmw.errorcode.DmwBizException;

public class FileUtils {
    private static final Log logger = LogFactory.getLog(FileUtils.class);

    private FileUtils() {
    }

    public static void syncWriteFileBillMapping(String fileName, String appId, String downloadUrl, String entityNumber, String attKey, String billPkId, String billEntryPkId, long attPkId) {
        ArrayList<AttachmentInfo> infos = new ArrayList<AttachmentInfo>(1);
        AttachmentInfo attachmentInfo = new AttachmentInfo();
        attachmentInfo.setAttSourceType(AttachmentType.attachmentfield);
        attachmentInfo.setEntityNum(entityNumber);
        attachmentInfo.setAttKey(attKey);
        attachmentInfo.setAttPkId(Long.valueOf(attPkId));
        attachmentInfo.setFieldKey(attKey);
        attachmentInfo.setBillPkId(billPkId);
        attachmentInfo.setBillEntryPkId(billEntryPkId);
        attachmentInfo.setFileName(fileName);
        attachmentInfo.setDownloadUrl(downloadUrl);
        attachmentInfo.setAppId(appId);
        attachmentInfo.setWriteMapping(true);
        attachmentInfo.setClient("web");
        attachmentInfo.setFieldType(FieldType.AttachmentPanel);
        infos.add(attachmentInfo);
        BillFileMappingWriter.syncWriteFileBillMapping(infos);
    }

    public static void addDownloadPermission(String formId, String urls, String appId) {
        String tempFileId = UrlUtil.getParam((String)urls, (String)"id");
        HashMap<String, String> refEntitiyMap = new HashMap<String, String>(3);
        refEntitiyMap.put("entityNum", formId);
        refEntitiyMap.put("appId", appId);
        refEntitiyMap.put("permissionItemId", "47150e89000000ac");
        DistributeSessionlessCache redisCache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache(formId);
        redisCache.put("TempFileCheckId:" + tempFileId, (Object)SerializationUtils.toJsonString(refEntitiyMap), 600);
    }

    public static String getUploadPrefixPath() {
        String date = LocalDate.now().format(DateTimeFormatter.ofPattern("yyyyMM"));
        String tenantId = RequestContext.get().getTenantId();
        String accountId = RequestContext.get().getAccountId();
        return String.format("/%s/%s/%s", tenantId, accountId, date);
    }

    public static TempFileCacheDownloadable.Content getCacheContentFromTempUrl(String url) {
        String[] queryParams;
        if (StringUtils.isEmpty((CharSequence)url)) {
            String msgTpl = ResManager.loadKDString((String)"\u4e34\u65f6\u6587\u4ef6url\u4e3a\u7a7a\uff01", (String)"FileUtils_0", (String)"imsc-dmw-common", (Object[])new Object[0]);
            throw new DmwBizException(msgTpl);
        }
        TempFileCacheDownloadable downLoad = (TempFileCacheDownloadable)CacheFactory.getCommonCacheFactory().getTempFileCache();
        try {
            queryParams = new URL(url).getQuery().split("&");
        }
        catch (MalformedURLException e) {
            String msgTpl = ResManager.loadKDString((String)"\u4e34\u65f6\u6587\u4ef6url\u89e3\u6790\u5931\u8d25\u3002%s", (String)"FileUtils_1", (String)"imsc-dmw-common", (Object[])new Object[0]);
            throw new DmwBizException(msgTpl, e);
        }
        HashMap<String, String> downloadFileParams = new HashMap<String, String>(queryParams.length);
        for (String queryParam : queryParams) {
            String[] p = queryParam.split("=");
            downloadFileParams.put(p[0], p[1]);
        }
        return downLoad.get((String)downloadFileParams.get("configKey"), (String)downloadFileParams.get("id"));
    }

    public static List<DynamicObject> uploadFileByTempUrl(String formId, Object pkId, String attachKey, String tempUrl, String uploadPath) {
        String realUrl;
        TempFileCacheDownloadable.Content cacheContentFromTempUrl = FileUtils.getCacheContentFromTempUrl(tempUrl);
        int length = cacheContentFromTempUrl.getLength();
        String fileName = cacheContentFromTempUrl.getFilename();
        uploadPath = FileUtils.getUploadPrefixPath() + File.separator + uploadPath + File.separator + fileName;
        FileService fs = FileServiceFactory.getAttachmentFileService();
        try (InputStream in = cacheContentFromTempUrl.getInputStream();){
            FileItem fi = new FileItem(fileName, uploadPath, in);
            realUrl = fs.upload(fi);
        }
        catch (Exception e) {
            String msgTpl = ResManager.loadKDString((String)"\u4e0a\u4f20\u6587\u4ef6\u5931\u8d25", (String)"FileUtils_2", (String)"imsc-dmw-common", (Object[])new Object[0]);
            throw new DmwBizException(msgTpl, e);
        }
        Map<String, Object> uploadFileMap = FileUtils.createUploadFileMap(formId, pkId, attachKey, realUrl, fileName, length, fileName.substring(fileName.lastIndexOf(46) + 1));
        ArrayList<Map<String, Object>> attachments = new ArrayList<Map<String, Object>>();
        attachments.add(uploadFileMap);
        return AttachmentFieldServiceHelper.saveAttachments((String)formId, (String)"", attachments);
    }

    public static void uploadFilePanel(String formId, Object pkId, String attachKey, String tempUrl, String uploadPath) {
        String realUrl;
        TempFileCacheDownloadable.Content cacheContentFromTempUrl = FileUtils.getCacheContentFromTempUrl(tempUrl);
        int length = cacheContentFromTempUrl.getLength();
        String fileName = cacheContentFromTempUrl.getFilename();
        String batch = UUID.randomUUID().toString().replace("-", "");
        uploadPath = FileUtils.getUploadPrefixPath() + File.separator + uploadPath + File.separator + batch + File.separator + fileName;
        FileService fs = FileServiceFactory.getAttachmentFileService();
        try (InputStream in = cacheContentFromTempUrl.getInputStream();){
            FileItem fi = new FileItem(fileName, uploadPath, in);
            realUrl = fs.upload(fi);
        }
        catch (Exception e) {
            String msgTpl = ResManager.loadKDString((String)"\u4e0a\u4f20\u6587\u4ef6\u5931\u8d25", (String)"FileUtils_2", (String)"imsc-dmw-common", (Object[])new Object[0]);
            throw new DmwBizException(msgTpl, e);
        }
        Map<String, Object> uploadFileMap = FileUtils.createUploadFileMap(formId, pkId, attachKey, realUrl, fileName, length, fileName.substring(fileName.lastIndexOf(46) + 1));
        ArrayList<Map<String, Object>> attachments = new ArrayList<Map<String, Object>>(16);
        attachments.add(uploadFileMap);
        AttachmentServiceHelper.upload((String)formId, (Object)pkId, (String)"attachmentpanelap", attachments);
    }

    public static Map<String, Object> createUploadFileMap(String formId, Object pkId, String attachKey, String uploadPath, String fileName, long size, String type) {
        HashMap<String, Object> uploadFileMap = new HashMap<String, Object>(16);
        uploadFileMap.put("entityNum", formId);
        uploadFileMap.put("billPkId", String.valueOf(pkId));
        uploadFileMap.put("lastModified", System.currentTimeMillis());
        uploadFileMap.put("uid", "rc-upload-" + DB.genGlobalLongId());
        logger.info("\u4e0a\u4f20\u6587\u4ef6\u670d\u52a1\u5668uid\uff1a" + uploadFileMap.get("uid"));
        uploadFileMap.put("attachKey", attachKey);
        uploadFileMap.put("client", "web");
        uploadFileMap.put("name", fileName);
        uploadFileMap.put("url", uploadPath);
        uploadFileMap.put("size", size);
        uploadFileMap.put("type", type);
        uploadFileMap.put("status", "success");
        return uploadFileMap;
    }

    public static String copyFileByUrl(String url, String fileName) {
        String realUrl;
        FileService fs = FileServiceFactory.getAttachmentFileService();
        try (InputStream fileInputStream = fs.getInputStream(url);){
            String uploadPath = FileUtils.getUploadPrefixPath() + File.separator + "report_import" + File.separator + fileName;
            FileItem fi = new FileItem(fileName, uploadPath, fileInputStream);
            realUrl = fs.upload(fi);
        }
        catch (Exception e) {
            String msgTpl = ResManager.loadKDString((String)"\u4e0a\u4f20\u6587\u4ef6\u5931\u8d25", (String)"FileUtils_2", (String)"imsc-dmw-common", (Object[])new Object[0]);
            throw new DmwBizException(msgTpl, e);
        }
        return realUrl;
    }

    public static File createTempDir(String dir) throws IOException {
        return Files.createTempDirectory(dir, new FileAttribute[0]).toFile();
    }

    public static boolean isFileExistWithFilePath(String filePath) {
        if (StringUtils.isEmpty((CharSequence)filePath)) {
            return false;
        }
        File file = new File(filePath);
        return file.exists();
    }

    public static int getDynamicSleepSecond(int beginSecond, int maxSecond) {
        if (beginSecond >= maxSecond) {
            return maxSecond;
        }
        return beginSecond * 13 / 10;
    }

    public static String getExceptionDetailInfo(Throwable exception) {
        String retMsg;
        if (exception == null) {
            return "exception is null";
        }
        try (StringWriter sw = new StringWriter();
             PrintWriter pw = new PrintWriter(sw);){
            exception.printStackTrace(pw);
            pw.flush();
            sw.flush();
            retMsg = sw.toString();
        }
        catch (IOException e) {
            String msgTpl = ResManager.loadKDString((String)"exception \u89e3\u6790\u5931\u8d25\uff01%s", (String)"FileUtils_3", (String)"imsc-dmw-common", (Object[])new Object[0]);
            retMsg = String.format(msgTpl, e.getMessage());
        }
        return retMsg;
    }

    public static String checkUrl(String url) {
        if (!StringUtils.isEmpty((CharSequence)url) && url.contains("path=")) {
            url = url.split("path=")[1];
        }
        return url;
    }

    public static boolean isFileZipFormatWithFileName(String fileName) {
        if (StringUtils.isEmpty((CharSequence)fileName)) {
            return false;
        }
        return fileName.endsWith(".zip") || fileName.endsWith(".ZIP");
    }

    public static String generateLocalPath() {
        String userHome = System.getProperty("user.home");
        String tempPath = String.valueOf(DB.genGlobalLongId());
        String localPath = userHome + File.separator + "KINGDEEDOWNLOAD" + File.separator + tempPath;
        return FileUtils.checkFilePath(localPath);
    }

    public static String checkFilePath(String path) {
        return path.replace("../", "#");
    }

    public static File checkAndCreateDir(String path) {
        File file = FileUtils.createFile(path);
        if (!file.exists()) {
            file.mkdirs();
        }
        return file;
    }

    public static File createFile(String path) {
        return new File(path);
    }

    public static void copyInputStreamToFile(InputStream source, File destination) throws IOException {
        org.apache.commons.io.FileUtils.copyToFile((InputStream)source, (File)destination);
    }
}

