/*
 * Decompiled with CFR 0.152.
 */
package kd.imsc.imic.business.taskdispatch;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.Tips;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.control.Label;
import kd.bos.form.control.TreeView;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.imsc.imic.common.StringUtils;

public class TaskDispatchHelper {
    private static final String ROOTNODE = "rootNode";
    private static final String CLOUD = "cloud";
    private static final String APP = "app";
    private static final String SCHEME = "scheme";
    private static final String SEARCH_TEXT_TIME = "searchText_time";
    private static final String SEARCH_TEXT = "searchText";
    private static final String TREE_NODE_CACHE = "treenodecache";
    private static final String SEARCH_DATA = "searchData";

    public static TreeNode buildTreeNode(TreeNode root) {
        DynamicObjectCollection schemes = QueryServiceHelper.query((String)"imic_initialscheme", (String)"id,name,bizapp,bizapp.name", (QFilter[])new QFilter[]{new QFilter("enable", "=", (Object)"1")});
        List appIdList = schemes.stream().map(y -> y.getString("bizapp")).collect(Collectors.toList());
        DynamicObjectCollection appData = QueryServiceHelper.query((String)"bos_devportal_bizapp", (String)"id,name,number,bizcloud,bizcloud.name", (QFilter[])new QFilter[]{new QFilter("id", "in", appIdList)});
        Map appIdMap = appData.stream().collect(Collectors.toMap(y -> y.getString("id"), Function.identity(), (existing, replacement) -> replacement));
        HashMap<String, TreeNode> allNodeMap = new HashMap<String, TreeNode>(16);
        for (DynamicObject scheme : schemes) {
            String schemeId = scheme.getString("id");
            String schemeName = scheme.getString("name");
            String bizAppId = scheme.getString("bizapp");
            DynamicObject bizApp = (DynamicObject)appIdMap.get(bizAppId);
            String appId = bizApp.getString("id");
            String appName = bizApp.getString("name");
            String cldId = bizApp.getString("bizcloud");
            String cldName = bizApp.getString("bizcloud.name");
            if (cldId != null && allNodeMap.get(cldId) == null) {
                TreeNode cldNode = new TreeNode(ROOTNODE, cldId, cldName, (Object)CLOUD);
                allNodeMap.put(cldId, cldNode);
                root.addChild(cldNode);
            }
            if (appId != null && allNodeMap.get(appId) == null) {
                TreeNode appNode = new TreeNode(cldId, appId, appName, (Object)APP);
                allNodeMap.put(appId, appNode);
                ((TreeNode)allNodeMap.get(cldId)).addChild(appNode);
            }
            if (schemeId == null || allNodeMap.get(schemeId) != null) continue;
            TreeNode schemeNode = new TreeNode(appId, schemeId, schemeName, (Object)SCHEME);
            allNodeMap.put(schemeId, schemeNode);
            ((TreeNode)allNodeMap.get(appId)).addChild(schemeNode);
        }
        return root;
    }

    public static QFilter getNodeClickFilter(TreeNode clickNode) {
        QFilter qFilter = null;
        if (Objects.nonNull(clickNode)) {
            Object nodeData = clickNode.getData();
            if (Objects.isNull(nodeData)) {
                return null;
            }
            String nodeDataStr = nodeData.toString();
            if (CLOUD.equalsIgnoreCase(nodeDataStr)) {
                qFilter = new QFilter("bizapp.bizcloud.id", "=", (Object)clickNode.getId());
            } else if (APP.equalsIgnoreCase(nodeDataStr)) {
                qFilter = new QFilter("bizapp.id", "=", (Object)clickNode.getId());
            } else if (SCHEME.equalsIgnoreCase(nodeDataStr)) {
                qFilter = new QFilter("initscheme.id", "=", (Object)Long.valueOf(clickNode.getId()));
            }
        }
        return qFilter;
    }

    public static void searchTreeText(IFormView view, String searchText) {
        IPageCache pageCache = view.getPageCache();
        TreeView treeView = (TreeView)view.getControl("treeview");
        String searchTextFormCache = pageCache.get(SEARCH_TEXT);
        String treeNodeCacheStr = pageCache.get(TREE_NODE_CACHE);
        if (StringUtils.isEmpty(treeNodeCacheStr)) {
            return;
        }
        TreeNode root = (TreeNode)SerializationUtils.fromJsonString((String)treeNodeCacheStr, TreeNode.class);
        List cloudNodes = root.getChildren();
        ArrayList appNodes = new ArrayList(16);
        for (Object cloudNode : cloudNodes) {
            if (cloudNode.getChildren() == null) continue;
            appNodes.addAll(cloudNode.getChildren());
        }
        ArrayList schemeNodes = new ArrayList(16);
        for (TreeNode appNode : appNodes) {
            if (appNode.getChildren() == null) continue;
            schemeNodes.addAll(appNode.getChildren());
        }
        ArrayList<Object> allNode = new ArrayList<Object>(16);
        allNode.add(root);
        allNode.addAll(cloudNodes);
        allNode.addAll(appNodes);
        allNode.addAll(schemeNodes);
        if (searchText.equals(searchTextFormCache)) {
            TaskDispatchHelper.searchByPageCache(view, treeView);
        } else {
            ArrayList<TreeNode> list = new ArrayList<TreeNode>(16);
            for (TreeNode treeNode : allNode) {
                if (!treeNode.getText().contains(searchText)) continue;
                list.add(treeNode);
            }
            if (list.isEmpty()) {
                view.showTipNotification(String.format(ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u4e0e\u201c%s\u201d\u7684\u76f8\u5173\u6570\u636e\u3002", (String)"TaskDispatchHelper_0", (String)"imsc-imic-platform", (Object[])new Object[0]), searchText));
            } else {
                TreeNode focusNode = (TreeNode)list.get(0);
                treeView.focusNode(focusNode);
                TaskDispatchHelper.treeNodeClick(view, focusNode.getId());
                treeView.expand(focusNode.getParentid());
                pageCache.put(SEARCH_TEXT, searchText);
                pageCache.put(SEARCH_TEXT_TIME, "1");
                pageCache.put(SEARCH_DATA, SerializationUtils.toJsonString(list));
            }
        }
    }

    private static void searchByPageCache(IFormView view, TreeView treeView) {
        List listFormCache;
        String searchDataString;
        IPageCache pageCache = view.getPageCache();
        String searchTextTimeString = pageCache.get(SEARCH_TEXT_TIME);
        int searchTextTime = 1;
        if (StringUtils.isNotBlank(searchTextTimeString)) {
            searchTextTime = Integer.parseInt(searchTextTimeString);
        }
        if ((searchDataString = pageCache.get(SEARCH_DATA)) != null && !(listFormCache = SerializationUtils.fromJsonStringToList((String)searchDataString, TreeNode.class)).isEmpty()) {
            if (listFormCache.size() > searchTextTime) {
                TreeNode focusNode = (TreeNode)listFormCache.get(searchTextTime);
                treeView.focusNode(focusNode);
                TaskDispatchHelper.treeNodeClick(view, focusNode.getId());
                treeView.expand(focusNode.getParentid());
                pageCache.put(SEARCH_TEXT_TIME, String.valueOf(searchTextTime + 1));
            } else {
                TreeNode focusNode = (TreeNode)listFormCache.get(0);
                treeView.focusNode(focusNode);
                TaskDispatchHelper.treeNodeClick(view, focusNode.getId());
                treeView.expand(focusNode.getParentid());
                pageCache.put(SEARCH_TEXT_TIME, "1");
            }
        }
    }

    private static void treeNodeClick(IFormView view, String nodeId) {
        IPageCache pageCache = view.getPageCache();
        String treeNodeCacheStr = pageCache.get(TREE_NODE_CACHE);
        if (StringUtils.isEmpty(treeNodeCacheStr)) {
            return;
        }
        TreeNode root = (TreeNode)SerializationUtils.fromJsonString((String)treeNodeCacheStr, TreeNode.class);
        TreeNode checkedNode = root.getTreeNode(nodeId, 10);
        TreeView tree = (TreeView)view.getControl("treeview");
        tree.focusNode(checkedNode);
        tree.expand(nodeId);
    }

    public static void setLabelVal(IFormView view, String labelKey, String labelVal) {
        Label label = (Label)view.getControl(labelKey);
        label.setText(labelVal);
        HashMap<String, String> map = new HashMap<String, String>(1);
        map.put("text", labelVal);
        view.updateControlMetadata(labelKey, map);
    }

    public static void setLabelForceColor(IFormView view, String labelKey, String colorCode) {
        HashMap<String, String> map = new HashMap<String, String>(1);
        map.put("fc", colorCode);
        view.updateControlMetadata(labelKey, map);
    }

    public static void setLabelTip(IFormView view, String labelKey, String tip) {
        Tips tips = new Tips();
        tips.setContent(new LocaleString(tip));
        tips.setType("text");
        Label label = (Label)view.getControl(labelKey);
        label.addTips(tips);
        HashMap<String, String> map = new HashMap<String, String>(1);
        map.put("tips", tip);
        view.updateControlMetadata(labelKey, map);
    }

    public static Map<Long, List<Long>> getTaskApplyOrgMap(Set<DynamicObject> initSchemes) {
        HashMap<Long, List<Long>> taskApplyOrgMap = new HashMap<Long, List<Long>>(16);
        long currUserId = RequestContext.get().getCurrUserId();
        HasPermOrgResult permOrgResult = PermissionServiceHelper.getUserHasPermOrgs((long)currUserId, (boolean)true);
        List hasPermOrgs = permOrgResult.getHasPermOrgs();
        List<Long> schemeIdList = initSchemes.stream().map(scheme -> scheme.getLong("id")).collect(Collectors.toList());
        Map<Long, List<Long>> assignOrgMap = TaskDispatchHelper.getAssignOrgMap(schemeIdList);
        for (DynamicObject scheme2 : initSchemes) {
            long schemeId = scheme2.getLong("id");
            boolean useDimension = scheme2.getBoolean("usedimension");
            if (!useDimension) continue;
            boolean isAllUse = scheme2.getBoolean("isalluse");
            List<String> viewTypeNumberList = TaskDispatchHelper.getViewTypeNumberList(scheme2);
            List<Long> assignOrgList = assignOrgMap.get(schemeId);
            List<Long> orgIds = TaskDispatchHelper.getOrgIdsByOrgViewNumbers(hasPermOrgs, viewTypeNumberList, assignOrgList, isAllUse);
            DynamicObjectCollection groups = scheme2.getDynamicObjectCollection("itemgroup");
            for (DynamicObject group : groups) {
                DynamicObjectCollection entryItems = group.getDynamicObjectCollection("imic_initentry_items");
                for (DynamicObject entryItem : entryItems) {
                    long taskId = entryItem.getLong("id");
                    taskApplyOrgMap.put(taskId, new ArrayList<Long>(orgIds));
                }
            }
        }
        return taskApplyOrgMap;
    }

    private static List<String> getViewTypeNumberList(DynamicObject scheme) {
        ArrayList<String> orgViewTypeNumberList = new ArrayList<String>(10);
        DynamicObjectCollection mulOrgViewType = scheme.getDynamicObjectCollection("mulorgviewtype");
        if (mulOrgViewType != null && !mulOrgViewType.isEmpty()) {
            mulOrgViewType.forEach(l -> orgViewTypeNumberList.add(l.getDynamicObject("fbasedataid").getString("fnumber")));
        }
        return orgViewTypeNumberList;
    }

    private static List<Long> getOrgIdsByOrgViewNumbers(List<Long> hasPermOrgs, List<String> orgViewTypeNumberList, List<Long> assignOrgList, boolean allUse) {
        if (orgViewTypeNumberList.isEmpty()) {
            return hasPermOrgs;
        }
        QFilter viewTypeFilter = new QFilter("number", "in", orgViewTypeNumberList);
        DynamicObjectCollection orgViewSchema = QueryServiceHelper.query((String)"bos_org_viewschema", (String)"id", (QFilter[])viewTypeFilter.toArray());
        QFilter viewFilter = new QFilter("structure.view", "in", orgViewSchema.stream().map(y -> y.get("id")).collect(Collectors.toList()));
        if (!allUse && assignOrgList != null && !assignOrgList.isEmpty()) {
            viewFilter.and(new QFilter("id", "in", assignOrgList));
        }
        List orgIds = QueryServiceHelper.queryPrimaryKeys((String)"bos_org", (QFilter[])viewFilter.toArray(), null, (int)-1);
        List longsInB = orgIds.stream().filter(item -> item instanceof Long).map(Long.class::cast).collect(Collectors.toList());
        return hasPermOrgs.stream().filter(longsInB::contains).collect(Collectors.toList());
    }

    private static Map<Long, List<Long>> getAssignOrgMap(List<Long> schemeIds) {
        QFilter allotSchemeFilter = new QFilter("initialscheme", "in", schemeIds);
        String selectFields = String.join((CharSequence)",", "initialscheme", "org");
        DynamicObjectCollection assignRecords = QueryServiceHelper.query((String)"imic_assignrecord", (String)selectFields, (QFilter[])allotSchemeFilter.toArray());
        return assignRecords.stream().collect(Collectors.groupingBy(assignrecord -> assignrecord.getLong("initialscheme"), Collectors.mapping(assignrecord -> assignrecord.getLong("org"), Collectors.toList())));
    }
}

