/*
 * Decompiled with CFR 0.152.
 */
package kd.imsc.imic.business.workbench;

import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.context.RequestContext;
import kd.bos.data.BusinessDataWriter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.imsc.imic.common.StringUtils;

public class ImicWorkBenchCache {
    private static final String CACHE_DIST_KEY = "imic_workbench";
    private static DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("imic_workbench", new DistributeCacheHAPolicy());

    public static String queryRecord(String key, long userId) {
        String value = ImicWorkBenchCache.getDistributeCache(userId, key);
        if (value != null) {
            return value;
        }
        value = "";
        QFilter filter = new QFilter("user", "=", (Object)userId);
        DynamicObject workBenchRecord = QueryServiceHelper.queryOne((String)"imic_workbenchrecord", (String)key, (QFilter[])filter.toArray());
        if (workBenchRecord != null) {
            value = workBenchRecord.getString(key);
        }
        ImicWorkBenchCache.putDistributeCache(userId, key, value);
        return value;
    }

    public static void updateRecord(String key, Object value, long userId) {
        if (StringUtils.isEmpty(key) || value == null) {
            return;
        }
        QFilter filter = new QFilter("user", "=", (Object)userId);
        DynamicObject workBenchRecord = BusinessDataServiceHelper.loadSingle((String)"imic_workbenchrecord", (QFilter[])filter.toArray());
        if (workBenchRecord == null) {
            workBenchRecord = BusinessDataServiceHelper.newDynamicObject((String)"imic_workbenchrecord");
            workBenchRecord.set("user", (Object)userId);
        }
        workBenchRecord.set(key, value);
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)"imic_workbenchrecord");
        BusinessDataWriter.save((IDataEntityType)dataEntityType, (Object[])new DynamicObject[]{workBenchRecord});
        ImicWorkBenchCache.putDistributeCache(userId, key, String.valueOf(value));
    }

    private static String getDistributeCache(long userId, String key) {
        return (String)cache.get(ImicWorkBenchCache.buildCacheType(userId), key);
    }

    private static void putDistributeCache(long userId, String key, String value) {
        if (value == null) {
            return;
        }
        cache.put(ImicWorkBenchCache.buildCacheType(userId), key, (Object)value);
    }

    private static String buildCacheType(long userId) {
        return String.format("%s.%s.%s", "imicworkbench", RequestContext.get().getAccountId(), userId);
    }
}

