/*
 * Decompiled with CFR 0.152.
 */
package kd.imsc.imic.business.workbench;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.portal.model.AppSchemeType;
import kd.bos.portal.util.PortalUsableFuncUtil;
import kd.bos.portal.util.SerializationUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.imsc.imic.business.workbench.ImicWorkBenchCache;
import kd.imsc.imic.business.workbench.model.InitSchemeModel;
import kd.imsc.imic.business.workbench.model.InitStepModel;
import kd.imsc.imic.common.CommonUtil;
import kd.imsc.imic.common.pagemodel.ImicInitialscheme;

public class ImicWorkBenchHelper {
    private static Log logger = LogFactory.getLog(ImicWorkBenchHelper.class);
    private static final String SRM_APPID = "181/2AWNX/C6";
    private static final String IMIC_APPID = "1KBEY0C69Q92";
    private static final String IMIC_INITGUIDE = "imic_initguide";

    public static List<String> getSchemeNumList(long orgId, long currUserId, IFormView view) {
        QFilter dimenFilter;
        String cacheSchemeStr = ImicWorkBenchCache.queryRecord("schemeorders", currUserId);
        List<String> cacheSchemeNums = new ArrayList(16);
        if (kd.imsc.imic.common.StringUtils.isNotEmpty(cacheSchemeStr)) {
            cacheSchemeNums = (List)SerializationUtils.fromJsonString((String)cacheSchemeStr, List.class);
        }
        if (orgId == 0L) {
            dimenFilter = new QFilter("usedimension", "=", (Object)"0");
        } else {
            dimenFilter = new QFilter("usedimension", "=", (Object)"1").and("isalluse", "=", (Object)"1");
            dimenFilter.or("usedimension", "=", (Object)"0");
            QFilter assignFilter = new QFilter("initialscheme.usedimension", "=", (Object)"1").and("initialscheme.dimensiontype.number", "=", (Object)"bos_org").and("dimension", "=", (Object)String.valueOf(orgId));
            DynamicObjectCollection assignRecords = QueryServiceHelper.query((String)"imic_assignrecord", (String)"initialscheme.number", (QFilter[])assignFilter.toArray(), null);
            if (!assignRecords.isEmpty()) {
                List assignSchemeNums = assignRecords.stream().map(assignRecord -> assignRecord.getString("initialscheme.number")).collect(Collectors.toList());
                dimenFilter.or("number", "in", assignSchemeNums);
            }
        }
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        DynamicObject[] initialSchemes = BusinessDataServiceHelper.load((String)"imic_initialscheme", (String)"number,usedimension,initguide,bizapp.id,mulorgviewtype", (QFilter[])new QFilter[]{enableFilter, dimenFilter});
        QFilter orgFilter = new QFilter("id", "=", (Object)orgId);
        DynamicObject orgDym = BusinessDataServiceHelper.loadSingle((String)"bos_org", (String)"view", (QFilter[])orgFilter.toArray());
        Set<Object> orgFuncSet = new HashSet(16);
        if (orgDym != null) {
            DynamicObjectCollection structures = orgDym.getDynamicObjectCollection("structure");
            orgFuncSet = structures.stream().filter(structure -> structure.getDynamicObject("view") != null).map(structure -> structure.getDynamicObject("view").getString("treetype")).collect(Collectors.toSet());
        }
        ArrayList<String> schemeNums = new ArrayList<String>(16);
        HashMap<String, List> appSchemeMap = new HashMap<String, List>(16);
        List initGuideStrList = Arrays.stream(initialSchemes).map(y -> y.getString("initguide")).filter(kd.imsc.imic.common.StringUtils::isNotBlank).collect(Collectors.toList());
        Map initGuideFormList = BusinessDataServiceHelper.loadFromCache((String)"bos_formmeta", (String)"id,number", (QFilter[])new QFilter[]{new QFilter("number", "in", initGuideStrList)});
        List initGuideNumberList = initGuideFormList.values().stream().map(y -> y.getString("number")).collect(Collectors.toList());
        initGuideNumberList.add(IMIC_INITGUIDE);
        String notExistNumber = "";
        String notExistName = "";
        for (DynamicObject initialScheme : initialSchemes) {
            DynamicObjectCollection mulOrgViewTypes = initialScheme.getDynamicObjectCollection("mulorgviewtype");
            String bizAppId = initialScheme.getString(ImicInitialscheme.EF_bizapp_id);
            String schemeNum = initialScheme.getString("number");
            String schemeName = initialScheme.getLocaleString("name").getLocaleValue();
            String initGuideForm = initialScheme.getString("initguide").trim();
            String useDimension = initialScheme.getString("usedimension");
            if (kd.imsc.imic.common.StringUtils.isEmpty(initGuideForm) || SRM_APPID.equals(bizAppId)) {
                initGuideForm = IMIC_INITGUIDE;
                bizAppId = IMIC_APPID;
            }
            Set schemeOrgFuncs = mulOrgViewTypes.stream().filter(orgViewType -> orgViewType.getDynamicObject("fbasedataid") != null).map(orgViewType -> orgViewType.getDynamicObject("fbasedataid").getString("fnumber")).collect(Collectors.toSet());
            Set sameFuncs = orgFuncSet.stream().filter(schemeOrgFuncs::contains).collect(Collectors.toSet());
            if (sameFuncs.isEmpty() && !mulOrgViewTypes.isEmpty()) continue;
            if (!initGuideNumberList.contains(initGuideForm)) {
                notExistNumber = kd.imsc.imic.common.StringUtils.join(new Object[]{notExistNumber, schemeNum}, "\uff0c");
                notExistName = kd.imsc.imic.common.StringUtils.join(new Object[]{notExistName, schemeName}, "\uff0c");
                continue;
            }
            int result = 0;
            if (String.valueOf(true).equals(useDimension)) {
                result = PermissionServiceHelper.checkPermission((Long)currUserId, (Long)orgId, (String)bizAppId, (String)initGuideForm, (String)"47150e89000000ac");
            } else if (String.valueOf(false).equals(useDimension)) {
                boolean booleanResult = PermissionServiceHelper.checkPermission((Long)currUserId, (String)bizAppId, (String)initGuideForm, (String)"47150e89000000ac");
                int n = result = booleanResult ? 1 : 0;
            }
            if (result == 0) continue;
            appSchemeMap.putIfAbsent(bizAppId, new ArrayList(16));
            ((List)appSchemeMap.get(bizAppId)).add(schemeNum);
            schemeNums.add(schemeNum);
        }
        if (kd.imsc.imic.common.StringUtils.isNotBlank(notExistNumber) && kd.imsc.imic.common.StringUtils.isNotBlank(notExistName) && view != null) {
            String tip = ResManager.loadKDString((String)"\u7f16\u7801\u4e3a\u3010%1$s\u3011\uff0c\u540d\u79f0\u4e3a\u3010%2$s\u3011\u7684\u65b9\u6848\u4e2d\u9875\u9762\u5411\u5bfc\u6807\u8bc6\u5173\u8054\u5143\u6570\u636e\u6709\u8bef\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u68c0\u67e5\u548c\u53cd\u9988\u3002", (String)"ImicWorkBenchHelper_0", (String)"imsc-imic-platform", (Object[])new Object[0]);
            view.showTipNotification(String.format(tip, notExistNumber, notExistName));
        }
        if (!cacheSchemeNums.isEmpty()) {
            ArrayList tempSchemeList1 = new ArrayList(cacheSchemeNums);
            tempSchemeList1.removeAll(schemeNums);
            cacheSchemeNums.removeAll(tempSchemeList1);
            schemeNums.removeAll(cacheSchemeNums);
            cacheSchemeNums.addAll(schemeNums);
        } else {
            List<String> appOrderList = ImicWorkBenchHelper.getMyApps();
            List<String> cacheSchemeNums1 = cacheSchemeNums;
            appOrderList.stream().filter(appSchemeMap::containsKey).forEach(appId -> cacheSchemeNums1.addAll((Collection)appSchemeMap.remove(appId)));
            if (!appSchemeMap.isEmpty()) {
                appSchemeMap.forEach((key, value) -> cacheSchemeNums1.addAll((Collection<String>)value));
            }
            cacheSchemeNums = cacheSchemeNums1;
        }
        ImicWorkBenchCache.updateRecord("schemeorders", SerializationUtils.toJsonString(cacheSchemeNums), currUserId);
        return cacheSchemeNums;
    }

    private static List<String> getMyApps() {
        ArrayList<String> appOrderList = new ArrayList<String>(16);
        PortalUsableFuncUtil portalUtil = new PortalUsableFuncUtil(logger);
        JSONArray allApps = portalUtil.getAllAppsInSystem();
        if (allApps.isEmpty()) {
            return appOrderList;
        }
        JSONArray filterBySchemeApps = portalUtil.getFilterBySchemeApps(allApps, Long.valueOf(RequestContext.get().getCurrUserId()), AppSchemeType.USERSCHEME);
        JSONArray hasPerApps = portalUtil.getAppsAfterFilter(allApps, Long.valueOf(RequestContext.get().getCurrUserId()));
        JSONArray finalFilterApps = ImicWorkBenchHelper.getFilterApps(filterBySchemeApps, hasPerApps);
        for (Object schemeApps : finalFilterApps) {
            JSONArray appArray = (JSONArray)schemeApps;
            for (Object schemeApp : appArray) {
                JSONObject appObject = (JSONObject)schemeApp;
                String appId = appObject.getString("id");
                appOrderList.add(appId);
            }
        }
        return appOrderList;
    }

    private static JSONArray getFilterApps(JSONArray filterBySchemeApps, JSONArray hasPerApps) {
        String openType;
        String id;
        JSONObject cloudOrApp;
        JSONArray cloudAndApp;
        if (filterBySchemeApps.isEmpty() || hasPerApps.isEmpty()) {
            return new JSONArray();
        }
        HashMap<String, String> appsMap = new HashMap<String, String>(16);
        for (Object hasPerAppObj : hasPerApps) {
            cloudAndApp = (JSONArray)hasPerAppObj;
            for (Object cloudAppObj : cloudAndApp) {
                cloudOrApp = (JSONObject)cloudAppObj;
                if (cloudOrApp.get((Object)"iscloud") != null || !kd.imsc.imic.common.StringUtils.isNotBlank(id = cloudOrApp.getString("id"))) continue;
                openType = cloudOrApp.getString("opentype");
                appsMap.put(id, openType);
            }
        }
        Iterator iterator = filterBySchemeApps.iterator();
        while (iterator.hasNext()) {
            Object nextObj = iterator.next();
            cloudAndApp = (JSONArray)nextObj;
            Iterator cloudAppIterator = cloudAndApp.iterator();
            while (cloudAppIterator.hasNext()) {
                Object cloudAppNext = cloudAppIterator.next();
                cloudOrApp = (JSONObject)cloudAppNext;
                if (cloudOrApp.get((Object)"iscloud") != null) continue;
                id = cloudOrApp.getString("id");
                if (kd.imsc.imic.common.StringUtils.isNotBlank(id) && !appsMap.containsKey(id)) {
                    cloudAppIterator.remove();
                    continue;
                }
                openType = cloudOrApp.getString("opentype");
                if (!StringUtils.isEmpty((CharSequence)openType)) continue;
                cloudOrApp.put("opentype", appsMap.get(id));
            }
            if (cloudAndApp.size() != 1) continue;
            iterator.remove();
        }
        return filterBySchemeApps;
    }

    public static List<InitSchemeModel> getAllSchemeInfos(List<String> schemeNums, long orgId) {
        String selectProperties = String.join((CharSequence)",", "id", "name", "number", "usedimension", "defaultcaliber", "bizapp", ImicInitialscheme.EF_itemgroup_seq, ImicInitialscheme.EF_itemgroup_stepname, ImicInitialscheme.EF_entry_initconfigmustset, ImicInitialscheme.EF_entry_itemenabled);
        QFilter schemeFilter = new QFilter("number", "in", schemeNums);
        DynamicObject[] initSchemes = BusinessDataServiceHelper.load((String)"imic_initialscheme", (String)selectProperties, (QFilter[])schemeFilter.toArray());
        List<DynamicObject> initSchemeList = Arrays.stream(initSchemes).sorted((o1, o2) -> {
            String schemeNum1 = o1.getString("number");
            String schemeNum2 = o2.getString("number");
            int i1 = schemeNums.indexOf(schemeNum1);
            int i2 = schemeNums.indexOf(schemeNum2);
            return i1 - i2;
        }).collect(Collectors.toList());
        ArrayList<Long> dimSchemeIds = new ArrayList<Long>(16);
        ArrayList<Long> noDimSchemeIds = new ArrayList<Long>(16);
        for (DynamicObject initScheme : initSchemes) {
            long schemeId = initScheme.getLong("id");
            boolean useDimension = initScheme.getBoolean("usedimension");
            if (useDimension) {
                dimSchemeIds.add(schemeId);
                continue;
            }
            noDimSchemeIds.add(schemeId);
        }
        QFilter dimenFilter = new QFilter("initialscheme", "in", dimSchemeIds).and("org", "=", (Object)orgId);
        QFilter noDimenFilter = new QFilter("initialscheme", "in", noDimSchemeIds);
        DynamicObjectCollection progressColl = QueryServiceHelper.query((String)"imic_progressunit", (String)"initialschemeentryid", (QFilter[])new QFilter[]{dimenFilter.or(noDimenFilter)});
        Set<Long> initEntryIdSet = new HashSet<Long>(16);
        if (!CommonUtil.isNull(progressColl)) {
            initEntryIdSet = progressColl.stream().map(o -> o.getLong("initialschemeentryid")).collect(Collectors.toSet());
        }
        return ImicWorkBenchHelper.prepareSchemeModels(initSchemeList, initEntryIdSet);
    }

    private static List<InitSchemeModel> prepareSchemeModels(List<DynamicObject> initSchemeList, Set<Long> initEntryIdSet) {
        ArrayList<InitSchemeModel> initSchemeModels = new ArrayList<InitSchemeModel>(16);
        Map<String, Boolean> appIdRepetitionMap = initSchemeList.stream().filter(y -> y.getDynamicObject("bizapp") != null).collect(Collectors.groupingBy(y -> y.getDynamicObject("bizapp").getString("id"), Collectors.collectingAndThen(Collectors.counting(), count -> count > 1L)));
        for (DynamicObject initScheme : initSchemeList) {
            long schemeId = initScheme.getLong("id");
            String schemeNum = initScheme.getString("number");
            DynamicObject bizApp = initScheme.getDynamicObject("bizapp");
            String bizAppId = bizApp.getString("id");
            Boolean isRepetition = appIdRepetitionMap.get(bizAppId);
            String localeValue = initScheme.getLocaleString("name").getLocaleValue();
            String schemeName = isRepetition != false ? bizApp.getString("name") + "\uff1a" + localeValue + "" : bizApp.getString("name");
            String defaultCaliber = initScheme.getString("defaultcaliber");
            boolean showMustItems = "B".equals(defaultCaliber);
            if (SRM_APPID.equals(bizAppId)) {
                DynamicObject bizCloud = bizApp.getDynamicObject("bizcloud");
                schemeName = bizCloud.getString("name");
            }
            int schemeCompleteItemSize = 0;
            int schemeAllItemSize = 0;
            DynamicObjectCollection itemGroups = initScheme.getDynamicObjectCollection("itemgroup");
            ArrayList<InitStepModel> initStepModels = new ArrayList<InitStepModel>(itemGroups.size());
            int seq = 0;
            for (DynamicObject itemGroup : itemGroups) {
                InitStepModel initStepModel = new InitStepModel();
                String stepName = itemGroup.getString("stepname");
                DynamicObjectCollection items = itemGroup.getDynamicObjectCollection("imic_initentry_items");
                List enableItems = items.stream().filter(item -> item.getBoolean("itemenabled")).collect(Collectors.toList());
                if (enableItems.isEmpty()) continue;
                List allMustItems = enableItems.stream().filter(item -> item.getBoolean("initconfigmustset")).collect(Collectors.toList());
                ArrayList<Long> stepCompleteItems = new ArrayList<Long>(16);
                ArrayList<Long> stepMustCompleteItems = new ArrayList<Long>(16);
                for (DynamicObject item2 : enableItems) {
                    long itemId = item2.getLong("id");
                    boolean mustSet = item2.getBoolean("initconfigmustset");
                    if (!initEntryIdSet.contains(itemId)) continue;
                    if (mustSet) {
                        stepMustCompleteItems.add(itemId);
                    }
                    stepCompleteItems.add(itemId);
                }
                ++seq;
                int stepAllItemSize = showMustItems ? allMustItems.size() : enableItems.size();
                int stepCompleteItemSize = showMustItems ? stepMustCompleteItems.size() : stepCompleteItems.size();
                schemeAllItemSize += stepAllItemSize;
                schemeCompleteItemSize += stepCompleteItemSize;
                BigDecimal total = new BigDecimal(stepAllItemSize);
                BigDecimal complete = new BigDecimal(stepCompleteItemSize);
                BigDecimal stepInitProgress = total.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : complete.divide(total, 2, RoundingMode.HALF_UP).multiply(BigDecimal.valueOf(100L));
                int stepProgress = stepInitProgress.intValue();
                if (allMustItems.size() == 0 && showMustItems) {
                    stepProgress = 100;
                }
                String stepStatus = "process";
                if (stepProgress == 0) {
                    stepStatus = "wait";
                } else if (stepProgress == 100) {
                    stepStatus = "finish";
                }
                initStepModel.setSeq(seq);
                initStepModel.setStepName(stepName);
                initStepModel.setStepAllItemSize(stepAllItemSize);
                initStepModel.setStepCompleteItemSize(stepCompleteItemSize);
                initStepModel.setStepInitProgress(stepProgress);
                initStepModel.setStepStatus(stepStatus);
                initStepModels.add(initStepModel);
            }
            BigDecimal total = new BigDecimal(schemeAllItemSize);
            BigDecimal complete = new BigDecimal(schemeCompleteItemSize);
            BigDecimal schemeInitProgress = total.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : complete.divide(total, 2, RoundingMode.HALF_UP).multiply(BigDecimal.valueOf(100L));
            int schemeInitPValue = schemeInitProgress.intValue();
            if (schemeAllItemSize == 0 && showMustItems) {
                schemeInitPValue = 100;
            }
            InitSchemeModel initSchemeModel = new InitSchemeModel();
            initSchemeModel.setSchemeId(schemeId);
            initSchemeModel.setSchemeName(schemeName);
            initSchemeModel.setSchemeNum(schemeNum);
            initSchemeModel.setInitProgress(schemeInitPValue);
            initSchemeModel.setInitStepModels(initStepModels);
            initSchemeModels.add(initSchemeModel);
        }
        return initSchemeModels;
    }
}

