/*
 * Decompiled with CFR 0.152.
 */
package kd.imsc.imic.common.fileimport;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import kd.bos.cache.CacheFactory;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.imsc.imic.common.ImicBizException;
import kd.imsc.imic.common.StringUtils;
import kd.imsc.imic.common.fileimport.Header;
import kd.imsc.imic.common.fileimport.ImportEntity;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFClientAnchor;
import org.apache.poi.hssf.usermodel.HSSFDataValidationHelper;
import org.apache.poi.hssf.usermodel.HSSFRichTextString;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.ss.usermodel.Comment;
import org.apache.poi.ss.usermodel.DataValidation;
import org.apache.poi.ss.usermodel.DataValidationConstraint;
import org.apache.poi.ss.usermodel.Drawing;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddressList;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFClientAnchor;
import org.apache.poi.xssf.usermodel.XSSFDataValidation;
import org.apache.poi.xssf.usermodel.XSSFDataValidationHelper;
import org.apache.poi.xssf.usermodel.XSSFRichTextString;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class FileImportUtils {
    private static final Log logger = LogFactory.getLog(FileImportUtils.class);
    private ImportEntity importEntity;

    public static FileImportUtils getInstance(ImportEntity importEntity) {
        return new FileImportUtils(importEntity);
    }

    public FileImportUtils(ImportEntity importEntity) {
        this.importEntity = importEntity;
    }

    public XSSFWorkbook createImportTemplate() {
        XSSFWorkbook excelBook = new XSSFWorkbook();
        this.createImportSheetIndex((Workbook)excelBook, 0);
        return excelBook;
    }

    public void createImportSheetIndex(Workbook excelBook, int startColumn) {
        Sheet sheetIndex = null;
        String sheetName = this.importEntity.getSheetName();
        sheetIndex = StringUtils.isEmpty(sheetName) ? excelBook.createSheet() : excelBook.createSheet(sheetName);
        Row titleRow = this.getRow(sheetIndex, 0);
        Cell titleCell = this.getCell(titleRow, startColumn);
        this.setCellStringValue(titleCell, this.importEntity.getSheetTitle());
        Row noteRow = this.getRow(sheetIndex, 1);
        Cell noteCell = this.getCell(noteRow, startColumn);
        this.setCellStringValue(noteCell, this.importEntity.getSheetNotes());
        this.setFontColor(this.createCellstyle(noteCell), this.createXSSFFont(noteCell), IndexedColors.RED);
        Row headRow = this.getRow(sheetIndex, 2);
        Cell headCell = null;
        Map<String, Header> sheetHeaderMap = this.importEntity.getSheetHeaderMap();
        int i = startColumn;
        for (Map.Entry<String, Header> entry : sheetHeaderMap.entrySet()) {
            Header value = entry.getValue();
            headCell = this.getCell(headRow, i);
            String headName = value.getHeader();
            this.setCellStringValue(headCell, headName);
            CellStyle cellstyle = this.createCellstyle(headCell);
            if (headName != null && headName.startsWith("*")) {
                this.setFontColor(cellstyle, this.createXSSFFont(headCell), IndexedColors.RED);
            }
            this.setBackgroundColor(cellstyle, IndexedColors.GREY_25_PERCENT);
            sheetIndex.setColumnWidth(headCell.getColumnIndex(), 5120);
            this.setCellTips(headCell, value.getTips());
            ++i;
        }
        Map<Integer, String[]> comboBoxList = this.importEntity.getComboBoxList();
        for (Map.Entry<Integer, String[]> entry : comboBoxList.entrySet()) {
            this.setColumnFormatAsCombo(sheetIndex, entry.getKey() + startColumn, entry.getValue());
        }
    }

    public XSSFRow getRow(XSSFSheet sheet, int rownum) {
        XSSFRow row = sheet.getRow(rownum);
        if (row == null) {
            row = sheet.createRow(rownum);
        }
        return row;
    }

    public Row getRow(Sheet sheet, int rownum) {
        Row row = sheet.getRow(rownum);
        if (row == null) {
            row = sheet.createRow(rownum);
        }
        return row;
    }

    public Cell getCell(Row row, int columnIndex) {
        Cell cell = row.getCell(columnIndex);
        if (cell == null) {
            cell = row.createCell(columnIndex);
        }
        return cell;
    }

    public void setCellStringValue(Cell cell, String value) {
        cell.setCellType(CellType.STRING);
        if (value != null && value.length() > Short.MAX_VALUE) {
            value = value.substring(0, Short.MAX_VALUE);
        }
        cell.setCellValue(value);
    }

    public CellStyle createCellstyle(Cell cell) {
        CellStyle cellStyle = cell.getRow().getSheet().getWorkbook().createCellStyle();
        cell.setCellStyle(cellStyle);
        return cellStyle;
    }

    public Font createXSSFFont(Cell cell) {
        return cell.getRow().getSheet().getWorkbook().createFont();
    }

    public void setFontColor(CellStyle cellStyle, Font font, IndexedColors color) {
        font.setColor(color.index);
        cellStyle.setFont(font);
    }

    public void setBackgroundColor(CellStyle cellStyle, IndexedColors color) {
        cellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        cellStyle.setFillForegroundColor(color.index);
    }

    public void setCellTips(Cell cell, String tips) {
        Sheet sheet = cell.getRow().getSheet();
        Drawing draw = sheet.createDrawingPatriarch();
        if (cell instanceof XSSFCell) {
            XSSFClientAnchor clientAnchor = new XSSFClientAnchor();
            Comment comment = draw.createCellComment((ClientAnchor)clientAnchor);
            XSSFRichTextString rtf = new XSSFRichTextString(tips);
            comment.setString((RichTextString)rtf);
            cell.setCellComment(comment);
        } else if (cell instanceof HSSFCell) {
            HSSFClientAnchor clientAnchor = new HSSFClientAnchor();
            Comment comment = draw.createCellComment((ClientAnchor)clientAnchor);
            HSSFRichTextString rtf = new HSSFRichTextString(tips);
            comment.setString((RichTextString)rtf);
            cell.setCellComment(comment);
        }
    }

    public void setColumnFormatAsCombo(Sheet sheet, int columnNum, String[] textList) {
        XSSFDataValidationHelper dvHelper = null;
        if (sheet instanceof XSSFSheet) {
            dvHelper = new XSSFDataValidationHelper((XSSFSheet)sheet);
        } else if (sheet instanceof HSSFSheet) {
            dvHelper = new HSSFDataValidationHelper((HSSFSheet)sheet);
        }
        if (dvHelper != null) {
            DataValidationConstraint dvConstraint = dvHelper.createExplicitListConstraint(textList);
            CellRangeAddressList addressList = new CellRangeAddressList(3, 50000, columnNum, columnNum);
            XSSFDataValidation validation = (XSSFDataValidation)dvHelper.createValidation(dvConstraint, addressList);
            sheet.addValidationData((DataValidation)validation);
        }
    }

    public String saveFileAsUrl(XSSFWorkbook excelBook, String fileName) {
        ByteArrayOutputStream outStream = null;
        ByteArrayInputStream inStream = null;
        try {
            outStream = new ByteArrayOutputStream();
            excelBook.write((OutputStream)outStream);
            outStream.flush();
            inStream = new ByteArrayInputStream(outStream.toByteArray());
            String string = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl(fileName + ".xlsx", (InputStream)inStream, 10000);
            return string;
        }
        catch (IOException e) {
            throw new ImicBizException(e);
        }
        finally {
            if (outStream != null) {
                try {
                    outStream.close();
                }
                catch (IOException e) {
                    logger.error((Throwable)e);
                }
            }
            if (inStream != null) {
                try {
                    inStream.close();
                }
                catch (IOException e) {
                    logger.error((Throwable)e);
                }
            }
        }
    }
}

