/*
 * Decompiled with CFR 0.152.
 */
package kd.imsc.imic.formplugin.initialscheme;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.LongProp;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormConfig;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.list.events.BuildTreeListFilterEvent;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.report.ReportShowParameter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.imsc.imbd.formplugin.AbstractImbdBdTreeListPlugin;
import kd.imsc.imic.business.ShowFormHelper;
import kd.imsc.imic.business.taskdispatch.TaskDispatchHelper;
import kd.imsc.imic.common.CommonUtil;
import kd.imsc.imic.common.ImicBizException;
import kd.imsc.imic.common.InitIalSchemeHelper;
import kd.imsc.imic.common.LockUtils;
import kd.imsc.imic.common.StringUtils;
import kd.imsc.imic.common.taskdispatch.TaskDispatchConst;
import org.apache.commons.collections4.CollectionUtils;

public class InitialSchemeListPlugin
extends AbstractImbdBdTreeListPlugin
implements TreeNodeClickListener {
    private static final Log logger = LogFactory.getLog(InitialSchemeListPlugin.class);
    private static final String CLOUD = "CLOUD";
    private static final String APP = "APP";
    private static final String ALLOT_DIMENSIONALITY = "allotdimensionality";
    private static final String VIEW_PRO = "viewpro";
    private static final String PREVIEW = "preview";
    private static final String CTRL_TREEVIEW = "treeview";
    private static final String TREE_NODE_CACHE = "treenodecache";
    private static final String SEARCH_TEXT_TIME = "searchText_time";
    private static final String RESET_SETTING_CONFIRM = "resetsetting_confirm";
    private static final String DIMENSION_CLOSE_BACK = "dimensionCloseBack";
    private static final String ALLOT_FOR_DIMENSION_DATA = "allotForDimensionData";
    private static final String RESETSETTING = "resetsetting";
    private static final String ALLOTDIMENSIONALITY = "allotdimensionality";
    private static final String ENABLE_CONFIRM = "enableConfirm";
    private static final String DELETE_CONFIRM = "deleteConfirm";
    private static final String DELETE_COMPLETE_UNIT = "deleteCompleteUnit";
    private static final String DIMENSIONID = "dimension";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        TreeView tv = (TreeView)this.getControl(CTRL_TREEVIEW);
        if (tv != null) {
            tv.addTreeNodeClickListener((TreeNodeClickListener)this);
        }
    }

    public void initTreeToolbar(EventObject e) {
        super.initTreeToolbar(e);
        this.getView().setVisible(Boolean.FALSE, new String[]{"btnnew", "btnedit", "btndel"});
    }

    public void beforeShowBill(BeforeShowBillFormEvent e) {
        super.beforeShowBill(e);
        TreeNode focusNode = this.getFocusNode();
        if (Objects.isNull(focusNode)) {
            return;
        }
        Object nodeData = focusNode.getData();
        if (nodeData != null && APP.equalsIgnoreCase(nodeData.toString())) {
            e.getParameter().setCustomParam("bizapp", (Object)focusNode.getId());
        }
        if (!OperationStatus.ADDNEW.equals((Object)e.getParameter().getStatus())) {
            e.getParameter().setStatus(OperationStatus.VIEW);
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.buildRootNode();
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey = evt.getItemKey();
        if ("tblrefresh".equals(itemKey)) {
            this.buildRootNode();
            BillList billList = (BillList)this.getView().getControl("billlistap");
            billList.clearSelection();
            this.getView().updateView("billlistap");
        }
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        String fieldName = args.getFieldName();
        if ("bizapp.id".equals(fieldName)) {
            QFilter filter = new QFilter("type", "!=", (Object)"2");
            args.getQfilters().add(filter);
        }
    }

    private TreeNode buildRootNode() {
        TreeView treeView = (TreeView)this.getControl(CTRL_TREEVIEW);
        TreeNode rootNode = (TreeNode)BizAppServiceHelp.getSubsysTree(null, null, null, (String)"app", (boolean)true, (boolean)true, (boolean)false);
        TreeNode sysRoot = this.getTreeModel().getRoot();
        sysRoot.setIsOpened(true);
        sysRoot.addChildren(rootNode.getChildren());
        treeView.addNode(sysRoot);
        treeView.updateNode(sysRoot);
        this.getPageCache().put(TREE_NODE_CACHE, SerializationUtils.toJsonString((Object)sysRoot));
        return rootNode;
    }

    public void search(SearchEnterEvent searchEnterEvent) {
        TreeView treeView = (TreeView)this.getControl(CTRL_TREEVIEW);
        String searchText = searchEnterEvent.getText();
        String searchTextFormCache = this.getPageCache().get("searchText");
        String treeNodeFromCache = this.getPageCache().get(TREE_NODE_CACHE);
        TreeNode root = (TreeNode)SerializationUtils.fromJsonString((String)treeNodeFromCache, TreeNode.class);
        List cloudNode = root.getChildren();
        ArrayList appNode = new ArrayList();
        for (TreeNode tn : cloudNode) {
            if (tn.getChildren() == null) continue;
            appNode.addAll(tn.getChildren());
        }
        ArrayList<Object> allNode = new ArrayList<Object>();
        allNode.add(root);
        allNode.addAll(cloudNode);
        allNode.addAll(appNode);
        if (searchText.equals(searchTextFormCache)) {
            this.searchByPageCache(treeView);
        } else {
            ArrayList<TreeNode> list = new ArrayList<TreeNode>();
            for (TreeNode treeNode : allNode) {
                if (!treeNode.getText().contains(searchText)) continue;
                list.add(treeNode);
            }
            if (list.isEmpty()) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u4e0e\u201c%s\u201d\u7684\u76f8\u5173\u6570\u636e", (String)"InitialSchemeListPlugin_0", (String)"imsc-imic-platform", (Object[])new Object[0]), searchText));
            } else {
                TreeNode focusNode = (TreeNode)list.get(0);
                treeView.focusNode(focusNode);
                this.treeNodeClick(focusNode.getId());
                treeView.expand(focusNode.getParentid());
                this.getPageCache().put("searchText", searchText);
                this.getPageCache().put(SEARCH_TEXT_TIME, "1");
                this.getPageCache().put("searchData", SerializationUtils.toJsonString(list));
            }
        }
    }

    private void searchByPageCache(TreeView treeView) {
        List listFormCache;
        String searchDataString;
        String searchTextTimeString = this.getPageCache().get(SEARCH_TEXT_TIME);
        int searchTextTime = 1;
        if (StringUtils.isNotBlank(searchTextTimeString)) {
            searchTextTime = Integer.parseInt(searchTextTimeString);
        }
        if ((searchDataString = this.getPageCache().get("searchData")) != null && !(listFormCache = SerializationUtils.fromJsonStringToList((String)searchDataString, TreeNode.class)).isEmpty()) {
            if (listFormCache.size() > searchTextTime) {
                TreeNode focusNode = (TreeNode)listFormCache.get(searchTextTime);
                treeView.focusNode(focusNode);
                this.treeNodeClick(focusNode.getId());
                treeView.expand(focusNode.getParentid());
                this.getPageCache().put(SEARCH_TEXT_TIME, String.valueOf(searchTextTime + 1));
            } else {
                TreeNode focusNode = (TreeNode)listFormCache.get(0);
                treeView.focusNode(focusNode);
                this.treeNodeClick(focusNode.getId());
                treeView.expand(focusNode.getParentid());
                this.getPageCache().put(SEARCH_TEXT_TIME, "1");
            }
        }
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        this.treeNodeClick(evt.getNodeId().toString());
    }

    public void listRowClick(ListRowClickEvent evt) {
        String currentPageCode;
        BillList list = (BillList)this.getView().getControl("billlistap");
        ListSelectedRow info = list.getCurrentSelectedRowInfo();
        if (info != null && "bos_treelist".equals(currentPageCode = this.getView().getFormShowParameter().getFormId())) {
            Object pk = info.getPrimaryKeyValue();
            DynamicObject scheme = BusinessDataServiceHelper.loadSingleFromCache((Object)pk, (String)"imic_initialscheme", (String)"id,number,bizapp");
            String treeNodeId = ((DynamicObject)scheme.get("bizapp")).get("id").toString();
            String treeNodeFromCache = this.getPageCache().get(TREE_NODE_CACHE);
            TreeNode root = (TreeNode)SerializationUtils.fromJsonString((String)treeNodeFromCache, TreeNode.class);
            TreeNode treeNode = root.getTreeNode(treeNodeId);
            this.getTreeModel().setCurrentNodeId((Object)treeNodeId);
            this.getTreeListView().getTreeView().focusNode(treeNode);
        }
    }

    protected QFilter nodeClickFilter() {
        TreeNode focusNode = this.getFocusNode();
        QFilter qFilter = null;
        if (Objects.nonNull(focusNode)) {
            Object nodeData = focusNode.getData();
            if (Objects.isNull(nodeData)) {
                return null;
            }
            qFilter = CLOUD.equalsIgnoreCase(nodeData.toString()) ? new QFilter("bizapp.bizcloud.name", "=", (Object)focusNode.getText()) : new QFilter("bizapp.name", "=", (Object)focusNode.getText());
        }
        return qFilter;
    }

    private TreeNode getFocusNode() {
        Object currentNodeId = this.getTreeModel().getCurrentNodeId();
        TreeNode root = (TreeNode)SerializationUtils.fromJsonString((String)this.getPageCache().get(TREE_NODE_CACHE), TreeNode.class);
        return root.getTreeNode((String)currentNodeId, 10);
    }

    public void buildTreeListFilter(BuildTreeListFilterEvent e) {
        QFilter filter = this.nodeClickFilter();
        if (filter != null) {
            e.addQFilter(filter);
            e.setCancel(true);
        }
    }

    private void treeNodeClick(String nodeId) {
        TreeNode root = (TreeNode)SerializationUtils.fromJsonString((String)this.getPageCache().get(TREE_NODE_CACHE), TreeNode.class);
        TreeNode checkedNode = root.getTreeNode(nodeId, 10);
        TreeView tree = (TreeView)this.getControl(CTRL_TREEVIEW);
        tree.focusNode(checkedNode);
        tree.expand(nodeId);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        if (args.getSource() instanceof AbstractOperate) {
            boolean deleteConfirm;
            AbstractOperate operate = (AbstractOperate)args.getSource();
            String opKey = operate.getOperateKey();
            ListSelectedRowCollection listSelectedRows = this.getSelectedRows();
            if (StringUtils.equals("allotdimensionality", opKey)) {
                if (listSelectedRows.size() != 1) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u9009\u62e9\u4e00\u6761\u6570\u636e\u6267\u884c\u8be5\u64cd\u4f5c\u3002", (String)"InitialSchemeListPlugin_1", (String)"imsc-imic-platform", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                boolean verify = this.schemeAllotValidate(listSelectedRows.get(0).getPrimaryKeyValue());
                if (!verify) {
                    args.setCancel(true);
                }
            } else if (StringUtils.equals(VIEW_PRO, opKey)) {
                if (listSelectedRows.size() > 1) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u9009\u62e9\u4e00\u6761\u6570\u636e\u6267\u884c\u8be5\u64cd\u4f5c\u3002", (String)"InitialSchemeListPlugin_1", (String)"imsc-imic-platform", (Object[])new Object[0]));
                    args.setCancel(true);
                }
            } else if (StringUtils.equals(PREVIEW, opKey) || StringUtils.equals("todispatch", opKey) || StringUtils.equals("todispatchrecord", opKey)) {
                Object[] primaryKeyValues;
                Object schemeId;
                QFilter filter;
                DynamicObject record;
                Object schemeId2;
                DynamicObject scheme;
                boolean isEnable;
                if (listSelectedRows.size() > 1) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u9009\u62e9\u4e00\u6761\u6570\u636e\u6267\u884c\u8be5\u64cd\u4f5c\u3002", (String)"InitialSchemeListPlugin_1", (String)"imsc-imic-platform", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                if (StringUtils.equals("todispatch", opKey) && !(isEnable = (scheme = QueryServiceHelper.queryOne((String)"imic_initialscheme", (String)"id, name,number,enable", (QFilter[])new QFilter[]{new QFilter("id", "=", schemeId2 = listSelectedRows.get(0).getPrimaryKeyValue())})).getBoolean("enable"))) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u65b9\u6848\u5df2\u88ab\u7981\u7528\uff0c\u4e0d\u5141\u8bb8\u8fdb\u884c\u4efb\u52a1\u4e0b\u8fbe\uff0c\u8bf7\u5148\u542f\u7528\u3002", (String)"InitialSchemeListPlugin_21", (String)"imsc-imic-platform", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                if (StringUtils.equals("todispatchrecord", opKey) && (record = QueryServiceHelper.queryOne((String)"imic_taskdispatchrecord", (String)"id", (QFilter[])(filter = new QFilter("initscheme.id", "=", schemeId = (primaryKeyValues = listSelectedRows.getPrimaryKeyValues())[0])).toArray())) == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u65b9\u6848\u6ca1\u6709\u4efb\u52a1\u4e0b\u8fbe\u8bb0\u5f55\u3002", (String)"InitialSchemeListPlugin_18", (String)"imsc-imic-platform", (Object[])new Object[0]));
                    args.setCancel(true);
                }
            } else if (RESETSETTING.equals(opKey)) {
                String tip = ResManager.loadKDString((String)"\u5c06\u91cd\u7f6e\u6240\u9009\u65b9\u6848\u521d\u59cb\u8fdb\u5ea6\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u6e05\u7a7a\u6240\u6709\u4efb\u52a1\u9879\u5b8c\u6210\u8bb0\u5f55\uff1f", (String)"InitialSchemeListPlugin_2", (String)"imsc-imic-platform", (Object[])new Object[0]);
                this.getView().showConfirm(tip, MessageBoxOptions.OKCancel, new ConfirmCallBackListener(RESET_SETTING_CONFIRM, (IFormPlugin)this));
                args.setCancel(true);
            } else if ("enable".equals(opKey)) {
                if (listSelectedRows.size() > 1) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u9009\u62e9\u4e00\u6761\u6570\u636e\u6267\u884c\u8be5\u64cd\u4f5c\u3002", (String)"InitialSchemeListPlugin_1", (String)"imsc-imic-platform", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                Object[] primaryKeyValues = listSelectedRows.getPrimaryKeyValues();
                if (!this.enableValidate(primaryKeyValues[0])) {
                    args.setCancel(true);
                }
            } else if (StringUtils.equals("delete", opKey) && !(deleteConfirm = this.deleteConfirm(listSelectedRows))) {
                args.setCancel(true);
            }
        }
    }

    private boolean deleteConfirm(ListSelectedRowCollection listSelectedRows) {
        QFilter qFilter = new QFilter("id", "in", (Object)listSelectedRows.getPrimaryKeyValues());
        DynamicObjectCollection selectScheme = QueryServiceHelper.query((String)"imic_initialscheme", (String)"id,name", (QFilter[])qFilter.toArray());
        StringBuilder schemeNames = new StringBuilder();
        ArrayList<Object> idList = new ArrayList<Object>(10);
        for (DynamicObject oneScheme : selectScheme) {
            boolean existSchemeRecord = InitIalSchemeHelper.existSchemeRecord(oneScheme.get("id"));
            if (existSchemeRecord) {
                schemeNames.append(oneScheme.get("name")).append(',');
            }
            idList.add(oneScheme.get("id"));
        }
        if (schemeNames.length() > 0) {
            schemeNames.deleteCharAt(schemeNames.lastIndexOf(","));
            String showTip = String.format(ResManager.loadKDString((String)"\u65b9\u6848[%s]\u5df2\u5206\u914d/\u5df2\u5b58\u5728\u4efb\u52a1\u6807\u8bb0\u5b8c\u6210/\u5df2\u6709\u4efb\u52a1\u4e0b\u8fbe\u8bb0\u5f55\uff0c\u662f\u5426\u786e\u8ba4\u5220\u9664\uff1f", (String)"InitialSchemeListPlugin_3", (String)"imsc-imic-platform", (Object[])new Object[0]), schemeNames);
            IFormView view = this.getView();
            if (view == null) {
                return false;
            }
            view.showConfirm(showTip, MessageBoxOptions.OKCancel, new ConfirmCallBackListener(DELETE_CONFIRM, (IFormPlugin)this));
            view.getPageCache().put("deleteSchemeList", JSON.toJSONString(idList));
            return false;
        }
        return true;
    }

    private boolean schemeAllotValidate(Object schemeId) {
        DynamicObject initialScheme = QueryServiceHelper.queryOne((String)"imic_initialscheme", (String)"id,bizapp,bizapp.name", (QFilter[])new QFilter("id", "=", schemeId).toArray());
        String bizApp = initialScheme.getString("bizapp");
        QFilter qFilter = new QFilter("bizapp", "=", (Object)bizApp).and("id", "!=", schemeId);
        QFilter otherCondition = qFilter.and(new QFilter("isalluse", "=", (Object)Boolean.TRUE)).and(new QFilter("enable", "=", (Object)Boolean.TRUE));
        DynamicObject scheme = QueryServiceHelper.queryOne((String)"imic_initialscheme", (String)"id, name", (QFilter[])otherCondition.toArray());
        if (scheme != null) {
            String schemeName = scheme.getString("name");
            String appName = initialScheme.getString("bizapp.name");
            String tips = String.format(ResManager.loadKDString((String)"%1$s\u5e94\u7528\u4e0b\u5df2\u5b58\u5728\u542f\u7528\u72b6\u6001\u5168\u5c40\u5171\u4eab\u65b9\u6848%2$s\uff0c\u5206\u914d\u5c06\u9020\u6210\u65b9\u6848\u51b2\u7a81\uff0c\u4e0d\u5141\u8bb8\u5206\u914d\u5176\u4ed6\u65b9\u6848", (String)"InitialSchemeListPlugin_4", (String)"imsc-imic-platform", (Object[])new Object[0]), appName, schemeName);
            this.getView().showTipNotification(tips);
            return false;
        }
        return true;
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String opKey = args.getOperateKey();
        if (StringUtils.equals(opKey, "allotdimensionality") && args.getOperationResult().isSuccess()) {
            this.allotDimension();
        } else if (StringUtils.equals(opKey, VIEW_PRO) && args.getOperationResult().isSuccess()) {
            this.openReportForm();
        } else if (StringUtils.equals(opKey, PREVIEW) && args.getOperationResult().isSuccess()) {
            ListSelectedRowCollection selectedRows = this.getSelectedRows();
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId("imic_initguide_preview");
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            showParameter.setCustomParam("initSchemeId", selectedRows.get(0).getPrimaryKeyValue());
            showParameter.setCustomParam(PREVIEW, (Object)PREVIEW);
            this.getView().showForm(showParameter);
        } else if ((StringUtils.equals(opKey, "todispatch") || StringUtils.equals(opKey, "todispatchrecord")) && args.getOperationResult().isSuccess()) {
            ListSelectedRow listSelectedRow = this.getSelectedRows().get(0);
            Object schemeId = listSelectedRow.getPrimaryKeyValue();
            HashMap<String, Object> customParams = new HashMap<String, Object>(1);
            customParams.put("schemeid", schemeId);
            if (StringUtils.equals(opKey, "todispatch")) {
                boolean isSuccessLock = LockUtils.requireLock(String.valueOf(schemeId), "default_netctrl", "imic_initialscheme", "todispatch");
                if (!isSuccessLock && LockUtils.checkLock(String.valueOf(schemeId), "default_netctrl", "imic_initialscheme", this.getView())) {
                    return;
                }
                FormShowParameter showParameter = ShowFormHelper.showFrom("imic_taskdispatch", null, null, ShowType.MainNewTabPage, null, customParams);
                this.getView().showForm(showParameter);
            } else {
                ListShowParameter listShowParameter = ShowFormHelper.showListForm("imic_taskdispatchrecord", "imic_taskdispatchtreelist", null, ShowType.MainNewTabPage, false, true, customParams, null, null, null);
                this.getView().showForm((FormShowParameter)listShowParameter);
            }
        }
    }

    private void allotDimension() {
        ListSelectedRowCollection selectedRows = this.getSelectedRows();
        Object schemeId = selectedRows.get(0).getPrimaryKeyValue();
        this.getView().getPageCache().put("schemeId", String.valueOf(schemeId));
        DynamicObject scheme = BusinessDataServiceHelper.loadSingle((Object)schemeId, (String)"imic_initialscheme");
        Object appId = scheme.getDynamicObject("bizapp").getPkValue();
        this.getPageCache().put("appId", String.valueOf(appId));
        String dimensionType = scheme.getDynamicObject("dimensiontype").getString("number");
        this.getPageCache().put("dimensionType", dimensionType);
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)dimensionType);
        ISimpleProperty primaryKey = entityType.getPrimaryKey();
        boolean isIdLongType = primaryKey instanceof LongProp;
        this.getPageCache().put("isIdLongType", String.valueOf(isIdLongType));
        ArrayList<String> orgViewTypeNumberList = new ArrayList<String>(10);
        if (StringUtils.equals(dimensionType, "bos_org")) {
            DynamicObjectCollection mulOrgViewType = scheme.getDynamicObjectCollection("mulorgviewtype");
            if (mulOrgViewType != null && !mulOrgViewType.isEmpty()) {
                mulOrgViewType.forEach(l -> orgViewTypeNumberList.add(l.getDynamicObject("fbasedataid").getString("fnumber")));
            } else {
                DynamicObject orgViewType = scheme.getDynamicObject("orgviewtype");
                if (orgViewType != null) {
                    orgViewTypeNumberList.add(orgViewType.getString("fnumber"));
                }
            }
        }
        this.allotForDimensionOpenForm(schemeId, dimensionType, appId, orgViewTypeNumberList);
    }

    private void openReportForm() {
        ListSelectedRowCollection selectedRows = this.getSelectedRows();
        ReportShowParameter formShowParameter = new ReportShowParameter();
        formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        formShowParameter.setFormId("imic_initprogress");
        ReportQueryParam queryParam = new ReportQueryParam();
        Object schemeId = selectedRows.get(0).getPrimaryKeyValue();
        FilterInfo filter = new FilterInfo();
        DynamicObject value = BusinessDataServiceHelper.loadSingle((Object)schemeId, (String)"imic_initialscheme");
        filter.addFilterItem("schemefiltercolum", (Object)value, "=");
        filter.addFilterItem("bizappfiltercolum", (Object)value.getDynamicObject("bizapp"), "=");
        filter.addFilterItem("rategtfiltercolumn", (Object)0);
        filter.addFilterItem("rateltfiltercolumn", (Object)100);
        boolean useDimension = value.getBoolean("usedimension");
        if (useDimension) {
            DynamicObjectCollection mulOrgViewType = value.getDynamicObjectCollection("mulorgviewtype");
            if (mulOrgViewType != null && !mulOrgViewType.isEmpty()) {
                filter.addFilterItem("mulorgviewtypeculomn", (Object)mulOrgViewType, "in");
            } else {
                DynamicObject orgViewType = value.getDynamicObject("orgviewtype");
                if (orgViewType != null) {
                    filter.addFilterItem("mulorgviewtypeculomn", (Object)orgViewType, "in");
                }
            }
        }
        queryParam.setFilter(filter);
        formShowParameter.setQueryParam(queryParam);
        formShowParameter.setCustomParam("selectSchemeId", schemeId);
        this.getView().showForm((FormShowParameter)formShowParameter);
    }

    private void allotForDimensionOpenForm(Object schemeId, String entityNumber, Object bizAppid, List<String> orgViewTypeNumberList) {
        if (StringUtils.isEmpty(entityNumber)) {
            return;
        }
        ListShowParameter listShowParameter = new ListShowParameter();
        listShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        FormConfig listFormConfig = FormMetadataCache.getListFormConfig((String)entityNumber);
        if (listFormConfig == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u65b9\u6848\u7684\u7ef4\u5ea6\u7c7b\u578b\u914d\u7f6e\u9519\u8bef\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u7ef4\u5ea6\u7c7b\u578b\u3002", (String)"InitialSchemeListPlugin_15", (String)"imsc-imic-platform", (Object[])new Object[0]));
            return;
        }
        String f7ListFormId = listFormConfig.getF7ListFormId();
        listShowParameter.setFormId(f7ListFormId);
        listShowParameter.setBillFormId(entityNumber);
        listShowParameter.setMultiSelect(true);
        listShowParameter.setShowApproved(false);
        listShowParameter.setF7Style(0);
        StyleCss style = new StyleCss();
        style.setWidth("1000");
        style.setHeight("600");
        listShowParameter.getOpenStyle().setInlineStyleCss(style);
        listShowParameter.setShowTitle(false);
        listShowParameter.setLookUp(true);
        Set<Object> existIds = this.getAppAllotedDataIds(bizAppid, schemeId, entityNumber);
        QFilter qFilter = new QFilter("id", "not in", existIds);
        if (!orgViewTypeNumberList.isEmpty()) {
            DynamicObjectCollection orgs = QueryServiceHelper.query((String)entityNumber, (String)"id", (QFilter[])qFilter.toArray());
            List<Long> ids = orgs.stream().map(l -> l.getLong("id")).collect(Collectors.toList());
            List<Long> showIds = CommonUtil.getOrgIdsByOrgViewNumbers(ids, orgViewTypeNumberList);
            qFilter = new QFilter("id", "in", showIds);
        }
        listShowParameter.getListFilterParameter().getQFilters().add(qFilter);
        listShowParameter.setCustomParam("islockfunc", (Object)Boolean.TRUE);
        Set<Object> selectPks = this.getAssignRecords(new Object[]{schemeId}, entityNumber);
        this.getView().getPageCache().put(ALLOT_FOR_DIMENSION_DATA, JSON.toJSONString(selectPks));
        ListSelectedRowCollection selectedRows = new ListSelectedRowCollection();
        selectPks.forEach(pk -> selectedRows.add((Object)new ListSelectedRow(pk)));
        listShowParameter.setListSelectedRowCollection(selectedRows);
        listShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, DIMENSION_CLOSE_BACK));
        this.getView().showForm((FormShowParameter)listShowParameter);
    }

    private Set<Object> getAppAllotedDataIds(Object appId, Object curSchemeId, String entityNumber) {
        QFilter enableFilter = new QFilter("enable", "=", (Object)Boolean.TRUE);
        QFilter appIdFilter = new QFilter("bizapp", "=", appId);
        List schemeIds = QueryServiceHelper.queryPrimaryKeys((String)"imic_initialscheme", (QFilter[])new QFilter[]{enableFilter, appIdFilter}, null, (int)-1);
        schemeIds.remove(curSchemeId);
        return this.getAssignRecords(schemeIds.toArray(), entityNumber);
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        String actionId = event.getActionId();
        Object returnData = event.getReturnData();
        if (StringUtils.equals(actionId, DIMENSION_CLOSE_BACK) && returnData instanceof ListSelectedRowCollection) {
            ListSelectedRowCollection selectedRows = (ListSelectedRowCollection)returnData;
            List<Object> newAllotDataIds = selectedRows.stream().map(ListSelectedRow::getPrimaryKeyValue).collect(Collectors.toList());
            Long schemeId = Long.valueOf(this.getPageCache().get("schemeId"));
            String bizAppId = this.getPageCache().get("appId");
            Set<Object> existIds = this.getAppAllotedDataIds(bizAppId, schemeId, "bos_org");
            boolean isExist = newAllotDataIds.stream().anyMatch(existIds::contains);
            if (isExist) {
                String tip = ResManager.loadKDString((String)"\u5206\u914d\u5931\u8d25\uff0c\u521d\u59cb\u5316\u5206\u914d\u8bb0\u5f55\u53d1\u751f\u53d8\u5316\uff0c\u8bf7\u91cd\u65b0\u5206\u914d\u3002", (String)"InitialSchemeListPlugin_17", (String)"imsc-imic-platform", (Object[])new Object[0]);
                this.getView().showTipNotification(tip, Integer.valueOf(5000));
                return;
            }
            String alreadyAllotDataIdStr = this.getView().getPageCache().get(ALLOT_FOR_DIMENSION_DATA);
            List alreadyAllotIdList = (List)JSON.parse((String)alreadyAllotDataIdStr);
            boolean isIdLongType = Boolean.parseBoolean(this.getPageCache().get("isIdLongType"));
            List oldAllotDataIds = isIdLongType ? alreadyAllotIdList.stream().map(l -> Long.valueOf(String.valueOf(l))).collect(Collectors.toList()) : alreadyAllotIdList.stream().map(String::valueOf).collect(Collectors.toList());
            List<Object> deletedDmsnIds = oldAllotDataIds.stream().filter(a -> !newAllotDataIds.contains(a)).collect(Collectors.toList());
            if (!deletedDmsnIds.isEmpty()) {
                QFilter dmsnFilter = new QFilter(DIMENSIONID, "in", deletedDmsnIds.stream().map(String::valueOf).collect(Collectors.toList()));
                QFilter schemeFilter = new QFilter("initialscheme", "=", (Object)schemeId);
                DynamicObjectCollection deleteCompleteRecord = QueryServiceHelper.query((String)"imic_progressunit", (String)"id,dimension,initialscheme", (QFilter[])new QFilter[]{dmsnFilter, schemeFilter});
                QFilter recordFilter = new QFilter(TaskDispatchConst.INITSCHEME_ID, "=", (Object)schemeId).and("dispatchorg.fbasedataid.id", "in", deletedDmsnIds);
                DynamicObjectCollection dispatchRecord = QueryServiceHelper.query((String)"imic_taskdispatchrecord", (String)"id, dispatchorg.fbasedataid.id", (QFilter[])recordFilter.toArray());
                if (!deleteCompleteRecord.isEmpty() || !dispatchRecord.isEmpty()) {
                    ArrayList<Object> deleteDimensionId = new ArrayList<Object>(10);
                    for (DynamicObject dynamicObject : deleteCompleteRecord) {
                        if (isIdLongType) {
                            deleteDimensionId.add(dynamicObject.getLong(DIMENSIONID));
                            continue;
                        }
                        deleteDimensionId.add(dynamicObject.getString(DIMENSIONID));
                    }
                    for (DynamicObject dynamicObject : dispatchRecord) {
                        Object dispatchOrgId = dynamicObject.get("dispatchorg.fbasedataid.id");
                        if (!deletedDmsnIds.contains(dispatchOrgId)) continue;
                        if (isIdLongType) {
                            deleteDimensionId.add(dynamicObject.getLong("dispatchorg.fbasedataid.id"));
                            continue;
                        }
                        deleteDimensionId.add(dynamicObject.getString("dispatchorg.fbasedataid.id"));
                    }
                    String dimensionType = this.getPageCache().get("dimensionType");
                    DynamicObjectCollection query = QueryServiceHelper.query((String)dimensionType, (String)"name", (QFilter[])new QFilter[]{new QFilter("id", "in", deleteDimensionId)});
                    ArrayList tips = new ArrayList(10);
                    query.forEach(data -> tips.add(data.getString("name")));
                    String showTip = String.format(ResManager.loadKDString((String)"\u53d6\u6d88\u5206\u914d%s\u5df2\u5b58\u5728\u6807\u8bb0\u5b8c\u6210\u4efb\u52a1\u9879\u548c\u4efb\u52a1\u4e0b\u8fbe\u8bb0\u5f55\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u53d6\u6d88\u5206\u914d\u5e76\u5220\u9664\u5b8c\u6210\u8bb0\u5f55\u548c\u4efb\u52a1\u4e0b\u8fbe\u8bb0\u5f55\uff1f", (String)"InitialSchemeListPlugin_5", (String)"imsc-imic-platform", (Object[])new Object[0]), Arrays.toString(tips.toArray()));
                    this.getView().showConfirm(showTip, MessageBoxOptions.OKCancel, new ConfirmCallBackListener(DELETE_COMPLETE_UNIT, (IFormPlugin)this));
                    this.getPageCache().put("dimensionSelectId", JSON.toJSONString(newAllotDataIds));
                    this.getPageCache().put("deletedDataIds", JSON.toJSONString(deletedDmsnIds));
                    return;
                }
            }
            this.updateAllotRecords(newAllotDataIds, deletedDmsnIds);
        }
    }

    private void updateAllotRecords(List<Object> nowAllotIds, List<Object> deleteAllotIds) throws KDBizException {
        String allotSchemeId = this.getView().getPageCache().get("schemeId");
        Long schemeId = Long.parseLong(allotSchemeId);
        String dimensionType = this.getView().getPageCache().get("dimensionType");
        Set<Object> oldAllotIds = this.getAssignRecords(new Long[]{schemeId}, dimensionType);
        Collection needNewAllotIds = CollectionUtils.subtract(nowAllotIds, oldAllotIds);
        ArrayList newAllotDatas = new ArrayList();
        needNewAllotIds.forEach(id -> {
            DynamicObject newAllotRecord = BusinessDataServiceHelper.newDynamicObject((String)"imic_assignrecord");
            newAllotRecord.set("initialscheme", (Object)schemeId);
            if ("bos_org".equals(dimensionType)) {
                newAllotRecord.set("org", (Object)Long.valueOf(String.valueOf(id)));
            }
            newAllotRecord.set(DIMENSIONID, id);
            newAllotDatas.add(newAllotRecord);
        });
        try (TXHandle h1 = TX.requiresNew();){
            try {
                SaveServiceHelper.save((DynamicObject[])newAllotDatas.toArray(new DynamicObject[0]));
                if (!deleteAllotIds.isEmpty()) {
                    QFilter schemeFilter = new QFilter("initialscheme", "=", (Object)schemeId);
                    QFilter dmsnDeleteFilter = new QFilter(DIMENSIONID, "in", deleteAllotIds.stream().map(String::valueOf).collect(Collectors.toList()));
                    DeleteServiceHelper.delete((String)"imic_assignrecord", (QFilter[])new QFilter[]{schemeFilter, dmsnDeleteFilter});
                    DeleteServiceHelper.delete((String)"imic_progressunit", (QFilter[])new QFilter[]{schemeFilter, dmsnDeleteFilter});
                    this.updateRecordOrgAndCheckResult(schemeId, deleteAllotIds);
                }
                this.updateDispatchStatus(schemeId);
            }
            catch (Exception e) {
                logger.error("\u5206\u914d\u5931\u8d25" + schemeId, (Throwable)e);
                h1.markRollback();
                throw new ImicBizException(ResManager.loadKDString((String)"\u5206\u914d\u5931\u8d25", (String)"InitialSchemeListPlugin_6", (String)"imsc-imic-platform", (Object[])new Object[0]), e);
            }
        }
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5206\u914d\u6210\u529f", (String)"InitialSchemeListPlugin_7", (String)"imsc-imic-platform", (Object[])new Object[0]));
    }

    private void updateDispatchStatus(Long schemeId) {
        DynamicObject scheme = BusinessDataServiceHelper.loadSingle((Object)schemeId, (String)"imic_initialscheme");
        HashSet<DynamicObject> schemes = new HashSet<DynamicObject>(1);
        schemes.add(scheme);
        Map<Long, List<Long>> taskApplyOrgMap = TaskDispatchHelper.getTaskApplyOrgMap(schemes);
        QFilter recordFilter = new QFilter(TaskDispatchConst.INITSCHEME_ID, "=", (Object)schemeId);
        String selectRecordProperties = String.join((CharSequence)",", "inittask", "dispatchstatus", "chargeuser", "dispatchorg");
        DynamicObject[] dispatchRecords = BusinessDataServiceHelper.load((String)"imic_taskdispatchrecord", (String)selectRecordProperties, (QFilter[])recordFilter.toArray());
        HashMap taskOrgMap = new HashMap(16);
        for (DynamicObject dispatchRecord : dispatchRecords) {
            DynamicObject task = dispatchRecord.getDynamicObject("inittask");
            long taskId = task.getLong("id");
            DynamicObjectCollection dispatchOrgs = dispatchRecord.getDynamicObjectCollection("dispatchorg");
            List dipatchOrgIdList = dispatchOrgs.stream().map(dispatchOrg -> dispatchOrg.getLong("fbasedataid_id")).collect(Collectors.toList());
            taskOrgMap.putIfAbsent(taskId, new ArrayList(16));
            ((List)taskOrgMap.get(taskId)).addAll(dipatchOrgIdList);
        }
        ArrayList<Long> disPatchedTaskIds = new ArrayList<Long>(16);
        ArrayList<Long> unDisPatchTaskIds = new ArrayList<Long>(16);
        for (Map.Entry taskOrgEntry : taskOrgMap.entrySet()) {
            Long taskId = (Long)taskOrgEntry.getKey();
            List newOrgList = (List)taskOrgEntry.getValue();
            List<Long> applyOrgList = taskApplyOrgMap.get(taskId);
            if (applyOrgList == null) continue;
            applyOrgList.removeAll(newOrgList);
            if (applyOrgList.isEmpty()) {
                disPatchedTaskIds.add(taskId);
                continue;
            }
            unDisPatchTaskIds.add(taskId);
        }
        for (DynamicObject dispatchRecord : dispatchRecords) {
            DynamicObject task = dispatchRecord.getDynamicObject("inittask");
            long taskId = task.getLong("id");
            if (disPatchedTaskIds.contains(taskId)) {
                dispatchRecord.set("dispatchstatus", (Object)"1");
                continue;
            }
            if (!unDisPatchTaskIds.contains(taskId)) continue;
            dispatchRecord.set("dispatchstatus", (Object)"0");
        }
        try {
            SaveServiceHelper.save((DynamicObject[])dispatchRecords);
        }
        catch (Exception ex) {
            throw new KDBizException(ResManager.loadKDString((String)"\u901a\u8fc7SaveServiceHelper.update()\u65b9\u6cd5\u66f4\u65b0\u4e0b\u8fbe\u72b6\u6001\u51fa\u73b0\u5f02\u5e38\u3002", (String)"InitialSchemeListPlugin_19", (String)"imsc-imic-platform", (Object[])new Object[0]));
        }
    }

    private void updateRecordOrgAndCheckResult(Long schemeId, List<Object> deleteAllotIds) {
        DynamicObject[] dispatchRecords;
        QFilter recordFilter = new QFilter(TaskDispatchConst.INITSCHEME_ID, "=", (Object)schemeId).and("dispatchorg.fbasedataid.id", "in", deleteAllotIds);
        String selectProperties = String.join((CharSequence)",", "id", "dispatchorg", "dispatchstatus");
        for (DynamicObject dispatchRecord : dispatchRecords = BusinessDataServiceHelper.load((String)"imic_taskdispatchrecord", (String)selectProperties, (QFilter[])recordFilter.toArray())) {
            DynamicObjectCollection dispatchOrgs = dispatchRecord.getDynamicObjectCollection("dispatchorg");
            DynamicObjectCollection newDispatchOrgs = new DynamicObjectCollection();
            for (DynamicObject dispatchOrg : dispatchOrgs) {
                if (deleteAllotIds.contains(dispatchOrg.get("fbasedataid_id"))) continue;
                newDispatchOrgs.add((Object)dispatchOrg);
            }
            dispatchRecord.set("dispatchorg", (Object)newDispatchOrgs);
        }
        try {
            SaveServiceHelper.save((DynamicObject[])dispatchRecords);
            QFilter checkResultFilter = new QFilter(TaskDispatchConst.INITSCHEME_ID, "=", (Object)schemeId).and("dispatchorg.id", "in", deleteAllotIds);
            DeleteServiceHelper.delete((String)"imic_checkresultrecord", (QFilter[])checkResultFilter.toArray());
        }
        catch (Exception ex) {
            throw new KDBizException(ResManager.loadKDString((String)"\u66f4\u65b0\u4efb\u52a1\u4e0b\u8fbe\u8bb0\u5f55\u4e0b\u8fbe\u7ec4\u7ec7\u6216\u8005\u5220\u9664\u4efb\u52a1\u68c0\u67e5\u7ed3\u679c\u51fa\u73b0\u5f02\u5e38\u3002", (String)"InitialSchemeListPlugin_20", (String)"imsc-imic-platform", (Object[])new Object[0]));
        }
    }

    private Set<Object> getAssignRecords(Object[] schemeIds, String entityNumber) {
        HashSet<Object> allotDataIds = new HashSet<Object>();
        QFilter qFilter = new QFilter("initialscheme", "in", (Object)schemeIds);
        DynamicObjectCollection allotRecords = QueryServiceHelper.query((String)"imic_assignrecord", (String)"id, dimension, org", (QFilter[])qFilter.toArray());
        if (!allotRecords.isEmpty()) {
            MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
            ISimpleProperty primaryKey = entityType.getPrimaryKey();
            boolean isLongId = primaryKey instanceof LongProp;
            if (isLongId) {
                allotRecords.forEach(allotRecord -> allotDataIds.add(allotRecord.getLong(DIMENSIONID)));
            } else {
                allotRecords.forEach(allotRecord -> allotDataIds.add(allotRecord.getString(DIMENSIONID)));
            }
        }
        return allotDataIds;
    }

    private boolean enableValidate(Object selectedRowId) {
        DynamicObject selectScheme = InitIalSchemeHelper.getInitialScheme(selectedRowId);
        boolean enable = selectScheme.getBoolean("enable");
        if (enable) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u4e3a\u53ef\u7528\u72b6\u6001", (String)"InitialSchemeListPlugin_16", (String)"imsc-imic-platform", (Object[])new Object[0]));
            return false;
        }
        boolean useDimension = selectScheme.getBoolean("usedimension");
        if (!useDimension) {
            QFilter qFilter = new QFilter("bizapp", "=", selectScheme.getDynamicObject("bizapp").getPkValue());
            qFilter.and(new QFilter("id", "not in", selectScheme.getPkValue()));
            boolean exists = QueryServiceHelper.exists((String)"imic_initialscheme", (QFilter[])qFilter.toArray());
            if (!exists) {
                return true;
            }
            String tips = ResManager.loadKDString((String)"\u5c06\u7981\u7528\u5f53\u524d\u5e94\u7528\u4e0b\u5176\u4ed6\u521d\u59cb\u5316\u65b9\u6848\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u7ee7\u7eed\u3002", (String)"InitialSchemeListPlugin_8", (String)"imsc-imic-platform", (Object[])new Object[0]);
            this.getView().showConfirm(tips, MessageBoxOptions.OKCancel, new ConfirmCallBackListener(ENABLE_CONFIRM, (IFormPlugin)this));
            this.getPageCache().put("enableSchemeId", selectScheme.getPkValue().toString());
            return false;
        }
        return true;
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        super.confirmCallBack(event);
        String callBackId = event.getCallBackId();
        if (StringUtils.equals(RESET_SETTING_CONFIRM, callBackId) && event.getResult() == MessageBoxResult.Yes) {
            ListSelectedRowCollection selectedRows = this.getSelectedRows();
            for (ListSelectedRow selectedRow : selectedRows) {
                QFilter qFilter = new QFilter("initialscheme", "=", selectedRow.getPrimaryKeyValue());
                DeleteServiceHelper.delete((String)"imic_progressunit", (QFilter[])qFilter.toArray());
            }
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u91cd\u7f6e\u6210\u529f", (String)"InitialSchemeListPlugin_9", (String)"imsc-imic-platform", (Object[])new Object[0]));
        } else if (StringUtils.equals(ENABLE_CONFIRM, callBackId)) {
            this.schemeEnableConfirm(event);
        } else if (StringUtils.equals(DELETE_CONFIRM, callBackId) && event.getResult() == MessageBoxResult.Yes) {
            String deleteSchemeList = this.getView().getPageCache().get("deleteSchemeList");
            List deleteSchemeIdList = (List)JSON.parse((String)deleteSchemeList);
            OperateOption option = OperateOption.create();
            option.setVariableValue("ignorerefentityids", "imic_progressunit,imic_assignrecord,imic_taskdispatchrecord,imic_checkresultrecord");
            OperationResult result = OperationServiceHelper.executeOperate((String)"delete", (String)"imic_initialscheme", (Object[])deleteSchemeIdList.toArray(new Object[0]), (OperateOption)option);
            if (result.isSuccess()) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f", (String)"InitialSchemeListPlugin_10", (String)"imsc-imic-platform", (Object[])new Object[0]));
            } else {
                StringBuilder errorMessage = new StringBuilder();
                errorMessage.append(ResManager.loadKDString((String)"\u5220\u9664\u5931\u8d25", (String)"InitialSchemeListPlugin_11", (String)"imsc-imic-platform", (Object[])new Object[0])).append(',');
                result.getAllErrorOrValidateInfo().forEach(errorMessage::append);
                this.getView().showErrorNotification(errorMessage.toString());
            }
            this.getView().updateView("billlistap");
        } else if (StringUtils.equals(DELETE_COMPLETE_UNIT, callBackId)) {
            if (event.getResult() == MessageBoxResult.Yes) {
                String dimensionSelectId = this.getPageCache().get("dimensionSelectId");
                String deleteCompleteRecordForDimensionId = this.getPageCache().get("deletedDataIds");
                List<Object> selectIds = (List<Object>)JSON.parse((String)dimensionSelectId);
                List<Object> deletedDmsnIds = (List<Object>)JSON.parse((String)deleteCompleteRecordForDimensionId);
                boolean isIdLongType = Boolean.parseBoolean(this.getPageCache().get("isIdLongType"));
                if (isIdLongType) {
                    selectIds = selectIds.stream().map(id -> Long.valueOf(String.valueOf(id))).collect(Collectors.toList());
                    deletedDmsnIds = deletedDmsnIds.stream().map(id -> Long.valueOf(String.valueOf(id))).collect(Collectors.toList());
                } else {
                    selectIds = selectIds.stream().map(String::valueOf).collect(Collectors.toList());
                    deletedDmsnIds = deletedDmsnIds.stream().map(String::valueOf).collect(Collectors.toList());
                }
                this.updateAllotRecords(selectIds, deletedDmsnIds);
            }
            this.getPageCache().remove("dimensionSelectId");
            this.getPageCache().remove("deletedDataIds");
        }
    }

    private void schemeEnableConfirm(MessageBoxClosedEvent event) {
        if (event.getResult() == MessageBoxResult.Yes) {
            String enableSchemeId = this.getView().getPageCache().get("enableSchemeId");
            OperationResult enableResult = OperationServiceHelper.executeOperate((String)"enable", (String)"imic_initialscheme", (Object[])new Object[]{Long.valueOf(enableSchemeId)}, (OperateOption)OperateOption.create());
            if (enableResult.isSuccess()) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u542f\u7528\u6210\u529f", (String)"InitialSchemeListPlugin_12", (String)"imsc-imic-platform", (Object[])new Object[0]));
                this.getView().updateView("billlistap");
            } else {
                String message = enableResult.getMessage();
                if (StringUtils.isBlank(message) || StringUtils.equals(message, "null")) {
                    message = ((IOperateInfo)enableResult.getAllErrorOrValidateInfo().get(0)).getMessage();
                }
                String errorMessage = String.format(ResManager.loadKDString((String)"\u542f\u7528\u5931\u8d25\uff0c%s", (String)"InitialSchemeListPlugin_14", (String)"imsc-imic-platform", (Object[])new Object[0]), message);
                this.getView().showErrorNotification(errorMessage);
            }
        }
        this.getView().getPageCache().remove("enableSchemeId");
    }
}

