/*
 * Decompiled with CFR 0.152.
 */
package kd.imsc.imic.formplugin.initialscheme;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.imsc.imic.common.CommonUtil;
import kd.imsc.imic.common.pagemodel.ImicInitialscheme;

public class OrgInitialSchemeFormPlugin
extends AbstractFormPlugin {
    private static final String INITSCHEMEID = "initSchemeId";
    private static final String DEFAULTCALIBER = "defaultcaliber";
    private static final String USEDIMENSION = "usedimension";

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        long initSchemeId = CommonUtil.getLongCustomParamValue(this.getView().getParentView(), INITSCHEMEID);
        this.createInitSchemeEntry(initSchemeId);
        String defaultcaliber = CommonUtil.getStringCustomParamValue(this.getView().getParentView(), DEFAULTCALIBER);
        boolean isVisible = "C".equals(defaultcaliber);
        this.getView().setVisible(Boolean.valueOf(isVisible), new String[]{"stepallprogress", "allfinish", "allunfinish", "stepmustsetprogress", "mustsetfinish", "mustsetunfinish"});
        this.getView().setVisible(Boolean.valueOf(!isVisible), new String[]{"stepprogress", "stepfinish", "stepunfinish"});
    }

    private void createInitSchemeEntry(long initSchemeId) {
        if (initSchemeId == 0L) {
            return;
        }
        QFilter qFilter = new QFilter("id", "=", (Object)initSchemeId);
        qFilter.and(new QFilter(ImicInitialscheme.EF_initentry_itemenabled, "=", (Object)Boolean.TRUE));
        String selectFields = String.join((CharSequence)",", "id", ImicInitialscheme.EF_itemgroup_id, ImicInitialscheme.EF_itemgroup_seq, ImicInitialscheme.EF_itemgroup_stepname, ImicInitialscheme.EF_initentry_items_id, ImicInitialscheme.EF_initentry_itemname, ImicInitialscheme.EF_initentry_initconfigmustset);
        String orderbys = String.join((CharSequence)",", "id", ImicInitialscheme.EF_itemgroup_seq);
        DynamicObjectCollection schemeColl = QueryServiceHelper.query((String)"imic_initialscheme", (String)selectFields, (QFilter[])qFilter.toArray(), (String)orderbys);
        if (!CommonUtil.isNull(schemeColl)) {
            DynamicObjectCollection entryColl = this.getModel().getEntryEntity("entryentity");
            entryColl.clear();
            QFilter filter = new QFilter("initialscheme", "=", (Object)initSchemeId);
            boolean usedImension = CommonUtil.getBooleanCustomParamValue(this.getView().getParentView(), USEDIMENSION);
            if (usedImension) {
                long orgId = CommonUtil.getLongCustomParamValue(this.getView(), "pkId");
                filter.and(new QFilter("org", "=", (Object)orgId));
            }
            DynamicObjectCollection progressColl = QueryServiceHelper.query((String)"imic_progressunit", (String)"initialschemeentryid", (QFilter[])filter.toArray());
            Set<Object> initEntryIdSet = new HashSet(16);
            if (!CommonUtil.isNull(progressColl)) {
                initEntryIdSet = progressColl.stream().map(o -> o.getLong("initialschemeentryid")).collect(Collectors.toSet());
            }
            Map allStepEntryMap = schemeColl.stream().collect(Collectors.groupingBy(o -> o.getLong(ImicInitialscheme.EF_itemgroup_id), LinkedHashMap::new, Collectors.toList()));
            for (Map.Entry stepMapEntry : allStepEntryMap.entrySet()) {
                DynamicObject entryDynObj = entryColl.addNew();
                List initEntryList = (List)stepMapEntry.getValue();
                ArrayList<String> completeItemNameList = new ArrayList<String>(16);
                ArrayList<String> completeMustItemNameList = new ArrayList<String>(16);
                ArrayList<String> unCompleteItemNameList = new ArrayList<String>(16);
                ArrayList<String> unCompleteMustItemNameList = new ArrayList<String>(16);
                for (DynamicObject initEntryDynObj : initEntryList) {
                    String itemName = initEntryDynObj.getString(ImicInitialscheme.EF_initentry_itemname);
                    if (initEntryIdSet.contains(initEntryDynObj.getLong(ImicInitialscheme.EF_initentry_items_id))) {
                        if (initEntryDynObj.getBoolean(ImicInitialscheme.EF_initentry_initconfigmustset)) {
                            completeMustItemNameList.add(itemName);
                        }
                        completeItemNameList.add(itemName);
                        continue;
                    }
                    if (initEntryDynObj.getBoolean(ImicInitialscheme.EF_initentry_initconfigmustset)) {
                        unCompleteMustItemNameList.add(itemName);
                    }
                    unCompleteItemNameList.add(itemName);
                }
                int allSize = initEntryList.size();
                long mustSize = initEntryList.stream().filter(o -> o.getBoolean(ImicInitialscheme.EF_initentry_initconfigmustset)).count();
                int completeAllSize = completeItemNameList.size();
                int completeMustSize = completeMustItemNameList.size();
                entryDynObj.set("stepname", (Object)((DynamicObject)initEntryList.get(0)).getString(ImicInitialscheme.EF_itemgroup_stepname));
                BigDecimal total = new BigDecimal(allSize);
                BigDecimal complete = new BigDecimal(completeAllSize);
                BigDecimal completeProgress = complete.divide(total, 2, RoundingMode.HALF_UP).multiply(BigDecimal.valueOf(100L));
                total = new BigDecimal(mustSize);
                complete = new BigDecimal(completeMustSize);
                BigDecimal completeMustProgress = total.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.valueOf(100L) : complete.divide(total, 2, RoundingMode.HALF_UP).multiply(BigDecimal.valueOf(100L));
                String defaultcaliber = CommonUtil.getStringCustomParamValue(this.getView().getParentView(), DEFAULTCALIBER);
                if ("A".equals(defaultcaliber)) {
                    entryDynObj.set("stepprogress", (Object)(completeProgress.intValue() + "%"));
                    entryDynObj.set("stepfinish", (Object)StringUtils.join((Object[])completeItemNameList.toArray(), (char)','));
                    entryDynObj.set("stepunfinish", (Object)StringUtils.join((Object[])unCompleteItemNameList.toArray(), (char)','));
                    continue;
                }
                if ("B".equals(defaultcaliber)) {
                    entryDynObj.set("stepprogress", (Object)(completeMustProgress.intValue() + "%"));
                    entryDynObj.set("stepfinish", (Object)StringUtils.join((Object[])completeMustItemNameList.toArray(), (char)','));
                    entryDynObj.set("stepfinish", (Object)StringUtils.join((Object[])unCompleteMustItemNameList.toArray(), (char)','));
                    continue;
                }
                if (!"C".equals(defaultcaliber)) continue;
                entryDynObj.set("stepallprogress", (Object)(completeProgress.intValue() + "%"));
                entryDynObj.set("allfinish", (Object)StringUtils.join((Object[])completeItemNameList.toArray(), (char)','));
                entryDynObj.set("allunfinish", (Object)StringUtils.join((Object[])unCompleteItemNameList.toArray(), (char)','));
                entryDynObj.set("stepmustsetprogress", (Object)(completeMustProgress.intValue() + "%"));
                entryDynObj.set("mustsetfinish", (Object)StringUtils.join((Object[])completeMustItemNameList.toArray(), (char)','));
                entryDynObj.set("mustsetunfinish", (Object)StringUtils.join((Object[])unCompleteMustItemNameList.toArray(), (char)','));
            }
        }
    }
}

