/*
 * Decompiled with CFR 0.152.
 */
package kd.imsc.imic.report.deliveryinitial;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.DefaultEntityOperate;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.report.IReportView;
import kd.bos.report.ReportList;
import kd.bos.report.events.SortAndFilterEvent;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.imsc.imic.common.StringUtils;

public class ImicProgressReportPlugin
extends AbstractReportFormPlugin
implements HyperLinkClickListener,
BeforeF7SelectListener {
    private Long getLoginUser() {
        return RequestContext.get().getCurrUserId();
    }

    public void setSortAndFilter(List<SortAndFilterEvent> list) {
        for (SortAndFilterEvent event : list) {
            event.setFilter(false);
            event.setSort(false);
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        IDataModel model = this.getModel();
        BasedataEdit bizFilterColumn = (BasedataEdit)this.getControl("bizappfiltercolum");
        bizFilterColumn.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            List userBizApps = PermissionServiceHelper.getUserBizApps((Long)this.getLoginUser());
            beforeF7SelectEvent.addCustomQFilter(new QFilter("id", "in", (Object)userBizApps));
        });
        BasedataEdit schemeFilterColumn = (BasedataEdit)this.getControl("schemefiltercolum");
        schemeFilterColumn.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit orgFilter = (BasedataEdit)this.getControl("orgfiltercolum");
        orgFilter.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            MulBasedataDynamicObjectCollection orgPatternColl = (MulBasedataDynamicObjectCollection)model.getValue("orgpatternfilterculomn");
            if (orgPatternColl != null && !orgPatternColl.isEmpty()) {
                List orgPatternId = orgPatternColl.stream().map(op -> (Long)op.get(2)).collect(Collectors.toList());
                beforeF7SelectEvent.addCustomQFilter(new QFilter("orgpattern", "in", orgPatternId));
            }
        });
        this.addItemClickListeners(new String[]{"toolbarap"});
        ReportList reportList = (ReportList)this.getControl("reportlistap");
        reportList.addHyperClickListener((HyperLinkClickListener)this);
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        IReportView view = this.getView();
        FilterInfo filter = queryParam.getFilter();
        Object bizAppFilterValue = filter.getValue("bizappfiltercolum");
        if (bizAppFilterValue == null) {
            view.showErrorNotification(ResManager.loadKDString((String)"\u67e5\u8be2\u6761\u4ef6\uff1a\u201c\u5e94\u7528\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ImicProgressReportPlugin_11", (String)"imsc-imic-platform", (Object[])new Object[0]));
            return false;
        }
        BigDecimal lessThan = filter.getBigDecimal("rateltfiltercolumn");
        BigDecimal greaterThan = filter.getBigDecimal("rategtfiltercolumn");
        if (lessThan != null && greaterThan != null && lessThan.compareTo(greaterThan) < 0) {
            view.showErrorNotification(String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u6761\u4ef6\uff1a\u521d\u59cb\u5316\u8fdb\u5ea6\u5927\u4e8e\u7b49\u4e8e\uff08%%\uff09\u7684\u503c%1$s \u5927\u4e8e \u521d\u59cb\u5316\u8fdb\u5ea6\u5c0f\u4e8e\u7b49\u4e8e\uff08%%\uff09\u7684\u503c%2$s\u3002", (String)"ImicProgressReportPlugin_8", (String)"imsc-imic-platform", (Object[])new Object[0]), greaterThan, lessThan));
            return false;
        }
        return true;
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs event) {
        DefaultEntityOperate operation;
        String operateKey;
        super.beforeDoOperation(event);
        Object source = event.getSource();
        if (source instanceof DefaultEntityOperate && "view".equals(operateKey = (operation = (DefaultEntityOperate)source).getOperateKey())) {
            this.showInitGuideForm();
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent hylevt) {
        String fieldName = hylevt.getFieldName();
        if ("initialscheme".equals(fieldName)) {
            this.showInitSchemeForm();
        }
    }

    private void showInitSchemeForm() {
        DynamicObject rowData = this.getCurrRowData();
        BaseShowParameter showParameter = new BaseShowParameter();
        showParameter.setFormId("imic_initialscheme");
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setStatus(OperationStatus.VIEW);
        showParameter.setPkId(rowData.getDynamicObject("initialscheme").getPkValue());
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private void showInitGuideForm() {
        DynamicObject rowData = this.getCurrRowData();
        Object schemeId = rowData.getDynamicObject("initialscheme").getPkValue();
        QFilter filter = new QFilter("id", "=", schemeId);
        DynamicObject scheme = BusinessDataServiceHelper.loadSingle((String)"imic_initialscheme", (String)"initguide", (QFilter[])filter.toArray());
        String formId = "imic_initguide";
        String initGuideForm = scheme.getString("initguide").trim();
        if (StringUtils.isNotEmpty(initGuideForm)) {
            formId = initGuideForm;
        }
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setStatus(OperationStatus.EDIT);
        showParameter.setFormId(formId);
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.getOpenStyle().setTargetKey("_submaintab_");
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "imic_initguide"));
        showParameter.setHasRight(true);
        HashMap<String, Object> params = new HashMap<String, Object>(4);
        params.put("initAppId", this.getModel().getDataEntity().getDynamicObject("bizappfiltercolum").getString("number"));
        params.put("initialscheme", schemeId);
        DynamicObject org = rowData.getDynamicObject("dimension");
        if (org != null) {
            params.put("dimension", org.getPkValue());
        }
        showParameter.setCustomParams(params);
        this.getView().showForm(showParameter);
    }

    private DynamicObject getCurrRowData() {
        ReportList reportlistap = (ReportList)this.getControl("reportlistap");
        int rowIndex = this.getModel().getEntryCurrentRowIndex("reportlistap");
        return reportlistap.getReportModel().getRowData(rowIndex);
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        if (StringUtils.equals("schemefiltercolum", evt.getProperty().getName())) {
            ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
            Object value = this.getModel().getValue("bizappfiltercolum");
            Object pkValue = null;
            if (value == null) {
                evt.setCancel(true);
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u67e5\u8be2\u6761\u4ef6\uff1a\u201c\u5e94\u7528\u201d\u3002", (String)"ImicProgressReportPlugin_9", (String)"imsc-imic-platform", (Object[])new Object[0]));
            } else if (value instanceof DynamicObject) {
                DynamicObject bizCloudDynamicObject = (DynamicObject)value;
                pkValue = bizCloudDynamicObject.getPkValue();
            }
            ArrayList<QFilter> customQFilters = new ArrayList<QFilter>(10);
            customQFilters.add(new QFilter("enable", "=", (Object)Character.valueOf('1')));
            customQFilters.add(new QFilter("bizapp_id", "=", pkValue));
            showParameter.getListFilterParameter().setQFilters(customQFilters);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name;
        switch (name = e.getProperty().getName()) {
            case "bizappfiltercolum": {
                this.getModel().setValue("schemefiltercolum", null);
                break;
            }
            case "orgpatternfilterculomn": {
                this.getModel().setValue("orgfiltercolum", null);
                break;
            }
        }
    }
}

