/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.upgradeservice;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.ssc.achieve.AchieveExtScoreHelper;

public class AchieveEvaluateDataUpgradeServiceImpl
implements IUpgradeService {
    private static final String QUERY_ENTRY_SEQ = "SELECT fid,fseq FROM t_tk_eva_processoperation";
    private static final String QUERY_ENTRY_CP = "SELECT B.fid, B.fentryid, B.fcpachieveid, B.fcptargettype, B.fcpunitid, B.fcpstandard, B.fcptarget, B.fcpweight, B.fcpactual, B.fcpapproved, B.fcpscore, B.fcpdescription FROM t_tk_eva_customerpleased B INNER JOIN t_tk_achieveevalute A ON B.fid = A.fid WHERE NOT EXISTS (SELECT 1 FROM t_tk_eva_processoperation C WHERE B.fentryid = C.fentryid)";
    private static final String QUERY_ENTRY_LR = "SELECT B.fid, B.fentryid, B.flrachieveid, B.flrtargettype, B.flrunitid, B.flrstandard, B.flrtarget, B.flrweight, B.flractual, B.flrapproved, B.flrscore, B.flrdescription FROM t_tk_eva_learngrowth B INNER JOIN t_tk_achieveevalute A ON B.fid = A.fid WHERE NOT EXISTS (SELECT 1 FROM t_tk_eva_processoperation C WHERE B.fentryid = C.fentryid)";
    private static final String QUERY_ENTRY_CC = "SELECT B.fid, B.fentryid, B.fccachieveid, B.fcctargettype, B.fccunitid, B.fccstandard, B.fcctarget, B.fccweight, B.fccactual, B.fccapproved, B.fccscore, B.fccdescription FROM t_tk_eva_costcontrol B INNER JOIN t_tk_achieveevalute A ON B.fid = A.fid WHERE NOT EXISTS (SELECT 1 FROM t_tk_eva_processoperation C WHERE B.fentryid = C.fentryid)";
    private static final String INSERT_ENTRY = "INSERT INTO t_tk_eva_processoperation (fid, fentryid, fseq, fpoachieveid, fpotargettype, fpounitid, fpostandard, fpotarget, fpoweight, fpoactual, fpoapproved, fposcore, fpodescription) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
    private static final String QUERY_UPDATE_SCORE = "SELECT fid, fsscid, fassessdimension, fassessuserid, fperiodstart, fperiodend, ftotalscore FROM t_tk_achieveevalute WHERE fstatus = 'C'";
    private static final String UPDATE_SCORE = "UPDATE t_tk_achieveevalute SET fextrapoint = ?, fscore = ? WHERE fid = ?";

    public UpgradeResult afterExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        Object[] obj;
        Integer seq;
        Long mainId;
        UpgradeResult upgradeResult = new UpgradeResult();
        HashMap<Long, Integer> maxSeqMap = new HashMap<Long, Integer>(32);
        try (DataSet ds = DB.queryDataSet((String)"fi.ssc.achieve.updateEValuateData.seq", (DBRoute)DBRoute.of((String)"ssc"), (String)QUERY_ENTRY_SEQ);){
            for (Row group : ds.groupBy(new String[]{"fid"}).max("fseq", "maxSeq").finish()) {
                maxSeqMap.put(group.getLong("fid"), group.getInteger("maxSeq"));
            }
        }
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        DataSet ds = DB.queryDataSet((String)"fi.ssc.achieve.updateEValuateData.cp", (DBRoute)DBRoute.of((String)"ssc"), (String)QUERY_ENTRY_CP);
        Object object = null;
        try {
            for (Row row : ds) {
                mainId = row.getLong("fid");
                seq = maxSeqMap.computeIfAbsent(mainId, key -> -1);
                Object[] objectArray = new Object[13];
                objectArray[0] = mainId;
                objectArray[1] = row.get("fentryid");
                seq = seq + 1;
                objectArray[2] = seq;
                objectArray[3] = row.get("fcpachieveid");
                objectArray[4] = row.get("fcptargettype");
                objectArray[5] = row.get("fcpunitid");
                objectArray[6] = row.get("fcpstandard");
                objectArray[7] = row.get("fcptarget");
                objectArray[8] = row.get("fcpweight");
                objectArray[9] = row.get("fcpactual");
                objectArray[10] = row.get("fcpapproved");
                objectArray[11] = row.get("fcpscore");
                objectArray[12] = row.get("fcpdescription");
                obj = objectArray;
                maxSeqMap.put(mainId, seq);
                params.add(obj);
            }
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (ds != null) {
                if (object != null) {
                    try {
                        ds.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    ds.close();
                }
            }
        }
        ds = DB.queryDataSet((String)"fi.ssc.achieve.updateEValuateData.lr", (DBRoute)DBRoute.of((String)"ssc"), (String)QUERY_ENTRY_LR);
        object = null;
        try {
            for (Row row : ds) {
                mainId = row.getLong("fid");
                seq = maxSeqMap.computeIfAbsent(mainId, key -> -1);
                Object[] objectArray = new Object[13];
                objectArray[0] = mainId;
                objectArray[1] = row.get("fentryid");
                seq = seq + 1;
                objectArray[2] = seq;
                objectArray[3] = row.get("flrachieveid");
                objectArray[4] = row.get("flrtargettype");
                objectArray[5] = row.get("flrunitid");
                objectArray[6] = row.get("flrstandard");
                objectArray[7] = row.get("flrtarget");
                objectArray[8] = row.get("flrweight");
                objectArray[9] = row.get("flractual");
                objectArray[10] = row.get("flrapproved");
                objectArray[11] = row.get("flrscore");
                objectArray[12] = row.get("flrdescription");
                obj = objectArray;
                maxSeqMap.put(mainId, seq);
                params.add(obj);
            }
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (ds != null) {
                if (object != null) {
                    try {
                        ds.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    ds.close();
                }
            }
        }
        ds = DB.queryDataSet((String)"fi.ssc.achieve.updateEValuateData.cc", (DBRoute)DBRoute.of((String)"ssc"), (String)QUERY_ENTRY_CC);
        object = null;
        try {
            for (Row row : ds) {
                mainId = row.getLong("fid");
                seq = maxSeqMap.computeIfAbsent(mainId, key -> -1);
                Object[] objectArray = new Object[13];
                objectArray[0] = mainId;
                objectArray[1] = row.get("fentryid");
                seq = seq + 1;
                objectArray[2] = seq;
                objectArray[3] = row.get("fccachieveid");
                objectArray[4] = row.get("fcctargettype");
                objectArray[5] = row.get("fccunitid");
                objectArray[6] = row.get("fccstandard");
                objectArray[7] = row.get("fcctarget");
                objectArray[8] = row.get("fccweight");
                objectArray[9] = row.get("fccactual");
                objectArray[10] = row.get("fccapproved");
                objectArray[11] = row.get("fccscore");
                objectArray[12] = row.get("fccdescription");
                obj = objectArray;
                maxSeqMap.put(mainId, seq);
                params.add(obj);
            }
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (ds != null) {
                if (object != null) {
                    try {
                        ds.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    ds.close();
                }
            }
        }
        if (params.size() < 1) {
            upgradeResult.setLog(ResManager.loadKDString((String)"\u6ca1\u6709\u9700\u8981\u8fdb\u884c\u5206\u5f55\u8fc1\u79fb\u7684\u6570\u636e\u3002", (String)"AchieveEvaluateDataUpgradeServiceImpl_0", (String)"ssc-task-upgradeservice", (Object[])new Object[0]));
            upgradeResult.setSuccess(true);
        } else {
            try {
                DB.executeBatch((DBRoute)DBRoute.of((String)"ssc"), (String)INSERT_ENTRY, params);
                upgradeResult.setLog(ResManager.loadKDString((String)"\u8fdb\u884c\u5206\u5f55\u6570\u636e\u8fc1\u79fb\u6210\u529f\u3002", (String)"AchieveEvaluateDataUpgradeServiceImpl_1", (String)"ssc-task-upgradeservice", (Object[])new Object[0]));
                upgradeResult.setSuccess(true);
            }
            catch (Throwable th) {
                upgradeResult.setErrorInfo(th.getMessage());
                upgradeResult.setLog(ResManager.loadKDString((String)"\u8fdb\u884c\u5206\u5f55\u6570\u636e\u8fc1\u79fb\u5931\u8d25\u3002", (String)"AchieveEvaluateDataUpgradeServiceImpl_2", (String)"ssc-task-upgradeservice", (Object[])new Object[0]));
                upgradeResult.setSuccess(false);
            }
        }
        ArrayList<Object[]> updateParams = new ArrayList<Object[]>();
        DataSet ds2 = DB.queryDataSet((String)"fi.ssc.achieve.updateEValuateData.score", (DBRoute)DBRoute.of((String)"ssc"), (String)QUERY_UPDATE_SCORE);
        Object object2 = null;
        try {
            for (Row row : ds2) {
                BigDecimal score;
                Long id = row.getLong("fid");
                String assessType = row.getString("fassessdimension");
                BigDecimal totalWeightScore = row.getBigDecimal("ftotalscore");
                if ("1".equals(assessType)) {
                    Object[] obj2 = new Object[]{BigDecimal.ZERO, totalWeightScore, id};
                    updateParams.add(obj2);
                    continue;
                }
                if (!"2".equals(assessType)) continue;
                Long sscId = row.getLong("fsscid");
                Long userId = row.getLong("fassessuserid");
                Date startDate = row.getDate("fperiodstart");
                Date endDate = row.getDate("fperiodend");
                BigDecimal userExtScore = AchieveExtScoreHelper.getUserExtScore((long)userId, (long)sscId, (Date)startDate, (Date)endDate);
                if (userExtScore != null) {
                    score = totalWeightScore.add(userExtScore);
                } else {
                    score = totalWeightScore;
                    userExtScore = BigDecimal.ZERO;
                }
                Object[] obj3 = new Object[]{userExtScore, score, id};
                updateParams.add(obj3);
            }
        }
        catch (Throwable throwable) {
            object2 = throwable;
            throw throwable;
        }
        finally {
            if (ds2 != null) {
                if (object2 != null) {
                    try {
                        ds2.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object2).addSuppressed(throwable);
                    }
                } else {
                    ds2.close();
                }
            }
        }
        if (updateParams.size() < 1) {
            upgradeResult.setLog(upgradeResult.getLog() + String.format(ResManager.loadKDString((String)"%s\u6ca1\u6709\u9700\u8981\u8fdb\u884c\u989d\u5916\u52a0\u51cf\u5206\u5347\u7ea7\u7684\u6570\u636e\u3002", (String)"AchieveEvaluateDataUpgradeServiceImpl_3", (String)"ssc-task-upgradeservice", (Object[])new Object[0]), ";"));
        } else {
            try {
                DB.executeBatch((DBRoute)DBRoute.of((String)"ssc"), (String)UPDATE_SCORE, updateParams);
                upgradeResult.setLog(upgradeResult.getLog() + String.format(ResManager.loadKDString((String)"%s\u8fdb\u884c\u989d\u5916\u52a0\u51cf\u5206\u5347\u7ea7\u6210\u529f\u3002", (String)"AchieveEvaluateDataUpgradeServiceImpl_4", (String)"ssc-task-upgradeservice", (Object[])new Object[0]), ";"));
            }
            catch (Throwable th) {
                upgradeResult.setErrorInfo(th.getMessage());
                upgradeResult.setLog(upgradeResult.getLog() + String.format(ResManager.loadKDString((String)"%s\u8fdb\u884c\u989d\u5916\u52a0\u51cf\u5206\u5347\u7ea7\u5931\u8d25\u3002", (String)"AchieveEvaluateDataUpgradeServiceImpl_5", (String)"ssc-task-upgradeservice", (Object[])new Object[0]), ";"));
                upgradeResult.setSuccess(false);
            }
        }
        return upgradeResult;
    }
}

