/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.upgradeservice;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.MainEntityType;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.util.StringUtils;

public class CalFactorFixUpgradeServiceImpl
implements IUpgradeService {
    private static final String QUERY_SQL = "select fid,ffieldmapping,fentityobject from t_tk_calfactor where fdatasource = '1'";
    private static final String UPDATE_SQL = "update t_tk_calfactor set ffieldmapping = ? where fid = ?";

    public UpgradeResult afterExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        ArrayList<Object[]> paramsList = new ArrayList<Object[]>(10);
        try (DataSet ds = DB.queryDataSet((String)"kd.fi.som.calFactorFix.QueryEntityCalFactor", (DBRoute)DBRoute.of((String)"ssc"), (String)QUERY_SQL);){
            while (ds.hasNext()) {
                Row row = ds.next();
                String entityNumber = row.getString("fentityobject");
                if (StringUtils.isEmpty((String)entityNumber)) continue;
                MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)entityNumber);
                Map allFields = dataEntityType.getAllFields();
                String fieldMappingStr = row.getString("ffieldmapping");
                JSONObject fieldMappingMap = JSONObject.parseObject((String)fieldMappingStr);
                for (Map.Entry entry : fieldMappingMap.entrySet()) {
                    JSONObject mapInfo = (JSONObject)entry.getValue();
                    String fieldNumber = mapInfo.getString("fieldNumber");
                    String fieldName = mapInfo.getString("fieldName");
                    if (!StringUtils.isEmpty((String)fieldName) || StringUtils.isEmpty((String)fieldNumber)) continue;
                    mapInfo.put("fieldName", (Object)((IDataEntityProperty)allFields.get(fieldNumber)).getDisplayName().toString());
                }
                Long fid = row.getLong("fid");
                Object[] param = new Object[]{SerializationUtils.toJsonString((Object)fieldMappingMap), fid};
                paramsList.add(param);
            }
            if (paramsList.size() > 0) {
                DB.executeBatch((DBRoute)DBRoute.of((String)"ssc"), (String)UPDATE_SQL, paramsList);
            }
        }
        UpgradeResult upgradeResult = new UpgradeResult();
        upgradeResult.setSuccess(true);
        return upgradeResult;
    }
}

