/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.upgradeservice;

import java.util.ArrayList;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.plugin.support.util.CollectionUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;

public class WorkBillSubEntryFlowNumUpgradeServiceImpl
implements IUpgradeService {
    private static final Log log = LogFactory.getLog(WorkBillSubEntryFlowNumUpgradeServiceImpl.class);
    private static final String QUERY_SQL = "select a.fentryid,max(a.fseq) as max_fseq from t_tk_field_subentry a,t_tk_panel_entry b where a.fentryid = b.fentryid and b.fpnumber ='fs_baseinfo' and a.fentryid not in (select fentryid from t_tk_field_subentry where ffieldnumber ='flownumber') group by a.fentryid";
    private static final String INSERT_SQL0 = "INSERT INTO t_tk_field_subentry (fentryid, fdetailid, fseq, ffieldnumber, ffieldname, ffieldproperty, fisvisible, fismust, ffieldpropertyjson, ffieldpropertyjson_tag, fispreset, ffieldapid, ffieldtype, ffcheckmeta) VALUES(?, ?, ?, 'flownumber', '\u670d\u52a1\u6d41\u7a0b\u7f16\u7801', ' ', '0', '0', ' ', '{\"editStyle\":0,\"maxLength\":50,\"minLength\":0}', '1', 'zGnvI0Yp3H', 'Text', '1')";
    private static final String INSERT_SQL1 = "INSERT INTO t_tk_field_subentry_l (fpkid, fdetailid, flocaleid, ffieldname) VALUES(?, ?, 'zh_CN', '\u670d\u52a1\u6d41\u7a0b\u7f16\u7801')";

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        String algoKey = this.getClass() + ".beforeExecuteSqlWithResult()";
        ArrayList<Object[]> subEntryParams = new ArrayList<Object[]>(16);
        ArrayList<Object[]> subEntryLparams = new ArrayList<Object[]>(16);
        try (DataSet resultSet = DB.queryDataSet((String)(algoKey + "_0"), (DBRoute)DBRoute.of((String)"ssc"), (String)QUERY_SQL);){
            for (Row row : resultSet) {
                long subEntryId = DB.genLongId((String)"t_tk_field_subentry");
                Object[] subEntryParamArr = new Object[]{row.get("fentryid"), subEntryId, Integer.parseInt(row.get("max_fseq").toString()) + 1};
                subEntryParams.add(subEntryParamArr);
                Object[] subEntryParamLArr = new Object[]{DB.genStringId((String)"t_tk_field_subentry_l"), subEntryId};
                subEntryLparams.add(subEntryParamLArr);
            }
        }
        if (CollectionUtils.isEmpty(subEntryParams)) {
            log.info("No need to upgrade.");
            return WorkBillSubEntryFlowNumUpgradeServiceImpl.buildSuccessResult();
        }
        var9_9 = null;
        try (TXHandle h = TX.requiresNew((String)"ssc_task_subentry_flownum_upgrade");){
            try {
                DB.executeBatch((DBRoute)DBRoute.of((String)"ssc"), (String)INSERT_SQL0, subEntryParams);
                DB.executeBatch((DBRoute)DBRoute.of((String)"ssc"), (String)INSERT_SQL1, subEntryLparams);
            }
            catch (Throwable e) {
                log.error("upgrade error", e);
                h.markRollback();
                UpgradeResult upgradeResult = WorkBillSubEntryFlowNumUpgradeServiceImpl.buildErrorResult(e);
                if (h != null) {
                    if (var9_9 != null) {
                        try {
                            h.close();
                        }
                        catch (Throwable throwable) {
                            var9_9.addSuppressed(throwable);
                        }
                    } else {
                        h.close();
                    }
                }
                return upgradeResult;
            }
        }
        catch (Throwable throwable) {
            var9_9 = throwable;
            throw throwable;
        }
        return WorkBillSubEntryFlowNumUpgradeServiceImpl.buildSuccessResult();
    }

    private static UpgradeResult buildSuccessResult() {
        UpgradeResult result = new UpgradeResult();
        result.setLog(ResManager.loadKDString((String)"\u5386\u53f2\u5de5\u5355\u65b0\u589e\u670d\u52a1\u6d41\u7a0b\u7f16\u7801\u5b57\u6bb5\u5347\u7ea7\u6210\u529f\u3002", (String)"WorkBillSubEntryFlowNumUpgradeServiceImpl_0", (String)"ssc-task-upgradeservice", (Object[])new Object[0]));
        result.setSuccess(true);
        return result;
    }

    private static UpgradeResult buildErrorResult(Throwable e) {
        UpgradeResult result = new UpgradeResult();
        result.setErrorInfo(e.getMessage());
        result.setLog(ResManager.loadKDString((String)"\u5386\u53f2\u5de5\u5355\u65b0\u589e\u670d\u52a1\u6d41\u7a0b\u7f16\u7801\u5b57\u6bb5\u5347\u7ea7\u5931\u8d25\u3002", (String)"WorkBillSubEntryFlowNumUpgradeServiceImpl_1", (String)"ssc-task-upgradeservice", (Object[])new Object[0]));
        result.setSuccess(false);
        return result;
    }
}

