/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.opplugin;

import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;

public class CheckPointDeleteValidatorPlugin
extends AbstractValidator {
    public void initializeConfiguration() {
        super.initializeConfiguration();
        this.setEntityKey("task_checkpoint");
    }

    public void validate() {
        StringBuilder errorMsg = new StringBuilder();
        for (ExtendedDataEntity extendedDataEntity : this.dataEntities) {
            DynamicObject checkPointInfo;
            Long id = Long.valueOf(extendedDataEntity.getObjectByName("id") + "");
            if (this.checkBeforeDelete(id) && (checkPointInfo = this.getCheckPointById(id)) != null) {
                String name = (String)checkPointInfo.get("name");
                errorMsg.append(name).append(ResManager.loadKDString((String)"\u68c0\u67e5\u9879\u88ab\u4efb\u52a1\u521b\u5efa\u89c4\u5219\u5f15\u7528\u4e0d\u80fd\u5220\u9664\uff1b", (String)"CheckPointDeleteValidatorPlugin_0", (String)"ssc-task-opplugin", (Object[])new Object[0])).append("\n\r");
            }
            if (errorMsg.length() <= 0) continue;
            this.addErrorMessage(extendedDataEntity, errorMsg.toString());
        }
    }

    private boolean checkBeforeDelete(Long id) {
        ORM orm = ORM.create();
        QFilter filter = new QFilter("entryentitycheck.taskcheck", "=", (Object)id);
        QFilter[] filters = new QFilter[]{filter};
        boolean isExist = orm.exists("task_taskbill_child", filters);
        return isExist;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DynamicObject getCheckPointById(Long id) {
        DynamicObject checkPointInfo = null;
        QFilter qFilter = new QFilter("id", "=", (Object)id);
        QFilter[] qFilters = new QFilter[]{qFilter};
        ORM orm = ORM.create();
        try (DataSet dataSet = null;){
            dataSet = orm.queryDataSet("checkpoint", "task_checkpoint", "name,description", qFilters);
            DynamicObjectCollection dynamicObjects = orm.toPlainDynamicObjectCollection(dataSet);
            if (dynamicObjects.size() > 0) {
                checkPointInfo = (DynamicObject)dynamicObjects.get(0);
            }
        }
        return checkPointInfo;
    }
}

