/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.opplugin;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class CheckingPointDisableValidator
extends AbstractValidator {
    public void initializeConfiguration() {
        super.initializeConfiguration();
        this.setEntityKey("task_checkpoint");
    }

    public void validate() {
        StringBuffer errorMsg = null;
        for (ExtendedDataEntity extendedDataEntity : this.dataEntities) {
            errorMsg = new StringBuffer();
            String number = extendedDataEntity.getValue("number") == null ? null : extendedDataEntity.getValue("number").toString();
            Object objSSCCenter = extendedDataEntity.getValue("ssccenter");
            Long sscId = 0L;
            if (objSSCCenter != null) {
                DynamicObject dySSC = (DynamicObject)objSSCCenter;
                sscId = dySSC.getLong("id");
            }
            if (this.isUsedByCheckScheme(sscId, number)) {
                errorMsg.append(String.format(ResManager.loadKDString((String)"\u8d28\u68c0\u70b9\u7f16\u53f7\u4e3a%s\uff0c\u5b58\u5728\u5f15\u7528\u5173\u7cfb\uff0c\u65e0\u6cd5\u7981\u7528\uff1b", (String)"CheckingPointDisableValidator_0", (String)"ssc-task-opplugin", (Object[])new Object[0]), number)).append("\n\r");
            }
            if (errorMsg.length() <= 0) continue;
            this.addMessage(extendedDataEntity, errorMsg.toString(), ErrorLevel.Error);
        }
    }

    private boolean isUsedByCheckScheme(Long sscId, String number) {
        if (StringUtils.isEmpty((CharSequence)number)) {
            return false;
        }
        QFilter sscFilter = new QFilter("ssccenter", "=", (Object)sscId);
        QFilter numberFilter = new QFilter("cpentry.cpnumber", "=", (Object)number);
        return QueryServiceHelper.exists((String)"task_qualitycheckscheme", (QFilter[])new QFilter[]{sscFilter, numberFilter});
    }
}

